/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <stdio.h>

/***
 *  Function    :   strtohex
 *
 *  Description :   convert a string containing an hexadecimal
 *                  representation into an hexadecimal flow of bytes.
 *
 *  Parameters  :   char *string   in/out
 *
 *  Return      :   length of hexadecimal flow of bytes.
 *                  -1 on error
 *
 *  OS/Compiler :   All
 ***/

int strtohex( char *string )

{ int len = 0;
  char *ptr = string, buffer[2];

  /* if string length is even, first char is a full number */
  if ( strlen(string) % 2 ) { if ( sscanf(ptr, "%01x", buffer) != 1 ) return -1;
                              *ptr++ = *buffer;
                              len = 1;
                            }

  while ( *ptr )
        { if ( sscanf( ptr, "%02x", string + len++) != 1 ) return -1;
          ptr += 2;
        }

  return len;
}
