/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  stralign
 *
 *  Description :  Copy an input string in an output string
 *		   with specified alignement (blank padding).
 *
 *  Decisions   :  If given length < 0 returns an empty string.
 *
 *  Parameters  :  out  char        *out_str     result
 *                 in   char        *in_str      in string
 *                 in   align_type  type,	 type
 *                 in   int         length       length to be copied
 *
 *  Value       :  type = { align_left, align_center, align_right }
 *
 *  Return code :   pointer to result.
 *
 *  OS/Compiler :   All
 */

char *stralign( char *out_str, const char *in_str, align_type type, int length )

{ int diff;
  char *ptr = out_str;

  if ( length <= 0 ) { *out_str = '\0';
  		       return out_str;
		     }

  if ( (diff = (length - strlen(in_str)) ) <= 0 )
     return strleft( out_str, in_str,diff );

  switch( type ) { case align_left  : while ( *out_str++ = *in_str++ );
	                              out_str --;
	       	 		      for (; diff; diff -- ) *out_str++ = ' ';
	       	 		      *out_str++ = '\0';
		 		      break;

		   case align_right : for (; diff; diff -- ) *out_str++ = ' ';
		 		      while ( *out_str++ = *in_str++ );
		 		      break;

	       	   case align_center: { int lim = diff / 2;
	       	   		        for (; diff > lim; diff -- ) *out_str++ = ' ';
	       	 		        while ( *out_str++ = *in_str++ ); out_str --;
	       	 		        for (; diff; diff -- ) *out_str++ = ' ';
	       	 		        *out_str++ = '\0';
	       	 		        break;
	       	 		      }
	         }

  return ptr;
}
                 