#include "date.h"
#include "bctools.h"
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>


/***
 *  Function    :   input_date
 *
 *  Description :   Input day, month and year at given position.
 *
 *  Parameters  :   in   int *  day
 *                  in   int *  month
 *                  in   int *  year
 *                  in   int    xpos
 *                  in   int    ypos
 *
 *  Decisions   :   Default = current date
 *		    Century may be omitted.
 *		    Colors = white on blue
 *		
 *  Return      :    0 if OK
 *                  -1 if no input
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

int input_date( int *day , int *month  , int *year , int xpos , int ypos )

{ struct text_info info ;
  struct date today ;


  gettextinfo( &info ) ;     /*  Save current window settings  */

  window( xpos , ypos , xpos+11 , ypos ) ;
  textbackground(BLUE) ;
  clrscr() ;
  textcolor(WHITE) ;

  getdate( &today ) ;        /* Get current date */

  for (;;) { char buffer[14] ;
	     int i ;

	     *day   = today.da_day ;
	     *month = today.da_mon ;
	     *year  = today.da_year ;
	     gotoxy( 2 , 1 ) ;
	     cprintf( "%2d-%02d-%4d" , *day , *month , *year ) ;
	     gotoxy( 2 , 1 ) ;

	     i = getch() ;
	     if ( i == ESC ) return -1 ;
	     if ( i == RETURN ) break ;

	     clreol() ;
	     ungetch( i ) ;
	     *buffer = 11 ;
	     cgets( buffer ) ;
	     i = sscanf( buffer+2 , "%d%[^0-9]%d%[^0-9]%d" , day , NULL , month , NULL , year ) ;
	     if ( i <= 0 ) return -1 ;
	     if ( *year < 100 ) *year += 1900 ;
	     if ( isdatevalid(*day , *month , *year) )
		{
 		  gotoxy( 2 , 1 ) ;
		  cprintf( "%02d-%02d-%4d" , *day , *month , *year ) ;
		  break ;
		}
	     else beep() ;
     }

	       /*  Restore previous window settings  */
  window( info.winleft , info.wintop , info.winright , info.winbottom ) ;
  textattr( info.attribute ) ;

  return 0 ;
}
