


MAKE(1)                MAKE User's Manual                 MAKE(1)



NAME
     make - maintain, update, and regenerate groups of programs

SYNOPSIS
     make [-f filename] [-CdeiknrstFV] [target ...] [macro=value
     ...]

DESCRIPTION
     Make reads an input file containing a listing of dependen-
     cies between files, and associated rules to maintain the
     dependencies.  The format is generally a target file name,
     followed by a list of files that it is dependent upon, fol-
     lowed by a set of commands to be used to recreate the target
     from the dependents.  Each dependent is in its own right a
     target, and so the maintenance of each dependent is per-
     formed recursively, before attempting to maintain the
     current target.  If, after processing its all of its depen-
     dencies, a target file is found either to be missing, or to
     be older than any of its dependency files, make uses the
     supplied commands or an implicit rule to rebuild it.

     If no makefile is specified with a -f option, make reads a
     file named `makefile', if it exists.

     If no target is specified on the command line, make uses the
     first target defined in makefile.

     If a target has no makefile entry, or if its entry has no
     rule, make attempts to derive a rule by each of the follow-
     ing methods:

     o    implicit rules, read in from a user-supplied makefile.

     o    standard implict rules typically read in from the file
          `default.mk'.

     o    the rule from the .DEFAULT: entry target, if there is
          such an entry in the makefile.

     If there is no makefile entry for a target, and no rule can
     be derived for building it, and if no file by that name is
     present, make issues an error message and stops.

OPTIONS
     -f  makefile
          Use the description file `makefile'.  A - as the
          makefile argument denotes the standard input.  The con-
          tents of `makefile', when present, override the stan-
          dard set of implicit rules and predefined macros.  When
          more than one -f makefile argument pair appears, make
          uses the concatenation of those files, in order of
          appearance.



Printed 7/20/89          April 30, 1989                         1






MAKE(1)                  Programmer's Manual              MAKE(1)



     -d   Display the reasons why make chooses to rebuild a tar-
          get; make displays any and all dependencies that are
          newer.

     -e   Do not override any assignments with present environ-
          ment variables.

     -F   Force all target updates.  Build target even when no
          update is needed according to file time/date.

     -i   Ignore error codes returned by commands.  Equivalent to
          the special-function target .IGNORE:.

     -k   Abandon building the current target as soon as an error
          code is returned during building. Continue with other
          targets.

     -n   No execution mode.  Print commands, but do not execute
          them.  Even lines beginning with an @ are printed.
          However, if a command line contains a reference to the
          $(MAKE) macro, that line is always executed.

     -r   Do not read in the default file (default.mk).

     -s   Silent mode.  Do not print command lines before execut-
          ing them.  Equivalent to the special-function target
          .SILENT:.

     -S   Undo the effect of the -k option.  With this switch,
          the -k option is undone, which means that any error
          code returned by a child process during building, will
          halt 'make' and display the error code.

     -t   Touch the target files (bringing them up to date)
          rather than performing their rules.

     -V   List the current version number of 'make'.

     macro=value
          Macro definition.  This definition remains fixed for
          the make invocation.  It overrides any regular defini-
          tion for the specified macro within the makefile
          itself.

USAGE
     Reading Makefiles
     When make first starts, it reads the environment setting of
     MAKE_FLAGS and scans all present options. Then it reads the
     command line for a list of options, after which it reads in
     a default makefile that typically contains predefined macro
     definitions and target entries for implicit rules.  If
     present, make uses the file `default.mk' in the current



Printed 7/20/89          April 30, 1989                         2






MAKE(1)                  Programmer's Manual              MAKE(1)



     directory.  Otherwise it looks for this file along the
     search path.

     Next, make reads any makefiles you specify with -f, or (if
     present, in order) `Makefile', and then `makefile', if no -f
     makefile's are specified.  Finally, make reads in all macro
     definitions from the command line.  These override macro
     definitions in the makefile.

     The makefile(s) may contain a mixture of comment lines,
     macro definitions, include lines, and target lines.  Lines
     may be continued across input lines by escaping the NEWLINE
     with a backslash (\).

     A comment line is any line whose first non-space character
     is a '#'.  The comment ends at the next unescaped NEWLINE.

     An include line is used to include the text of another
     makefile.  The first seven letters of the line is the word
     "include" followed by a space.  The string that follows is
     taken as a filename to include at this line.

     Macros
     A macro definition line has the form of `WORD=text...'.  The
     word to the left of the equal sign (without surrounding
     white space) is the macro name.  Text to the right is the
     value of the macro.  Leading white space between the = and
     the first word of the value is ignored.  A word break fol-
     lowing the = is implied.  Trailing white space (up to but
     not including a comment character) is included in the value.

     Macros are referenced with a $.  The following character, or
     the parenthesized ( ) or bracketed { } string, is inter-
     preted as a macro reference.  make expands the reference
     (including the $) by replacing it with the macro's value.
     If a macro contains another macro, the interior one is
     expanded first.  Note that this may lead to infinite expan-
     sion, if a macro references itself.

     The MAKE macro is special.  It has the value "make" by
     default, and temporarily overrides the -n option for any
     line in which it is referred to.  This allows nested invoca-
     tions of make written as:

          $(MAKE) ...

     to run recursively, with the -n flag in effect for all com-
     mands but make.

     make supplies predefined macros in the `default.mk' file.
     If -r is in effect, make does not supply these macro defini-
     tions.



Printed 7/20/89          April 30, 1989                         3






MAKE(1)                  Programmer's Manual              MAKE(1)



     There are several dynamically maintained macros that are
     useful as abbreviations within rules.  They are shown here
     as references; it is best not to define them explicitly.

     $*   The basename of the current target, derived as if
          selected for use with an implicit rule.

     $<   The name of a dependency file, derived as if selected
          for use with an implicit rule.

     $@   The name of the current target.

     Because make assigns $< and $* as it would for implicit
     rules (according to the suffixes list and the directory con-
     tents), they may be unreliable when used within explicit
     target entries.

     A line of the form `WORD += text...' is used to append the
     given text to the end of a macro.  The += must be surrounded
     by white space.

     Makefile Target Entries
     A target entry in the makefile has the following format:

          target ...  : [dependency] ...
               [command]
               ...

     The first line contains the name of a target, or a list of
     target names separated by white space.  This may be followed
     by a dependency, or a dependency list that make checks in
     order.  Subsequent lines in the target entry begin with a
     space or TAB, and contain shell commands.  These commands
     comprise a rule for building the target.

     If a target it named in more than one colon-terminated tar-
     get entry, the dependencies and rules are added to form the
     target's complete dependency list and rule list.

     To rebuild a target, make expands macros, strips off initial
     TABs, and either executes the command directly (if it con-
     tains no shell metacharacters), or passes each command line
     to a shell for execution.

     The first line that does not begin with a space, TAB or #
     begins another target or macro definition.

     Macros are expanded during input, for target lines.  All
     other lines have macro expansion delayed until absolutely
     required.





Printed 7/20/89          April 30, 1989                         4






MAKE(1)                  Programmer's Manual              MAKE(1)



     Special-Function Targets
     When incorporated in a makefile, the following target names
     perform special-functions:

     .DEFAULT:
          The rule for this target is used to process a target
          when there is no other entry for it, and no rule for
          building it.  make ignores any dependencies for this
          target.

     .DONE:
          make processes this target and its dependencies after
          all other targets are built.

     .IGNORE:
          make ignores non-zero error codes returned from com-
          mands.

     .INIT:
          This target and its dependencies are built before any
          other targets are processed.

     .RESPONSE:
          This target is used for DOS only and specifies all pro-
          grams that can cope with a response file as soon as the
          command line grows past 128 characters (the limit for
          DOS command lines). The command line for the child pro-
          cess to spawn is then reformatted and will look some-
          thing like : '@MAKxxxxx' with in this response file the
          original version of the command line, with all blanks
          used as line seperators.

     .SILENT:
          make does not echo commands before executing them.

     .SUFFIXES:
          The suffixes list for selecting implicit rules.

     Rules
     When processing rules, the first non-space character may
     imply special handling.  Lines beginning with the following
     special cahracters are handled as follows:

     -    make ingores any nonzero error code.  Normally, make
          terminates when a command returns a nonzero status,
          unless the -i option or the .IGNORE target is used.

     @    make does not print the command line before executing
          it.  Normally, each line is displayed before being exe-
          cuted, unless the -s option or the .SILENT target is
          used.




Printed 7/20/89          April 30, 1989                         5






MAKE(1)                  Programmer's Manual              MAKE(1)



     +    a shell is used to execute this command.  Normally the
          shell is used (via system()) only if metacharacters are
          found, and for certain implicitly known commands.

     When any combination of -, @ or + appear as the first char-
     acters after the spaces or TABs, all apply.  None are passed
     to the shell.

     Implicit Rules
     A target file name is made of a basename and a suffix.  The
     suffix may be null.  When a target has no explicit target
     entry, make looks for an implicit target made of an element
     from the suffixes list concatenated with the suffix of the
     target.  If such an implicit target exists, a dependecy file
     name consisting of the basename and the suffix from the suf-
     fix list is recursively made.  If successful, the implicit
     rule is invoked to build the target.

     An implicit rule is a target of the form:

          .Ds.Ts :
               rule

     where .Ts is the suffix of the target, .Ds is the suffix of
     the dependency file, and `rule' is the implicit rule for
     building such a target from such a dependency file.

     The Suffixes List
     The suffixes list is given as the list of dependencies for
     the .SUFFIXES: special-function target.  The default list is
     contained in the SUFFIXES macro .  You can define additional
     .SUFFIXES: targets; a SUFFIXES target with no dependencies
     clears the list of suffixes.  Order is significant within
     the list; make selects a rule that corresponds to the
     target's suffix and the first dependency-file suffix found
     in the list.  To place suffixes at the head of the list,
     clear the list and replace it with the new suffixes, fol-
     lowed by the default list:

          .SUFFIXES:
          .SUFFIXES: suffixes $(SUFFIXES)

EXAMPLES
     This makefile says that pgm.exe depends on two files a.o and
     b.o, and that they in turn depend on their corresponding










Printed 7/20/89          April 30, 1989                         6






MAKE(1)                  Programmer's Manual              MAKE(1)



     source files (a.c and b.c) along with a common file incl.h:

          pgm.exe: a.o b.o
               $(CC) a.o b.o -o $@

          a.o: incl.h a.c
               $(CC) -c a.c

          b.o: incl.h b.c
               $(CC) -c b.c

     The following makefile uses implicit rules to express the
     same dependencies:

          pgm.exe: a.o b.o
               $(CC) a.o b.o -o pgm.exe

          a.o b.o: incl.h

FILES
     makefile       Current version(s) of make description file.
     default.mk     Default file for user-defined targets, mac-
                    ros, and implicit rules.

DIAGNOSTICS
     make returns a exit status of 1 when it halts as a result of
     an error.  Otherwise it returns and exit status of 0.

     Badly formed macro
          A macro definition has been encountered which has
          incorrect syntax.  Most likely, the name is missing.

     cannot open file
          The makefile indicated in an include directive was not
          found or was not accessible.

     Don't know how to make target
          There is no makefile entry for target, none of make's
          implicit rules apply, and there is no .DEFAULT: rule.

     Improper Macro.
          An error has occurred during macro expansion.  The most
          likely error is a missing closing bracket.

     rules must be after target
          makefile syntax error, where a line beginning with a
          space or TAB has been encountered before a target line.

     too many options
          make has run out of allocated space while processing





Printed 7/20/89          April 30, 1989                         7






MAKE(1)                  Programmer's Manual              MAKE(1)



          command line options or a target list.

BUGS
     make does not allow a target line to end with a semi-colon
     (;) and a command.  All commands must be on subsequent
     lines.

     make allows spaces as well as TABs to introduce shell comand
     lines.

     target lines cannot use the double colon (::) syntax.

     make attempts to derive values for the dynamic macros $* and
     $<, while processing explicit targets.  It uses the same
     methods as for implicit rules.  In some cases, this can lead
     to unexpected values.

     Once a dependency is made, make assumes that the dependency
     file is present for the remainder of the run.  If a rule
     subsequently removes that file, and future targets depend on
     its existence, unexpected errors may result.

     Sometimes make gets confused when searching for implicit
     rules, and uses severla rules instead of a single rule.  For
     example, the two rules .c.o and .l.c may be used, rather
     than the more direct .l.o rule.

     Environment variables are neither read nor written.


     -p   Print out the complete set of macro definitions and
          target descriptions.

     -P   Report dependencies recursively to show the entire
          dependency hierarchy, without rebuilding any targets.

     -q   Question mode.  make returns a zero or nonzero status
          code depending on whether or not the target file is up
          to date.

     The following special-function targets are NOT supported:

     .KEEP_STATE:
     .MAKE_VERSION:
     .PRECIOUS:
     .SCCS_GET:









Printed 7/20/89          April 30, 1989                         8



