	PAGE	60,132
NAME	BootSave
	TITLE	BootSave BootRest BootChk Resuce Master boot sector
Comment |
	Version 1.8 1996 October 23 Roedy Green
	works with MASM 6.0 and Optasm

See Boot.TXT for details on use.

  USAGE:

Examples:
*********

BootSave A:\MyBoot.Sav /Q

BootRest A:\MyBoot.Sav /Q

BootChk  A:\ByBoot.Sav /Q

Syntax errors or missing file trouble generates an ERRORLEVEL 4.
BootChk generates an ERRORLEVEL 1 if the Boot record has changed
since the BootSave was done.

Version History
***************

Version 1.8 1996 Nov 22
- missing com files corrected

Version 1.7 1996 Nov 15
- lower cost, combo site licence.

Version 1.6 1996 October 23
- Quadra address
- presume C:\SAFE again for files.

Version 1.5 1995 August 8
- /Q option
- cleaner CHKBOOT.BAT
- configure with SET CMPDIR= to say where utils and *.SAV files kept.

Version 1.4 1993 June 1
- new phone number and address

Version 1.3
- change status to shareware
- banner changes
- error message beeps

Version 1.2
- bypassed to keep in sync with CMOSSAVE

Version 1.1
- released to BIX 91/09/23
- simpler use, parallels CMOSSave

Version 1.0
- released to BIX 90/11/19

How to Assemble
***************

Manually set the GENERATING equate in embedded in the following code, then:

to assemble with MASM 6.0 use:
ML.EXE /AT /c /Fl /VM /Zf /Zm BOOT.Asm
LINK.EXE /TINY /MAP BOOT.Obj,BOOT.com,BOOT.map;
copy boot.com bootsave.com

to assemble with OPTASM use:
Optasm	 BOOT.Asm,BOOT.Obj,BOOT.Lst/L/N/G/S
OLINK	 BOOT.Obj,BOOT.COM,/MAP/TINY;
copy boot.com bootsave.com

| ; end of comment


;	E Q U A T E S

BootSAVE	EQU	1
BootREST	EQU	2
BootCHK 	EQU	3

; use /DGenerating#BootSAVE
;     /DGenerating#BootREST
;     /DGenerating#BootCHK
; on the assembler command line to select which version
; of the code to assemble.
;	Or add code following of the form:

; GENERATING EQU BootCHK



	If	Generating eq BootSave
%OUT Generating BootSave.Com
	Endif

	If	Generating eq BootRest
%OUT Generating BootRest.Com
	endif

	If	Generating eq BootChk
%OUT Generating BootChk.Com
	endif
;==============================================================


stack	segment stack		; keep MS link happy by providing null stack
stack	ends

CODE	SEGMENT PARA		; start off in code.

;==============================================================

data	segment byte		; provide a separate DATA segment
				; actually all come after the code

;==============================================================

;  V A R I A B L E S


	If	Generating eq BootSave

BannerMsg	DB ' BootSave 1.8 ۲',13d,10d
	DB	13d,10d
	DB	'Saves contents of hard disk master boot sector to a file on disk or floppy.',13,10
	DB	'Copyright (c) 1991,1996 Roedy Green Canadian Mind Products.',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'Shareware to freely distribute and use for any purpose except military.',13,10
		DB 13,10
		db '$'

UsageMsg	DB ' Error ۲',7,13,10
		DB 'Insert a formatted diskette.',13,10
		DB 'then try:',13,10
		DB 'BootSav A:\Boot.Sav',13,10
		DB 'or if want to save on hard disk try:',13,10
		DB 'BootSav C:\SAFE\Boot.Sav',13,10
		DB 'Read Boot.Txt to find how to use it properly.',13,10
		db '$'

FileTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot create the disk file.',13,10
		db '$'

BootTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot read the boot sector.',13,10
		db '$'


WorkedMsg	DB 'Hard disk master boot sector successfully saved.',13,10
		db '$'

	EndIf


	If	Generating eq BootRest

BannerMsg	label byte
	DB ' BootRest 1.8 ۲',13d,10d
	DB 13d,10d
	DB	'Restores hard disk master boot sector from a BootSave file on disk or floppy.',13,10
	DB	'Copyright (c) 1991,1996 Roedy Green Canadian Mind Products.',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'Shareware to freely distribute and use for any purpose except military.',13,10
	DB 13,10
	db '$'

UsageMsg	DB ' Error ۲',7,13,10
		DB 'Insert the diskette you used for BootSave.',13,10
		DB 'then try:',13,10
		DB 'BootRest A:\Boot.Sav',13,10
		DB 'or if the file is on hard disk try:',13,10
		DB 'BootRest C:\SAFE\Boot.Sav',13,10
		DB 'Read Boot.Txt to find how to use it properly.',13,10
		db '$'

GeomMsg 	DB ' Error ۲',7,13,10
		DB 'The Boot.Sav file does not match the geometry of this hard disk.',13,10
		DB 'Either you have a Boot.Sav file from a different computer,',13,10
		DB 'or you have changed the disk drive since you did the BootSave,',13,10
		DB 'or your CMOS disk configuration is corrupted.',13,10
		DB 'Your hard disk boot sector has been left as is.',13,10
		DB '$'

FileTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot find/read the disk file.',13,10
		db '$'

BootTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot write the boot sector.',13,10
		db '$'

HardMsg 	DB ' Error ۲',7,13,10
		DB 'Hard disk failed.',13,10
		db '$'

WorkedMsg	DB 'Hard disk master boot sector successfully restored',13,10
		db '$'

	EndIf

	If	Generating eq BootChk

BannerMsg	DB ' BootChk 1.8 ۲',13d,10d
	DB 13d,10d
	DB	'Ensures hard disk master boot sector not corrupted or changed.',13,10
	DB	'Copyright (c) 1991,1996 Roedy Green Canadian Mind Products.',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'Shareware to freely distribute and use for any purpose except military.',13,10
	DB	13,10
	db	'$'

UsageMsg	DB ' Error ۲',7,13,10
		DB 'Insert the diskette you used for BootSave.',13,10
		DB 'then try:',13,10
		DB 'BootChk A:\Boot.Sav',13,10
		DB 'or if you have the file on hard disk try:',13,10
		DB 'BootChk C:\SAFE\Boot.Sav',13,10
		DB 'Read Boot.TXT to find how to use it properly.',13,10
		db '$'

FileTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot find/read the disk file.',13,10
		db '$'

BootTroubleMsg	DB ' Error ۲',7,13,10
		DB 'Cannot read the boot sector.',13,10
		db '$'

GeomMsg 	DB ' Error ۲',7,13,10
		DB 'The Boot.Sav file does not match the geometry of this hard disk.',13,10
		DB 'Either you have a Boot.Sav file from a different computer,',13,10
		DB 'or you have changed the disk drive since you did the BootSave,',13,10
		DB 'or your CMOS disk configuration is corrupted.',13,10
		DB 'Try using CMOSREST to fix your CMOS.',13,10
		DB '$'

MatchTroubleMsg DB ' Error ۲',7,13,10
		DB 'Hard disk master boot sector has been corrupted!',13,10
		db '$'

WorkedMsg	DB 'Hard disk master boot sector is OK, i.e. unchanged since the last BootSave.',13,10
		db '$'

	EndIf

ParmIndex	DW	0


Filename	DB	64 dup (0)
			; asciiz filename

SlashQuiet	DB	0
			; -1 means quiet mode /QQ

CXSave		DW 0	; disk geometry from INT 13/08
DXSave		DW 0	; will be saved along with boot record

Buffer		dw 0	; dynamic buffer will grow to 512
			; it hangs out past the end of the program

Buffer2 	equ	Buffer+512
			; used to compare two versions of sector

data		ends

com	group	code,data	; force data segment to go at the end

	ASSUME	CS:com,DS:com,ES:com,SS:com
				; seg regs cover everything
	ORG	100H		; in Code segment

;==========================

Main	proc	far

;	M A I N L I N E   R O U T I N E
Start:
	Call	Parse		; get filename from command line

	lea	dx,BannerMsg	; display the banner after have /Q
	Call	SayQ

	If	Generating eq BootSave
	call	GetBoot 	; fetch Boot to buffer
	call	SaveGeom	; save disk geometry as well
	call	WriteBoot	; write Boot contents to file
	lea	dx,WorkedMsg	; crow about success
	Call	Say
	EndIf

	If	Generating eq BootRest
	call	ReadBoot	; read Boot contents from file
	call	CheckGeom	; make sure disk geometry matches
				; safety check we have the right file.
	call	PutBoot 	; store buffer to Boot
	lea	dx,WorkedMsg	; crow about success
	Call	Say
	EndIf

	If	Generating eq BootChk
	call	ReadBoot	; read Boot contents from file
	call	CheckGeom	; make sure disk geometry matches
				; safety check we have the right file.
	call	Duplicate	; make copy in Buffer2
	call	GetBoot 	; get current boot into Buffer
	call	CompareBoot	; compare buffer with Buffer2
	lea	dx,WorkedMsg	; crow about success
	Call	SayQ
	EndIf

Done:
	mov	ax,4c00h
	int	21h		;normal termination

Main	EndP

;===============================================================

Trouble proc	near

FileTrouble:
	Lea	dx,FileTroubleMsg	; display file trouble
	Call	Say
	Jmp	Abort

BootTrouble:
	lea	dx,BootTroubleMsg	; display problems reading boot sector
	Call	Say
	Jmp	Abort

SyntaxTrouble:
	lea	dx,BannerMsg
	Call	Say			; always display banner on syntax error error
	lea	dx,UsageMsg		; display usage message
	Call	Say
	Jmp	Abort

	If	Generating ne BootSave

GeomTrouble:
	Lea	dx,GeomMsg		; display geometry trouble
	Call	Say
	Jmp	Abort

	EndIf

	If	Generating eq BootChk

MatchTrouble:
	lea	dx,MatchTroubleMsg	; display Boot mismatch
	call	Say
	mov	ax, 4c01h		; ERRORLEVEL = 1
	int	21h			; DIE

	EndIf

abort:
					; error exit
	mov	ax, 4c04h		; ERRORLEVEL = 4
	int	21h			; DIE

Trouble endp

;===============================================================

SayQ	Proc
;	on entry DX points to a string to display
;	Only displays string if /Q not on
	test	SlashQuiet,-1
	jnz	Quietly
	call	Say
Quietly:
	ret
SayQ	Endp

;========================================
Say	Proc

;	on entry DX points to a string to display

	MOV	AH,9
	Int	21h
	ret

Say	EndP

;======================================

	If	Generating ne BootRest

GetBoot Proc	Near

;	Read first sector, the boot block of hard disk C:

	mov	ah,02		; function 2 read
	mov	dl,080h 	; C:= 080h
	mov	dh,0		; head 0
	mov	ch,0		; cyl 0
	mov	cl,1		; sector 1 is first
	mov	al,1		; just 1 sector
	lea	bx,Buffer	; ES:BX is buffer
	int	13h
	jc	BootTrouble
	ret

GetBoot EndP

	EndIf

;===============================================================

	If	Generating eq BootSave

SaveGeom	Proc	Near

;	Save disk geometry (heads, cyls)
;	We can later ensure we are restoring to a suitable disk

	mov	dx,0080h	; get drv parms for disk c:
	mov	ax,0800h	; ah 08 = get disk parameters
	int	13h		; into CX/DX
	jc	BootTrouble
	mov	CXSave,CX
	mov	DXSave,DX
	ret

SaveGeom	EndP

	EndIf

;===============================================================

	If	Generating eq BootRest

PutBoot Proc	Near

;	Write first sector, the boot block of hard disk C:

	mov	ah,03		; function 3 write
	mov	dl,080h 	; 80h = C:
	mov	dh,0		; head 0
	mov	ch,0		; cyl 0
	mov	cl,1		; sector 1 is first
	mov	al,1		; just 1 sector
	lea	bx,Buffer	; ES:BX is buffer
	int	13h
	jc	BootTrouble
	ret

PutBoot EndP

	EndIf

;===============================================================

	If	Generating eq BootChk

Duplicate	Proc	Near

;	Make a duplicate copy of Buffer in Buffer2

	lea	si,Buffer
	lea	di,Buffer2
	mov	cx,512/2
	rep movsw
	ret

Duplicate	EndP

	EndIf

;===============================================================

	If	Generating eq BootChk

CompareBoot	proc	Near

;	compares buffer version of Boot with contents of actual Boot
;	Aborts if finds a mismatch

	lea	si,Buffer
	lea	di,Buffer2
	mov	cx,512/2
	rep cmpsw
	jne	MatchTrouble
	ret

CompareBoot	EndP

	EndIf

;===============================================================

	If	Generating ne BootSave

ReadBoot	Proc	Near

;	Open a file read the Boot.sav into a buffer

	lea	dx,FileName	; DS:DX point to file
	xor	al,al		; AL=0 is attribute read/only
	mov	ah,03Dh 	; DOS open function
	int	21h
	jc	FileTrouble
	mov	bx,ax		; save handle
	mov	cx,512+4	; read CX DX + 1 sector
	lea	dx,CXSave	; buffer address
	mov	ah,3fH		; DOS read
	int	21h
	jc	FileTrouble
	cmp	ax,512+4
	jne	FileTrouble
	mov	ah,3eh		; DOS close
	int	21h
	jc	FileTrouble
	ret

ReadBoot	EndP

	EndIf

;===============================================================

	If	Generating ne BootSave

CheckGeom	Proc	Near

;	Check disk geometry (heads, cyls)
;	Ensure we are restoring to a suitable disk

	mov	dx,0080h	; drive no. for c:
	mov	ax,0800h	; ah 08 = get disk parameters
	int	13h		; into CX/DX
	jc	BootTrouble
	cmp	CX,CXSave
	jne	GeomTrouble
	cmp	DX,DXSave
	jne	GeomTrouble
	ret

CheckGeom	EndP

	EndIf

;===============================================================

	if	Generating eq BootSave

WriteBoot	Proc	Near

;	Create a boot.sav file write Boot to it

	lea	dx,FileName	; DS:DX point to filename
	xor	cx,cx		; CX=0 is attribute
	mov	ah,03ch 	; DOS create function
	int	21h
	jc	FileTrouble
	mov	bx,ax		; save handle
	mov	cx,512+4	; write CX/DXSave + 1 sector buffer
	lea	dx,CXSave	; buffer address
	mov	ah,40h		; DOS write
	int	21h
	jc	FileTrouble
	cmp	ax,512+4
	jne	FileTrouble
	mov	ah,3eh		; DOS close
	int	21h
	jc	FileTrouble
	ret

WriteBoot	EndP

	EndIf

;===============================================================

Parse	Proc	near
;	Parse the command line and process each parameter.
;	sample inputs
;	CMOSSAVE A:\CMOS.SAV /Q
;	CMOSREST C:\SAFE\CMOS.SAV
				; counted string at HEX 80 PSP
				; contains command line.
				; Preceeded by unwanted spaces.
				; possibly followed by unwanted spaces.
				; currently missing a trailing null.
				; Both ES and DS cover the command line
				; since this is a COM file.
				; However to make code compatible with EXE
				; files we use ES: to cover the command line.
	call	CommandLine	; string addr ES:bx, length cx.
	jcxz	NullParms

	mov	ParmIndex,1	; start parsing with the 1st parm
				; note start with 1 not 0!
				; We don't want the the program name.
	jmp	Short Parseloop

NullParms:
NoMoreParms:
	test	fileName,-1	; ensure some sort of filename provided
	jz	BadCmd		; by the time all done
	mov	ax,DS
	mov	ES,ax		; restore ES to match DS, for COM file
	ret			; we are done

Parseloop:
	call	CommandLine	; commmandline=ES:bx, length=cx
	mov	dx,ParmIndex
	call	NthParm 	; work left to right
	jcxz	NoMoreParms	; null param means no more
				; e.g. ES:bx points to A: or /Q
				; cx is length of that piece
	mov	ax,ES:[bx]	; al=A ah=:  or  al=/ ah=Q
	call	ToUc		; Convert both chars to upper case
	xchg	ah,al
	call	ToUc
	cmp	ah,'/'		; drive or Switch?
	jne	ProcessDrive
				; it was a switch with slash
				; was it /Q?
	cmp	al,'Q'
	JE	ProcessQ
				; something else, give up.
BadCmd:
	Jmp	SyntaxTrouble

ProcessDrive:
				; don't insist on drive letter.
				; should have C:\SAFE\CMOS.SAV
				; copy string to FileName
				; followed by a null

	mov	si,bx
	lea	di,FileName	; ES:si -> DS:di ( segs are backwards )
	push	ES		; swap ES DS
	push	DS
	pop	ES
	pop	DS
	rep movsb		; copy filename DS:si -> ES:di
	mov	ES:[di],byte ptr 0 ; append a null
	push	ES		; swap ES DS back to normal
	push	DS
	pop	ES
	pop	DS
	jmp	short Next

ProcessQ:			; handle /Quiet
	mov	SlashQuiet,-1

Next:
	inc	ParmIndex	; bump loop counter
	jmp	Parseloop	; loop till hit null param

Parse	EndP

;===============================================================

CommandLine Proc  near
;	gets command line into ES:bx with length in cx.
;	This version works for a COM file only.
	xor	ch,ch
	mov	cl,ES:80H
	mov	bx,81H
	ret
CommandLine EndP

;===============================================================
NthParm Proc	near
;	Parses string for Nth Parameter delimited by blanks
;	e.g.  "  A: /Q " with bx=1 would give string "/Q"
;	on entry:
;	ES:bx - string, usually the command line
;	cx - length of string
;	dx - which parm wanted 1=parm1 2=parm2 etc.
;	NthParm only finds one parm per call.
;	On exit ES:bx points to string and cx is its length.
;	If there is no parm, the length will be 0.
;	It also handles multiple leading/trailing blanks on parms.
	mov	al,20h		; al = blank  -- the search char
	mov	di,bx
Parmloop:
;	Remove leading blanks on parm
	jcxz	NullParm	; jump if null string
	repe	scasb		; scan ES:di forwards till hit non blank

				; di points just after it
				; cx is one too small, or 0 if none found
	je	NullParm	; jump if entire string was blank
	inc	cx		; cx is length of remainder of string
	dec	di		; di points to non-blank
	mov	si,di		; remember start of string
;	Search for terminating blank on parm
	jcxz	NullParm	; jump if null string
	repne	scasb		; scan ES:di forwards till hit blank
				; di points just after it
				; cx is one too small, or 0 if none found
	jne	NoBlank 	; jump if entire string was non blank
	inc	cx		; cx is length of remainder of string
	dec	di		; backup di to point to blank at string end
NoBlank:
				; di=addr tail end of command string,
				; cx=len tail end of command string
				; si=addr parm just parsed
;	Major loop for each parm
	dec	dx
	jnz	Parmloop	; loop once for each parm

	mov	cx,di
	sub	cx,si		; cx is length of parameter.
	mov	bx,si
	ret
NullParm:			; was no nth parameter
	mov	cx,0
	mov	bx,si
	ret
NthParm EndP

;==============================================================

ToUC		PROC	NEAR
;	converts char in AL to upper case
	cmp	al,'a'
	jb	FineAsIs
	cmp	al,'z'
	ja	FineAsIs
	sub	al,20H		; convert a to A
FineAsIs:
	ret

ToUc		ENDP

;======================================

CODE	ends			; end of code segment
	end	Start
