 page ,132
 .model tiny
 .code
first:
;
; WATCHCAT copyright 1989, Joseph R. Ahlgren
;  see WATCHCAT.DOC
;
; WATCHCAT performs 5 critical functions for any RBBS system:
;  1.  Reboots system if no carrier in specified period of time
;    This catches RBBS or system failures
;  2.  Reboots system if carrier lost during critical period
;    This allows Doors to be used safely
;  3.  Reboots system if 20 rings without answering phone
;    This allows system to be restarted by phone
;  4.  Reboots system if "Hit any key to return to system" message appears
;    This restarts system on a common RBBS failure
;  5.  Drops carrier if L&R shift keys pressed simultaneously
;    This allows users to be logged off without a nasty message.
;WATCHCAT loads the TSR and disables all functions
; WATCHCAT OFF disables all functions
; WATCHCAT ON enables 1,3,4,and 5
; WATCHCAT TIMER enables 2,4,and 5
;ComPort = 03f8h  ;{COM1}
;ComPort = 02f8h  ;{COM2}
;ComPort = 03e8h  ;{COM3}
;ComPort = 02e8h  ;{COM4}
;ScreenSegment = 0b800h  ;{Color}
;ScreenSegment = 0b000h  ;{Mono}
ModemStatus = 0006h
ModemControl = 0004h
CarrierDetect = 0080h
RingIndicator = 0040h
tpm = 1092 ; {ticks per minute}
RingTicks = 110; {6 seconds}
 org 100h
start:
 jmp init
RingTrigger dw 0
RingTimer db 0
Flag db 'F' and 0fh  ;  OFF ON TIME = F O I
TimerInt dd ?
Minutes dw 3*60  ;{minutes of no carrier to trigger reset, modified P. Eibl}
Seconds dw tpm
MinReset dw 3*60 ;{ change to 2 form 8 P. Eibl}
ColdBoot dd 0ffff0000h
ExitTimer db 0
DropTrigger db 3  ;Drop DTR on L&R shift
ExitMessage db 'Hit any key to return to system'
ExitMessageEnd db 0
ComPort dw 02f8h  ;{COM2}
ScreenSegment dw 0b000h  ;{Mono}
Ident db "jOeY"
Ident2 db "50c4"
timer:
 assume ds:nothing,es:nothing,ss:nothing
 cmp cs:[Flag],'F' and 0fh
 jne SystemOn
 jmp cs:[TimerInt]
SystemOn:
 push ax
 push dx
 push ds
;  4.  Reboots system if "Hit any key to return to system" message appears
;    This restarts system on a common RBBS failure
 dec cs:[ExitTimer]
 jnz NoExitLoop
 push cx
 push si
 push di
 mov ax,cs:[ScreenSegment]
 mov ds,ax
 mov cx,25
 xor si,si
SSLoop1:
 push cx
 push si
 mov cx,ExitMessageEnd-ExitMessage
 mov di,offset ExitMessage
SSLoop2:
 lodsw
 cmp al,cs:[di]
 jne SSLoop2x
 inc di
 loop SSLoop2
 jmp short NoCarrier
SSLoop2x:
 pop si
 pop cx
 add si,160
 loop SSLoop1
 pop di
 pop si
 pop cx
NoExitLoop:
;  5.  Drops carrier if L&R shift keys pressed simultaneously
;    This allows users to be logged off without a nasty message.
 xor ax,ax
 mov ds,ax
 assume ds:Lowmem
 mov al,[ShiftStatus]
 and al,0fh
 cmp al,cs:[DropTrigger]
 jne NoShift
 mov dx,cs:[ComPort]
 add dx,ModemControl
 in al,dx
; or al,1
 and al,0feh
 out dx,al       ;drop DTR
NoShift:
;  3.  Reboots system if 20 rings without answering phone
;    This allows system to be restarted by phone
 mov dx,[ComPort]
 add dx,ModemStatus
 in al,dx
 test al,RingIndicator
 jz NotRinging
 or cs:[RingTrigger],1
NotRinging:
 dec cs:[RingTimer]
 jnz NoRingTime
 mov cs:[RingTimer],RingTicks
 mov ax,cs:[RingTrigger]
 or ax,0f000h              ;P Eibl
 cmp ax,0ffffh             ;P Eibl
 je NoCarrier
 shl ax,1
 mov cs:[RingTrigger],ax
;  2.  Reboots system if carrier lost during critical period
;    This allows Doors to be used safely
NoRingTime:
 cmp cs:[Flag],'I' and 0fh
 jb NoMonitor
 je TimeCheck
 in al,dx
 and al,CarrierDetect
 jz NoCarrier
NoMonitor:
 pop ds
 pop dx
 pop ax
 jmp cs:[TimerInt]
NoCarrier:
 jmp cs:[ColdBoot]
;  1.  Reboots system if no carrier in specified period of time
;    This catches RBBS or system failures
TimeCheck:
 test al,CarrierDetect
 jnz ResetTime
 dec cs:[Seconds]
 jnz NoMonitor
 mov cs:[Seconds],tpm
 dec cs:[Minutes]
 jz NoCarrier
 jmp short NoMonitor
ResetTime:
 mov ax,cs:[MinReset]
 mov cs:[Minutes],ax
 jmp short NoMonitor
;
;
;
;
 assume ds:@code,es:@code,ss:@code
init:
 mov dx,offset SignOnMessage
 mov ax,0900h
 int 21h     ;print load message
 mov ax,[word ptr Ident2]
 xor [word ptr Ident],ax
 mov ax,[word ptr Ident2+2]
 xor [word ptr Ident+2],ax
 xor dx,dx
 mov es,dx
 mov si,offset Ident
 mov cx,cs
 mov ax,[si]
findloop:
 cmp ax,es:[si]
 jz found
NotQuite:
 inc dx
 mov es,dx
 loop findloop
LoadWatchCat:
 xor bx,bx
 mov es,bx
 mov bl,ds:[82h]
 cmp bl,'0'
 jle NoCom
 cmp bl,'4'
 jle ComSpec
NoCom:
 mov bl,'1'
ComSpec:
 mov [ComPortNumber],bl
 add bx,bx
 mov ax,es:[bx+400h-31h-31h]
 mov [ComPort],ax
 cmp byte ptr ds:[83h],'C'
 jnz NotColor
 mov [ScreenSegment],0b800h
 mov [ScreenSegNum],'8'
NotColor:
 mov ax,3508h
 int 21h     ;get timer interrupt
 mov [word ptr TimerInt],bx
 mov [word ptr TimerInt+2],es
 mov dx,offset Timer
 mov ax,2508h
 int 21h     ;set timer interrupt
 mov dx,offset message1
 mov ax,0900h
 int 21h     ;print load message
 mov dx,(init-first+15)/16
 mov ax,3101h
 int 21h      ;TSR
Found:
 mov bx,[si+2]
 cmp bx,es:[si+2]
 jnz NotQuite
 mov ax,es
 mov bx,10h
 mov di,offset message2x
 mov cx,4
loc:
 mul bx
 cmp dl,9
 jbe locx
 add dl,7
locx:
 add dl,'0'
 mov [di],dl
 inc di
 loop loc
 mov ax,es:[MinReset]
 mov es:[Minutes],ax
 mov al,ds:[83h]
 and al,0fh
 mov es:[Flag],al
 mov dx,offset message2tim
 cmp al,'I' and 0fh
 jz done
 mov dx,offset message2off
 jb done
 mov dx,offset message2on
done:
 push dx
 mov dx,offset message2
 mov ax,0900h
 int 21h
 pop dx
 mov ax,0900h
 int 21h
 mov ax,4c00h
 int 21h
message1 db 0ah,0dh,'Watchcat Loaded, set to COM'
ComPortNumber db '1 and Screen B'
ScreenSegNum db '000',0ah,0dh,'$'
message2 db 0ah,0dh,'Watchcat found at '
message2x db '0000 and set to $'
message2on db 'ON',0ah,0dh,'$'
message2off db 'OFF',0ah,0dh,'$'
message2tim db 'TIMER',0ah,0dh,'$'
SignOnMessage db 0dh,0ah,'WATCHCAT, copyright 1989 Joseph R. Ahlgren'
 db '   RBBS 703-241-7980',0dh,0ah
 db ' WATCHCAT may be freely distributed provided this message is not modified',0dh,0ah
 db ' Load with WATCHCAT ps, where p is the port number (1,2,3,4)',0dh,0ah
 db '  and s is the screen type (Color or Mono), e.g., WATCHCAT 2C',0dh,0ah
 db '  specifies COM2 and Color Screen',0ah,0dh
 db ' Subsequent calls are WATCHCAT ON, WATCHCAT OFF, and WATCHCAT TIMER',0dh,0ah
 db '  OFF disables all functions',0dh,0ah
 db '  ON reboots if carrier lost',0dh,0ah
 db '  TIMER reboots if 20 rings without answering phone, if no carrier',0dh,0ah
 db '   in 8 hours, or if "Hit any key to return to system" appears on screen',0dh,0ah
 db '   Also, pressing both Left and Right Shift keys simultaneously will',0dh,0ah
 db '   drop the line, logging off the current user.',0dh,0ah
 db '$'
 Lowmem segment at 0000h
 org 417h
ShiftStatus db ?
Lowmem ends
 end start
