/* XBBS Message Base Reader -- This module parses the control file */

#include "msgg.h"
#include "twindow.h"
#include "keys.h"
#include "headedit.h"



void pascal read_control (char *file,char *application) {

	struct nodeidx huge *nidxx=NULL;
	int pf;
	static char s[256];
	char *p;
	char *pp;
	struct ffblk f;
	char nonodelist=0;
	char nomouse=0;
	long x;

    for(x=0;x<10;x++) fkey[(word)x]=NULL;

	if(!strchr(file,'\\') && !strchr(file,':') && !strchr(file,'/')) {
		p=searchpath(file);
		file=p;
	}

	if(!(pf=_open(file,O_RDONLY | O_DENYNONE | O_TEXT))==-1) {
		error_message(" Can't open ctl file ");
		pause();
		exit(3);
	}
	fputs("\nParsing config file...",stderr);

	if(*application && application) {
		while (!eof(pf)) {
			getone(s,pf);
			if (!*s) continue;
			p=strtok(s," ");
			strupr(p);
			pp=strtok(0,"\n");
			if (pp==NULL) pp="";
			strip(pp,98);
			stripcr(p);
			if(!stricmp(p,"APPLICATION")) {
				if(!stricmp(pp,application)) break;
			}
		}
	}
	if(eof(pf)) {
		error_message(" APPLICATION statement not matched or empty file ");
		pause();
		exit(3);
	}

	while (!eof(pf)) {
		getone(s,pf);
		if (!*s) continue;
		p=strtok(s," ");
		pp=strtok(0,"\n");
		if (pp==NULL) pp="";
		strip(pp,98);
		stripcr(p);

#ifdef DEBUG

		printf("\n`%s' -> `%s'",p,pp);

#endif

		if(!stricmp(p,"SPAWNVIEW")) {
			strip(pp,79);
			if(spawnview) free(spawnview);
			spawnview=strdup(pp);
		}
		else if(!stricmp(p,"FLSEARCH")) {
			strip(pp,79);
			if(flsearch)free(flsearch);
			flsearch=strdup(pp);
		}
		else if(!stricmp(p,"ENDAPP")) break;
        else if (!stricmp(p,"ADDRESS") && noaddress<(char)(max(maxy,25)-2)) {
			strip(pp,27);
			pp=strtok(pp,":");
			address[noaddress]=(struct _address *)malloc(sizeof(struct _address));
			if (address[noaddress]==NULL) {
				fputs("\nOOM for addresses\n",stdout);
			}
			else {
				address[noaddress]->zone=(word)atol(pp);
				address[noaddress]->net=(word)atol(strtok(0,"/"));
				address[noaddress]->node=(word)atol(strtok(0,"."));
				address[noaddress]->point=(word)atol(strtok(0,"@"));
				p=strtok(0,"\n");
				strncpy(address[noaddress]->domain,p,37);
				address[noaddress]->domain[36]=0;
				noaddress++;
			}
		}
		else if(!stricmp(p,"FKEY")) {

            int temp;

            temp=atoi(strtok(pp," "));
			pp=strtok(0,"\n");
			lstrip(pp);
			if(pp!=NULL && *pp && temp>0 && temp<11) {
				if(fkey[temp-1])free(fkey[temp-1]);
				fkey[temp-1]=(char *)malloc(strlen(pp)+1);
				if(!fkey[temp-1]) continue;
				strcpy(fkey[temp-1],pp);
			}
		}
		else if(!stricmp(p,"VMODE")) {
			videomethod=atoi(pp);
		}
		else if(!stricmp(p,"HEIGHT")) {
			maxy=atoi(pp);
		}
		else if(!stricmp(p,"WIDTH")) {
			maxx=atoi(pp);
		}
		else if(!stricmp(p,"NOMOUSE")) {
			nomouse=1;
		}
		if (!stricmp(p,"NOHILITE")) {
			hilite=1;
		}
		else if (!stricmp(p,"TEMPLATE")) {
			strip(pp,79);
			if(template)free(template);
			template=strdup(pp);
		}
		else if (!stricmp(p,"TEXTEDITOR")) {
			if(texteditor) free(texteditor);
			texteditor=strdup(pp);
		}
		else if (!stricmp(p,"USEDEFAULT")) {
            usedefault=1;
        }
		else if (!stricmp(p,"MAKEINFO")) {
            makeinfo=1;
        }
		else if (!stricmp(p,"NO*PT")) {
			nopt=1;
		}
		else if (!stricmp(p,"NOINTL")) {
			nointl=1;
		}
		else if (!stricmp(p,"NOCHECK")) {
			autocheck=0;
		}
        else if (!stricmp(p,"COMPRESS")) {
			packsize=(word)atol(pp);
            if(packsize<1024)packsize=1024;
        }
        else if(!stricmp(p,"NOTRACK")) {
			notrack=1;
		}
		else if(!stricmp(p,"NETBOARD")) {
			netboard=(word)atol(pp);
			if(netboard>4095)netboard=0;
		}
		else if(!stricmp(p,"ALTBOARD")) {
			altboard=(word)atol(pp);
			if(altboard>4095)altboard=0;
		}
		else if(!stricmp(p,"TOTALAREAS")) {
			totalareas=(word)atol(pp);
			printf("\nTracking LMRs for %u areas",totalareas);
		}
		else if(!stricmp(p,"USERNUMBER")) {
			userno=(word)atol(pp);
		}
		else if (!stricmp(p,"START")) {
			areano=(word)atol(pp);
			if (areano<1 || areano>4095) areano=0;
		}
		else if (!stricmp(p,"WRAP")) {
			if(wrapcall) free(wrapcall);
			wrapcall=strdup(pp);
		}
		else if (!stricmp(p,"LINES")) {
			maxlines=(word)atol(pp);
			if (maxlines<257) maxlines=257;
		}
		else if (!stricmp(p,"BEFOREQUOTE")) {
			strip(pp,79);
			if(before_quote) free(before_quote);
			before_quote=strdup(pp);
		}
		else if (!stricmp(p,"AFTERBEFORE")) {
			strip(pp,79);
			if(after_before) free(after_before);
			after_before=strdup(pp);
		}
		else if (!stricmp(p,"AFTERQUOTE")) {
			strip(pp,79);
			if(after_quote) free(after_quote);
			after_quote=strdup(pp);
		}
		else if (!stricmp(p,"NONODELIST")) {
			nonodelist=1;
		}
		else if (!stricmp(p,"EDITOR")) {
			if(editor)free(editor);
			editor=strdup(pp);
		}
		else if (!stricmp(p,"ANSIEDITOR")) {
			if(ansieditor)free(ansieditor);
			ansieditor=strdup(pp);
		}
		else if (!stricmp(p,"NODELIST")) {
			strip(pp,78);
			if(nodepath)free(nodepath);
			nodepath=strdup(pp);
		}
		else if (!stricmp(p,"PAGELENGTH")) {
			pagelength=(char)atoi(pp);
		}
		else if (!stricmp(p,"TOPMARGIN")) {
			topmargin=(char)atoi(pp);
		}
		else if (!stricmp(p,"BOTTOMMARGIN")) {
			bottommargin=(char)atoi(pp);
		}
		else if (!stricmp(p,"LEFTMARGIN")) {
			leftmargin=(char)atoi(pp);
		}
		else if (!stricmp(p,"TEXTWIDTH")) {
			textwidth=(char)atoi(pp);
		}
		else if (!stricmp(p,"BEFOREHEADER")) {
			strip(pp,11);
			while ((p=strchr(pp,'~'))) *p='\x1b';
			while ((p=strchr(pp,'`'))) *p='\n';
			strcpy(beforeheader,pp);
		}
		else if (!stricmp(p,"AFTERTEXT")) {
			strip(pp,47);
			while ((p=strchr(pp,'~'))) *p='\x1b';
			while ((p=strchr(pp,'`'))) *p='\n';
			strcpy(aftertext,pp);
		}
		else if (!stricmp(p,"AFTERHEADER")) {
			strip(pp,11);
			while ((p=strchr(pp,'~'))) *p='\x1b';
			while ((p=strchr(pp,'`'))) *p='\n';
			strcpy(afterheader,pp);
		}
		else if (!stricmp(p,"AFTERPRINTING")) {
			strip(pp,11);
			while ((p=strchr(pp,'~'))) *p='\x1b';
			while ((p=strchr(pp,'`'))) *p='\n';
			strcpy(afterprinting,pp);
		}
        else if (!stricmp(p,"ALIAS") && noalias<(char)(max(maxy,25)-2)) {
			strip(pp,35);
			if(noalias) for(x=0;x<noalias;x++) {
				if(!stricmp(pp,alias[(word)x])) goto BreakOut;
			}
			alias[noalias]=(char *)malloc(36);
			if (alias[noalias]==NULL) {
				fputs("\nOOM for aliases\n",stdout);
			}
			else {
				strcpy(alias[noalias],pp);
				noalias++;
			}
BreakOut:
;
		}
		else if (!stricmp(p,"ATTRIBUTES")) defaultattr=(word)atol(pp);
		else if (!stricmp(p,"EXPORTNAME")) {
			strip(pp,65);
			strcpy(filenamer,pp);
		}
        else if (!stricmp(p,"PATH") && nodirs<(char)(max(maxy,25)-2)) {
			strip(pp,78);
			if(nodirs) for(x=0;x<nodirs;x++) {
				if(!stricmp(pp,dirs[(word)x])) goto BreakOut2;
			}
			dirs[nodirs]=(char *)malloc(79);
			if(dirs[nodirs]==NULL) {
				fputs("\nOOM for paths\n",stdout);
			}
			else {
				if(!*pp) dirs[nodirs]=0;
				strcpy(dirs[nodirs],pp);
				nodirs++;
			}
BreakOut2:
;
		}
		else if (!stricmp(p,"USEEMS")) {
			LIMEMS=1;
		}
		else if (!stricmp(p,"SWAP")) {
			swap=1;
		}
		else if (!stricmp(p,"SWAPDRIVE")) {
			useswapdisk=toupper(*pp);
		}
		else if (!stricmp(p,"SWAPFILE")) {
			strip(pp,63);
			strcpy(swapname,pp);
		}
		if (!stricmp(p,"TEXTCOLOR")) readtextcolor=(char)atoi(pp);
		else if (!stricmp(p,"TEXTBACK")) readtextback=(char)atoi(pp);
		else if (!stricmp(p,"STATCOLOR")) readstatcolor=(char)atoi(pp);
		else if (!stricmp(p,"STATBACK")) readstatback=(char)atoi(pp);
		else if (!stricmp(p,"HEADCOLOR")) readheadcolor=(char)atoi(pp);
		else if (!stricmp(p,"HEADBACK")) readheadback=(char)atoi(pp);
		else if (!stricmp(p,"ORIGFORE")) orig_fore=(char)atoi(pp);
		else if (!stricmp(p,"ORIGBACK")) orig_back=(char)atoi(pp);
		else if (!stricmp(p,"TEARFORE")) tear_fore=(char)atoi(pp);
		else if (!stricmp(p,"TEARBACK")) tear_back=(char)atoi(pp);
		else if (!stricmp(p,"QUOTEFORE")) quote_fore=(char)atoi(pp);
		else if (!stricmp(p,"QUOTEBACK")) quote_back=(char)atoi(pp);
		else if (!stricmp(p,"KLUDGEFORE")) kludge_fore=(char)atoi(pp);
		else if (!stricmp(p,"KLUDGEBACK")) kludge_back=(char)atoi(pp);
        else if(!stricmp(p,"BELL")) nobell=0;

        if (!stricmp(p,"ORIGIN")) {
			strip(pp,58);
			strcpy(origin,pp);
		}
		else if (!stricmp(p,"OUTBOUND")) {
			strip(pp,80);
			strcpy(outbound,pp);
        }
		else if (!stricmp(p,"INBOUND")) {
			strip(pp,80);
			strcpy(inbound,pp);
		}
		else if(!stricmp(p,"MSGAREAS")) {
			strcpy(msgareas,pp);
		}
		else if(!stricmp(p,"DOMAIL")) {
			domail=(char)atoi(pp);
		}
		else if(!stricmp(p,"SKIPDELETED")) {
			skipdeleted=(char)atoi(pp);
		}
	}
	_close(pf);

	if(!nomouse) {
		x=(long)getvect(0x33);  /* Check for mouse driver */
		if(x!=0L) {
			_AX=0;  /* Initialize mouse */
			geninterrupt(0x33);
		}
        usemouse=(unsigned char)_AX;
		if(usemouse) {	/* Make sure mouse cursor stays hidden */
			_AX=2;
			geninterrupt(0x33);
		}
	}

	if (totalareas) {
		lastread=(word *)malloc(totalareas * sizeof(word));
		if (lastread==NULL) {
			fputs("\nOut of memory for LMRs\n",stdout);
			exit(254);
		}
		for(x=0;x<totalareas;x++) lastread[(word)x]=0;
	}
	if (areano) {
		if(nodirs) strcpy(path,dirs[0]);
		if(totalareas)load_lastread();
		nomess=check_area(areano);
		if (!nomess) messno=0;
		else messno=1;
		if (areano<(totalareas+1) && nomess) messno=lastread[areano-1];
		if ((messno>nomess && nomess) || (messno==0 && nomess)) messno=1;
		if (messno) get_mess(0);
	}

	if (nonodelist) goto BigFinish;
	sprintf(s,"%sQNL_IDX.BBS",nodepath);
	if (!findfirst(s,&f,0)) {
TryNodeAgain:
		nidxsize=f.ff_fsize/(long)sizeof(struct nodeidx);
		nidx=(struct nodeidx huge *) farmalloc(nidxsize * (long)sizeof(struct nodeidx));
		if (nidx==NULL) {
			if(nidxsize<512L) {
				printf("\nScrew it, can't load nodelist.\n");
				nonodelist=0;
				nidxsize=0L;
				goto BigFinish;
			}
			nidxsize/=2L;
			f.ff_fsize=nidxsize*(long)sizeof(struct nodeidx);
			printf("\nInsufficient memory for whole nodelist index...trying %ld nodes...",nidxsize);
			goto TryNodeAgain;
		}
		if((pf=_open(s,O_RDONLY | O_BINARY | O_DENYNONE))==-1) {
			error_message(" Can't open nodelist ");
			if (nidx!=NULL) farfree ((void far *)nidx);
			nidx=NULL;
			nonodelist=0;
			nidxsize=0L;
			goto BigFinish;
		}
		fputs("\nReading nodelist...",stdout);
		nidxx=nidx;
		while (f.ff_fsize) {

			int x;

			x=32767/sizeof(struct nodeidx);
			x*=sizeof(struct nodeidx);
			if(f.ff_fsize>(long)x) {
				f.ff_fsize-=(long)x;
			}
			else {
				x=(int)f.ff_fsize;
				f.ff_fsize=0;
			}
			if (_read(pf,(void *)nidxx,x)<1 || eof(pf)==-1) {
				perror("Error");
				if (nidx) free ((void *)nidx);
				break;
			}
            nidxx=&nidx[(long)x/(long)sizeof(struct nodeidx)];
		}
		_close(pf);
	}
BigFinish:
	if(nodirs>1) nodirs=max(23,maxy-2);
}



void pascal strip (char *s,int blank) {

       lstrip(s);
       stripcr(s);
       s[blank]=0;
}




void pascal getone (char *s, int fp) {

   do {
       if (!fgetsx(s,256,fp)) *s=0;
   } while (!eof(fp) && *s==';');
   if (eof(fp)) *s=0;
}

