{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'fs_pkg.int'}
{$include: 'xmodem.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}
{$include: 'script0.int'}
{$include: 'script1.int'}
{$include: 'script2a.int'}
{$include: 'script2b.int'}
{$include: 'script3.int'}
{$include: 'script4.int'}
{$include: 'script5.int'}

IMPLEMENTATION OF script5;

USES types,globals,utils,fs_pkg,xmodem,database,load,sutils,
     script0,script1,script2a,script2b,script3,script4;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the assembler utilities packages***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

{***Interface to the MS C library***}
function system : integer [C, VARYING]; EXTERN;

var
  doseqq [EXTERN]: word;

procedure bbs5(consts s : lstring; var str : lstring);
var
  i,j : integer;
  i4 : integer4;
  next_state : task;
  p : para;
  h : mailhead;

begin
  if q[wx].state<dummy
    then next_state:=succ(q[wx].state)
    else next_state:=dummy;
  case q[wx].state of
  ordr:
    if nagree(str) then
      [q[wx].bio_msg:=nill; q[wx].bio_msg_last:=nill;
       q[wx].send_line_count:=1;
       q[wx].es:=order; display(q[wx].es^.qna)]
    else
      next_state:=q[wx].return_state;
  ordr1:
    [next_state:=q[wx].return_state;
     if q[wx].es<>nil then
       [q[wx].es:=q[wx].es^.link; display(q[wx].es^.qna)];
        if q[wx].es^.link<>nil then next_state:=ordr2];
  ordr2: prompt_with(arrow_txt);
  ordr3:
    if s<>null then
      q[wx].bio_msg_last:=newpara(s)
    else
      [display(q[wx].es^.qna); next_state:=ordr2];
  ordr4:
    [nconc(q[wx].bio_msg,q[wx].bio_msg_last);
     q[wx].send_line_count:=q[wx].send_line_count+1;
     q[wx].bio_msg_last:=nill; q[wx].es:=q[wx].es^.link;
     if q[wx].es<>nil then
       [display(q[wx].es^.qna);
        if q[wx].es^.link<>nil then next_state:=ordr2]];
  ordr5:
    [ParaToMsg(order_target,ss[48] {Order},q[wx].bio_msg);
     q[wx].count:=6; GotOrdr:=GotOrdr+1];
  ordr6:
    [next_state:=q[wx].return_state;
     if not sendmsg then
       [if q[wx].count>0
	  then [q[wx].count:=q[wx].count-1; next_state:=ordr6]
          else display(cannot_file_txt)]];
  bio: prompt_with(continue_txt);
  bio1:
    if q[wx].return_state=given_out or else nagree(str) then
      [mbx(biopath,q[wx].my.userid,str); mail_delete(str);
       if fs_openw(wx,str)=0 then
         [q[wx].bio_msg:=nill; q[wx].bio_msg_last:=nill; q[wx].es:=essay;
          q[wx].flag:=false; q[wx].count:=0; display(q[wx].es^.qna)]
       else
         [fs_close(wx); next_state:=q[wx].return_state]]
    else
      next_state:=q[wx].return_state;
  bio2: prompt_with(arrow_txt);
  bio3:
    if s=null then
      [if confirm_essay
         then prompt_with(cor_txt)]
    else
      [p:=newpara(s);
       if q[wx].bio_msg=nill
         then q[wx].bio_msg:=p
         else q[wx].bio_msg_last^.link:=p;
       q[wx].bio_msg_last:=p; q[wx].count:=q[wx].count+1;
       if q[wx].count>=msg_line_limit then
         [if confirm_essay
            then prompt_with(cor_txt)]
       else
         [prompt_with(arrow_txt); next_state:=bio3]];
  bio4:
    [q[wx].count:=0;
     if (not confirm_essay) or else agree(s) then {write q&a to file}
       [if q[wx].bio_msg<>nill then
	  [p:=q[wx].es^.qna;
	   while p<>nill do
	     [for i:=1 to ord(p^.crlfs) do if fs_puts(wx,null)<>0 then break;
	      if fs_puts(wx,p^.msg)=0 then p:=p^.link else break];
	   while q[wx].bio_msg<>nill and then
		 fs_puts(wx,q[wx].bio_msg^.msg)=0 do
	     [q[wx].flag:=true; p:=q[wx].bio_msg;
	      q[wx].bio_msg:=q[wx].bio_msg^.link; dispara(p)];
	   disparas(q[wx].bio_msg)];
	q[wx].bio_msg_last:=nill; q[wx].es:=q[wx].es^.link;
	if q[wx].es=nil then
	  [fs_close(wx);
	   if not q[wx].flag then
	     [mbx(biopath,q[wx].my.userid,str); mail_delete(str)];
	   display(filing_txt); next_state:=q[wx].return_state]
	else
	  [display(q[wx].es^.qna); next_state:=bio2]]
     else
       [disparas(q[wx].bio_msg); q[wx].bio_msg_last:=nill;
	display(q[wx].es^.qna); next_state:=bio2]];
  newpass:
    [if pwdigp then {password must contain digit or punctuation}
       [j:=0;
        for i:=1 to ord(str.len) do
          if str[i]<'A' or else str[i]>'Z' then
            [j:=1; break]]
     else
       j:=1;
     if not decode(s,i) then i:=0;
     if ord(s.len)>=shortest_password and then j=1 and then
     	not eq(s,q[wx].my.name) and then q[wx].userid<>i then
       [encrypt(str); kopystr(str,q[wx].my.pw);
	if q[wx].xover then
	  dbp_member(q[wx].userid,q[wx].my);
	next_state:=main_menu]
     else
       display(bad_pw_length_txt)];
  newpass2: [prompt_with(enter_pw_txt); next_state:=newpass];
  who:
    if q[wx].index>=who_b_low then
      [if w^[q[wx].index].active then
         [if fEmpties or else w^[q[wx].index].state=going
            then display(who_line_txt)];
       q[wx].index:=q[wx].index-1; next_state:=who]
    else
      next_state:=q[wx].return_state;
  maint: {!DOS command}
    [if str.len>0 then
       [str.len:=str.len+1; str[ord(str.len)]:=chr(0);
        eval(system(ads str[1]))];
     next_state:=main_menu];
  snip: [w^[wx].more:=-MAXINT; {suppress page pause}
         q[wx].cleanup:='I'; display(farewell_txt)];
  cleanup1:
    [i:=w^[wx].chat; if i>=0 then w^[i].chat:=-1; w^[wx].chat:=-1;
     if wx>0 and then q[wx].state2>0 then xcancel;
     fs_close(wx);
     if q[wx].handle>0 then mail_close(q[wx].handle);
     if w^[wx].file_locked<>nill then
       [dispara(w^[wx].file_locked); w^[wx].file_locked:=nill];
     q[wx].handle:=0;
     disparas(w^[wx].bulletin);
     disparas(w^[wx].chatintro);
     if w^[wx].crud
       then disparas(w^[wx].output)
       else w^[wx].output:=nill;
     sayanora; {cancel group chat} q[wx].holding:=false;
     disparas(q[wx].msg_first);
     q[wx].msg_last:=nill; q[wx].mbx_last:=nil; q[wx].msg_ptr:=nill;
     disparas(q[wx].pub_msg);
     disparas(q[wx].bio_msg);
     q[wx].bio_msg_last:=nill;
     disparas(q[wx].verify_data);
     if q[wx].qa<>nill then [dispara(q[wx].qa); q[wx].qa:=nill];
     if q[wx].msg_from<>nill
       then [dispara(q[wx].msg_from); q[wx].msg_from:=nill];
     if q[wx].msg_to<>nill
       then [dispara(q[wx].msg_to); q[wx].msg_to:=nill];
     if q[wx].msg_date<>nill
       then [dispara(q[wx].msg_date); q[wx].msg_date:=nill];
     if q[wx].msg_subject<>nill
       then [dispara(q[wx].msg_subject); q[wx].msg_subject:=nill];
     disparas(q[wx].xstr);
     if q[wx].buffer<>RETYPE(bpara,nill)
       then [disbpara(q[wx].buffer); q[wx].buffer:=RETYPE(bpara,nill)];
     if q[wx].mail_mod then
       [mbx(mailpath,q[wx].my.userid,str); mail_delete(str)];
     q[wx].count:=0]; {counting messages}
  cleanup2:
    [if q[wx].mbx_first=nil then
       [if q[wx].handle>0 then
          [mail_close(q[wx].handle);
           if w^[wx].file_locked<>nill then
             [dispara(w^[wx].file_locked); w^[wx].file_locked:=nill]];
        q[wx].handle:=0;
{update members file}
        if q[wx].logged_in and then ((not q[wx].xover) or q[wx].mail_mod) then
          [if q[wx].my.junk[1]='J' then q[wx].count:=q[wx].count+1;
           if q[wx].mail_mod and then (not q[wx].mail_io_error) and then
              encode(str,q[wx].count:1) then
             kopystr(str,q[wx].my.mbx_count);
           if not q[wx].xover then
             [i4:=jt-w^[wx].connect_sec0;
              if i4<0 then i4:=jt; {just count time used on current day}
              q[wx].minutes_on:=ord(i4 div 60)+1;
              i:=q[wx].minutes_2day+q[wx].minutes_on;
	      if i<0 then i:=0 else if i>9999 then i:=9999;
              if encode(str,i:1) then kopystr(str,q[wx].my.minutes_today);
              kopystr(w^[wx].date_of_call,q[wx].my.last_called_date);
              kopystr(w^[wx].time_of_call,q[wx].my.last_called_time)];
           dbp_member(q[wx].userid,q[wx].my)];
        next_state:=cleanup4]
     else if q[wx].mbx_first^.deleted then     
       [disparas(q[wx].mbx_first^.text_first);
        h:=q[wx].mbx_first^.head_link; dishead(q[wx].mbx_first);
        q[wx].mbx_first:=h; next_state:=cleanup2]
     else
       [if q[wx].handle=0 and then q[wx].mail_mod then
          [mbx(mailpath,q[wx].my.userid,str);
           q[wx].handle:=mult_open(str,0)];
        if q[wx].handle>0 then
          [q[wx].index:=0; p:=q[wx].mbx_first^.text_first;
           while p<>nill do [q[wx].index:=q[wx].index+1; p:=p^.link];
           eval(encode(str,q[wx].index:3));
           mail_writeln(q[wx].handle,str); q[wx].count:=q[wx].count+1]
        else
          [q[wx].mbx_first^.deleted:=true; next_state:=cleanup2]]];
  cleanup3:
    [if q[wx].mbx_first=nil then
       next_state:=cleanup2
     else if q[wx].mbx_first^.text_first=nill then
       [h:=q[wx].mbx_first^.head_link;
        dishead(q[wx].mbx_first);
        q[wx].mbx_first:=h;
        next_state:=cleanup2]
     else
       [if q[wx].mail_mod then
          [kopylst(q[wx].mbx_first^.text_first^.msg,str);
           mail_writeln(q[wx].handle,str)];
        p:=q[wx].mbx_first^.text_first;
        q[wx].mbx_first^.text_first:=p^.link; dispara(p);
        next_state:=cleanup3]];
  cleanup4:
{update userlog.  this occurs after members file update.}
    [if q[wx].logged_in and then (not q[wx].xover) and then
        q[wx].userid>=log_lowest then
       [eval(encode(str,q[wx].callno:-8));
        movel(adr str[1],adr q[wx].my.pw,8);
        eval(encode(str,wx:1)); kopystr(str,q[wx].my.mbx_max);
        movel(adr mydate[1],adr q[wx].my.mult_answer[5][1],8);
        movel(adr mytime[1],adr q[wx].my.mult_answer[5][9],8);
        eval(encode(str,w^[wx].baud:5));
        movel(adr str[1],adr q[wx].my.mult_answer[5][17],5);
        if q[wx].xcall
          then q[wx].my.active[1]:='X'
          else q[wx].my.active[1]:=' ';
        dbp_userlog(userlog_next,q[wx].my);
        if userlog_next>userlog_entries then userlog_entries:=userlog_next;
        userlog_next:=userlog_next+1;
        if userlog_next>userlog_max then userlog_next:=1];
     if (jt div 3600)<>(last_save div 3600) then
       db_update_all; {save db once per hour}
     q[wx].xcall:=false; q[wx].logged_in:=false;
     case q[wx].cleanup of
      'Q' : [doseqq:=2; running:=false];
      'X' : [q[wx].xcall:=true; next_state:=top];
      otherwise [w^[wx].state:=stopped; w^[wx].node_type:=nt_prompt];
     end {case};
     newstat(wx,0,iattr,null);
     copylst(ss[36],str); {Line 0:}
     for i:=1 to ord(str.len) do
       if str[i]='0' then
         [str[i]:=chr((wx mod 10)+ord('0'));
          if wx>9 and then i>1 then str[i-1]:=chr((wx div 10)+ord('0'));
          break];
     newstat(wx,0,iattr,str)];
  otherwise {dummy}
    [w^[wx].state:=stopped; w^[wx].node_type:=nt_prompt; next_state:=dummy];
  end {case};
  q[wx].state:=next_state;
end {bbs5};

function pre_scr{consts s : lstring; var str : lstring}  {boolean};
var
  i : integer;
  p : para;
begin
  pre_scr:=false;
  if w^[wx].state=starting then
    [q[wx].state:=top; q[wx].return_state:=main_menu; q[wx].userid:=0;
     q[wx].level:=0; q[wx].minutes_on:=0; q[wx].minutes_2day:=0;
     q[wx].logged_in:=false; q[wx].xcall:=false;
     q[wx].cleanup:='I'; q[wx].sysop:=false; q[wx].last_chat:=0;
     if w^[wx].file_locked<>nill then w^[wx].file_locked^.msg:=null; 
     w^[wx].rw:=reading; w^[wx].state:=going]
  else if w^[wx].state=stopping and then {don't interrupt sending mail/exiting}
     not (q[wx].state in [verify_mail3,junk3,cleanup1..dummy]) then
    q[wx].state:=snip;
  if s=null then
    str.len:=0
  else if s[1]=chr(3) then {Handle Control-C}
    [case cc[q[wx].state] of
       zot : return;
       nada : [w^[wx].node_type:=nt_compute; return];
       nadamm: if q[wx].logged_in
                 then [q[wx].state:=main_menu; q[wx].return_state:=main_menu]
                 else [w^[wx].node_type:=nt_compute; return];
       mm : if q[wx].logged_in
              then [q[wx].state:=main_menu; q[wx].return_state:=main_menu]
              else [q[wx].state:=snip; q[wx].return_state:=snip];
       rs : q[wx].state:=q[wx].return_state;
       rs_close : [fs_close(wx); q[wx].state:=q[wx].return_state];
       rs_kill : [disparas(q[wx].msg_first);
                  q[wx].msg_last:=nill; q[wx].msg_ptr:=nill;
		  q[wx].state:=q[wx].return_state];
       mm_kill : [if not q[wx].holding then
                    [disparas(q[wx].msg_first);
                     q[wx].msg_last:=nill; q[wx].msg_ptr:=nill];
                  if q[wx].logged_in then
                    [q[wx].state:=main_menu; q[wx].return_state:=main_menu]
                  else
                    [q[wx].state:=snip; q[wx].return_state:=snip]];
       canrep : [fs_close(wx); disparas(q[wx].msg_first);
                 q[wx].msg_last:=nill; q[wx].msg_ptr:=nill];
       cm : [disparas(q[wx].xstr); sayanora; q[wx].state:=chat_menu];
       lm : q[wx].state:=libr_menu;
       lm3 : q[wx].state:=libr3_menu;
       sm : q[wx].state:=sendmail_menu;
       pub3 : q[wx].state:=pubmail3;
       pub5 : [disparas(q[wx].pub_msg);
               q[wx].state:=pubmail5; q[wx].return_state:=pubmail5];
       bio_close : [fs_close(wx);
       		    disparas(q[wx].bio_msg); q[wx].bio_msg_last:=nill;
		    q[wx].state:=q[wx].return_state];
       ordr_close : [disparas(q[wx].bio_msg); q[wx].bio_msg_last:=nill;
		     q[wx].state:=q[wx].return_state];
       db : q[wx].state:=db1;
     end {case};
     ucs(s,str)]
  else
    [ucs(s,str);
     {BYE, OFF, EXIT}
     if ((str[1]=ss[37][1])or(str[1]=ss[38][1])or(str[1]=ss[39][1])) and then
        (eq(str,ss[37]) or eq(str,ss[38]) or eq(str,ss[39])) and then
        (not (q[wx].state in [sendmail_prompt..sendmail_cancel,gchat])) then
       [w^[wx].node_type:=nt_compute; q[wx].state:=snip]];
  pre_scr:=true;
end {pre_scr};

procedure bbs{consts s : lstring};
var
  str : lstring(long_line);
begin
  if not pre_scr(s,str) then return;
  w^[wx].node_type:=nt_compute;
  if q[wx].state<main_menu then
    bbs0(s,str)
  else if q[wx].state<delete_old then
    bbs1(s,str)
  else if q[wx].state<libr_menu then
    bbs2a(s,str)
  else if q[wx].state<userlog then
    bbs2b(s,str)
  else if q[wx].state<pubmail5 then
    bbs3(s,str)
  else if q[wx].state<ordr then
    bbs4(s,str)
  else
    bbs5(s,str);
end {bbs};

procedure swap_ovl;
begin
{just a dummy call that forces the script overlay to be brought in}
end {swap_ovl};

END.
