{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'load.int'}
{$include: 'utils.int'}
{$include: 'database.int'}
{$include: 'dlxutil.int'}

IMPLEMENTATION OF dlxutil;

USES types,globals,load,utils,database;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

const
  bs = chr(8);
  lf = chr(10);
  cr = chr(13);

var
  row0 [EXTERN], col0 [EXTERN], lmc0 [EXTERN] : integer;
  screen_ptr [EXTERN] : screen_ads_typ;

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}

{***Interface to KBD library***}
{$include: 'kbd.int'}

{***Interface to MS Pascal library***}
procedure date(var s : string); EXTERN;
function dosxqq(command, parameter: word): byte; EXTERN;

procedure clean_up;
var
  i : integer;
  flag : boolean;
begin
{shut down active lines}
  for i:=number_of_lines downto 1 do
    if w^[i].active then
      [if i>0 then
         [select_port(i); dtr_off; close_com];
       if w^[i].onscreen then
         [newstat(i,ord(ss[36].len)+1,iattr,null);
          newstat(i,ord(ss[36].len)+1,iattr,ss[2])]]; {Inactive}
{restore old serial drivers}
  restorec(1);
  restorec(2);
  db_close_all;
{clear screen}
  scrollup(0,srm1*256+scm1,7,0); setcp(0,0);
  alls_well:=true;
end {clean_up};

procedure allow_break;
begin
  eval(dosxqq(11,0));
end {allow_break};

procedure send_ls{consts s : string};
begin
  for var i:=1 to UPPER(s) do send(s[i]);
end {send_ls};

function send_para{p : para} {boolean};
var
  i : integer;
begin
  for i:=w^[wx].more_crlfs+1 to ord(p^.crlfs) do begin
    send(cr); send(lf);
    if w^[wx].row>w^[wx].bot then
      [scrollu(w^[wx].top,w^[wx].bot,nattr,1);
       w^[wx].row:=w^[wx].bot; w^[wx].col:=0];
    w^[wx].row:=w^[wx].row+1; w^[wx].lmc:=0;
    if w^[wx].more>0 then w^[wx].more:=w^[wx].more+1;
    if w^[wx].more>w^[wx].pagesize then
      [w^[wx].more_crlfs:=i;
       send_para:=false; return];
  end {for};
  for i:=1 to ord(p^.msg.len) do send(p^.msg[i]);
  send_para:=true;
end {send_para};

procedure send2{line : integer; ch : char};
var
  str : lstring(1);
begin
  if line=0
    then [w^[0].row:=row0; w^[0].col:=col0]
    else [select_port(line); send(ch); if wx>0 then select_port(wx)];
  case ch of
    bs : if w^[line].col>0 then w^[line].col:=w^[line].col-1;
    cr : w^[line].col:=0;
    lf : w^[line].row:=w^[line].row+1;
    otherwise
      if w^[line].col<screen_cols then
        [if w^[line].onscreen then
           screen_ptr^[w^[line].row,w^[line].col].character:=ch;
         w^[line].col:=w^[line].col+1];
  end {case};
  if w^[line].row>w^[line].bot then
    [if w^[line].onscreen then
       scrollup(w^[line].top*256+0,w^[line].bot*256+scm1,nattr,1);
     w^[line].row:=w^[line].bot];
  if line=0 then
    [row0:=w^[0].row; col0:=w^[0].col; setcp(row0,col0)];
end {send2};

function chat_timed_out {boolean};
var
  i4 : integer4;
  i,j,t,time2day : integer;
begin
  chat_timed_out:=false;
  if w^[wx].chat>=0 then begin
    if q[wx].level=9 or else q[w^[wx].chat].level=9 then return;
    i4:=jt-w^[wx].connect_sec0;
    if i4<0 then i4:=i4+one_day;
    q[wx].minutes_on:=ord(i4 div 60);
    i4:=jt-w^[wx].ch0;
    if i4<0 then i4:=i4+one_day;
    t:=ord(i4 div 60);
    time2day := q[wx].minutes_on + q[wx].minutes_2day;
    if nBump>0 then
      [if time2day<=bumpmax and then q[wx].level < q[w^[wx].chat].level
         then return; {let higher level user govern chat bumping}
       j:=0;
       if q[wx].level>=privnbm or else time2day<=bumpmax then
         for i:=1 to number_of_lines do
           if w^[i].active and then
              ((w^[i].state<>going) or (q[i].state>=snip)) then
	     [j:=j+1; if j>=nBump then return];
       if (q[wx].minutes_on+q[wx].minutes_2day)>time_limit[q[wx].level] then
         [notify(wx,ubumped_txt); notify(w^[wx].chat,ubumped_txt);
	  chat_timed_out:=true]
       else if not w^[wx].chat_warned and then t>chat_time_limit-3 then
         [notify(wx,ch_warn); notify(w^[wx].chat,ch_warn);
          w^[wx].chat_warned:=true; w^[w^[wx].chat].chat_warned:=true]
       else if t>chat_time_limit then
         chat_timed_out:=true]
    else if not w^[wx].chat_warned and then
       ((t>=chat_time_limit-4) or
	(q[wx].minutes_on+q[wx].minutes_2day>time_limit[q[wx].level]-3))
      then [notify(wx,ch_warn); notify(w^[wx].chat,ch_warn);
	    w^[wx].chat_warned:=true; w^[w^[wx].chat].chat_warned:=true]
    else if t>chat_time_limit or else
	    (q[wx].minutes_on+q[wx].minutes_2day>time_limit[q[wx].level])
      then chat_timed_out:=true;
  end {if};
end {chat_timed_out};

procedure domore{line : integer};
var
  p : para;
begin
  if line=0 then w^[0].row:=row0;
  w^[line].row:=w^[line].row+1; w^[line].col:=0; w^[line].lmc:=0;
  if w^[line].row>w^[line].bot then
    [scrollu(w^[line].top,w^[line].bot,nattr,1);
     w^[line].row:=w^[line].bot];
  if more_txt<>nill then begin
    if more_txt^.amper
      then p:=zip(more_txt)
      else p:=more_txt;
    if w^[line].onscreen then
      strout(w^[line].row,0,p^.msg); {-- More --}
    if line>0 then
      send_ls(p^.msg);
    w^[line].col:=ord(p^.msg.len);
    if more_txt^.amper then disparas(p);
  end {if};
  w^[line].lmc:=w^[line].col;
  if line=0 then
    [row0:=w^[0].row; col0:=w^[0].col; lmc0:=w^[0].lmc;
     setcp(row0,col0); echo_kbd]
  else
    echo_com;
end {domore};

procedure intl_date;
var
  w : word;
  ls : lstring(8);
begin
  fix_date; ls.len:=8; date(ls);
  if ls<>oldate then begin
    copylst(ls,oldate);
    w := date_format;
    copylst(ls,mydate);
    if LOBYTE(w)>0 then
      [mydate[1]:=ls[4]; mydate[2]:=ls[5];
       mydate[4]:=ls[1]; mydate[5]:=ls[2]];
    if LOBYTE(w)>1 then
      [mydate[1]:=ls[7]; mydate[2]:=ls[8];
       mydate[7]:=ls[4]; mydate[8]:=ls[5]];
    mydate[3]:=chr(HIBYTE(w));
    mydate[6]:=chr(HIBYTE(w));
    jd:=date2jd(mydate);
  end {if};
end {intl_date};

END.
