{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'database.int'}

IMPLEMENTATION OF database;

USES types,globals,utils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}

procedure closegl;
begin
  f_globals.trap:=true;
  f_globals.errs:=0;
  assign(f_globals,globs);
  rewrite(f_globals);
  if f_globals.errs=0 then
    writeln(f_globals,number_of_calls:-20,' {number of calls}');
  if f_globals.errs=0 then
    writeln(f_globals,last_new_user:-20,' {last new user number}');
  if f_globals.errs=0 then
    writeln(f_globals,mem_avl:-20,' {bytes in heap}');
  close(f_globals);
end {closegl};

procedure db_close_all;
var
  i : integer;
  pm : pubmail_ptr;
begin
{globals}
  closegl;
{members}
  close(f_members);
{userlog}
  close(f_userlog);
end {db_close_all};

procedure db_update_all;
begin
  last_save:=jt;
  db_close_all;
{members}
  f_members.mode:=direct;
  f_members.trap:=true;
  f_members.errs:=0;
  assign(f_members,members);
  reset(f_members);
  members_io_flag:=getting;
{userlog}
  f_userlog.mode:=direct;
  f_userlog.trap:=true;
  f_userlog.errs:=0;
  assign(f_userlog,ulog);
  rewrite(f_userlog);
  userlog_io_flag:=putting;
end {db_update_all};

function dbg_member{mem : integer; var where : member_record} {boolean};
begin
  dbg_member:=true;
  if mem<1 or else mem>largest_member_number then
    dbg_member:=false
  else
    [if members_io_flag<>getting or else f_members.errs<>0 then
       [close(f_members);
        f_members.mode:=direct;
        f_members.trap:=true;
        f_members.errs:=0;
        assign(f_members,members); reset(f_members);
        members_io_flag:=getting];
     if f_members.errs<>0 then
       dbg_member:=false
     else
       [seek(f_members,mem);
        if f_members.errs=0 then
          [readln(f_members,member_internal_buffer);
           movel(adr member_internal_buffer,adr where,member_length)]
        else
           dbg_member:=false]];
end {dbg_member};

procedure dbp_member{mem : integer; const where : member_record};
begin
  if mem<1 or else mem>largest_member_number+1 then
    return
  else
    [movel(adr where,adr member_buffer,member_length);
     if mem<=member_index_top then
       [member_index^[mem].active:=(member_buffer.active[1]='T');
        member_index^[mem].gender[1]:=member_buffer.gender[1];
        member_index^[mem].pref[1]:=member_buffer.pref[1];
        member_index^[mem].age:=ivalue(member_buffer.age)];
     movel(adr member_buffer,adr member_internal_buffer,member_length);
     if members_io_flag<>putting or else f_members.errs<>0 then
       [close(f_members);
        f_members.mode:=direct;
        f_members.trap:=true;
        f_members.errs:=0;
        assign(f_members,members); rewrite(f_members);
        members_io_flag:=putting];
     if f_members.errs=0 then seek(f_members,mem);
     if f_members.errs=0 then writeln(f_members,member_internal_buffer)];
end {dbp_member};

procedure dbg_userlog{dex : integer; var where : member_record};
begin
  if dex<1 or else dex>userlog_entries then
    fillc(adr where,userlog_length,' ')
  else
    [if userlog_io_flag<>getting then
       [close(f_userlog);
        f_userlog.mode:=direct;
        f_userlog.trap:=true;
        f_userlog.errs:=0;
        assign(f_userlog,ulog); reset(f_userlog);
        userlog_io_flag:=getting];
     seek(f_userlog,dex);
     readln(f_userlog,userlog_internal_buffer);
     f_userlog.errs:=0;
     movel(adr userlog_internal_buffer,adr where,userlog_length)];
end {dbg_userlog};

procedure dbp_userlog{dex : integer; const where : member_record};
begin
  if dex<1 or else dex>userlog_entries+1 then
    return
  else
    [movel(adr where,adr userlog_internal_buffer,userlog_length);
     if userlog_io_flag<>putting then
       [close(f_userlog);
        f_userlog.mode:=direct;
        f_userlog.trap:=true;
        f_userlog.errs:=0;
        assign(f_userlog,ulog); rewrite(f_userlog);
        userlog_io_flag:=putting];
     seek(f_userlog,dex);
     writeln(f_userlog,userlog_internal_buffer);
     f_userlog.errs:=0];
end {dbp_userlog};

procedure pad(vars str : lstring);
var
  i : integer;
begin
  i:=ord(str.len);
  if i<screen_cols-2 then
    fillsc(ads str[i+1],wrd(screen_cols-2-i),' ');
  str[0]:=chr(screen_cols-2);
end {pad};

function dbp_pubmail{p : para; d : char} {boolean};
var
  h,n : integer;
  str : lstring(ord(index_length));
  p2 : para;
begin
  copylst(pbd,str); concat(str,q[wx].pm^.letter);
  h:=mail_zopen(str); {DATA}
  if h<=0 then [q[wx].dos_err:=-h; dbp_pubmail:=false; return];
  n:=0;
  while p<>nill do
    [pad(p^.msg); mail_writeln(h,p^.msg);
     p2:=p; p:=p^.link; dispara(p2); n:=n+1];
  mail_close(h);
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  h:=mail_zopen(str); {INDEX}
  if h<=0 then [q[wx].dos_err:=-h; dbp_pubmail:=false; return];
  fillc(adr index_buffer,index_length,' ');
  eval(encode(str,q[wx].pm^.next_slot:10)); copystr(str,index_buffer.fptr);
  eval(encode(str,n:5)); copystr(str,index_buffer.mlen);
  index_buffer.deleted[1]:=d;
  copylst(q[wx].my.name,str); cat(str,q[wx].my.userid);
  kopystr(str,index_buffer.msg_from);
  if q[wx].msg_to=nill
    then kopystr(null,index_buffer.msg_to)
    else kopystr(q[wx].msg_to^.msg,index_buffer.msg_to);
  copystr(mydate,index_buffer.date);
  copystr(mytime,index_buffer.time);
  movel(adr index_buffer,adr str[1],index_length); str[0]:=chr(index_length);
  mail_writeln(h,str);
  mail_close(h);
  copystr(index_buffer.date,q[wx].pm^.date);
  copystr(index_buffer.time,q[wx].pm^.time);
  q[wx].pm^.next_slot:=q[wx].pm^.next_slot+n;
  q[wx].pm^.msgs:=q[wx].pm^.msgs+1;
  dbp_pubmail:=true;
end {dbp_pubmail};

function dbg_pubmail{vars p : para; dex : integer} {char};
var
  str : lstring(screen_cols);
  i,j,n : integer;
  p2,p3 : para;
  i4 : integer4;
begin
  p:=nill;
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
  assign(f_index,str); reset(f_index); seek(f_index,dex);
  readln(f_index,index_internal_buffer);
  movel(adr index_internal_buffer,adr index_buffer,index_length);
  close(f_index);
  if (f_index.errs<>0) then [dbg_pubmail:='D'; return];
  if index_buffer.deleted<>' ' then
    [dbg_pubmail:=index_buffer.deleted[1]; return];
  copylst(pbd,str); concat(str,q[wx].pm^.letter);
  f_data.mode:=direct; f_data.trap:=true; f_data.errs:=0;
  assign(f_data,str); reset(f_data);
  copylst(index_buffer.fptr,str);
  if decode(str,i4) then seek(f_data,i4);
  if q[wx].flag {scanning} then
    n:=4
  else
    [n:=ivalue(index_buffer.mlen);
     if n>(4*msg_line_limit) then n:=msg_line_limit];
  fSmall:=true; {don't waste heap space - we'll never edit these}
  for i:=1 to n do begin
    if f_data.errs<>0 then break;
    readln(f_data,str);
    for j:=ord(str.len) downto 1 do
      if str[j]=' ' then str.len:=wrd(j-1) else break;
    p3:=newpara(str);
    if p=nill
      then [p:=p3; p2:=p3]
      else [p2^.link:=p3; p2:=p3];
  end {for};
  fSmall:=false;
  close(f_data);
  dbg_pubmail:=' ';
end {dbg_pubmail};

procedure dbg_pubindex{dex : integer};
var
  str : lstring(screen_cols);
begin
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
  assign(f_index,str); reset(f_index); seek(f_index,dex);
  readln(f_index,index_internal_buffer);
  movel(adr index_internal_buffer,adr index_buffer,index_length);
  close(f_index);
end {dbg_pubindex};

{extract file number from name/number pair}
function get_num(var str : lstring) : integer;
var
  i,ii,j : integer;
begin
  ii:=0;
  for i:=ord(str.len) downto 1 do if str[i]<>' ' then [ii:=i; break];
  for j:=ii-1 downto 1 do if str[j]=' ' then [delete(str,1,j); break];
  eval(decode(str,i));
  get_num:=i;
end {get_num};

{D command from pubmail category menu}
function dbm_pubdelete{dex : index} {char};
var
  str : lstring(screen_cols);
  fl : boolean;
begin
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
  assign(f_index,str); reset(f_index); seek(f_index,dex);
  readln(f_index,index_internal_buffer);
  movel(adr index_internal_buffer,adr index_buffer,index_length);
  close(f_index);
  if f_index.errs<>0 then [dbm_pubdelete:='D'; return];
  fl:=false; {fl means permission to delete/undelete}
  if q[wx].level=9 or else
     (fTrust and (q[wx].pm^.memberid=q[wx].userid)) then
    fl:=true
  else
    [copylst(index_buffer.msg_from,str);
     if q[wx].userid=get_num(str) then
       fl:=true
     else
       [copylst(index_buffer.msg_to,str);
        if q[wx].userid=get_num(str) then
          fl:=true];
     close(f_data)];
  if fl then
    [copylst(pbi,str); concat(str,q[wx].pm^.letter);
     f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
     assign(f_index,str); rewrite(f_index); seek(f_index,dex);
     if index_buffer.deleted='D' then
       [if q[wx].level=9 or else
           q[wx].pm^.memberid=q[wx].userid or else q[wx].pm^.memberid=0
          then index_buffer.deleted:=' '
          else index_buffer.deleted:='H']
     else
       index_buffer.deleted:='D';
     movel(adr index_buffer,adr index_internal_buffer,index_length);
     writeln(f_index,index_internal_buffer);
     close(f_index)];
  dbm_pubdelete:=index_buffer.deleted[1];
end {dbm_pubdelete};

function dbm_pubhold{dex : index} {char};
var
  str : lstring(screen_cols);
  i,n : integer;
  p2 : para;
begin
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
  assign(f_index,str); reset(f_index); seek(f_index,dex);
  readln(f_index,index_internal_buffer);
  movel(adr index_internal_buffer,adr index_buffer,index_length);
  close(f_index);
  if f_index.errs<>0 then [dbm_pubhold:='D'; return];
  copylst(pbi,str); concat(str,q[wx].pm^.letter);
  f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
  assign(f_index,str); rewrite(f_index); seek(f_index,dex);
  if index_buffer.deleted<>'D' then
    [if index_buffer.deleted='H'
       then index_buffer.deleted:=' '
       else index_buffer.deleted:='H'];
  movel(adr index_buffer,adr index_internal_buffer,index_length);
  writeln(f_index,index_internal_buffer);
  close(f_index);
  dbm_pubhold:=index_buffer.deleted[1];
end {dbm_pubhold};

END.
