/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                 This module was written by Bob Hartman                   */
/*               with some hacking done by Vince Perriello                  */
/*                       BinkleyTerm timer routines                         */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

/*

  This file contains routines to implement a simple multiple
  alarm system.  The routines allow setting any number of alarms,
  and then checking if any one of them has expired.  It also allows
  adding time to an alarm.
*/

/*
 * $Log$
 */

/*
  long timerset (t)
  unsigned int t;

  This routine returns a timer variable based on the MS-DOS
  time.  The variable returned is a long which corresponds to
  the MS-DOS time at which the timer will expire.  The variable
  need never be used once set, but to find if the timer has in
  fact expired, it will be necessary to call the timeup function.
  The expire time 't' is in hundredths of a second.

  Note: This routine as coded had a granularity of one week. I
  have put the code that implements that inside the flag
  "HIGH_OVERHEAD". If you want it, go ahead and use it. For
  BT's purposes, (minute) granularity should suffice.

*/
long 
timerset (unsigned int t)
{
#ifdef HIGH_OVERHEAD

	long l;
	int l2;
	int hours, mins, secs, ths;
	extern int week_day ();

	/* Get the DOS time and day of week */
	dostime (&hours, &mins, &secs, &ths);

	l2 = week_day ();

	/* Figure out the hundredths of a second so far this week */
	l = l2 * PER_DAY +
		(hours % 24) * PER_HOUR +
		(mins % 60) * PER_MINUTE +
		(secs % 60) * PER_SECOND +
		ths;

	/* Add in the timer value */
	l += t;

	/* Return the alarm off time */
	return (l);
#else

	long l;
	int hours, mins, secs, ths;

	/* Get the DOS time */
	dostime (&hours, &mins, &secs, &ths);

	/* Convert to 100ths of a second */
	l = (mins) * PER_MINUTE + (secs) * PER_SECOND + ths;

	/* Return sum of current time and offset time */
	return (l + t);

#endif

}

/*
  int timeup (t)
  long t;

  This routine returns a 1 if the passed timer variable corresponds
  to a timer which has expired, or 0 otherwise.
*/
int 
timeup (long t)
{
	long l;

	EventSub ();

	/* Get current time in hundredths */
	l = timerset (0);

	/* If current is less then set by more than max int, then adjust */
	if (l < (t - 65536L))
	{
#ifdef HIGH_OVERHEAD
		l += PER_WEEK;
#else
		l += PER_HOUR;
#endif
	}

	/* Return whether the current is greater than the timer variable */
	return ((l - t) >= 0L);
}

/*
  long addtime (t1, t2)
  long t1;
  unsigned int t2;

  This routine adds t2 hundredths of a second to the timer variable
  in t1.  It returns a new timer variable.

        Not needed in BinkleyTerm, commented out.

long addtime (long t1, unsigned int t2)
{
   return (t1 + t2);
}
*/
