/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*            BinkleyTerm Language Compiler File Output Module              */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>

#include "language.h"

/*
 * put_language -- store compiled language file
 *
 * This is a simple four step operation
 *
 * 1. Open file for write
 * 2. Write out the used part of the fixup array
 * 3. Write out the used part of the memory block
 * 4. Close the file
 *
 */

int 
put_language (char *name_of_file)
{
	FILE *fpt;					/* stream pointer            */
	int error;					/* Internal error value      */
	int wanna_write;			/* How many we wanna write   */
	int written;				/* How many we really write  */
	long total_length;

   /*
    * Open the file for output now.
    *
    */

	fpt = fopen (name_of_file, "wb");	/* Open the file             */
	if (fpt == NULL)			/* Were we successful?       */
	{
		fprintf (stderr, "Can not open output file %s\n", name_of_file);
		return (-1);			/* Return failure to caller  */
	}

   /*
    * OK. Looking good so far. Write out the pointer array.
    * Don't forget that last NULL pointer to terminate it!
    *
    */

	wanna_write = pointer_size;	/* Number of things to write */

	/* Write the string table count */
	/* and string memory size */

	LangHdr.ElemCnt = wanna_write;
	LangHdr.PoolSize = memory_size;
	written = fwrite ((char *) &LangHdr, sizeof (struct _lang_hdr), 1, fpt);

	if (written != 1)
	{
		fprintf (stderr, "Unable to language file header\n");
		fclose (fpt);
		return (-2);
	}
	written = fwrite ((char *) pointers, sizeof (char *), wanna_write, fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write fixup array to output file\n");
		fclose (fpt);
		return (-2);
	}
	fprintf (stderr, "Pointer Table Elements: %d\n", wanna_write);

   /*
    * Pointer array is there. Now write out the characters.
    *
    */

	wanna_write = memory_size;	/* Number of chars to write  */
	written = fwrite (memory, sizeof (char), wanna_write, fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write characters to output file\n");
		fclose (fpt);
		return (-3);
	}

   /*
    * Write the terminal mode remap table, first the count,
    * then the table itself.
    */

	written = fwrite ((char *) &TrmnlAccelCnt, sizeof (short), 1, fpt);

	if (written != 1)
	{
		fprintf (stderr, "Unable to write Terminal Accel Count\n");
		fclose (fpt);
		return (-2);
	}
	wanna_write = TrmnlAccelCnt;

	written = fwrite ((char *) TrmnlAccelTbl,
		sizeof (struct _key_fnc),
		wanna_write,
		fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write terminal accel array to output file\n");
		fclose (fpt);
		return (-2);
	}

	fprintf (stderr, "Terminal Mode Remap Table Size: %d\n", wanna_write);

   /*
    * Write the unattended mode remap table, first, the count,
    * then the table itself.
    */

	written = fwrite ((char *) &UnattendedAccelCnt, sizeof (short), 1, fpt);

	if (written != 1)
	{
		fprintf (stderr, "Unable to Write Unattended Accel Count\n");
		fclose (fpt);
		return (-2);
	}
	wanna_write = UnattendedAccelCnt;

	written = fwrite ((char *) UnattendedAccelTbl,
		sizeof (struct _key_fnc),
		wanna_write,
		fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write terminal accel array to output file\n");
		fclose (fpt);
		return (-2);
	}

	fprintf (stderr, "Unattended Mode Remap Table Size: %d\n", wanna_write);

   /*
    * Write the product code table, first the string table count and
    * string memory size, then the pointer array.
    */

	written = fwrite ((char *) &PrdctHdr, sizeof (struct _lang_hdr), 1, fpt);

	if (written != 1)
	{
		fprintf (stderr, "Unable to write product code header\n");
		fclose (fpt);
		return (-2);
	}

	wanna_write = PrdctHdr.ElemCnt;	/* Number of things to write */
	written = fwrite ((char *) PrdctTbl, sizeof (char *), wanna_write, fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write prdct fixup array to output file\n");
		fclose (fpt);
		return (-2);
	}

   /*
    * Pointer array is there. Now write out the characters.
    *
    */

	wanna_write = PrdctHdr.PoolSize;	/* Number of chars to write  */
	written = fwrite (PrdctMem, sizeof (char), wanna_write, fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write characters to output file\n");
		fclose (fpt);
		return (-3);
	}

	fprintf (stderr, "Product Code Table Size: %d\n", PrdctHdr.ElemCnt);

   /*
    * Write out the ANSI table.
    */

	written = fwrite ((char *) &AnsiHdr, sizeof (struct _lang_hdr), 1, fpt);

	if (written != 1)
	{
		fprintf (stderr, "Unable to write ANSI map header\n");
		fclose (fpt);
		return (-2);
	}

	wanna_write = AnsiHdr.PoolSize;
	written = fwrite (AnsiMem, sizeof (char), wanna_write, fpt);

	if (written != wanna_write)
	{
		fprintf (stderr, "Unable to write characters to output file\n");
		fclose (fpt);
		return (-3);
	}

	fprintf (stderr, "ANSI Translate Table Size: %d\n", AnsiHdr.ElemCnt);

   /*
    * Everything's there now. Close the file.
    */

	total_length = ftell (fpt);

	fprintf (stderr, "Size of complete table: %ld\n", total_length);

	error = fclose (fpt);
	if (error != 0)
	{
		fprintf (stderr, "Unable to properly close output file %s\n", name_of_file);
		return (-4);
	}

	return (0);
}
