' opcodes.c

$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFWRD A-Z

$INCLUDE "OPCODES.BI"

%False = 0
%True = NOT %False

DIM RefText(3) AS SHARED STRING
DIM Opcodes.Opcode(%NBR.OPCODES) AS SHARED BYTE
DIM Opcodes.OperType(%NBR.OPCODES) AS SHARED BYTE
DIM Opcodes.Text(%NBR.OPCODES) AS SHARED STRING

DIM Initialized AS SHARED BYTE

SUB InitOpcodes PRIVATE
  RefText(0) = "NONE"
  RefText(1) = "CODE"
  RefText(2) = "DATA"
  ' opcode field
  Opcodes.Opcode(0) = %OPC.HALT
  Opcodes.Opcode(1) = %OPC.STATUS
  Opcodes.Opcode(2) = %OPC.RETURN
  Opcodes.Opcode(3) = %OPC.NOP
  Opcodes.Opcode(4) = %OPC.DEBUG
  Opcodes.Opcode(5) = %OPC.XXX.5
  Opcodes.Opcode(6) = %OPC.XXX.6
  Opcodes.Opcode(7) = %OPC.XXX.7
  Opcodes.Opcode(8) = %OPC.CALL
  Opcodes.Opcode(9) = %OPC.LOOP
  Opcodes.Opcode(10) = %OPC.IFTRUE
  Opcodes.Opcode(11) = %OPC.IFFALSE
  Opcodes.Opcode(12) = %OPC.GOTO
  Opcodes.Opcode(13) = %OPC.BAUD
  Opcodes.Opcode(14) = %OPC.DATABITS
  Opcodes.Opcode(15) = %OPC.STOPBITS
  Opcodes.Opcode(16) = %OPC.PARITY
  Opcodes.Opcode(17) = %OPC.QUIET
  Opcodes.Opcode(18) = %OPC.HANGUP
  Opcodes.Opcode(19) = %OPC.REPLY
  Opcodes.Opcode(20) = %OPC.DELAY
  Opcodes.Opcode(21) = %OPC.SETCOUNT
  Opcodes.Opcode(22) = %OPC.SETWAIT
  Opcodes.Opcode(23) = %OPC.SAY
  Opcodes.Opcode(24) = %OPC.WAITFOR
  Opcodes.Opcode(25) = %OPC.SETPACE
  Opcodes.Opcode(26) = %OPC.SETCASE
  Opcodes.Opcode(27) = %OPC.ACCEPT
  Opcodes.Opcode(28) = %OPC.PROTOCOL
  Opcodes.Opcode(29) = %OPC.SEND
  Opcodes.Opcode(30) = %OPC.RECEIVE
  Opcodes.Opcode(31) = %OPC.TEST
  Opcodes.Opcode(32) = %OPC.IF
  Opcodes.Opcode(33) = %OPC.IFNOT
  Opcodes.Opcode(34) = %OPC.XXX.34
  Opcodes.Opcode(35) = %OPC.XXX.35
  Opcodes.Opcode(36) = %OPC.XXX.36
  Opcodes.Opcode(37) = %OPC.XXX.37
  Opcodes.Opcode(38) = %OPC.XXX.38
  Opcodes.Opcode(39) = %OPC.XXX.39
  Opcodes.Opcode(40) = %OPC.XXX.40
  Opcodes.Opcode(41) = %OPC.USER1
  Opcodes.Opcode(42) = %OPC.USER2
  Opcodes.Opcode(43) = %OPC.USER3
  Opcodes.Opcode(44) = %OPC.USER4
  Opcodes.Opcode(45) = %OPC.USER5
  Opcodes.Opcode(46) = %OPC.USER6
  Opcodes.Opcode(47) = %OPC.USER7
  Opcodes.Opcode(48) = %OPC.USER8
  'operation type filed
  Opcodes.OperType(0) = %REF.HALT
  Opcodes.OperType(1) = %REF.STATUS
  Opcodes.OperType(2) = %REF.RETURN
  Opcodes.OperType(3) = %REF.NOP
  Opcodes.OperType(4) = %REF.DEBUG
  Opcodes.OperType(10) = %REF.IFTRUE
  Opcodes.OperType(11) = %REF.IFFALSE
  Opcodes.OperType(12) = %REF.GOTO
  Opcodes.OperType(13) = %REF.BAUD
  Opcodes.OperType(14) = %REF.DATABITS
  Opcodes.OperType(15) = %REF.STOPBITS
  Opcodes.OperType(16) = %REF.PARITY
  Opcodes.OperType(17) = %REF.QUIET
  Opcodes.OperType(18) = %REF.HANGUP
  Opcodes.OperType(19) = %REF.REPLY
  Opcodes.OperType(20) = %REF.DELAY
  Opcodes.OperType(21) = %REF.SETCOUNT
  Opcodes.OperType(22) = %REF.SETWAIT
  Opcodes.OperType(23) = %REF.SAY
  Opcodes.OperType(24) = %REF.WAITFOR
  Opcodes.OperType(25) = %REF.SETPACE
  Opcodes.OperType(26) = %REF.SETCASE
  Opcodes.OperType(27) = %REF.ACCEPT
  Opcodes.OperType(28) = %REF.PROTOCOL
  Opcodes.OperType(29) = %REF.SEND
  Opcodes.OperType(30) = %REF.RECEIVE
  Opcodes.OperType(31) = %REF.TEST
  Opcodes.OperType(32) = %REF.IF
  Opcodes.OperType(33) = %REF.IFNOT
  Opcodes.OperType(41) = %REF.USER
  Opcodes.OperType(42) = %REF.USER
  Opcodes.OperType(43) = %REF.USER
  Opcodes.OperType(44) = %REF.USER
  Opcodes.OperType(45) = %REF.USER
  Opcodes.OperType(46) = %REF.USER
  Opcodes.OperType(47) = %REF.USER
  Opcodes.OperType(48) = %REF.USER
  ' text field
  Opcodes.Text(0) = "HALT"
  Opcodes.Text(1) = "STATUS"
  Opcodes.Text(2) = "RETURN"
  Opcodes.Text(3) = "NOP"
  Opcodes.Text(4) = "DEBUG"
  Opcodes.Text(10) = "IFTRUE"
  Opcodes.Text(11) = "IFFALSE"
  Opcodes.Text(12) = "GOTO"
  Opcodes.Text(13) = "BAUD"
  Opcodes.Text(14) = "DATABITS"
  Opcodes.Text(15) = "STOPBITS"
  Opcodes.Text(16) = "PARITY"
  Opcodes.Text(17) = "QUIET"
  Opcodes.Text(18) = "HANGUP"
  Opcodes.Text(19) = "REPLY"
  Opcodes.Text(20) = "DELAY"
  Opcodes.Text(21) = "SETCOUNT"
  Opcodes.Text(22) = "SETWAIT"
  Opcodes.Text(23) = "SAY"
  Opcodes.Text(24) = "WAITFOR"
  Opcodes.Text(25) = "SETPACE"
  Opcodes.Text(26) = "SETCASE"
  Opcodes.Text(27) = "ACCEPT"
  Opcodes.Text(28) = "PROTOCOL"
  Opcodes.Text(29) = "SEND"
  Opcodes.Text(30) = "RECEIVE"
  Opcodes.Text(31) = "TEST"
  Opcodes.Text(32) = "IF"
  Opcodes.Text(33) = "IFNOT"
  Opcodes.Text(41) = "USER1"
  Opcodes.Text(42) = "USER2"
  Opcodes.Text(43) = "USER3"
  Opcodes.Text(44) = "USER4"
  Opcodes.Text(45) = "USER5"
  Opcodes.Text(46) = "USER6"
  Opcodes.Text(47) = "USER7"
  Opcodes.Text(48) = "USER8"
END SUB


FUNCTION MatchOpCode(BYVAL Opcode AS WORD) PUBLIC AS INTEGER
DIM I AS INTEGER
IF NOT Initialized THEN
  InitOpcodes
  Initialized = 1
END IF
FOR I = 0 TO %NBR.OPCODES-1
   IF Opcodes.Opcode(I) = Opcode THEN
     MatchOpCode = I
     EXIT FUNCTION
   END IF
NEXT I
MatchOpCode = -1
END FUNCTION

FUNCTION MatchOpText(BYVAL Text AS STRING) PUBLIC AS INTEGER
DIM I AS INTEGER
IF NOT Initialized THEN
  InitOpcodes
  Initialized = 1
END IF
FOR I = 0 TO %NBR.OPCODES-1
   IF Opcodes.Text(I) = Text THEN
     MatchOpText = I
     EXIT FUNCTION
   END IF
NEXT I
MatchOpText = -1
END FUNCTION

FUNCTION GetOpCode(BYVAL Index AS WORD) PUBLIC AS INTEGER
IF Index < %NBR.OPCODES THEN
   GetOpCode = Opcodes.Opcode(Index)
ELSE
   GetOpCode = -1
END IF
END FUNCTION

FUNCTION GetOpText(BYVAL Index AS WORD) PUBLIC AS STRING
IF Index < %NBR.OPCODES THEN
   GetOpText = Opcodes.Text(Index)
ELSE
   GetOpText = ""
END IF
END FUNCTION

FUNCTION GetOperType(BYVAL Index AS WORD) PUBLIC AS INTEGER
IF Index < %NBR.OPCODES THEN
   GetOperType = Opcodes.OperType(Index)
ELSE
   GetOperType = -1
END IF
END FUNCTION

FUNCTION GetOperText(BYVAL Index AS WORD) PUBLIC AS STRING
IF Index <= %DATA.REF THEN
   GetOperText = RefText(Index)
 ELSE
   GetOperText = ""
END IF
END FUNCTION
