'
' SELFTEST.BAS
'
' SELFTEST performs an external loopback test. Your serial port must be
' terminated by a loopback adapter (TX and RX pins are connected). A
' modem will usually also function as a loopback adapter.
'
' See LOOPBACK.TXT for directions on making a loopback adapter. Very easy!
'
' *** IMPORTANT: Boot to DOS before running under Windows! ***
'
$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$LINK "PCL4PB.OBJ"


DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)

%True = 0
%False = NOT %True

%PC = 1
%DB = 2
%BB = 3

' Global Variables

DIM RxBuf(512+16) AS BYTE
DIM TxBuf(512+16) AS BYTE

DIM ThePort AS SHARED INTEGER
DIM Port AS INTEGER
DIM BaudCode AS INTEGER
DIM TestString AS STRING
DIM TestLength AS INTEGER
DIM ComLimit AS INTEGER
DIM C AS BYTE
DIM TheSwitch AS INTEGER
DIM LibVer AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM Code AS INTEGER
DIM BufSeg AS INTEGER
DIM Parms AS STRING
DIM Args(10) AS STRING
DIM nArgs AS INTEGER
DIM X AS STRING
DIM RxQue AS INTEGER
DIM Rates(9) AS STRING
DIM UartString(4) AS STRING
DIM RxBase AS INTEGER
DIM TxBase AS INTEGER
DIM CharPerInt AS SINGLE

' initialize

BaudCode = -1
TheSwitch = 0
X = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" + CHR$(10)
TestString = X + X + X + X

Rates$(1) = "300"
Rates$(2) = "1200"
Rates$(3) = "2400"
Rates$(4) = "4800"
Rates$(5) = "9600"
Rates$(6) = "19200"
Rates$(7) = "38400"
Rates$(8) = "57600"
Rates$(9) = "115200"

UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

CLS

' get command line arguments

nArgs = 0
Parms = LTRIM$(RTRIM$(COMMAND$)) + " "
DO
   I = INSTR(Parms, " ")
   L = LEN(Parms)
   IF I <= 1 THEN EXIT DO
   nArgs = nArgs + 1
   Args(nArgs) = UCASE$(LEFT$(Parms, I - 1))
   Parms = LTRIM$(MID$(Parms,I,L-I+1))
LOOP

IF nArgs <> 3 THEN
   PRINT "Usage: selftest {pc|db|bb} port baudrate"
   STOP
END IF

IF Args(1) = "PC" THEN TheSwitch = %PC
IF Args(1) = "DB" THEN TheSwitch = %DB
IF Args(1) = "BB" THEN TheSwitch = %BB

IF TheSwitch = 0 THEN
   PRINT "Must specify 'PC', 'DB' or 'BB' as 1st argument"
   PRINT "1st arg ='";Args(1);"'"
   PRINT "EG:  SELFTEST PC 1 4"
   STOP
END IF

'Get baud code
FOR I = 1 TO 9
  IF Rates(I) = Args(3) THEN
     BaudCode = I
     EXIT FOR
  END IF
NEXT I

'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; Args(3)
  STOP
END IF

IF TheSwitch = %PC THEN ComLimit = %COM4
IF TheSwitch = %DB THEN ComLimit = %COM8
IF TheSwitch = %BB THEN ComLimit = %COM16

ThePort = VAL(Args(2)) -1
PRINT "ThePort  = COM";(1+ThePort)
IF ThePort < %COM1 THEN
   PRINT "Port must be >= COM1"
   STOP
END IF

IF TheSwitch = %DB THEN
   ' Custom Configuration: DigiBoard PC/8
   PRINT "[ Configuring for DigiBoard PC/8 (IRQ5) ]"
   Code = SioPorts(8,%COM1,&H140,%DIGIBOARD)
   FOR Port = %COM1 TO %COM8
     ' set DigiBoard UART addresses
      CALL ErrorCheck( SioUART(Port,&H180+8*Port) )
      ' set DigiBoard IRQ
      CALL ErrorCheck( SioIRQ(Port,%IRQ5) )
   NEXT Port
END IF

IF TheSwitch = %BB THEN
   ' Custom Configuration: BOCA BB2016
   PRINT "[ Configuring for BOCA Board BB2016 (IRQ10) ]"
   Code = SioPorts(16,%COM1,&H107,%BOCABOARD)
   FOR Port = %COM1 TO %COM16
     ' set BOCA Board UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set BOCA Board IRQ
      CALL ErrorCheck( SioIRQ(Port,%IRQ10) )
   NEXT Port
END IF

IF TheSwitch = %PC THEN
   ' Standard Configuration
   PRINT "[ Configuring for PC ]"
END IF

' set parmameters for the port
CALL ErrorCheck( SioParms(ThePort,%NoParity,%OneStopBit,%WordLength8) )
' setup receive buffer
BufSeg = 1 + VARSEG(RxBuf(0)) + (VARPTR(RxBuf(0)) \ 16)
CALL ErrorCheck( SioRxBuf(ThePort, BufSeg, %Size512) )
IF SioInfo(ASC("I")) <> 0 THEN
   'setup transmit buffer
   BufSeg = 1 + VARSEG(TxBuf(0)) + (VARPTR(TxBuf(0)) \ 16)
   CALL ErrorCheck( SioTxBuf(ThePort, BufSeg, %Size512) )
END IF

' reset ThePort
CALL ErrorCheck( SioReset(ThePort, BaudCode) )
CLS

PRINT  "SELFTEST (12/17/97)"
PRINT "   Port : COM"; LTRIM$(STR$(1+ThePort))
PRINT "   Baud : ";Rates$(BaudCode)
LibVer = SioInfo(ASC("V"))
PRINT "Library : "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))

PRINT "TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF

'use FIFO if present
Code = SioFIFO(ThePort,%LEVEL.4TH)
PRINT "   UART : "; UartString(Code)
PRINT

'init
RxBase = SioInfo(ASC("R"))
TxBase = SioInfo(ASC("T"))
TestLength = LEN(TestString)
'send string
PRINT "  Sending: ";
FOR I = 1 TO TestLength
   X$ = MID$(TestString,I,1)
   C = ASC(X$)
   Code = SioPutc(ThePort,C)
   IF C = 10 THEN
     PRINT
   ELSE
     PRINT X$;
   END IF
NEXT I
' receive string
PRINT
PRINT "Receiving: ";
RxQue = SioRxQue(ThePort)
FOR I = 1 TO TestLength
   Code = SioGetc(ThePort,18)
   IF Code < 0 THEN
       PRINT "ERROR: ";
       Code = SioError(Code)
       Call ShutDown
    END IF
    ' echo just received char
    IF Code = 10 THEN
      PRINT
    ELSE
      PRINT CHR$(Code);
    END IF
    ' compare character
    X$ = MID$(TestString,I,1)
    IF CHR$(Code) <> X$ THEN
       PRINT
       PRINT "ERROR: Expecting '";X$;"', received '";CHR$(Code)
       Call ShutDown
    END IF
 NEXT I
 PRINT
 PRINT "SUCCESS: Test AOK !"

 'check RX FIFO
 I = SioInfo(ASC("R"))
 PRINT I-RxBase;" RX interrupts on"; TestLength; " incoming bytes: "
 IF I <> RxBase THEN
   CharPerInt = TestLength / (I - RxBase)
   PRINT ROUND(CharPerInt,1); " characters per RX interrupt"
 END IF

 IF SioInfo(ASC("I")) THEN
   'check TX FIFO
   I = SioInfo(ASC("T"))
   PRINT I-TxBase;" TX interrupts on"; TestLength; " incoming bytes: "
   IF I <> TxBase THEN
     CharPerInt = TestLength / (I - TxBase)
     PRINT ROUND(CharPerInt,1); " characters per TX interrupt"
   END IF
 END IF
 Call ShutDown
END

SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
   Code = SioError(Code)
   Call ShutDown
END IF
END SUB

SUB ShutDown
DIM Code AS INTEGER
Code = SioDone(ThePort)
STOP
END SUB

