'
' FIFOTEST.BAS
'
' *** IMPORTANT: Boot to DOS before running under Windows! ***
'                The FIFO cannot be modified if running under Windows.
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$LINK "PCL4PB.OBJ"

DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)

%True = 0
%False = NOT %True

%PC = 1
%DB = 2
%BB = 3

' Global Variables

DIM RxBuf(512+16) AS BYTE
DIM TxBuf(512+16) AS BYTE

DIM ThePort AS SHARED INTEGER
DIM Port AS INTEGER
DIM BaudCode AS INTEGER
DIM BaudRate AS SINGLE
DIM TheSwitch AS INTEGER
DIM ComLimit AS INTEGER
DIM TestString AS STRING
DIM TestLength AS INTEGER
DIM C AS BYTE
DIM LibVer AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM Code AS INTEGER
DIM BufSeg AS INTEGER
DIM Parms AS STRING
DIM Args(10) AS STRING
DIM nArgs AS INTEGER
DIM X AS STRING
DIM RxQue AS INTEGER
DIM UartString(4) AS STRING
DIM RxBase AS INTEGER
DIM TxBase AS INTEGER
DIM CharPerInt AS SINGLE

' initialize

BaudCode = %Baud19200
BaudRate = 19200

TheSwitch = 0
X = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
TestString = X + X + X + X + CHR$(10) + CHR$(13)
TestString = TestString + TestString

UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

CLS

' get arguments

nArgs = 0
Parms = LTRIM$(RTRIM$(COMMAND$)) + " "
DO
   I = INSTR(Parms, " ")
   L = LEN(Parms)
   IF I <= 1 THEN EXIT DO
   nArgs = nArgs + 1
   Args(nArgs) = UCASE$(LEFT$(Parms, I - 1))
   Parms = LTRIM$(MID$(Parms,I,L-I+1))
LOOP

IF nArgs <> 2 THEN
   PRINT "Usage: FIFOTEST {pc|db|bb} port"
   STOP
END IF

IF Args(1) = "PC" THEN TheSwitch = %PC
IF Args(1) = "DB" THEN TheSwitch = %DB
IF Args(1) = "BB" THEN TheSwitch = %BB

IF TheSwitch = 0 THEN
   PRINT "Must specify 'PC', 'DB' or 'BB' as 1st argument"
   PRINT "1st arg ='";Args(1);"'"
   PRINT "EG:  FIFOTEST PC 1"
   STOP
END IF

IF TheSwitch = %PC THEN ComLimit = %COM4
IF TheSwitch = %DB THEN ComLimit = %COM8
IF TheSwitch = %BB THEN ComLimit = %COM16

ThePort = VAL(Args(2)) -1
PRINT "ThePort  = COM";(1+ThePort)
IF ThePort < %COM1 THEN
   PRINT "Port must be >= COM1"
   STOP
END IF

IF TheSwitch = %DB THEN
   ' Custom Configuration: DigiBoard PC/8
   PRINT "[ Configuring for DigiBoard PC/8 (IRQ5) ]"
   Code = SioPorts(8,%COM1,&H140,%DIGIBOARD)
   FOR Port = %COM1 TO %COM8
     ' set DigiBoard UART addresses
      CALL ErrorCheck( SioUART(Port,&H180+8*Port) )
      ' set DigiBoard IRQ
      CALL ErrorCheck( SioIRQ(Port,%IRQ5) )
   NEXT Port
END IF

IF TheSwitch = %BB THEN
   ' Custom Configuration: BOCA BB2016
   PRINT "[ Configuring for BOCA Board BB2016 (IRQ10) ]"
   Code = SioPorts(16,%COM1,&H107,%BOCABOARD)
   FOR Port = %COM1 TO %COM16
     ' set BOCA Board UART addresses
      CALL ErrorCheck( SioUART(Port,&H100+8*Port) )
      ' set BOCA Board IRQ
      CALL ErrorCheck( SioIRQ(Port,%IRQ10) )
   NEXT Port
END IF

IF TheSwitch = %PC THEN
   ' Standard Configuration
   PRINT "[ Configuring for PC ]"
END IF

' set parmameters for the port
CALL ErrorCheck( SioParms(ThePort,%NoParity,%OneStopBit,%WordLength8) )
' setup receive buffer
BufSeg = 1 + VARSEG(RxBuf(0)) + (VARPTR(RxBuf(0)) \ 16)
CALL ErrorCheck( SioRxBuf(ThePort, BufSeg, %Size512) )
IF SioInfo(ASC("I")) <> 0 THEN
   'setup transmit buffer
   BufSeg = 1 + VARSEG(TxBuf(0)) + (VARPTR(TxBuf(0)) \ 16)
   CALL ErrorCheck( SioTxBuf(ThePort, BufSeg, %Size512) )
ELSE
   PRINT "You MUST link with the version of the library"
   PRINT "(PCL4PB.OBJ) with TX interrupts enabled!"
   PRINT
   STOP
END IF

' reset port
CALL ErrorCheck( SioReset(ThePort, BaudCode) )
Code = SioDTR(ThePort,%SET.LINE)
Code = SioRTS(ThePort,%SET.LINE)
CLS

PRINT  "FIFOTEST 12/15/97"
PRINT "   Port : COM"; LTRIM$(STR$(1+ThePort))
PRINT "   Baud :"; BaudRate
LibVer = SioInfo(ASC("V"))
PRINT "Library : "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))

PRINT "TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF

' use FIFO if present
Code = SioFIFO(ThePort,%LEVEL.4TH)
PRINT "   UART : "; UartString(Code)

TxBase = SioInfo(ASC("T"))
TestLength = LEN(TestString)
'test for incoming data
Code = SioPutc(ThePort,13)
Code = SioDelay(4)
IF SioGetc(ThePort,4) > 0 THEN
  PRINT
  PRINT "*** Disconnect RS232 cable!"
  Code = SioDone(ThePort)
  STOP
END IF

'send string
FOR I = 1 TO TestLength
   X$ = MID$(TestString,I,1)
   '''PRINT X$;
   C = ASC(X$)
   Code = SioPutc(ThePort,C)
NEXT I
PRINT

'wait for all bytes to be transmitted
WHILE SioTxQue(ThePort) > 0
  Code = SioGetc(ThePort,0)
WEND

IF SioInfo(ASC("I")) <> 0 THEN
  'check TX FIFO
  I = SioInfo(ASC("T"))
  PRINT I-TxBase;" TX interrupts on"; TestLength; " transmitted bytes "
  IF I <> TxBase THEN
    CharPerInt = TestLength / (I - TxBase)
    PRINT ROUND(CharPerInt,1); " characters per TX interrupt"
    PRINT
    'PCL4PB stuffs one less than maximum FIFO size
    '15 for 16550, 31 for 16650, and 63 for 16750
    I = FIX(CharPerInt)
    IF (I>=14) AND (I<=17) THEN
      PRINT "   ==> 16 byte FIFO detected"
    END IF
    IF (I>=28) AND (I<=34) THEN
      PRINT "   ==> 32 byte FIFO detected"
    END IF
    IF (I>=60) AND (I<=66) THEN
      PRINT "   ==> 64 byte FIFO detected"
    END IF
  END IF
  Call ShutDown
END IF
END

SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
   Code = SioError(Code)
   Call ShutDown
END IF
END SUB

SUB ShutDown
DIM Code AS INTEGER
Code = SioDone(ThePort)
STOP
END SUB

 