DEFINT A-Z
DECLARE FUNCTION GetParms% (Parms$())
DECLARE SUB SetKBDRate (KBDelay AS INTEGER,_
                        KBRepeat AS INTEGER)
DECLARE SUB Usage ()

'PROGRAM - KBSETUP.BAS

' Set the desired delay/repeat rate
' for the keyboard.

'BASIC Version 7.0 users should change the next
'line to load the QBX.BI file

'$INCLUDE: 'QB.BI'

  DIM ParamStr$(2)

  KBDelay = 0
  KBRepeat = 0

  ParamCount = GetParms(ParamStr$())

  IF ParamCount = 0 THEN
	 Usage
  ELSE
	 FOR I = 1 TO ParamCount
		KeyString$ = UCASE$(LEFT$(ParamStr$(I), 1))
		IF KeyString$ >= "A" AND_
		   KeyString$ <= "D" THEN
		  KBDelay = ASC(KeyString$) - ASC("A")
		ELSE
		  KBRepeat = VAL(ParamStr$(I))
		  IF (KBRepeat < 0) OR (KBRepeat > 31) THEN
			 PRINT "-- Invalid Letter or "; ""
			 PRINT " Number Entered -->  "; ""
			 PRINT (ParamStr$(I))
			 Usage
		  END IF
		END IF
	  NEXT I

'   * Set the keyboard delay/repeat rate *

		SetKBDRate KBDelay, KBRepeat
		
	 END IF

FUNCTION GetParms% (Parms$())
CONST True = -1, False = 0
  Ub = UBOUND(Parms$)
  Cmd$ = COMMAND$
  GetParms = 0
  IF LEN(Cmd$) <> 0 THEN
	 Inside = 0
	 ParmNbr = 0
	 FOR I = 1 TO LEN(Cmd$)
		Ch$ = MID$(Cmd$, I, 1)
		IF Ch$ <> CHR$(9) AND Ch$ <> " " THEN
		  IF NOT Inside THEN
			 ParmNbr = ParmNbr + 1
			 IF ParmNbr > Ub THEN EXIT FUNCTION
			 Inside = True
		  END IF
		  Parms$(ParmNbr) = Parms$(ParmNbr) + Ch$
		ELSE
		  Inside = False
		END IF
	 NEXT I
  ELSE
	 EXIT FUNCTION
  END IF
  GetParms = ParmNbr
END FUNCTION

DEFSNG A-Z
SUB SetKBDRate (KBDelay AS INTEGER,_
                KBRepeat AS INTEGER)
  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.ax = &H305
  InRegs.bx = KBDelay * 256 + KBRepeat
  CALL Interrupt(&H16, InRegs, OutRegs)
END SUB

SUB Usage
	 PRINT
	 PRINT "KBSETUP Command format: "
	 PRINT
	 PRINT "KBSETUP  n {A | B | C | D}  "
	 PRINT
	 PRINT "n  A number from 0 to 31 "
	 PRINT "   to set the keyboard repeat rate. "
	 PRINT "   0 is the fastest and "
	 PRINT "   31 is the slowest. "; ""
	 PRINT
	 PRINT "A,B,C or D Sets the keyboard "
	 PRINT "           delay before repeating "
	 PRINT "           to 1/4, 1/2, 3/4 and "
	 PRINT "           1 second"
END SUB

