;
; *** Listing 7-3 ***
;
; Calculates the 16-bit sum of all bytes in a 128Kb block
; using optimized code that takes advantage of the knowledge
; that the first byte summed is at offset 0 in its segment.
;
; Time with LZTIME.BAT, since this takes more than
; 54 ms to run.
;
	call	ZTimerOn
	sub	bx,bx	;we'll just sum the 128Kb starting
			; at DS:0
	mov	cx,2	;count two 64Kb blocks
	mov	ax,bx	;set initial sum to 0
	mov	dh,ah	;set DH to 0 for summing later
SumLoop:
	mov	dl,[bx]	;get this byte
	add	ax,dx	;add the byte to the sum
	inc	bx	;point to the next byte
	jnz	SumLoop	;go until we wrap at the end of a
			; 64Kb block
	mov	si,ds
	add	si,1000h ;advance the segment by 64K bytes
	mov	ds,si
	loop	SumLoop	;count down 64Kb blocks
	call	ZTimerOff
