;
; *** Listing 10-15 ***
;
; Generates the 8-bit checksum of a 1000-byte array
; using LODS without a segment override, by setting
; DS up to point to the far segment for the duration
; of the loop.
;
	jmp	Skip
;
FarSeg	segment	para
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (0)
FarSeg	ends
Skip:
	call	ZTimerOn
	push	ds	;preserve the normal DS setting
	mov	si,seg ByteArray
	mov	ds,si	;point DS to the far segment for
			; the duration of the loop-we
			; won't need the normal DS setting
			; until the loop is done
	mov	si,offset ByteArray
	mov	cx,ARRAY_LENGTH
	sub	ah,ah	;zero the checksum counter
	cld		;make LODSB move the pointer up
ChecksumLoop:
	lodsb		;get the next byte to checksum
	add	ah,al	;add the byte into the checksum
	loop	ChecksumLoop
	pop	ds	;retrieve the normal DS setting
	call	ZTimerOff
