
 Title 'Wolfware Assembler Sample', 'BASIC Screen Subroutine'

;=====================================================================;
;              BASIC Clear Partial Screen Version 1.10                ;
;                                                                     ;
; BASIC machine language subroutine to scroll or clear the entire     ;
; screen or just a window within it.                                  ;
;                                                                     ;
; Five integer parameters are passed from BASIC to the subroutine:    ;
; upper row, left column, lower row, right column, and number of      ;
; lines to scroll up.  Zero lines to scroll means clear the window.   ;
;                                                                     ;
; The following is example BASIC implementation using the subroutine  ;
; in the file CLP.BLD.  The subroutine is stored in the data space of ;
; a string variable.  The string MUST NOT BE MODIFIED while the       ;
; subroutine is still being used.                                     ;
;                                                                     ;
; 10 DEF SEG                                  'BASIC data segment     ;
; 20 CLP$ = STRING$(255,0)                    'create string space    ;
; 30 CLP = VARPTR(CLP$)                       'string descriptor      ;
; 40 CLP = PEEK(CLP+1) + (PEEK(CLP+2) * 256)  'string data location   ;
; 50 BLOAD "CLP.BLD",CLP                      'load routine to CLP$   ;
; 60 '                                                                ;
; 70 'clear the entire screen                                         ;
; 80 A%=1:B%=1:C%=25:D%=80:E%=0               'set coordinates        ;
; 90 CALL CLP(A%,B%,C%,D%,E%)                 'call routine           ;
; 100 '                                                               ;
; 110 'scroll a 5 by 5 window in                                      ;
; 120 'the upper left corner up 2                                     ;
; 130 A%=1:B%=1:C%=5:D%=5:E%=2                'set coordinates        ;
; 140 CALL CLP(A%,B%,C%,D%,E%)                'call routine           ;
;                                                                     ;
; Due to a quirk of the BIOS function, the window must be bigger than ;
; one row or one column, i.e. the smallest window is two rows by two  ;
; columns.  None of the parameter values are checked, so the BASIC    ;
; program better better make sure they're valid.                      ;
;                                                                     ;
; The object code resulting from assembly is directly BLOADable from  ;
; BASIC.  Because BLOADable programs are not directly executable, it  ;
; is a good idea not to use COM (the default) as the object file      ;
; extension.                                                          ;
;=====================================================================;

 Proc Far

Blank_Atr Equ 07h       ;screen attribute for blanked screen

;----- bload header

 Db 0fdh                ;bload marker
 Dw 0f000h, 0           ;default load location
 Dw $Size               ;program size

;----- start of code

;----- load upper left row

 Mov Bp, Sp             ;base for finding parameters
 Mov Si, [Bp+12]        ;parameter location
 Mov Ch, [Si]           ;load
 Dec Ch                 ;decrement (make 0-24)

;----- load upper left column

 Mov Si, [Bp+10]        ;parameter location
 Mov Cl, [Si]           ;load
 Dec Cl                 ;decrement

;----- load lower right row

 Mov Si, [Bp+8]         ;parameter location
 Mov Dh, [Si]           ;load
 Dec Dh                 ;decrement

;----- load lower right column

 Mov Si, [Bp+6]         ;parameter location
 Mov Dl, [Si]           ;load
 Dec Dl                 ;decrement

;----- load lines to scroll

 Mov Si, [Bp+4]         ;parameter location
 Mov Al, [Si]           ;load

;----- scroll window

 Mov Bh, Blank_Atr      ;attribute for blanked lines
 Mov Ah, 6h             ;scroll function
 Int 10h                ;execute

 Ret 10                 ;exit, return to basic
 Endp

