; This program is made by Daniel Horchner.
; email: dbjh@gmx.net

segment code32 public align=16 use32

%include "raw32.inc"

;32-bit data
palette         dd      0               ; pointer to palette buffer
oldX            dw      0
oldY            dw      0
font            dd      0               ; pointer to font table
Xmsg            db      'x coordinate=',0
Ymsg            db      'y coordinate=',0
activity_msg    db      'activity',0
activity_color  db      4
nomouse_msg     db      'No mouse (driver) installed.$'

;32-bit code
main:
        mov word [v86r_ax],0            ; ax=0 -> Mouse reset/Mouse installed
        mov al,33h                      ;  check
        int RMCALL_VECT
        cmp word [v86r_ax],0ffffh       ; ax=ffffh -> mouse installed
        je short .hide
        mov edx,nomouse_msg
        call dosprint
        jmp exit

.hide:
        mov word [v86r_ax],2            ; ax=2 -> Hide mouse cursor
        int RMCALL_VECT

        call setfont                    ; Set font variable (for put funcs)

        mov word [v86r_ax],13h
        mov al,10h
        int RMCALL_VECT

        mov eax,256*3                   ; 256 palette entries; for each entry
        call getlomem                   ;  3 bytes: red, green and blue
        jc near @exit                   ;  intensity of color
        mov [palette],eax

        push ds
        pop es

        mov edi,[palette]
        add edi,(256-64)*3              ; Use last 64 palette entries
        mov ecx,64*3/4                  ; 64 red, green and blue byte values
        xor eax,eax
        rep stosd                       ; Clear palette entries (set to black)

        mov edi,[palette]
        add edi,(256-64)*3 + 2          ; blue component of color is 3rd byte
        mov ecx,63                      ; cl=intensity of blue (63 at start;
.next_entry:                            ;  standard VGA has a 6-bit DAC -> 64
        mov [edi],cl                    ;  intensities possible for red, green
        add edi,3                       ;  and blue each)
        loop .next_entry                ; Decrease blue intensity one step
                                        ; 64th intensity is omitted; already
                                        ;  set to black when clearing palette
                                        ;  entries
        cli
        mov al,256-64                   ; al=base pal entry that rgb values
        mov edx,3c8h                    ;  are written for; last 64 entries
        out dx,al
        mov esi,[palette]
        add esi,(256-64)*3
        mov ecx,64*3
        mov edx,3c9h
        rep outsb                       ; Output byte at ds:esi to port dx
        sti

        @rlp edi,0a0000h
        mov al,256-64                   ; al=palette entry
        mov ah,al
        mov dx,ax
        shl eax,16
        mov ax,dx                       ; eax=4 bytes with palette entry
        xor dl,dl                       ;  (draw 4 pixels at once; stos_d_)
.next_color:
        mov ecx,320/4                   ; 320 pixels per line
        rep stosd                       ; Draw line
        mov ecx,320/4 
        rep stosd                       ; Draw line
        mov ecx,320/4
        rep stosd                       ; Draw line
        add eax,01010101h               ; 1 dword = 4 pixels; next pal entry
        inc dl
        cmp dl,64                       ; All intensities drawn?
        jb short .next_color
        mov ecx,(200-192)*320/4
        mov eax,0ffffffffh
        rep stosd                       ; Draw remaining lines the same color
;
        mov al,33h
        mov word [v86r_ax],1            ; ax=1 -> Show mouse cursor
        int RMCALL_VECT

        mov esi,Xmsg
        mov ecx,0
        mov edx,0
        mov bl,0fh
        call gputstr
        mov esi,Ymsg
        add edx,8
        call gputstr

        mov es,[zerosel]                ; necessary for 'rectangle'
main_loop:
        mov word [v86r_ax],3            ; ax=3 -> Get mouse pos and but stat
        mov al,33h
        int RMCALL_VECT

        cmp word [v86r_bx],2            ; Right mouse button pressed?
        je short @exit

        movzx eax,word [v86r_cx]
        cmp [oldX],ax
        je short .x_done
        call update_x
.x_done:

        movzx eax,word [v86r_dx]
        cmp [oldY],ax
        je short .y_done
        call update_y
.y_done:

        mov esi,activity_msg
        mov ecx,320-8*8
        mov edx,0
        xor byte [activity_color],0ffh
        mov bl,[activity_color]
        call gputstr

        mov byte [v86r_ah],1            ; ah=1 -> Get keystroke status
        mov al,16h
        int RMCALL_VECT
        test word [v86r_flags],64       ; Zero Flag is bit 6 in flag register
        jz short @exit                  ; ZF=0 if key pressed
        jmp main_loop

@exit:
        mov byte [v86r_ah],0            ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        mov word [v86r_ax],3            ; Set video mode 3 (text 80x25x16)
        mov al,10h
        int RMCALL_VECT
        mov word [v86r_ax],0            ; ax=0 -> Mouse reset
        mov al,33h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
update_x:
        mov [oldX],ax

        mov ecx,13*8
        mov edx,0
        mov ebx,30fh

        push ebx
        push ecx
        push edx
        shl ecx,16
        mov cx,dx
        mov edx,ecx
        add edx,(3*8 << 16) + 8
        mov bl,256-64
        call rectangle
        pop edx
        pop ecx
        pop ebx

        call gputnumdec
        ret

;
update_y:
        mov [oldY],ax

        mov ecx,13*8
        mov edx,8
        mov ebx,30fh

        push ebx
        push ecx
        push edx
        shl ecx,16
        mov cx,dx
        mov edx,ecx
        add edx,(3*8 << 16) + 8
        mov bl,256-64+3
        call rectangle
        pop edx
        pop ecx
        pop ebx

        call gputnumdec
        ret

;
; Draw a picture element on the output screen ;) (macro)
; In:
;   gs = zerosel
;
;   %1 = x coordinate (dword)
;   %2 = y coordinate (dword)
;   %3 = palette entry (byte)
;   %4 = 1st temporary register (dword)
;   %5 = 2nd temporary register (dword)
; Out:
;   %4 = ?
;   %5 = ?
;
%macro  putpixel 5
        mov %4,%2
        mov %5,%2
        shl %4,8                        ; y * 256
        shl %5,6                        ; y * 64
        add %4,%5                       ; y * 320
        add %4,%1                       ; %4 = y * 320 + x
        mov byte [gs:0a0000h+%4],%3
%endmacro

;
; Draw a filled rectangle
; In:
;   es = zerosel
;   ecx = x:y coordinates of first corner
;   edx = x:y coordinates of second corner
;   bl = color
; Out:
;   CF=0 -> No error
;   CF=1 -> The x and/or y coordinates of the corners were equal
;
rectangle:
        pushad
        mov esi,ecx
        mov edi,edx
        mov al,bl                       ; al=color
        mov ah,bl
        shl eax,16
        mov al,bl
        mov ah,bl                       ; eax contains color for 4 pixels

        and ecx,0ffffh                  ; low word contains y coordinate
        and edx,0ffffh
        cmp edx,ecx
        jae short .edx_greatest
        xchg edx,ecx
.edx_greatest:
        mov ebx,ecx                     ; ebx=y start
        sub edx,ecx                     ; edx=height
        jz short .errexit

        shr esi,16                      ; high word contains x coordinate
        shr edi,16
        cmp edi,esi
        jae short .edi_greatest
        xchg edi,esi
.edi_greatest:                          ; esi=x start
        sub edi,esi
        mov ecx,edi                     ; ecx=length
        jz short .errexit

        mov edi,ebx
        shl edi,8                       ; y * 256
        shl ebx,6                       ; y * 64
        add edi,ebx                     ; y * 320
        add edi,esi                     ; y * 320 + x
        add edi,0a0000h
        mov ebp,ecx
        and ebp,3                       ; number of pixels modulo 4
        shr ecx,2                       ; number of dwords to plot
.next_y:
        mov ebx,ecx
        mov esi,edi
        rep stosd                       ; Draw a horizontal line
        mov ecx,ebp
        rep stosb                       ; Draw remaining pixels of line
        mov edi,esi
        add edi,320                     ; next line 320 bytes further in mem
        mov ecx,ebx
        dec edx
        jnz short .next_y

        popad
        clc
        ret

.errexit:
        popad
        stc
        ret

;
; Set font variable to linear address of 8x8 font in RAM
; In:
;   ds = data32sel
; Out:
;   font = linear address of font
;   eax = ?
;   ecx = ?
;   esi = ?
;   edi = ?
;
setfont:
        push es
        mov word [v86r_ax],1130h        ; al=30 -> Get cur char table info
        mov byte [v86r_bh],3            ; ROM 8x8 character table pointer
        mov al,10h
        int RMCALL_VECT
        movzx eax,word [v86r_es]        ; es:bp=pointer to table
        shl eax,4
        and dword [v86r_ebp],0ffffh     ; Clear high word for "add eax,..."
        add eax,[v86r_ebp]
        sub eax,[code32a]               ; offset of font in ROM from 'code32'
                                        ; Copy char table to RAM -> faster
        mov esi,eax                     ;  access -> faster writing of text
        mov eax,8*256                   ; 256 diff chars; 1 byte per scanline
        mov ecx,8*256/4
        call gethimem
        mov es,[data32sel]
        mov edi,eax
        rep movsd
        add eax,[code32a]
        mov [font],eax                  ; Linear address of font in RAM
        pop es
        ret

;
; Graphically put 0 terminated string to screen
; In:
;   ds:esi = address of 0 terminated string
;   gs = zerosel
;   bl = character color
;   cx = x coordinate to put top left corner of string
;   dx = y coordinate to ,,  ,,   ,,    ,,   ,,   ,,
;   font = linear address of 8x8 font
;   video mode = 8 bits per pixel
;
gputstr:
        pushad
        shl ecx,16
        mov cx,dx                       ; ecx=x:y coordinates to put string
        push ecx
        push es
        mov ax,ds                       ; First, get string length
        mov es,ax                       ; es=ds for scasb
        mov edi,esi
        mov ecx,0ffffffffh              ; Search max 4GB
        mov al,0                        ; Scan for 0 (=end of string)
        cld
        repne scasb                     ; Compare al with es:edi
        not ecx
        dec ecx                         ; When scasb stops, edi points 1 byte
                                        ;  past the 0; that's 1 byte too far
        pop es                          ; ecx=string length

        pop edx                         ; edx=x:y coordinates to put string
        mov ah,bl                       ; bl=character color

        push esp                        ; Minor adjustment for 'gputnumdec'
        push esi
putchar:
        pop esi
        mov al,[esi]                    ; al=ASCII # of character to print
        mov ebp,0                       ; ebp=scanline in character to print
        inc esi
        push esi                        ; Save pointer to string
        push ecx                        ; Save counter of chars left to print
.next_scanline:
        movzx edi,al
        shl edi,3
        add edi,[cs:font]               ; edi=font address + ASCII # * 8
        mov cl,[gs:edi+ebp]             ; cl=1 scanline of char (_8_x8...)
        mov ch,0                        ; ch=pixel # in scanline of char to
.next_pixel:                            ;  print
        test cl,80h                     ; The font is a character bit mask ->
        jz short .pixel_done            ;  Draw only the character itself
        mov edi,edx                     ; edx=x:y coordinates
        and edi,0ffffh                  ; edi=y coordinate
        mov esi,edx
        shr esi,16                      ; esi=x coordinate
        add edi,ebp                     ; edi=y + scanline # in character
        movzx ebx,ch
        add esi,ebx                     ; esi=x + pixel # in scanline of char
        putpixel esi,edi,ah, ebx,edi    ; edi= y==temp reg2 -> Is allowed
.pixel_done:
        shl cl,1                        ; Shift next bit to test position
        inc ch
        cmp ch,8                        ; Last pixel in char scanline printed?
        jb short .next_pixel
        inc ebp
        cmp ebp,8                       ; Last scanline printed?
        jb short .next_scanline
        add edx,80000h                  ; x=x+8 -> following char will be
        pop ecx                         ;  printed next to last one
        dec ecx
        jnz short putchar               ; Print next character

        pop esi
        pop esp                         ; Minor adjustment for 'gputnumdec'
        popad
        ret

;
; Graphically put number in eax to screen in decimal
; In:
;   eax = number
;   ds = data32sel; Add ds=ss code and ds-restore code if ds!=data32sel
;   gs = zerosel
;   bl = character color
;   bh = minimal number of characters to write (1 dword on stack per char)
;   cx = x coordinate to put top left corner of string
;   dx = y coordinate to ,,  ,,   ,,    ,,   ,,   ,,
;   font = linear address of font
;   video mode = 8 bits per pixel
;
; Note:
;   This routine avoids the use of POPAD+RET because gputstr did the same
;   instructions just before exit. It does that in the following way:
;   First, it does PUSHAD to save all the registers (they are all used) and
;   saves the stack pointer that points to this stack frame which is the one
;   we want for POPAD+RET. (The stack pointer value that points to the PUSHAD
;   frame of this function is pushed on the stack just before jumping to
;   gputstr.)
;   Now the stack can be used in any way we want. At the exit of gputstr
;   gputstr gets a stack pointer from the stack. If gputstr is called
;   normally this is its own stack pointer. If gputstr is 'called' from
;   gputnumdec it is the one that points to the PUSHAD stack frame of
;   gputnumdec. When gputstr then does POPAD it doesn't restore all the
;   registers to it's own original values, but to the values on entry at
;   gputnumdec. By using this technique a redundant POPAD in gputnumdec is
;   avoided as well as restoring esp (to be able to do POPAD at all) at the
;   exit of gputnumdec.
;   After POPAD, gputstr does RET which pops the return address off the
;   stack. When gputstr is 'called' from gputnumdec this pops the return
;   address of the code that called gputnumdec. This avoids a redundant RET.
;   If the code of putchar would be in gputnumdec it would be faster, because
;   a PUSH+JMP(near) could be left out (=2 clock cycles on a Pentium; 9+ on a
;   386). But, now only one putchar has to be maintained.
;
gputnumdec:
        pushad
        mov ebp,esp                     ; Save stack pointer
        mov esi,ebx                     ; Save bl (color)
        shl ecx,16
        mov cx,dx                       ; ecx=x:y coordinates to put string
        mov edi,ecx                     ; Save coordinates

        mov cl,bh
        mov ebx,10                      ; Divide by 10
        xor ch,ch                       ; count of numbers pushed on stack
.push_digit:
        xor edx,edx                     ; Reset edx: eax = _edx_:eax / ebx
        div ebx
        push edx                        ; remains in edx
        inc ch
        cmp eax,0                       ; Are there any digits left?
        jne short .push_digit
        sub cl,ch                       ; If cl > ch add zero's
        jbe short .start_pop_digit
.extra_digit:
        push dword 0
        inc ch
        dec cl
        jnz short .extra_digit
.start_pop_digit:
        mov edx,esp                     ; Save esp
        mov ebx,esp                     ; String has to 'grow' up in mem
        movzx eax,ch
        push eax                        ; Save string length
.pop_digit:
        mov eax,[ss:edx]                ; Get next digit, but don't give up
        add edx,4                       ;  stack space (POP would)
        add al,'0'                      ; Convert to ASCII
        mov [ss:ebx],al                 ; Store character on stack
        inc ebx
        dec ch
        jnz short .pop_digit            ; ch=count of numbers pushed on stack

        mov eax,esi
        mov ah,al                       ; ah=color
        mov edx,edi                     ; edi=x:y coordinates
        pop ecx                         ; ecx=string length
        mov esi,esp                     ; esp=start of string
;       mov bx,ss                       ; Already done in extender (ss=ds);
;       mov ds,bx                       ;  str ptr at [esp] must point in ds
                                        ; Avoid redundant POPAD (see note)
        push ebp                        ; Provide ptr to PUSHAD stack frame
        push esi                        ; 'putchar' expects a ptr to the
        jmp putchar                     ;  string at [esp]
                                        ; The RET of gputstr returns to the
                                        ;  calling code
