/* SPLIT.C

	programmed in the small memory model of Turbo C version 2.0

	splits root file appended overlay files into separate files with
	the extension of .001, .002, etc.

*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "io.h"

FILE *fpin,*fpout;

char fname[128];
char f_noext_name[125];	/* file name in fname without extension */
unsigned char header[27];
char inbuff[4096];	/* file inbuffer for setvbuf */
char outbuff[4096];	/* file outbuffer for setvbuf */
char transbuff[512];	/* file bytes transfer buffer */

int filecount=0;

void operate();
int split(char *workname);

void main(int argc, char *argv[])
{
	char *period_pos;	/* position of period in fname */

	if(argc<2){	/* file name was not provided on command line */
		cprintf("\n\rInput overlay file to split\r\n");
		gets(fname);
	}
	else{	/* command link provided file name */
		strcpy(fname,argv[1]);
	}
	strcpy(f_noext_name,fname);
	if((period_pos=strchr(f_noext_name,'.'))==NULL){	/* need to add default .exe file extension */
		strcat(fname,".exe");	/* add the .exe extension */
	}
	else{
		period_pos[0]=0;	/* kill the extension */
	}
	operate();
}

void operate()
{
	char workname[128];
	char file_ext[5];	/* file extension; .$$$, .001, .002, etc. */

	if((fpin=fopen(fname,"rb"))==NULL){	/* error opening file */
		printf("\n\007Error opening file %s",fname);
		exit(1);
	}
	setvbuf(fpin,inbuff,_IOFBF,4096);	/* speed up i/o */
	while(!feof(fpin)){	/* split out .exe files until end of file or invalid .EXE information */
		strcpy(workname,f_noext_name);
		/* get appropriate extension for work file */
		sprintf(file_ext,!filecount?".$$$":".%03d",filecount);
		strcat(workname,file_ext);	/* add extension to the work file name */
		if(split(workname)){
			break;	/* all done splitting out files */
		}
		filecount++;	/* increment count of files split */
	}
	fclose(fpin);
	/* no errors, kill old file, rename temporary .$$$ file to old name */
	strcpy(workname,f_noext_name);
	strcat(workname,".$$$");
	unlink(fname);
	rename(workname,fname);
	printf("\nSplit complete:  %d overlay file%s",filecount-1,filecount!=2?"s":"");
}

int split(char *workname)
{
	int signature,ovl_number;
	unsigned long loop;
	unsigned long filelen;	/* length of .exe file (overlay or root) */

	fread(header,27,1,fpin);	/* read in first 27 .exe header bytes */
	fseek(fpin,-27L,SEEK_CUR);	/* position back to start of .exe file */

	signature=(header[0]=='M' && header[1]=='Z');	/* check for valid MZ .exe signature */
	ovl_number=header[26];	/* get overlay number */
	if(!signature || ovl_number!=filecount){	/* header bytes have invalid values */
		return(1);	/* not a proper .EXE file to split */
	}

	if((fpout=fopen(workname,"wb"))==NULL){	/* error opening file */
		printf("\n\007Error opening file %s",workname);
		exit(1);
	}
	setvbuf(fpout,outbuff,_IOFBF,4096);	/* speed up i/o */

	filelen=header[5];
	filelen*=256L;
	filelen+=header[4];
	filelen*=512L;	/* get length of .exe file to nearest 512 byte page */
	for(loop=0L;loop<=filelen-512L;loop+=512L){	/* transfer in 512 byte chunks */
		fread(transbuff,1,512,fpin);
		fwrite(transbuff,1,512,fpout);
	}
	/* transfer leftover bytes */
	fread(transbuff,1,filelen%512,fpin);
	fwrite(transbuff,1,filelen%512,fpout);

	fclose(fpout);
	return(0);	/* successful file split */
}
