; traptest.asm
;
; written on Sun  11-13-1994  by Ed Beroset
;  and released to the public domain by the author
;
;   This program is designed to test whether the an INT 1 handler
;   (single step trap) automatically sets the trap flag on exit.  This
;   is tested using the following algorithm:
;
;       1. load an INT 1 handler consisting of only a counter
;               increment and IRET.
;       2. turn on the trap flag to enable single step debugging
;       3. execute TARGETNUM instructions
;       4. turn off the trap flag
;       5. read the counter.
;
;   If the counter value is equal to TARGETNUM, then the trap DOES set
;   the trap flag on exit.  If it is equal to 1, then the trap DOES NOT
;   set the trap flag on exit.  If it is any other number, there may be
;   some other process interfering with the test.
;
        IDEAL
        MODEL small
        STACK 200h

DOS_FUNCTION            =        21h
DOS_WRITE_STRING        =       009h
DOS_SET_VECTOR          =       025h
DOS_GET_VECTOR          =       035h

MACRO DosInt  function, subfunction
        ifnb <subfunction>
          mov al,subfunction
        endif
        mov ah,function
        int DOS_FUNCTION
ENDM DosInt

        DATASEG
SSINT           =       1         ; single step interrupt number
TARGETNUM       =     100         ; expected count
TRAPFLAGMASK    =    0100h
counter         DW      0         ; the counter used by our interrupt
oldSSIntoffs    DW      ?         ; storage for original vector
oldSSIntseg     DW      ?         ;
ResetMsg        DB      "Trap Flag is reset automatically",13,10,'$'
NoResetMsg      DB      "Trap Flag is not reset automatically",13,10,'$'


        CODESEG
PROC main
        STARTUPCODE
        ; save the original single step vector
        DosInt  DOS_GET_VECTOR, SSINT
        mov     [oldSSIntoffs], bx
        mov     [oldSSIntseg],  es
        ; install the new single step handler
        push    ds
        mov     dx,seg SingleStepHandler
        mov     ds,dx
        mov     dx,offset SingleStepHandler
        DosInt  DOS_SET_VECTOR, SSINT
        pop     ds
        ; turn on the trap flag (enable single step trap)
        pushf
        pop     ax
        push    ax              ; save the original flags value
        or      ax,TRAPFLAGMASK ; set the trap flag in flags image
        push    ax              ; stow that
        popf                    ; tracing begins after this instr
        ; begin tracing instructions
        REPT (TARGETNUM - 1)    ; the 1 is the number of instructions
        nop                     ; required to turn off the trap flag
        ENDM
        ; turn off the trap flag (disable single step trap)
        popf                    ; restore original flags
        ; load original single step vector
        push    ds
        lds     dx,[DWORD oldSSIntoffs]
        DosInt  DOS_SET_VECTOR, SSINT
        pop     ds
        ; see if the counter has predicted value
        mov     dx,OFFSET ResetMsg
        cmp     [counter],TARGETNUM
        je      @@trapreset
        mov     dx,OFFSET NoResetMsg
@@trapreset:
        DosInt  DOS_WRITE_STRING
        EXITCODE
ENDP main

PROC SingleStepHandler FAR
        inc  [WORD far counter]
        iret
ENDP SingleStepHandler

        END
===============================================================================
