;-----------------------
; label.asm - Change the disk label. Public domain code by Jerry Coffin.

.model tiny,c

EXTENDEDFCB struc
   xfcbSignature    db  0ffh
   xfcbReserved1    db  5 dup(0)
   xfcbAttribute    db  ?
   xfcbDriveID      db  ?
   xfcbFileName     db  8 dup('?')
   xfcbExtent       db  3 dup('?')
   xfcbCurBlockNo   dw  ?
   xfcbRecSize      dw  ?
   xfcbFileSize     db  4 dup(0)
   xfcbFileDate     dw  ?
   xfcbFileTime     dw  ?
   xfcbReserved2    db  8 dup(0)
   xfcbCurRecNo     db  ?
   xfcbRandomRecNo  db  4 dup(0)
EXTENDEDFCB ends

.data
fcb EXTENDEDFCB<,,08h,,,,0,0,,0,0,,0,>

.code
.startup
main    proc

    mov     ah,19h          ; get current drive.
    int     21h

    mov     di,offset fcb
    mov     dx,di
    inc     al
    mov     [di].xfcbDriveID,al ; put it in the FCB

    mov     ah,13h          ; delete current volume label.
    int     21h

    mov     si,081h         ; find new label in command tail.
    mov     cl,ds:[080h]
    xor     ch,ch
    jcxz    done            ; if no parameter was entered, no new label.
find_loop:
    lodsb                   ; first find a non-space character
    cmp     al,' '
    loopz   find_loop
    jcxz    done

    mov     cx,11
    mov     di,offset fcb.xfcbFileName

move_loop:                  ; copy characters until end of command tail
    stosb
    lodsb
    cmp     al,13
    loopnz  move_loop

    jcxz    doit
    mov     al,' '          ; fill in rest of name with spaces
    rep     stosb
doit:
    mov     ah,016h         ; and create the new disk lable
    int     21h
done:
    mov     ax,04c00h
    int     21h
main endp
    end main

