;--------------------------------------------------
;  From: Saul Ansbacher
;  Subject: DetectSB routine from TinyPlay

                DosSeg                          ; Use Standalone DOS
                                                ; segment ordering.
                Jumps                           ; resolve out of range
                                                ; jumps.
                .Model  Small                   ; Use SMALL memory model.
                .286                            ; enable 80286 code.
                .Stack  0400h                   ; 1Kb for Stack Space.
.data

MsgNotFound db          'Sound Blaster not found or IRQ error.',10,13,'$'
MsgFound db             'Sound Blaster found at Address 2'
PortText db             'x0h, IRQ '
IrqText db              'x.',10,13,'$'

.code

DetectSb        Proc    Near

                pusha
                push es

ScanPort:       mov     bx,210h                 ; start scanning ports
                                                ; 210h, 220h, .. 260h
ResetDSP:       mov     dx,bx                   ; try to reset the DSP.
                add     dx,06h
                mov al, 1
                OUT dx, al
                in al, dx
                in al, dx
                in al, dx
                in al, dx
                xor     al,al
                OUT dx, al
                add     dx,08h
                mov cx, 100
WaitID:         in al, dx
                or      al,al
                js GetID
                loop    WaitID
                jmp NextPort
GetID:          sub     dx,04h
                in al, dx
                cmp     al,0AAh
                je Found
                add     dx,04h
                loop    WaitID

NextPort:       add     bx,10h                  ; if not response,
                cmp     bx,260h                 ; try the next port.
                jbe ResetDSP
                jmp Fail

Found:          mov     [SbAddr],bx             ; SB Port Address Found!

ScanIRQ:        cli

                in      al,21h                  ; save the IMR.
                mov bl, al
                mov     al,11111111b            ; disable all the IRQs.
                out     21h,al
                xor     ax,ax                   ; trap the IRQs 2,3,5,7.
                mov es, ax

SaveIrqs:       mov     ax,es:[28h]             ; irq2
                mov     dx,es:[2Ah]
                push ax
                push dx
                mov     ax,es:[2Ch]             ; irq3
                mov     dx,es:[2Eh]
                push ax
                push dx
                mov     ax,es:[34h]             ; irq5
                mov     dx,es:[36h]
                push ax
                push dx
                mov     ax,es:[3Ch]             ; irq7
                mov     dx,es:[3Eh]
                push ax
                push dx

SetIrqs:        mov     ax,offset TrapIrq2      ; irq2
                mov     es:[28h],ax
                mov     es:[2Ah],cs
                mov     ax,offset TrapIrq3      ; irq3
                mov     es:[2Ch],ax
                mov     es:[2Eh],cs
                mov     ax,offset TrapIrq5      ; irq5
                mov     es:[34h],ax
                mov     es:[36h],cs
                mov     ax,offset TrapIrq7      ; irq7
                mov     es:[3Ch],ax
                mov     es:[3Eh],cs

EnableIrqs:     mov     al,bl                   ; enable IRQs 2,3,5,7.
                and     al,01010011b
                out     21h,al
                sti
                mov     [SbIrq],0               ; clear the IRQ level.
                mov     dx,[SbAddr]             ; tells to the SB to
                add     dx,0Ch                  ; generate a IRQ!
WaitSb:         in al, dx
                or      al,al
                js WaitSb
                mov     al,0F2h
                OUT dx, al
                xor     cx,cx                   ; wait until IRQ level
WaitIRQ:        cmp     [SbIrq],0               ; is changed or timeout.
                jne IrqOk
                loop    WaitIRQ

IrqOk:          mov     al,bl                   ; restore IMR.
                out     21h,al

RestoreIrqs:    cli                             ; restore IRQ vectors.
                xor     ax,ax
                mov es, ax
                pop     dx                      ; irq7
                pop ax
                mov     es:[3Ch],ax
                mov     es:[3Eh],dx
                pop     dx                      ; irq5
                pop ax
                mov     es:[34h],ax
                mov     es:[36h],dx
                pop     dx                      ; irq3
                pop ax
                mov     es:[2Ch],ax
                mov     es:[2Eh],dx
                pop     dx                      ; irq2
                pop ax
                mov     es:[28h],ax
                mov     es:[2Ah],dx
                cli
                cmp     [SbIrq],0               ; IRQ level was changed?
                je      Fail                    ; no, fail.

Success:        mov     dx,[SbAddr]             ; Print Sucessful message.
                mov cx, (SbIrq)
                shr dl, 4
                add     dl,'0'
                mov (PortText), dl
                add     cl,'0'
                mov (IrqText), cl
                mov ah, 9
                mov     dx,offset MsgFound
                int     21h
                pop es
                popa                            ; Return to caller.
                ret

Fail:           mov     ah,9                    ; Print Failed Message,
                mov     dx,offset MsgNotFound   ; and exit to DOS.
                int     21h
                mov     ax,4C00h
                int     21h

DetectSb EndP


TrapIrq         Proc    Far

                push    dx                      ; General IRQ trapper
                push    ds                      ; used for IRQ autodetect.
                mov     dx,@Data
                mov ds, dx
                mov     [SbIrq],ax              ; save IRQ level.
                mov dx, (SbAddr)
                add     dx,0Eh
                in      al,dx                   ; SB acknowledge.
                mov     al,20h
                out     20h,al                  ; Hardware acknowledge.
                pop ds
                pop dx
                pop ax
                iret                            ; bye!

                IRP Level,<2,3,5,7>
TrapIrq&Level:  push    ax
                mov ax, Level
                jmp TrapIrq
                EndM

TrapIrq EndP

