;--------------------------
; Bres's circle drawing routine.
; Compiles surely under TASM 3.0; can't say others.
; Works in real mode; uses 386 instructions.
; Released as Public Domain.
; By Mikko Saukoski - No crediting req'd.
; Mikko Saukoski, 2:222/70@fidonet.org, eMail: msauk@somerbx.nullnet.fi

    IDEAL
    MODEL LARGE,C
    JUMPS
    P386

CODESEG

PUBLIC bcircle

PROC bcircle FAR x:WORD,y:WORD,rad:WORD,color:BYTE
USES es,gs,si,di

; Load vidram segment.
    mov ax,0a000h
    mov es,ax

; BX=X Offset, CX=Y Offset, DX=Some evil counter
    xor bx,bx
    mov cx,[rad]
    mov ax,cx
    shl ax,1
    mov dx,3
    sub dx,ax

; AL=Color
    mov al,[color]

; Calculate address of center in vidmem.
    mov di,[y]
    mov si,di
    shl di,8
    shl si,6
    add di,si
    add di,[x]
    mov gs,di

@@l1:
; Plot 8 pixels using known centerpoint and X and Y offsets.
    mov di,gs

    add di,bx
    mov si,cx
    shl si,6
    add di,si
    shl si,2
    add di,si
    mov [es:di],al

    sub di,si
    sub di,si
    shr si,2
    sub di,si
    sub di,si
    mov [es:di],al

    sub di,bx
    sub di,bx
    mov [es:di],al

    add di,si
    add di,si
    shl si,2
    add di,si
    add di,si
    mov [es:di],al

    mov di,gs
    add di,cx
    mov si,bx
    shl si,6
    add di,si
    shl si,2
    add di,si
    mov [es:di],al

    sub di,si
    sub di,si
    shr si,2
    sub di,si
    sub di,si
    mov [es:di],al

    sub di,cx
    sub di,cx
    mov [es:di],al

    add di,si
    add di,si
    shl si,2
    add di,si
    add di,si
    mov [es:di],al

; Is DX still under zero?
    cmp dx,0
    jge @@l2

; If, add 4*XOffset+6 to DX
    mov si,bx
    shl si,2
    add si,6
    add dx,si
    jmp @@l3

@@l2:
; If not, add 4*(XOffset-YOffset)+10 to DX
    mov si,bx
    sub si,cx
    shl si,2
    add si,10
    add dx,si
; Decrease Y coordinate
    dec cx

@@l3:
; Increase X coordinate
    inc bx
; Is X Offset<Y Offset; if is, loop again.
    cmp bx,cx
    jl @@l1

    ret

ENDP
END



