; CHARACTER BITMAPS, TILED BACKGROUNDS & SCREEN BUFFERING DEFINITIONS

; "not visible" borders of display buffer
;  n.b. The y border consist of YBORDER lines "above" and "under" the visible
;       lines.
;       The x border consists of XBORDER extra pixels ON ONLY ONE SIDE
;       of the screen buffer, but because of the linear addressing
;       you have the "illusion" of two borders XBORDER wide
;       if you add ONE LINE to the YBORDER you use.

YBORDER  = 32
XBORDER  = 64

; width & height of "playground" window inside visible window
; (where is the tiled map)
RXWIDTH  = 320 ; width of "background window"  inside page buffer
RYHEIGHT = 182 ; height etc. etc.

SCOREBOARD = 18    ; "scoreboard" window height

VXWIDTH    = 3200  ; "virtual" screen size (multiples of RXWIDTH & RYHEIGHT)
VYHEIGHT   = 364   ;


XTILE = 10 ; tiles inside the "playground window"
YTILE = 7  ;

XTILES = 100 ; tiles inside the "virtual playground window"
YTILES = 14  ;

; minitile width & height
MTWIDTH  = 16
MTHEIGHT = 13

; tile width & height
TWIDTH  = 32
THEIGHT = 26
; tile size
MTILESIZE = (MTWIDTH*MTHEIGHT)
TILESIZE  = (TWIDTH*THEIGHT)

; Logical size of a character bitmap
LCHARX = 8
LCHARY = 8

; character bitmap size
CHARSIZE  = (LCHARX*LCHARY)

; shift equivalent to a multiplication by CHARSIZE
CHARSHIFT = 6

; number of char bitmaps on a single font block
NUMCHAR    = 128

; Value currently not supported
UPDOWN    = 2

; Supported value for blitting pictures and sprites
LEFTRIGHT = 1

