NAME
    lhx - A file test/recovery tool for LHARC archives


SYNOPSIS
    lhx [-command] [@recovery_info] arcname [filename ...]


DESCRIPTION
    The newest archive tool out of Japan, LHARC, does a very good job of file
    compression but it does not handle damaged archives well at all.  LHX is a
    tool designed to assist in the recovery of data from damaged LHARC
    archives.

    LHX can be used to list the contents of an LHARC archive, test the
    integrity of an archive, scan a damaged archive to look for recoverable
    files, and to extract files from an archive.


    The commands are:  "l" to list archive contents, "t" to test the integrity
    of an archive, "e" to extract files from an archive, and "s" to scan an
    archive for possible file headers.  The default command is "l".

    'arcname' is the name of the archive files to be used.  This is the only
    required argument.  MS-DOS wildcard characters '*' and '?' are allowed.  If
    no extension is given, .LZH is assumed.

    'filename' arguments are files to list/test/extract from the archive.  If
    no 'filename's are given, all files will be selected.  MS-DOS wildcard
    characters '*' and '?' are allowed.  LHX ignores any pathnames stored in
    the archive when selecting files.


    LIST COMMAND
        The list command generates an 'ls -l' like listing of the selected
        files in the archive.  Any file headers in the archive with checksum
        errors will be marked with a '?'.

                > lhx -l test

                Listing archive TEST.LZH
                  --rw-     651 /     331  11 Apr 89  22:01:34   TEST\DIR
                ? --rw-    1161 /     715   5 Apr 89  09:07:38   REaDME
                  --rw-    8435 /    8435  12 Apr 89  19:55:38   TEST2.LZH

        The file README has a bad header.  In this case, the error is due to
        the change in the filename.


    TEST COMMAND
        The test command checks the file headers and file contents of the
        selected files in the archive.

                > lhx -t test

                Testing archive TEST.LZH
                  TEST\DIR -- data CRC error
                  REaDME -- bad file header, data OK
                  TEST2.LZH -- data OK
                2 errors detected

        The file TEST\DIR has an error in the data portion of the file.  LHX
        will be able to extract the file, but the data will be bad.  The file
        README has an error in the file header, but its data is intact.  LHX
        will be able to extract the file with no errors.


    EXTRACT COMMAND
        This command extracts the selected files from the archive.  If one of
        the files exists, the user will be prompted whether or not he wants to
        overwrite the file.  LHX ignores the path and attribute information in
        the archive; the files will be created in the current working directory
        with standard attributes.

                > lhx -e test

                Extracting archive TEST.LZH
                  TEST\DIR -- extracted with CRC error
                  REaDME --
                file exists; overwrite (y/n) ? y
                exacted OK
                  TEST2.LZH --
                file exists; overwrite (y/n) ? n
                1 error detected

        File DIR did not exist in the current working directory so it was
        extracted without query; it is probably bad due to the CRC error.  The
        files README and TEST2.LZH already exist so LHX asks if they should be
        overwritten.


    SCAN COMMAND
        This command scans damaged archives looking for anything that looks
        like it might be a file header.  Information about these possible file
        headers is reported.  This information can be given to LHX test/list/
        extract commands via the '@' option so that it can attempt to recover
        files from the damaged archive.

                > lhx -s test

                Scanning file TEST.LZH
                  @0,{32 | 32},651,1  TEST\DIR
                  @363,{393 | 393},1161,1  REaDME
                  @1108,{1141 | 1141},8435,0  TEST2.LZH
                  @1141,{1175 | 1175},955,1  ADDBFCRC.C
                  @1758,{1791 | 1791},2560,1  CRCDEFS.C
                  @2851,{2880 | 2880},5058,1  LHX.C
                  @4721,{4752 | 4752},15337,1  LZHUF.C

        The numbers in each of these output lines are:
            the starting offset of the file header,
            the starting offset of the file data--calculated from two different
                values in the header--the first value is the one that LHX
                normally uses.  If the values are different and the filename
                looks correct, the second number is more likely to be correct.
            the output file length, and
            the compression flag.

        These numbers are used in the same order in the '@' parameter.  Any
        values that are not supplied to the '@' parameter are read from the
        header.  If a filename is supplied in the '@' parameter, only one file
        will be processed by LHX.

        In this example, LHX found the headers for all the files in TEST.LZH
        and also found all the headers in TEST2.LZH that was stored
        uncompressed in the archive.  TEST2 could be directly listed/tested/
        extracted by using '@1141'.


    SELF-EXTRACTING ARCHIVES
        Due to the growing number of "virus" programs that are circulating in
        the PC community, people are leery about running self-extracting
        archives because they may not be as advertised.  LHX can be used to
        extract the files from a self-extracting archive.

                > lhx -s lharc10e.com

                Scanning file LHARC10E.COM
                  @1290,{1323 | 1323},27498,1  LHARC.EXE
                  @18852,{18885 | 18885},21984,1  LHARC.MAN
                  @27919,{27949 | 27949},1161,1  README

        This file can be manipulated by LHX like any other archive by using the
        "@1290" option:

                > lhx -l @1290 lharc10e.com

                Listing archive LHARC10E.COM
                  --rw-   27498 /   17529   4 Mar 89  18:07:22   LHARC.EXE
                  --rw-   21984 /    9034   5 Apr 89  09:07:28   LHARC.MAN
                  --rw-    1161 /     715   5 Apr 89  09:07:38   README

                > lhx -e @1290 lharc10e.com

                Extracting archive ..\LHARC10E.COM
                  LHARC.EXE -- extracted OK
                  LHARC.MAN -- extracted OK
                  README -- extracted OK


    A JOURNEY INTO THE ABSURD
        Just to show what can be done with LHX, let's play with LHARC10E.COM a
        little bit more; first we'll extract LHARC.MAN, still compressed, into
        LHARCMAN.Z, then we'll uncompress LHARCMAN.Z into LHARC.MAN.

                > lhx -e @18852,,9034,0,lharcman.z lharc10e.com

                Extracting archive LHARC10E.COM
                  lharcman.z -- extracted with CRC error
                1 error detected

        The CRC error is expected since the CRC in the header is that of the
        uncompressed file.  LHARCMAN.Z now contains the raw compressed data for
        LHARC.MAN.  This file can be decompressed by:

                > lhx -e @0,0,21984,1,lharc.man lharcman.z

                Extracting archive LHARC.Z
                  lharc.man --
                file exists; overwrite (y/n) ? y
                extracted with CRC error
                1 error detected

        The CRC error is expected since there was no header on the file.
        (Actually, we told LHX to read the header from the beginning of the raw
        data file, but it didn't use any of the data it read.)


ACKNOWLEDGEMENTS
    This program was written using code from the Usenet distribution of LZHUF.C
    written by Haruyasu Yoshizaki, Haruhiko Okumura, and Kenji Rikitake.  This
    is copyrighted code with permission granted for non-commercial use.

    I also used ADDBFCRC.C and CRCDEFS.C from the Usenet ZOO 2.01 distribution.
    Rahul Dhesi claims no copyright on them but I acknowledge him anyway--he
    saved me a bunch of typing.


AUTHOR
    Mark Armbrust
    maa@nbires.nbi.com
