/*
 * Copyright (C) 1985-1992  New York University
 * 
 * This file is part of the Ada/Ed-C system.  See the Ada/Ed README file for
 * warranty (none) and distribution info and also the GNU General Public
 * License for more details.

 */

#include "hdr.h"
#include "ada.h"

int symcount = 344;

struct namelistmap gramsyms[] = {
    { 1, "Epsilon", gramsyms + 324, NULL },
    { 2, "ABORT", gramsyms + 325, NULL },
    { 3, "ABS", gramsyms + 326, NULL },
    { 4, "ACCEPT", gramsyms + 327, NULL },
    { 5, "ACCESS", gramsyms + 328, NULL },
    { 6, "ALL", gramsyms + 329, NULL },
    { 7, "AND", gramsyms + 330, NULL },
    { 8, "ARRAY", gramsyms + 331, NULL },
    { 9, "AT", gramsyms + 332, NULL },
    { 10, "BEGIN", gramsyms + 333, NULL },
    { 11, "BODY", gramsyms + 334, NULL },
    { 12, "CASE", gramsyms + 335, NULL },
    { 13, "CONSTANT", gramsyms + 336, NULL },
    { 14, "DECLARE", gramsyms + 337, NULL },
    { 15, "DELAY", gramsyms + 338, NULL },
    { 16, "DELTA", gramsyms + 339, NULL },
    { 17, "DIGITS", gramsyms + 340, NULL },
    { 18, "DO", gramsyms + 341, NULL },
    { 19, "ELSE", gramsyms + 342, NULL },
    { 20, "ELSIF", gramsyms + 343, NULL },
    { 21, "END", gramsyms + 20, NULL },
    { 22, "ENTRY", gramsyms + 21, NULL },
    { 23, "EXCEPTION", gramsyms + 22, NULL },
    { 24, "EXIT", gramsyms + 23, NULL },
    { 25, "FOR", gramsyms + 24, NULL },
    { 26, "FUNCTION", gramsyms + 25, NULL },
    { 27, "GENERIC", gramsyms + 26, NULL },
    { 28, "GOTO", gramsyms + 27, NULL },
    { 29, "IF", gramsyms + 28, NULL },
    { 30, "IN", gramsyms + 29, NULL },
    { 31, "IS", gramsyms + 30, NULL },
    { 32, "LIMITED", gramsyms + 31, NULL },
    { 33, "LOOP", gramsyms + 32, NULL },
    { 34, "MOD", gramsyms + 33, NULL },
    { 35, "NEW", gramsyms + 34, NULL },
    { 36, "NOT", gramsyms + 35, NULL },
    { 37, "NULL", gramsyms + 36, NULL },
    { 38, "OF", gramsyms + 37, NULL },
    { 39, "OR", gramsyms + 38, NULL },
    { 40, "OTHERS", gramsyms + 39, NULL },
    { 41, "OUT", gramsyms + 40, NULL },
    { 42, "PACKAGE", gramsyms + 41, NULL },
    { 43, "PRAGMA", gramsyms + 42, NULL },
    { 44, "PRIVATE", gramsyms + 43, NULL },
    { 45, "PROCEDURE", gramsyms + 44, NULL },
    { 46, "RAISE", gramsyms + 45, NULL },
    { 47, "RANGE", gramsyms + 46, NULL },
    { 48, "RECORD", gramsyms + 47, NULL },
    { 49, "REM", gramsyms + 48, NULL },
    { 50, "RENAMES", gramsyms + 49, NULL },
    { 51, "RETURN", gramsyms + 50, NULL },
    { 52, "REVERSE", gramsyms + 51, NULL },
    { 53, "SELECT", gramsyms + 52, NULL },
    { 54, "SEPARATE", gramsyms + 53, NULL },
    { 55, "SUBTYPE", gramsyms + 54, gramsyms + 15 },
    { 56, "TASK", gramsyms + 55, NULL },
    { 57, "TERMINATE", gramsyms + 56, NULL },
    { 58, "THEN", gramsyms + 57, NULL },
    { 59, "TYPE", gramsyms + 58, NULL },
    { 60, "USE", gramsyms + 59, NULL },
    { 61, "WHEN", gramsyms + 60, NULL },
    { 62, "WHILE", gramsyms + 61, NULL },
    { 63, "WITH", gramsyms + 62, NULL },
    { 64, "XOR", gramsyms + 63, NULL },
    { 65, "identifier", gramsyms + 64, NULL },
    { 66, "numeric_literal", gramsyms + 65, NULL },
    { 67, "string_literal", gramsyms + 66, NULL },
    { 68, "character_literal", gramsyms + 67, NULL },
    { 69, "&", gramsyms + 68, NULL },
    { 70, "'", gramsyms + 69, NULL },
    { 71, "(", gramsyms + 70, NULL },
    { 72, ")", gramsyms + 71, NULL },
    { 73, "*", gramsyms + 72, NULL },
    { 74, "+", gramsyms + 73, NULL },
    { 75, ",", gramsyms + 74, NULL },
    { 76, "-", gramsyms + 75, NULL },
    { 77, ".", gramsyms + 76, NULL },
    { 78, "/", gramsyms + 77, NULL },
    { 79, ":", gramsyms + 78, NULL },
    { 80, ";", gramsyms + 79, NULL },
    { 81, "<", gramsyms + 80, NULL },
    { 82, "=", gramsyms + 81, NULL },
    { 83, ">", gramsyms + 82, NULL },
    { 84, "|", gramsyms + 83, gramsyms + 3 },
    { 85, "=>", gramsyms + 84, NULL },
    { 86, "..", gramsyms + 85, NULL },
    { 87, "**", gramsyms + 86, NULL },
    { 88, ":=", gramsyms + 87, NULL },
    { 89, "/=", gramsyms + 88, gramsyms + 57 },
    { 90, ">=", gramsyms + 89, NULL },
    { 91, "<=", gramsyms + 90, NULL },
    { 92, "<<", gramsyms + 91, NULL },
    { 93, ">>", gramsyms + 92, NULL },
    { 94, "<>", gramsyms + 93, NULL },
    { 95, "$EOF", gramsyms + 94, NULL },
    { 96, "$ACC", gramsyms + 95, NULL },
    { 97, "expression", gramsyms + 96, NULL },
    { 98, "expanded_name", gramsyms + 97, gramsyms + 20 },
    { 99, "simple_expression", gramsyms + 98, NULL },
    { 100, "subtype_indication", gramsyms + 99, NULL },
    { 101, "simple_name", gramsyms + 100, NULL },
    { 102, "name", gramsyms + 101, NULL },
    { 103, "[simple_name]", gramsyms + 102, NULL },
    { 104, "[simple_name:]", gramsyms + 103, NULL },
    { 105, "[expanded_name]", gramsyms + 104, NULL },
    { 106, "range", gramsyms + 105, NULL },
    { 107, "aggregate", gramsyms + 106, NULL },
    { 108, "compilation", gramsyms + 107, NULL },
    { 109, "pragma", gramsyms + 108, NULL },
    { 110, "[(argument_association{,argument_association})]", gramsyms + 109, NULL },
    { 111, "argument_association", gramsyms + 110, NULL },
    { 112, "[argument_identifier=>]expression", gramsyms + 111, NULL },
    { 113, "basic_declaration", gramsyms + 112, gramsyms + 21 },
    { 114, "object_declaration", gramsyms + 113, NULL },
    { 115, "number_declaration", gramsyms + 114, NULL },
    { 116, "type_declaration", gramsyms + 115, NULL },
    { 117, "subtype_declaration", gramsyms + 116, NULL },
    { 118, "subprogram_declaration", gramsyms + 117, gramsyms + 25 },
    { 119, "package_declaration", gramsyms + 118, NULL },
    { 120, "task_declaration", gramsyms + 119, NULL },
    { 121, "generic_declaration", gramsyms + 120, NULL },
    { 122, "exception_declaration", gramsyms + 121, NULL },
    { 123, "generic_instantiation", gramsyms + 122, NULL },
    { 124, "renaming_declaration", gramsyms + 123, NULL },
    { 125, "identifier_list", gramsyms + 124, NULL },
    { 126, "[:=expression]", gramsyms + 125, NULL },
    { 127, "[CONSTANT]", gramsyms + 126, NULL },
    { 128, "constrained_array_definition", gramsyms + 127, NULL },
    { 129, "{,identifier}", gramsyms + 128, NULL },
    { 130, "full_type_declaration", gramsyms + 129, gramsyms + 95 },
    { 131, "incomplete_type_declaration", gramsyms + 130, NULL },
    { 132, "private_type_declaration", gramsyms + 131, NULL },
    { 133, "[discriminant_part]IS", gramsyms + 132, NULL },
    { 134, "type_definition", gramsyms + 133, NULL },
    { 135, "enumeration_type_definition", gramsyms + 134, NULL },
    { 136, "integer_type_definition", gramsyms + 135, NULL },
    { 137, "real_type_definition", gramsyms + 136, NULL },
    { 138, "array_type_definition", gramsyms + 137, NULL },
    { 139, "record_type_definition", gramsyms + 138, gramsyms + 11 },
    { 140, "access_type_definition", gramsyms + 139, NULL },
    { 141, "derived_type_definition", gramsyms + 140, NULL },
    { 142, "[constraint]", gramsyms + 141, NULL },
    { 143, "constraint", gramsyms + 142, NULL },
    { 144, "range_constraint", gramsyms + 143, NULL },
    { 145, "floating_point_constraint", gramsyms + 144, NULL },
    { 146, "fixed_point_constraint", gramsyms + 145, NULL },
    { 147, "general_aggregate", gramsyms + 146, NULL },
    { 148, "enumeration_literal_specification", gramsyms + 147, NULL },
    { 149, "{,enumeration_literal_specification}", gramsyms + 148, NULL },
    { 150, "enumeration_literal", gramsyms + 149, NULL },
    { 151, "floating_accuracy_definition", gramsyms + 150, NULL },
    { 152, "[range_constraint]", gramsyms + 151, gramsyms + 138 },
    { 153, "fixed_accuracy_definition", gramsyms + 152, NULL },
    { 154, "unconstrained_array_definition", gramsyms + 153, NULL },
    { 155, "index_subtype_definition", gramsyms + 154, NULL },
    { 156, "{,index_subtype_definition}", gramsyms + 155, NULL },
    { 157, "index_constraint", gramsyms + 156, NULL },
    { 158, "discrete_range", gramsyms + 157, NULL },
    { 159, "{,discrete_range}", gramsyms + 158, NULL },
    { 160, "component_list", gramsyms + 159, gramsyms + 86 },
    { 161, "{pragma}", gramsyms + 160, NULL },
    { 162, "{component_declaration}", gramsyms + 161, NULL },
    { 163, "component_declaration", gramsyms + 162, NULL },
    { 164, "variant_part", gramsyms + 163, NULL },
    { 165, "discriminant_part", gramsyms + 164, NULL },
    { 166, "discriminant_specification", gramsyms + 165, NULL },
    { 167, "{;discriminant_specification}", gramsyms + 166, NULL },
    { 168, "variant", gramsyms + 167, NULL },
    { 169, "{variant}", gramsyms + 168, NULL },
    { 170, "choice", gramsyms + 169, gramsyms + 46 },
    { 171, "{|choice}", gramsyms + 170, gramsyms + 83 },
    { 172, "[discriminant_part];", gramsyms + 171, NULL },
    { 173, "declarative_part", gramsyms + 172, NULL },
    { 174, "{basic_declarative_item}", gramsyms + 173, NULL },
    { 175, "basic_declarative_item", gramsyms + 174, NULL },
    { 176, "representation_clause", gramsyms + 175, NULL },
    { 177, "use_clause", gramsyms + 176, NULL },
    { 178, "body", gramsyms + 177, NULL },
    { 179, "proper_body", gramsyms + 178, gramsyms + 144 },
    { 180, "body_stub", gramsyms + 179, NULL },
    { 181, "subprogram_body", gramsyms + 180, NULL },
    { 182, "package_body", gramsyms + 181, NULL },
    { 183, "task_body", gramsyms + 182, NULL },
    { 184, "operator_symbol", gramsyms + 183, NULL },
    { 185, "indexed_component", gramsyms + 184, gramsyms + 135 },
    { 186, "selected_component", gramsyms + 185, NULL },
    { 187, "attribute", gramsyms + 186, gramsyms + 26 },
    { 188, "selector", gramsyms + 187, NULL },
    { 189, "attribute_designator", gramsyms + 188, NULL },
    { 190, "component_association", gramsyms + 189, gramsyms + 182 },
    { 191, "{,component_association}", gramsyms + 190, NULL },
    { 192, "[choice{|choice}=>]expression", gramsyms + 191, NULL },
    { 193, "general_component_association", gramsyms + 192, gramsyms + 37 },
    { 194, "{,general_component_association}", gramsyms + 193, NULL },
    { 195, "relation", gramsyms + 194, gramsyms + 87 },
    { 196, "relation{AND__relation}", gramsyms + 195, NULL },
    { 197, "relation{OR__relation}", gramsyms + 196, NULL },
    { 198, "relation{XOR__relation}", gramsyms + 197, NULL },
    { 199, "relation{AND__THEN__relation}", gramsyms + 198, NULL },
    { 200, "relation{OR__ELSE__relation}", gramsyms + 199, NULL },
    { 201, "[relational_operator__simple_expression]", gramsyms + 200, gramsyms + 189 },
    { 202, "[NOT]", gramsyms + 201, NULL },
    { 203, "[unary_adding_operator]term{binary_adding_operator__term}", gramsyms + 202, NULL },
    { 204, "term", gramsyms + 203, NULL },
    { 205, "factor{multiplying_operator__factor}", gramsyms + 204, gramsyms + 184 },
    { 206, "factor", gramsyms + 205, NULL },
    { 207, "primary", gramsyms + 206, NULL },
    { 208, "[**__primary]", gramsyms + 207, NULL },
    { 209, "allocator", gramsyms + 208, NULL },
    { 210, "qualified_expression", gramsyms + 209, NULL },
    { 211, "relational_operator", gramsyms + 210, NULL },
    { 212, "binary_adding_operator", gramsyms + 211, NULL },
    { 213, "unary_adding_operator", gramsyms + 212, NULL },
    { 214, "multiplying_operator", gramsyms + 213, gramsyms + 16 },
    { 215, "sequence_of_statements", gramsyms + 214, NULL },
    { 216, "statement", gramsyms + 215, NULL },
    { 217, "{statement}", gramsyms + 216, NULL },
    { 218, "{label}", gramsyms + 217, NULL },
    { 219, "simple_statement", gramsyms + 218, NULL },
    { 220, "compound_statement", gramsyms + 219, NULL },
    { 221, "null_statement", gramsyms + 220, NULL },
    { 222, "assignment_statement", gramsyms + 221, NULL },
    { 223, "exit_statement", gramsyms + 222, NULL },
    { 224, "return_statement", gramsyms + 223, NULL },
    { 225, "goto_statement", gramsyms + 224, NULL },
    { 226, "delay_statement", gramsyms + 225, NULL },
    { 227, "abort_statement", gramsyms + 226, NULL },
    { 228, "raise_statement", gramsyms + 227, NULL },
    { 229, "code_statement", gramsyms + 228, NULL },
    { 230, "call_statement", gramsyms + 229, NULL },
    { 231, "if_statement", gramsyms + 230, NULL },
    { 232, "case_statement", gramsyms + 231, NULL },
    { 233, "loop_statement", gramsyms + 232, gramsyms + 149 },
    { 234, "block_statement", gramsyms + 233, NULL },
    { 235, "accept_statement", gramsyms + 234, gramsyms + 92 },
    { 236, "select_statement", gramsyms + 235, NULL },
    { 237, "label", gramsyms + 236, NULL },
    { 238, "condition", gramsyms + 237, gramsyms + 80 },
    { 239, "{ELSIF__condition__THEN__sequence_of_statements}", gramsyms + 238, NULL },
    { 240, "[ELSE__sequence_of_statements]", gramsyms + 239, gramsyms + 62 },
    { 241, "case_statement_alternative", gramsyms + 240, gramsyms + 214 },
    { 242, "{case_statement_alternative}", gramsyms + 241, gramsyms + 42 },
    { 243, "[iteration_scheme]", gramsyms + 242, gramsyms + 69 },
    { 244, "iteration_scheme", gramsyms + 243, NULL },
    { 245, "loop_parameter_specification", gramsyms + 244, gramsyms + 18 },
    { 246, "[REVERSE]", gramsyms + 245, NULL },
    { 247, "[DECLARE__declarative_part]", gramsyms + 246, NULL },
    { 248, "[EXCEPTION__exception_handler{exception_handler}]", gramsyms + 247, NULL },
    { 249, "[WHEN__condition]", gramsyms + 248, NULL },
    { 250, "[expression]", gramsyms + 249, NULL },
    { 251, "subprogram_specification", gramsyms + 250, NULL },
    { 252, "[formal_part]", gramsyms + 251, gramsyms + 188 },
    { 253, "designator", gramsyms + 252, gramsyms + 111 },
    { 254, "formal_part", gramsyms + 253, NULL },
    { 255, "parameter_specification", gramsyms + 254, NULL },
    { 256, "{;parameter_specification}", gramsyms + 255, NULL },
    { 257, "mode", gramsyms + 256, NULL },
    { 258, "[IN]", gramsyms + 257, NULL },
    { 259, "[designator]", gramsyms + 258, NULL },
    { 260, "package_specification", gramsyms + 259, NULL },
    { 261, "[PRIVATE{basic_declarative_item}]", gramsyms + 260, NULL },
    { 262, "[LIMITED]", gramsyms + 261, NULL },
    { 263, "{,package_name}", gramsyms + 262, NULL },
    { 264, "identifier:type_mark", gramsyms + 263, NULL },
    { 265, "identifier:EXCEPTION", gramsyms + 264, NULL },
    { 266, "task_specification", gramsyms + 265, NULL },
    { 267, "[TYPE]", gramsyms + 266, NULL },
    { 268, "{entry_declaration}", gramsyms + 267, NULL },
    { 269, "{representation_clause}", gramsyms + 268, gramsyms + 162 },
    { 270, "entry_declaration", gramsyms + 269, NULL },
    { 271, "[(discrete_range)][formal_part]", gramsyms + 270, gramsyms + 237 },
    { 272, "[(entry_index)][formal_part]", gramsyms + 271, NULL },
    { 273, "entry_index", gramsyms + 272, NULL },
    { 274, "selective_wait", gramsyms + 273, gramsyms + 142 },
    { 275, "conditional_entry_call", gramsyms + 274, NULL },
    { 276, "timed_entry_call", gramsyms + 275, NULL },
    { 277, "select_alternative", gramsyms + 276, NULL },
    { 278, "{OR__select_alternative}", gramsyms + 277, NULL },
    { 279, "[WHEN__condition=>]", gramsyms + 278, NULL },
    { 280, "selective_wait_alternative", gramsyms + 279, gramsyms + 221 },
    { 281, "accept_alternative", gramsyms + 280, NULL },
    { 282, "delay_alternative", gramsyms + 281, NULL },
    { 283, "terminate_alternative", gramsyms + 282, gramsyms + 267 },
    { 284, "[sequence_of_statements]", gramsyms + 283, gramsyms + 43 },
    { 285, "{,task_name}", gramsyms + 284, NULL },
    { 286, "{compilation_unit}", gramsyms + 285, NULL },
    { 287, "compilation_unit", gramsyms + 286, NULL },
    { 288, "context_clause", gramsyms + 287, NULL },
    { 289, "library_unit", gramsyms + 288, NULL },
    { 290, "secondary_unit", gramsyms + 289, NULL },
    { 291, "library_unit_body", gramsyms + 290, NULL },
    { 292, "subunit", gramsyms + 291, NULL },
    { 293, "{with_clause{use_clause}}", gramsyms + 292, NULL },
    { 294, "with_clause", gramsyms + 293, NULL },
    { 295, "{,unit_simple_name}", gramsyms + 294, NULL },
    { 296, "exception_handler", gramsyms + 295, NULL },
    { 297, "exception_choice", gramsyms + 296, gramsyms + 172 },
    { 298, "{|exception_choice}", gramsyms + 297, NULL },
    { 299, "generic_specification", gramsyms + 298, NULL },
    { 300, "generic_formal_part", gramsyms + 299, NULL },
    { 301, "{generic_parameter_declaration}", gramsyms + 300, NULL },
    { 302, "generic_parameter_declaration", gramsyms + 301, NULL },
    { 303, "[IN[OUT]]", gramsyms + 302, NULL },
    { 304, "generic_type_definition", gramsyms + 303, NULL },
    { 305, "[IS__name__or__<>]", gramsyms + 304, NULL },
    { 306, "[generic_actual_part]", gramsyms + 305, NULL },
    { 307, "generic_actual_part", gramsyms + 306, NULL },
    { 308, "generic_association", gramsyms + 307, NULL },
    { 309, "{,generic_association}", gramsyms + 308, NULL },
    { 310, "[generic_formal_parameter=>]generic_actual_parameter", gramsyms + 309, NULL },
    { 311, "generic_formal_parameter", gramsyms + 310, NULL },
    { 312, "generic_actual_parameter", gramsyms + 311, NULL },
    { 313, "type_representation_clause", gramsyms + 312, gramsyms + 38 },
    { 314, "address_clause", gramsyms + 313, gramsyms + 268 },
    { 315, "length_clause", gramsyms + 314, NULL },
    { 316, "enumeration_representation_clause", gramsyms + 315, NULL },
    { 317, "record_representation_clause", gramsyms + 316, NULL },
    { 318, "[alignment_clause]", gramsyms + 317, gramsyms + 54 },
    { 319, "{component_clause}", gramsyms + 318, gramsyms + 238 },
    { 320, "alignment_clause", gramsyms + 319, NULL },
    { 321, "component_clause", gramsyms + 320, NULL },
    { 322, "argument_association_list", gramsyms + 321, NULL },
    { 323, "exception_handler_list", gramsyms + 322, gramsyms + 32 },
    { 324, "use_clause_list", gramsyms + 323, NULL },
    { 325, "CONTROLLED", gramsyms + 0, NULL },
    { 326, "INLINE", gramsyms + 1, gramsyms + 272 },
    { 327, "INTERFACE", gramsyms + 2, NULL },
    { 328, "SUPPRESS", gramsyms + 3, NULL },
    { 329, "SHARED", gramsyms + 4, gramsyms + 52 },
    { 330, "PACK", gramsyms + 5, NULL },
    { 331, "PRIORITY", gramsyms + 6, NULL },
    { 332, "ELABORATE", gramsyms + 7, NULL },
    { 333, "MEMORY_SIZE", gramsyms + 8, gramsyms + 222 },
    { 334, "STORAGE_UNIT", gramsyms + 9, NULL },
    { 335, "SYSTEM_NAME", gramsyms + 10, NULL },
    { 336, "EDUMP", gramsyms + 11, gramsyms + 91 },
    { 337, "TDUMP", gramsyms + 12, NULL },
    { 338, "TRACE_ON", gramsyms + 13, NULL },
    { 339, "TRACE_OFF", gramsyms + 14, NULL },
    { 340, "TRACE_TABLES_OFF", gramsyms + 15, NULL },
    { 341, "DEBUG", gramsyms + 16, NULL },
    { 342, "TRACE_TABLES_ON", gramsyms + 17, NULL },
    { 343, "INCLUDE_CODE", gramsyms + 18, NULL },
    { 344, "IO_INTERFACE", gramsyms + 19, NULL }
	  };

struct namelistmap *numtostrtable[] = {
    gramsyms + 324,
    gramsyms + 325,
    gramsyms + 326,
    gramsyms + 327,
    gramsyms + 328,
    gramsyms + 329,
    gramsyms + 330,
    gramsyms + 331,
    gramsyms + 332,
    gramsyms + 333,
    gramsyms + 334,
    gramsyms + 335,
    gramsyms + 336,
    gramsyms + 337,
    gramsyms + 338,
    gramsyms + 339,
    gramsyms + 340,
    gramsyms + 341,
    gramsyms + 342,
    gramsyms + 343,
    gramsyms + 20,
    gramsyms + 21,
    gramsyms + 22,
    gramsyms + 23,
    gramsyms + 24,
    gramsyms + 25,
    gramsyms + 26,
    gramsyms + 27,
    gramsyms + 28,
    gramsyms + 29,
    gramsyms + 30,
    gramsyms + 31,
    gramsyms + 32,
    gramsyms + 33,
    gramsyms + 34,
    gramsyms + 35,
    gramsyms + 36,
    gramsyms + 37,
    gramsyms + 38,
    gramsyms + 39,
    gramsyms + 40,
    gramsyms + 41,
    gramsyms + 42,
    gramsyms + 43,
    gramsyms + 44,
    gramsyms + 45,
    gramsyms + 46,
    gramsyms + 47,
    gramsyms + 48,
    gramsyms + 49,
    gramsyms + 50,
    gramsyms + 51,
    gramsyms + 52,
    gramsyms + 53,
    gramsyms + 54,
    gramsyms + 55,
    gramsyms + 56,
    gramsyms + 57,
    gramsyms + 58,
    gramsyms + 59,
    gramsyms + 60,
    gramsyms + 61,
    gramsyms + 62,
    gramsyms + 63,
    gramsyms + 64,
    gramsyms + 65,
    gramsyms + 66,
    gramsyms + 67,
    gramsyms + 68,
    gramsyms + 69,
    gramsyms + 70,
    gramsyms + 71,
    gramsyms + 72,
    gramsyms + 73,
    gramsyms + 74,
    gramsyms + 75,
    gramsyms + 76,
    gramsyms + 77,
    gramsyms + 78,
    gramsyms + 79,
    gramsyms + 80,
    gramsyms + 81,
    gramsyms + 82,
    gramsyms + 83,
    gramsyms + 84,
    gramsyms + 85,
    gramsyms + 86,
    gramsyms + 87,
    gramsyms + 88,
    gramsyms + 89,
    gramsyms + 90,
    gramsyms + 91,
    gramsyms + 92,
    gramsyms + 93,
    gramsyms + 94,
    gramsyms + 95,
    gramsyms + 96,
    gramsyms + 97,
    gramsyms + 98,
    gramsyms + 99,
    gramsyms + 100,
    gramsyms + 101,
    gramsyms + 102,
    gramsyms + 103,
    gramsyms + 104,
    gramsyms + 105,
    gramsyms + 106,
    gramsyms + 107,
    gramsyms + 108,
    gramsyms + 109,
    gramsyms + 110,
    gramsyms + 111,
    gramsyms + 112,
    gramsyms + 113,
    gramsyms + 114,
    gramsyms + 115,
    gramsyms + 116,
    gramsyms + 117,
    gramsyms + 118,
    gramsyms + 119,
    gramsyms + 120,
    gramsyms + 121,
    gramsyms + 122,
    gramsyms + 123,
    gramsyms + 124,
    gramsyms + 125,
    gramsyms + 126,
    gramsyms + 127,
    gramsyms + 128,
    gramsyms + 129,
    gramsyms + 130,
    gramsyms + 131,
    gramsyms + 132,
    gramsyms + 133,
    gramsyms + 134,
    gramsyms + 135,
    gramsyms + 136,
    gramsyms + 137,
    gramsyms + 138,
    gramsyms + 139,
    gramsyms + 140,
    gramsyms + 141,
    gramsyms + 142,
    gramsyms + 143,
    gramsyms + 144,
    gramsyms + 145,
    gramsyms + 146,
    gramsyms + 147,
    gramsyms + 148,
    gramsyms + 149,
    gramsyms + 150,
    gramsyms + 151,
    gramsyms + 152,
    gramsyms + 153,
    gramsyms + 154,
    gramsyms + 155,
    gramsyms + 156,
    gramsyms + 157,
    gramsyms + 158,
    gramsyms + 159,
    gramsyms + 160,
    gramsyms + 161,
    gramsyms + 162,
    gramsyms + 163,
    gramsyms + 164,
    gramsyms + 165,
    gramsyms + 166,
    gramsyms + 167,
    gramsyms + 168,
    gramsyms + 169,
    gramsyms + 170,
    gramsyms + 171,
    gramsyms + 172,
    gramsyms + 173,
    gramsyms + 174,
    gramsyms + 175,
    gramsyms + 176,
    gramsyms + 177,
    gramsyms + 178,
    gramsyms + 179,
    gramsyms + 180,
    gramsyms + 181,
    gramsyms + 182,
    gramsyms + 183,
    gramsyms + 184,
    gramsyms + 185,
    gramsyms + 186,
    gramsyms + 187,
    gramsyms + 188,
    gramsyms + 189,
    gramsyms + 190,
    gramsyms + 191,
    gramsyms + 192,
    gramsyms + 193,
    gramsyms + 194,
    gramsyms + 195,
    gramsyms + 196,
    gramsyms + 197,
    gramsyms + 198,
    gramsyms + 199,
    gramsyms + 200,
    gramsyms + 201,
    gramsyms + 202,
    gramsyms + 203,
    gramsyms + 204,
    gramsyms + 205,
    gramsyms + 206,
    gramsyms + 207,
    gramsyms + 208,
    gramsyms + 209,
    gramsyms + 210,
    gramsyms + 211,
    gramsyms + 212,
    gramsyms + 213,
    gramsyms + 214,
    gramsyms + 215,
    gramsyms + 216,
    gramsyms + 217,
    gramsyms + 218,
    gramsyms + 219,
    gramsyms + 220,
    gramsyms + 221,
    gramsyms + 222,
    gramsyms + 223,
    gramsyms + 224,
    gramsyms + 225,
    gramsyms + 226,
    gramsyms + 227,
    gramsyms + 228,
    gramsyms + 229,
    gramsyms + 230,
    gramsyms + 231,
    gramsyms + 232,
    gramsyms + 233,
    gramsyms + 234,
    gramsyms + 235,
    gramsyms + 236,
    gramsyms + 237,
    gramsyms + 238,
    gramsyms + 239,
    gramsyms + 240,
    gramsyms + 241,
    gramsyms + 242,
    gramsyms + 243,
    gramsyms + 244,
    gramsyms + 245,
    gramsyms + 246,
    gramsyms + 247,
    gramsyms + 248,
    gramsyms + 249,
    gramsyms + 250,
    gramsyms + 251,
    gramsyms + 252,
    gramsyms + 253,
    gramsyms + 254,
    gramsyms + 255,
    gramsyms + 256,
    gramsyms + 257,
    gramsyms + 258,
    gramsyms + 259,
    gramsyms + 260,
    gramsyms + 261,
    gramsyms + 262,
    gramsyms + 263,
    gramsyms + 264,
    gramsyms + 265,
    gramsyms + 266,
    gramsyms + 267,
    gramsyms + 268,
    gramsyms + 269,
    gramsyms + 270,
    gramsyms + 271,
    gramsyms + 272,
    gramsyms + 273,
    gramsyms + 274,
    gramsyms + 275,
    gramsyms + 276,
    gramsyms + 277,
    gramsyms + 278,
    gramsyms + 279,
    gramsyms + 280,
    gramsyms + 281,
    gramsyms + 282,
    gramsyms + 283,
    gramsyms + 284,
    gramsyms + 285,
    gramsyms + 286,
    gramsyms + 287,
    gramsyms + 288,
    gramsyms + 289,
    gramsyms + 290,
    gramsyms + 291,
    gramsyms + 292,
    gramsyms + 293,
    gramsyms + 294,
    gramsyms + 295,
    gramsyms + 296,
    gramsyms + 297,
    gramsyms + 298,
    gramsyms + 299,
    gramsyms + 300,
    gramsyms + 301,
    gramsyms + 302,
    gramsyms + 303,
    gramsyms + 304,
    gramsyms + 305,
    gramsyms + 306,
    gramsyms + 307,
    gramsyms + 308,
    gramsyms + 309,
    gramsyms + 310,
    gramsyms + 311,
    gramsyms + 312,
    gramsyms + 313,
    gramsyms + 314,
    gramsyms + 315,
    gramsyms + 316,
    gramsyms + 317,
    gramsyms + 318,
    gramsyms + 319,
    gramsyms + 320,
    gramsyms + 321,
    gramsyms + 322,
    gramsyms + 323
	  };

struct namelistmap *strtonumtable[] = {
    gramsyms + 294,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 122,
    NULL,
    gramsyms + 151,
    gramsyms + 196,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 292,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 116,
    NULL,
    NULL,
    NULL,
    gramsyms + 68,
    gramsyms + 242,
    gramsyms + 70,
    gramsyms + 71,
    gramsyms + 72,
    gramsyms + 73,
    gramsyms + 74,
    gramsyms + 75,
    gramsyms + 76,
    gramsyms + 77,
    gramsyms + 10,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 175,
    gramsyms + 78,
    gramsyms + 79,
    gramsyms + 270,
    gramsyms + 81,
    gramsyms + 82,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 133,
    NULL,
    NULL,
    gramsyms + 244,
    NULL,
    NULL,
    NULL,
    gramsyms + 9,
    gramsyms + 226,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 291,
    NULL,
    gramsyms + 160,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 329,
    NULL,
    gramsyms + 1,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 115,
    gramsyms + 343,
    NULL,
    NULL,
    gramsyms + 340,
    NULL,
    NULL,
    gramsyms + 235,
    NULL,
    NULL,
    NULL,
    gramsyms + 27,
    NULL,
    gramsyms + 119,
    gramsyms + 23,
    NULL,
    gramsyms + 217,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 14,
    NULL,
    NULL,
    gramsyms + 170,
    NULL,
    gramsyms + 159,
    gramsyms + 22,
    NULL,
    gramsyms + 4,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 275,
    gramsyms + 317,
    NULL,
    NULL,
    gramsyms + 85,
    gramsyms + 274,
    gramsyms + 278,
    gramsyms + 322,
    gramsyms + 165,
    gramsyms + 236,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 198,
    NULL,
    gramsyms + 55,
    NULL,
    gramsyms + 41,
    gramsyms + 88,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 225,
    NULL,
    NULL,
    gramsyms + 36,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 157,
    gramsyms + 194,
    NULL,
    gramsyms + 60,
    gramsyms + 335,
    gramsyms + 90,
    gramsyms + 93,
    NULL,
    gramsyms + 84,
    gramsyms + 89,
    gramsyms + 234,
    NULL,
    gramsyms + 303,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 296,
    NULL,
    gramsyms + 287,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 7,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 239,
    NULL,
    gramsyms + 208,
    gramsyms + 181,
    NULL,
    NULL,
    gramsyms + 0,
    gramsyms + 8,
    gramsyms + 17,
    gramsyms + 28,
    NULL,
    gramsyms + 19,
    gramsyms + 126,
    NULL,
    gramsyms + 302,
    NULL,
    NULL,
    gramsyms + 29,
    NULL,
    NULL,
    NULL,
    gramsyms + 192,
    gramsyms + 30,
    NULL,
    gramsyms + 310,
    NULL,
    gramsyms + 134,
    gramsyms + 304,
    NULL,
    gramsyms + 58,
    gramsyms + 147,
    NULL,
    NULL,
    gramsyms + 312,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 233,
    NULL,
    gramsyms + 257,
    NULL,
    gramsyms + 12,
    NULL,
    NULL,
    gramsyms + 163,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 314,
    gramsyms + 215,
    NULL,
    gramsyms + 118,
    gramsyms + 316,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 248,
    gramsyms + 113,
    gramsyms + 136,
    NULL,
    NULL,
    NULL,
    gramsyms + 260,
    gramsyms + 112,
    NULL,
    NULL,
    NULL,
    gramsyms + 271,
    gramsyms + 318,
    gramsyms + 187,
    gramsyms + 205,
    gramsyms + 199,
    gramsyms + 105,
    gramsyms + 178,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 289,
    NULL,
    gramsyms + 110,
    NULL,
    gramsyms + 197,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 255,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 183,
    NULL,
    NULL,
    gramsyms + 169,
    NULL,
    NULL,
    NULL,
    gramsyms + 45,
    NULL,
    NULL,
    gramsyms + 229,
    NULL,
    gramsyms + 152,
    NULL,
    NULL,
    gramsyms + 120,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 125,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 311,
    gramsyms + 231,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 331,
    NULL,
    NULL,
    gramsyms + 100,
    gramsyms + 137,
    NULL,
    NULL,
    gramsyms + 315,
    gramsyms + 143,
    NULL,
    gramsyms + 104,
    NULL,
    NULL,
    gramsyms + 276,
    NULL,
    gramsyms + 324,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 333,
    gramsyms + 106,
    NULL,
    gramsyms + 31,
    gramsyms + 121,
    gramsyms + 213,
    NULL,
    NULL,
    NULL,
    gramsyms + 139,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 247,
    NULL,
    NULL,
    NULL,
    gramsyms + 53,
    NULL,
    gramsyms + 254,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 245,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 273,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 266,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 228,
    gramsyms + 336,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 293,
    NULL,
    NULL,
    gramsyms + 141,
    NULL,
    gramsyms + 262,
    NULL,
    gramsyms + 306,
    NULL,
    NULL,
    gramsyms + 61,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 219,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 320,
    NULL,
    NULL,
    NULL,
    gramsyms + 259,
    NULL,
    NULL,
    NULL,
    gramsyms + 218,
    NULL,
    NULL,
    gramsyms + 223,
    gramsyms + 107,
    gramsyms + 154,
    NULL,
    NULL,
    gramsyms + 176,
    NULL,
    NULL,
    NULL,
    gramsyms + 2,
    NULL,
    NULL,
    gramsyms + 264,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 168,
    gramsyms + 6,
    NULL,
    NULL,
    NULL,
    gramsyms + 5,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 277,
    gramsyms + 202,
    gramsyms + 173,
    gramsyms + 97,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 300,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 56,
    gramsyms + 204,
    gramsyms + 24,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 209,
    gramsyms + 177,
    gramsyms + 250,
    NULL,
    gramsyms + 153,
    NULL,
    NULL,
    gramsyms + 33,
    gramsyms + 155,
    NULL,
    gramsyms + 34,
    NULL,
    gramsyms + 334,
    gramsyms + 96,
    NULL,
    NULL,
    gramsyms + 48,
    gramsyms + 127,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 35,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 49,
    gramsyms + 13,
    gramsyms + 101,
    NULL,
    NULL,
    gramsyms + 258,
    gramsyms + 40,
    NULL,
    NULL,
    gramsyms + 307,
    NULL,
    gramsyms + 59,
    gramsyms + 295,
    NULL,
    gramsyms + 44,
    NULL,
    NULL,
    NULL,
    gramsyms + 145,
    gramsyms + 313,
    NULL,
    gramsyms + 269,
    NULL,
    NULL,
    NULL,
    gramsyms + 99,
    NULL,
    NULL,
    gramsyms + 63,
    NULL,
    NULL,
    NULL,
    gramsyms + 256,
    gramsyms + 180,
    NULL,
    gramsyms + 148,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 211,
    gramsyms + 281,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 161,
    gramsyms + 201,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 325,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 207,
    NULL,
    NULL,
    NULL,
    gramsyms + 290,
    gramsyms + 114,
    NULL,
    NULL,
    gramsyms + 224,
    NULL,
    NULL,
    gramsyms + 261,
    NULL,
    NULL,
    NULL,
    gramsyms + 203,
    NULL,
    gramsyms + 332,
    gramsyms + 146,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 327,
    NULL,
    gramsyms + 309,
    NULL,
    NULL,
    gramsyms + 130,
    gramsyms + 195,
    gramsyms + 297,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 280,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 109,
    NULL,
    gramsyms + 284,
    NULL,
    NULL,
    NULL,
    gramsyms + 251,
    NULL,
    NULL,
    gramsyms + 249,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 240,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 298,
    NULL,
    gramsyms + 164,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 103,
    NULL,
    gramsyms + 47,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 179,
    gramsyms + 232,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 193,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 129,
    gramsyms + 158,
    gramsyms + 210,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 227,
    NULL,
    gramsyms + 51,
    gramsyms + 321,
    NULL,
    NULL,
    NULL,
    gramsyms + 305,
    NULL,
    NULL,
    gramsyms + 123,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 167,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 253,
    NULL,
    gramsyms + 328,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 108,
    NULL,
    NULL,
    NULL,
    gramsyms + 185,
    gramsyms + 117,
    gramsyms + 246,
    gramsyms + 94,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 282,
    NULL,
    NULL,
    gramsyms + 286,
    NULL,
    gramsyms + 241,
    NULL,
    NULL,
    gramsyms + 326,
    NULL,
    gramsyms + 301,
    NULL,
    gramsyms + 308,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 220,
    NULL,
    NULL,
    NULL,
    gramsyms + 230,
    NULL,
    NULL,
    gramsyms + 200,
    gramsyms + 206,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 140,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 263,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 124,
    gramsyms + 102,
    NULL,
    gramsyms + 174,
    gramsyms + 323,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 338,
    NULL,
    NULL,
    NULL,
    gramsyms + 243,
    gramsyms + 265,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 39,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 330,
    NULL,
    NULL,
    NULL,
    gramsyms + 50,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 283,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 150,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 337,
    NULL,
    NULL,
    NULL,
    gramsyms + 186,
    NULL,
    gramsyms + 319,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 279,
    NULL,
    gramsyms + 191,
    gramsyms + 342,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 288,
    gramsyms + 98,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 171,
    gramsyms + 339,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 131,
    gramsyms + 341,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 299,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 156,
    gramsyms + 252,
    NULL,
    gramsyms + 285,
    NULL,
    NULL,
    NULL,
    gramsyms + 212,
    NULL,
    NULL,
    gramsyms + 166,
    gramsyms + 190,
    NULL,
    gramsyms + 132,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 216,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    gramsyms + 128
	  };

short lhs[] = {
     109,
     111,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     113,
     114,
     114,
     114,
     115,
     125,
     116,
     116,
     116,
     130,
     134,
     134,
     134,
     134,
     134,
     134,
     134,
     117,
     100,
     143,
     143,
     143,
     143,
     141,
     144,
     106,
     106,
     135,
     148,
     150,
     150,
     136,
     137,
     137,
     145,
     151,
     146,
     153,
     138,
     138,
     154,
     128,
     155,
     157,
     158,
     158,
     139,
     160,
     160,
     160,
     163,
     165,
     166,
     164,
     168,
     170,
     170,
     140,
     131,
     173,
     175,
     175,
     175,
     175,
     178,
     178,
     179,
     179,
     179,
     102,
     102,
     102,
     102,
     102,
     102,
     101,
     185,
     186,
     188,
     188,
     188,
     188,
     187,
     189,
     189,
     189,
     189,
     107,
     190,
     147,
     193,
     193,
     193,
      97,
      97,
      97,
      97,
      97,
      97,
     195,
     195,
      99,
     204,
     206,
     206,
     206,
     207,
     207,
     207,
     207,
     207,
     207,
     211,
     211,
     211,
     211,
     211,
     211,
     212,
     212,
     212,
     213,
     213,
     214,
     214,
     214,
     214,
     210,
     209,
     209,
     209,
     215,
     216,
     216,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     219,
     220,
     220,
     220,
     220,
     220,
     220,
     237,
     221,
     222,
     231,
     238,
     232,
     241,
     233,
     244,
     244,
     245,
     234,
     223,
     224,
     225,
     118,
     251,
     251,
     253,
     253,
     184,
     254,
     255,
     257,
     257,
     257,
     181,
     230,
     119,
     260,
     182,
     182,
     132,
     177,
     124,
     124,
     124,
     124,
     120,
     266,
     266,
     183,
     270,
     235,
     235,
     273,
     226,
     236,
     236,
     236,
     274,
     277,
     280,
     280,
     280,
     281,
     282,
     283,
     275,
     276,
     227,
     108,
     287,
     287,
     289,
     289,
     289,
     289,
     289,
     290,
     290,
     291,
     288,
     294,
     180,
     180,
     180,
     292,
     122,
     296,
     297,
     297,
     228,
     121,
     299,
     299,
     300,
     302,
     302,
     302,
     302,
     304,
     304,
     304,
     304,
     304,
     304,
     123,
     123,
     123,
     307,
     308,
     311,
     311,
     312,
     176,
     176,
     313,
     313,
     313,
     315,
     316,
     317,
     320,
     321,
     314,
     229,
     161,
     161,
     110,
     110,
     322,
     322,
     112,
     112,
     126,
     126,
     127,
     127,
     129,
     129,
     133,
     133,
     142,
     142,
      98,
      98,
     149,
     149,
     152,
     152,
     156,
     156,
     159,
     159,
     162,
     162,
     167,
     167,
     169,
     169,
     171,
     171,
     172,
     172,
     174,
     174,
     191,
     191,
     192,
     192,
     194,
     194,
     196,
     196,
     197,
     197,
     198,
     198,
     199,
     199,
     200,
     200,
     201,
     201,
     202,
     202,
     203,
     203,
     203,
     205,
     205,
     208,
     208,
     217,
     217,
     218,
     218,
     239,
     239,
     240,
     240,
     242,
     242,
     104,
     104,
     103,
     103,
     243,
     243,
     246,
     246,
     247,
     247,
     248,
     248,
     323,
     323,
     105,
     105,
     249,
     249,
     250,
     250,
     252,
     252,
     256,
     256,
     258,
     258,
     259,
     259,
     261,
     261,
     262,
     262,
     263,
     263,
     264,
     265,
     267,
     267,
     268,
     268,
     269,
     269,
     271,
     271,
     272,
     272,
     278,
     278,
     279,
     279,
     284,
     284,
     285,
     285,
     286,
     286,
     293,
     293,
     324,
     324,
     295,
     295,
     298,
     298,
     301,
     301,
     303,
     303,
     305,
     305,
     305,
     306,
     306,
     309,
     309,
     310,
     310,
     318,
     318,
     319,
     319
	  };

short rhslen[] = {
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     6,
     6,
     6,
     2,
     1,
     1,
     1,
     5,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     2,
     1,
     1,
     1,
     1,
     2,
     2,
     1,
     3,
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     2,
     2,
     2,
     1,
     1,
     7,
     4,
     3,
     4,
     2,
     1,
     4,
     4,
     4,
     4,
     5,
     4,
     4,
     9,
     5,
     1,
     1,
     2,
     3,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     3,
     1,
     1,
     1,
     1,
     3,
     1,
     1,
     1,
     1,
     4,
     1,
     4,
     1,
     3,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     2,
     4,
     1,
     1,
     2,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     3,
     2,
     3,
     4,
     3,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     3,
     2,
     4,
     9,
     1,
     9,
     5,
     8,
     2,
     2,
     4,
     8,
     4,
     3,
     3,
     2,
     3,
     5,
     1,
     1,
     1,
     4,
     5,
     1,
     2,
     1,
     9,
     2,
     2,
     7,
     8,
    11,
     6,
     4,
     4,
     4,
     5,
     4,
     2,
     3,
     8,
    11,
     4,
     4,
     8,
     1,
     3,
     1,
     1,
     1,
     8,
     2,
     1,
     1,
     1,
     2,
     2,
     3,
     9,
    10,
     4,
     1,
     2,
     2,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     4,
     4,
     6,
     6,
     5,
     4,
     5,
     1,
     1,
     3,
     2,
     2,
     2,
     2,
     6,
     5,
     1,
     4,
     3,
     2,
     2,
     2,
     1,
     1,
     7,
     7,
     6,
     4,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     1,
     5,
     5,
     9,
     4,
     6,
     6,
     4,
     0,
     2,
     0,
     3,
     1,
     3,
     1,
     3,
     0,
     2,
     0,
     1,
     0,
     3,
     1,
     2,
     0,
     1,
     1,
     3,
     0,
     3,
     0,
     1,
     0,
     3,
     0,
     3,
     0,
     3,
     0,
     3,
     0,
     2,
     0,
     3,
     1,
     2,
     1,
     3,
     0,
     3,
     1,
     4,
     0,
     3,
     3,
     3,
     3,
     3,
     3,
     3,
     4,
     4,
     4,
     4,
     0,
     2,
     0,
     1,
     1,
     2,
     3,
     1,
     3,
     0,
     2,
     1,
     3,
     0,
     2,
     0,
     5,
     0,
     2,
     0,
     2,
     0,
     2,
     0,
     1,
     0,
     1,
     0,
     1,
     0,
     2,
     0,
     3,
     1,
     2,
     0,
     1,
     0,
     2,
     0,
     1,
     0,
     1,
     0,
     3,
     0,
     1,
     0,
     1,
     0,
     2,
     0,
     1,
     0,
     3,
     3,
     3,
     0,
     1,
     1,
     3,
     0,
     3,
     1,
     4,
     1,
     4,
     0,
     4,
     0,
     4,
     1,
     1,
     0,
     3,
     1,
     3,
     0,
     3,
     1,
     3,
     0,
     3,
     0,
     3,
     0,
     2,
     1,
     2,
     0,
     2,
     2,
     0,
     1,
     0,
     3,
     1,
     3,
     1,
     3,
     0,
     3
	  };

short act_tab1[] = {
	   0,
	   0,
	   0,
	   0,
	   0,
	6093,
	  83,
	  84,
	  85,
	  86,
	7796,
	   0,
	 741,
	6693,
	6696,
	7800,
	  77,
	6743,
	   0,
	  75,
	6096,
	   0,
	   0,
	  80,
	   0,
	   0,
	6863,
	  63,
	  62,
	  72,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 641,
	   0,
	   0,
	   0,
	   0,
	6646,
	6866,
	6871,
	6877,
	7451,
	  71,
	7454,
	  65,
	   0,
	  58,
	  70,
	  59,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 911,
	   0,
	   0,
	   0,
	 911,
	   0,
	 911,
	   0,
	  38,
	6880,
	  50,
	6884,
	   0,
	  64,
	6887,
	  82,
	   0,
	7424,
	  74,
	6890,
	 334,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 911,
	   0,
	   0,
	   0,
	   0,
	7195,
	 911,
	 911,
	6853,
	8233,
	6856,
	8237,
	 911,
	6534,
	 911,
	   0,
	  73,
	 911,
	 911,
	 911,
	   0,
	1093,
	   0,
	 911,
	   0,
	 911,
	 911,
	 911,
	   0,
	   0,
	   0,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 277,
	   0,
	   0,
	   0,
	   0,
	   0,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 268,
	   0,
	   0,
	   0,
	 710,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	6634,
	  68,
	  69,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	  87,
	  83,
	  84,
	  85,
	7427,
	  88,
	   0,
	   0,
	6637,
	6640,
	  78,
	  77,
	7430,
	  79,
	7435,
	7439,
	  60,
	   0,
	7442,
	  76,
	  66,
	  67,
	7445,
	7226,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 324,
	   0,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	6860,
	 655,
	   0,
	  80,
	 654,
	   0,
	   0,
	   0,
	   0,
	  52,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6086,
	   0,
	 272,
	 337,
	 106,
	   0,
	 340,
	   0,
	   0,
	   0,
	   0,
	   0,
	 614,
	   0,
	 344,
	 343,
	 632,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7077,
	 314,
	   0,
	   0,
	   0,
	   6,
	   0,
	 700,
	   0,
	 222,
	 699,
	 812,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 271,
	 581,
	   0,
	 342,
	   0,
	   0,
	   0,
	   0,
	 102,
	   0,
	   0,
	   0,
	   0,
	  61,
	6448,
	  62,
	  72,
	6620,
	   6,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 341,
	 649,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 730,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6281,
	6126,
	6129,
	6132,
	   0,
	  63,
	6623,
	  72,
	   0,
	6074,
	 129,
	  59,
	   0,
	 538,
	   0,
	   0,
	   0,
	   0,
	 270,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7955,
	7419,
	6284,
	6287,
	  38,
	6627,
	6630,
	  65,
	   0,
	6798,
	6690,
	6135,
	 801,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	7958,
	   0,
	 346,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	6291,
	 338,
	  64,
	6294,
	 317,
	   0,
	6594,
	 125,
	6297,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   2,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	   0,
	  64,
	 527,
	 720,
	8230,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 357,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	 128,
	   0,
	  87,
	6065,
	  84,
	7977,
	  86,
	6068,
	8316,
	   0,
	  81,
	8393,
	6597,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	  66,
	  67,
	6278,
	  69,
	  66,
	6600,
	  68,
	  69,
	 159,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	6123,
	6603,
	  79,
	6607,
	6610,
	  60,
	   0,
	6613,
	  76,
	  66,
	  67,
	6617,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	8319,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	 419,
	 657,
	  38,
	   0,
	 656,
	 336,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 765,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 280,
	 113,
	 275,
	   0,
	 603,
	   0,
	6071,
	 354,
	 353,
	   0,
	 372,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7952,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8396,
	  62,
	  72,
	   0,
	 347,
	   0,
	   0,
	   0,
	   0,
	 508,
	   0,
	   0,
	 223,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 220,
	 319,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 754,
	8331,
	6445,
	  50,
	  65,
	  38,
	   0,
	6247,
	  65,
	  61,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	  61,
	  64,
	 125,
	 406,
	   0,
	7406,
	7409,
	7413,
	   0,
	 231,
	   0,
	   0,
	 802,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	 129,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	6847,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	  58,
	 422,
	7416,
	 107,
	   0,
	   0,
	5994,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	 525,
	  58,
	   0,
	  59,
	  38,
	  71,
	  50,
	6850,
	   0,
	   0,
	  70,
	8390,
	   0,
	7378,
	7949,
	7788,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 813,
	   0,
	  63,
	  62,
	6009,
	6362,
	7791,
	6013,
	  66,
	7580,
	  68,
	6244,
	  73,
	   0,
	   0,
	   0,
	  82,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	  81,
	6819,
	  78,
	6117,
	  60,
	   0,
	6022,
	  76,
	   0,
	  38,
	6016,
	6120,
	  65,
	   0,
	  63,
	6365,
	  72,
	   0,
	  58,
	 129,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 162,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	 128,
	 561,
	   0,
	  82,
	  38,
	6368,
	6371,
	  65,
	   0,
	   0,
	  70,
	7381,
	7384,
	7387,
	  69,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 237,
	7743,
	 731,
	   0,
	   0,
	  66,
	  67,
	6003,
	6006,
	7390,
	  79,
	7393,
	  77,
	7396,
	  61,
	7399,
	  76,
	6822,
	7204,
	7402,
	7207,
	  65,
	 274,
	   0,
	6340,
	6343,
	5951,
	  77,
	6825,
	   0,
	  75,
	7746,
	   0,
	   0,
	  80,
	   0,
	  81,
	6828,
	6831,
	6834,
	6837,
	   0,
	6841,
	6844,
	   0,
	 373,
	7050,
	  62,
	7054,
	  38,
	   0,
	   0,
	   0,
	   0,
	 282,
	7750,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 616,
	   0,
	 658,
	5991,
	6238,
	  68,
	  69,
	6000,
	   0,
	  64,
	  74,
	   0,
	7057,
	7060,
	7063,
	7067,
	  84,
	  85,
	7071,
	  88,
	   0,
	8054,
	8058,
	7074,
	6347,
	7943,
	  60,
	7946,
	8061,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	  63,
	  62,
	6350,
	  67,
	  68,
	  69,
	   0,
	   0,
	6353,
	   0,
	7032,
	 517,
	  64,
	7035,
	  83,
	  84,
	  85,
	7038,
	7041,
	   0,
	   0,
	6356,
	  79,
	  78,
	  77,
	  60,
	  61,
	  75,
	  76,
	   0,
	  38,
	6359,
	  50,
	  65,
	  61,
	   0,
	6241,
	7198,
	  67,
	7201,
	 283,
	  59,
	   0,
	   0,
	 803,
	   0,
	   0,
	   0,
	   0,
	6795,
	 257,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	6111,
	6114,
	  72,
	   0,
	 133,
	   0,
	 541,
	 718,
	7358,
	7362,
	  72,
	   0,
	   0,
	   0,
	  73,
	 234,
	   0,
	  81,
	6442,
	  78,
	8387,
	7173,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	 280,
	  38,
	  71,
	  50,
	8205,
	   0,
	 174,
	  70,
	7044,
	7365,
	7368,
	7372,
	7375,
	   0,
	   0,
	  70,
	 106,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	 232,
	  81,
	  79,
	7223,
	  77,
	  60,
	   0,
	  75,
	  76,
	 575,
	   0,
	7047,
	  74,
	   0,
	   0,
	 104,
	   0,
	7338,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 814,
	   0,
	   0,
	   5,
	 701,
	   0,
	   0,
	   0,
	6229,
	  67,
	  68,
	6232,
	   0,
	1163,
	   0,
	 756,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	6235,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	1165,
	  80,
	   0,
	   0,
	   0,
	   0,
	6987,
	   0,
	   0,
	1163,
	   0,
	 664,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 634,
	   0,
	   0,
	   0,
	   0,
	 585,
	   0,
	   0,
	 514,
	   0,
	6108,
	  67,
	  68,
	  69,
	1163,
	 117,
	   0,
	   0,
	7740,
	  67,
	  68,
	  69,
	1163,
	   0,
	   0,
	1163,
	 807,
	 591,
	   0,
	7341,
	  79,
	6990,
	6993,
	6996,
	6984,
	6981,
	6999,
	7344,
	  79,
	7347,
	7351,
	7354,
	  61,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	 423,
	  40,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 105,
	8227,
	 713,
	   0,
	   0,
	  63,
	  62,
	7026,
	  38,
	   0,
	  50,
	 241,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 768,
	   0,
	   0,
	   0,
	   0,
	   0,
	 668,
	   0,
	 514,
	   0,
	 781,
	  43,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	7029,
	   0,
	   0,
	7734,
	   0,
	  59,
	  44,
	   0,
	   0,
	  21,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 491,
	 820,
	6083,
	   0,
	  63,
	   0,
	7785,
	   0,
	  64,
	7217,
	   0,
	   0,
	   0,
	   0,
	7003,
	7220,
	   0,
	   0,
	   0,
	 146,
	 145,
	  66,
	  67,
	  68,
	  69,
	   0,
	 113,
	   0,
	   0,
	 153,
	7329,
	   0,
	6788,
	  65,
	  38,
	8184,
	  50,
	8187,
	   0,
	   0,
	  70,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 743,
	8378,
	1240,
	6792,
	   0,
	 113,
	  63,
	  62,
	7737,
	  38,
	8191,
	8195,
	8198,
	   0,
	  64,
	8202,
	   0,
	1240,
	   0,
	   0,
	8374,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	8369,
	   0,
	5963,
	   0,
	  63,
	  62,
	7007,
	7332,
	7335,
	8364,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	8178,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	7010,
	  79,
	7013,
	7016,
	  60,
	   0,
	  75,
	7019,
	  73,
	  38,
	7022,
	  50,
	  65,
	7940,
	   0,
	  70,
	8381,
	   0,
	7312,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	7192,
	6785,
	  69,
	7779,
	  67,
	7782,
	7936,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	 574,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 576,
	   0,
	   0,
	   0,
	   0,
	 225,
	   0,
	  75,
	  76,
	   0,
	   0,
	   0,
	   0,
	8181,
	  67,
	  68,
	  69,
	   0,
	   0,
	 231,
	   0,
	   0,
	  42,
	   0,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	  41,
	   0,
	   0,
	   0,
	   0,
	 119,
	   0,
	  75,
	  76,
	7315,
	  67,
	7318,
	7321,
	  79,
	  78,
	  77,
	  60,
	   0,
	6978,
	  76,
	 260,
	 866,
	6337,
	   0,
	   0,
	  61,
	   0,
	   0,
	  81,
	  79,
	7974,
	  77,
	  60,
	   0,
	  75,
	  76,
	  66,
	  67,
	7326,
	  69,
	 424,
	 220,
	 276,
	 278,
	 592,
	   0,
	   0,
	 326,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	8313,
	6810,
	6813,
	6816,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	 704,
	   0,
	   0,
	   0,
	 188,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	  38,
	   0,
	 321,
	   0,
	6212,
	6975,
	  50,
	6059,
	   0,
	   0,
	  70,
	   0,
	   0,
	6531,
	   0,
	  59,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	   0,
	   0,
	8384,
	   9,
	   0,
	6215,
	  62,
	6219,
	   8,
	  64,
	  74,
	 816,
	   0,
	 822,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6105,
	  71,
	  50,
	5914,
	  45,
	   0,
	  70,
	   0,
	  38,
	6223,
	  50,
	6226,
	   0,
	   0,
	  70,
	   0,
	   0,
	8167,
	   0,
	8170,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 351,
	 261,
	   0,
	   0,
	   0,
	   0,
	   0,
	 317,
	   0,
	5921,
	5924,
	 586,
	   0,
	 544,
	 126,
	6194,
	7170,
	  64,
	  74,
	   0,
	  38,
	  71,
	  50,
	8174,
	   0,
	   0,
	  70,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 217,
	   0,
	 407,
	   0,
	   0,
	6507,
	  67,
	6510,
	  69,
	   0,
	   0,
	   0,
	   0,
	 805,
	   0,
	 454,
	7167,
	6588,
	7188,
	  85,
	6591,
	7214,
	   0,
	  64,
	8157,
	  79,
	  78,
	6513,
	  60,
	  73,
	  75,
	6516,
	 455,
	 776,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	6519,
	   0,
	   0,
	   0,
	 769,
	  54,
	   0,
	   0,
	   0,
	 429,
	   0,
	   0,
	   0,
	 133,
	 433,
	   0,
	 450,
	   0,
	   0,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	 289,
	  66,
	6522,
	  68,
	6525,
	  65,
	   0,
	   0,
	   0,
	 279,
	   0,
	   0,
	6197,
	6200,
	6203,
	6206,
	8223,
	  88,
	  75,
	  76,
	  81,
	  79,
	6209,
	  77,
	  60,
	   0,
	  75,
	  76,
	 793,
	6528,
	  80,
	   0,
	 686,
	   0,
	   0,
	   0,
	   0,
	  61,
	 453,
	 435,
	  66,
	8161,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 120,
	7717,
	8164,
	  76,
	 543,
	   0,
	  63,
	8301,
	  72,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 374,
	   0,
	   0,
	   0,
	 635,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 183,
	7720,
	7724,
	7728,
	8304,
	  71,
	8307,
	  65,
	   0,
	   0,
	  70,
	   0,
	   0,
	  58,
	   0,
	8310,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6498,
	6740,
	  68,
	  69,
	   0,
	  38,
	7731,
	  50,
	  65,
	   0,
	  89,
	  70,
	  82,
	   0,
	8248,
	  74,
	  59,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	8251,
	8254,
	 747,
	5911,
	  61,
	   0,
	  70,
	   0,
	   0,
	  46,
	 377,
	 428,
	6737,
	7654,
	 438,
	7657,
	 440,
	7660,
	7663,
	6501,
	 444,
	 445,
	7666,
	7669,
	 457,
	 458,
	 459,
	6504,
	 461,
	 426,
	 668,
	   0,
	   0,
	   0,
	   0,
	   0,
	6773,
	6776,
	  72,
	 375,
	   0,
	   0,
	 618,
	   0,
	 474,
	 472,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 108,
	   0,
	 110,
	   0,
	   0,
	   0,
	  47,
	   0,
	   0,
	   0,
	6582,
	7185,
	 607,
	   0,
	7305,
	6779,
	6782,
	  65,
	   0,
	   0,
	  70,
	8257,
	8260,
	8263,
	  69,
	  59,
	1218,
	   0,
	   0,
	  61,
	   0,
	   0,
	  87,
	  83,
	8267,
	  85,
	  86,
	8270,
	   6,
	   0,
	  81,
	  79,
	8273,
	8276,
	8280,
	 302,
	8283,
	8287,
	7672,
	8154,
	8292,
	7676,
	   0,
	 220,
	 245,
	   0,
	7679,
	 244,
	   0,
	  87,
	  83,
	7684,
	7687,
	7690,
	7693,
	   0,
	   0,
	  81,
	7696,
	  78,
	7699,
	7702,
	6585,
	7706,
	7709,
	  65,
	  38,
	7713,
	7309,
	  65,
	  10,
	  58,
	8151,
	7211,
	   0,
	7932,
	   0,
	  59,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	  61,
	   0,
	  70,
	   0,
	   0,
	  58,
	   0,
	  59,
	   0,
	8217,
	 794,
	6561,
	   0,
	7275,
	6564,
	  82,
	   0,
	  64,
	7278,
	  73,
	   0,
	   0,
	   0,
	7281,
	 498,
	 494,
	 495,
	 496,
	 497,
	   0,
	 770,
	   0,
	6685,
	6146,
	6439,
	   0,
	 746,
	   0,
	6760,
	  67,
	  68,
	6764,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8220,
	  83,
	  84,
	  85,
	  86,
	7182,
	5997,
	7929,
	  81,
	6767,
	  78,
	  77,
	  60,
	  38,
	6770,
	8297,
	6149,
	   0,
	  80,
	6152,
	   0,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	   0,
	 465,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 643,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6567,
	7642,
	6570,
	6573,
	  66,
	  67,
	  68,
	  69,
	6139,
	   0,
	   0,
	   0,
	7968,
	   0,
	   6,
	7971,
	  83,
	  84,
	  85,
	7284,
	7288,
	6576,
	6579,
	7292,
	  79,
	7296,
	7299,
	  60,
	   0,
	7302,
	  76,
	   0,
	   0,
	7645,
	  62,
	  72,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	  38,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	   0,
	  50,
	  65,
	8044,
	  71,
	  50,
	7648,
	   0,
	 358,
	7651,
	 353,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	8048,
	   0,
	   5,
	   0,
	   0,
	 514,
	   0,
	6142,
	6413,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	 748,
	   0,
	  64,
	 379,
	   0,
	   0,
	  64,
	  74,
	   0,
	 136,
	   0,
	  81,
	7625,
	  78,
	8051,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 511,
	   0,
	   0,
	  48,
	   0,
	   0,
	 588,
	   0,
	   0,
	 410,
	   0,
	   0,
	 112,
	   0,
	 110,
	  63,
	  62,
	  72,
	  43,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	 548,
	 134,
	   0,
	   0,
	   0,
	   0,
	   0,
	7158,
	 226,
	 134,
	7161,
	   0,
	   0,
	   0,
	   0,
	 220,
	 658,
	   0,
	6191,
	  71,
	  50,
	7164,
	  61,
	   0,
	  70,
	   0,
	6436,
	  58,
	   0,
	6734,
	  67,
	7260,
	7263,
	7629,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 499,
	   0,
	   0,
	7908,
	7911,
	7914,
	7632,
	7636,
	   0,
	  75,
	7639,
	5917,
	7266,
	  71,
	  50,
	7269,
	   0,
	   0,
	7272,
	   0,
	 210,
	  58,
	   0,
	7918,
	   0,
	   0,
	   0,
	6558,
	6555,
	   0,
	   0,
	   0,
	   0,
	 204,
	 205,
	  38,
	7775,
	7921,
	7925,
	   0,
	   0,
	  70,
	6682,
	  97,
	7235,
	 135,
	7238,
	   0,
	  64,
	7241,
	   0,
	   0,
	   0,
	 395,
	7244,
	   0,
	   0,
	   0,
	 263,
	7247,
	  62,
	  72,
	6328,
	   0,
	   0,
	   0,
	6969,
	6486,
	  50,
	6489,
	   0,
	  64,
	6492,
	 795,
	   0,
	  58,
	   0,
	6495,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 291,
	   0,
	   0,
	   0,
	  66,
	5984,
	5987,
	7809,
	7813,
	 190,
	7816,
	7819,
	7824,
	7827,
	7830,
	7835,
	7839,
	 198,
	7844,
	7847,
	   0,
	   0,
	   0,
	  81,
	7850,
	7854,
	7857,
	  60,
	  11,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	 561,
	 335,
	  82,
	  38,
	6331,
	6334,
	  65,
	  38,
	  71,
	6972,
	7250,
	  67,
	7254,
	7257,
	  59,
	   0,
	  58,
	   0,
	  59,
	   0,
	   0,
	  87,
	  83,
	  84,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	  79,
	  78,
	7860,
	7863,
	7868,
	7871,
	7876,
	8244,
	 180,
	7880,
	7885,
	 317,
	 597,
	  64,
	6941,
	6316,
	7154,
	  85,
	6944,
	6947,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	  66,
	6731,
	6463,
	  69,
	 565,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	6466,
	6469,
	  78,
	6472,
	6475,
	6056,
	6479,
	6482,
	  65,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	6728,
	  83,
	  84,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	7965,
	7889,
	  77,
	  60,
	  38,
	6756,
	5981,
	  65,
	   0,
	6546,
	7892,
	   0,
	   0,
	  58,
	 208,
	7895,
	7899,
	6319,
	6322,
	  66,
	  67,
	  68,
	  69,
	   0,
	  51,
	   5,
	8328,
	  83,
	  84,
	  85,
	  86,
	6552,
	   0,
	   0,
	6325,
	  79,
	  78,
	  77,
	6951,
	  79,
	6955,
	6959,
	  60,
	   0,
	6963,
	6966,
	  73,
	  93,
	  80,
	  16,
	7902,
	   0,
	   0,
	   0,
	 531,
	   0,
	   0,
	   0,
	 549,
	   0,
	   0,
	   0,
	   0,
	 183,
	 184,
	 185,
	7905,
	 187,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 365,
	 134,
	 106,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	 501,
	   0,
	   0,
	   0,
	 105,
	 107,
	   0,
	   0,
	 128,
	   0,
	 109,
	  66,
	  67,
	6046,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	 818,
	   0,
	  13,
	   0,
	   0,
	 237,
	 236,
	   0,
	   0,
	 564,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5978,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	  51,
	   0,
	  50,
	   0,
	 431,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	8325,
	  78,
	6460,
	6049,
	   0,
	  75,
	  76,
	   0,
	   0,
	7179,
	   0,
	   0,
	   0,
	 133,
	   0,
	   0,
	   0,
	   0,
	 639,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	 228,
	 672,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 307,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	 620,
	   0,
	6053,
	   0,
	   0,
	   0,
	 235,
	 277,
	   0,
	   0,
	   0,
	   0,
	 566,
	 220,
	   0,
	   0,
	   0,
	   0,
	   0,
	  49,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 785,
	   0,
	 113,
	 359,
	   0,
	   0,
	   0,
	   0,
	   0,
	 520,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  52,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	 315,
	6080,
	   5,
	 167,
	   0,
	   0,
	   0,
	   0,
	 730,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	 809,
	   0,
	 110,
	  38,
	   0,
	   0,
	   0,
	 234,
	  63,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 608,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 593,
	   0,
	   0,
	 626,
	   0,
	   0,
	 551,
	   0,
	   0,
	  38,
	8038,
	8041,
	  65,
	   0,
	   0,
	  70,
	   0,
	 532,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	  12,
	   0,
	   0,
	   0,
	   0,
	 673,
	   0,
	   0,
	   6,
	   0,
	   0,
	   0,
	  64,
	  74,
	 674,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 413,
	   0,
	 412,
	   0,
	 689,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  22,
	  17,
	 671,
	 675,
	7151,
	 677,
	   0,
	6410,
	   0,
	   0,
	   0,
	   0,
	 220,
	   6,
	   0,
	 502,
	  30,
	   5,
	   0,
	  21,
	   0,
	   0,
	   0,
	  38,
	   0,
	  50,
	  65,
	   0,
	8361,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6679,
	7148,
	  66,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 784,
	   0,
	   0,
	   0,
	   0,
	   0,
	 534,
	   0,
	   0,
	   0,
	 140,
	8028,
	8031,
	8034,
	 329,
	  75,
	  76,
	   0,
	  97,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6019,
	 107,
	   0,
	 397,
	   0,
	 293,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	5939,
	   0,
	   0,
	  95,
	8346,
	  24,
	6043,
	8349,
	 110,
	8352,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 407,
	   0,
	   0,
	   0,
	   0,
	   0,
	 624,
	   0,
	   0,
	 365,
	 134,
	   0,
	   0,
	   0,
	   0,
	 796,
	6752,
	   0,
	7806,
	 546,
	   0,
	   0,
	   0,
	 567,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5969,
	  69,
	 598,
	   0,
	   0,
	   0,
	1192,
	   0,
	   0,
	   0,
	6313,
	  27,
	  29,
	   0,
	   0,
	   0,
	   0,
	   0,
	 521,
	   0,
	   0,
	7962,
	   0,
	   0,
	   0,
	   0,
	 169,
	   0,
	   0,
	1188,
	   0,
	 116,
	   0,
	 627,
	   0,
	   6,
	   0,
	 825,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6725,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 554,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 749,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  20,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 365,
	8355,
	   0,
	  38,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	   0,
	   0,
	   5,
	 653,
	   0,
	 144,
	   0,
	   0,
	   0,
	   0,
	 142,
	   0,
	 143,
	 216,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  15,
	  14,
	  31,
	  32,
	   0,
	   0,
	   0,
	   0,
	   0,
	 514,
	  16,
	8358,
	   0,
	   6,
	   0,
	   0,
	 688,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	7142,
	  22,
	7145,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 786,
	   0,
	   0,
	 210,
	   0,
	 310,
	  21,
	 133,
	   0,
	   0,
	   0,
	   0,
	   0,
	 536,
	   0,
	   0,
	 204,
	 205,
	   0,
	1136,
	 200,
	  94,
	   0,
	   0,
	   0,
	   0,
	  97,
	   0,
	 887,
	   0,
	   0,
	   0,
	   0,
	 610,
	   0,
	   0,
	   0,
	   0,
	   0,
	   5,
	   0,
	   0,
	   0,
	   0,
	   0,
	 915,
	   0,
	   0,
	   0,
	   0,
	   6,
	 337,
	   0,
	   0,
	 340,
	   0,
	 811,
	   0,
	   6,
	   0,
	   0,
	 294,
	 474,
	 472,
	   0,
	   0,
	   0,
	  34,
	5933,
	 220,
	   0,
	   0,
	5930,
	   0,
	7090,
	 189,
	 190,
	7093,
	7096,
	 193,
	7099,
	7102,
	 196,
	 197,
	7551,
	7106,
	 207,
	5975,
	 141,
	   0,
	   0,
	 201,
	 202,
	7109,
	 469,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 915,
	   0,
	   0,
	 229,
	  33,
	6077,
	 915,
	 915,
	5927,
	 915,
	 915,
	1119,
	 915,
	7176,
	7556,
	7560,
	  72,
	8213,
	 915,
	 915,
	   0,
	   0,
	6275,
	 915,
	   0,
	 915,
	 915,
	5948,
	   0,
	1176,
	   0,
	   0,
	   0,
	   0,
	 177,
	7112,
	 214,
	7115,
	7118,
	7121,
	7125,
	 181,
	 182,
	 797,
	7565,
	  71,
	7568,
	7571,
	   0,
	1176,
	8209,
	 568,
	   0,
	7574,
	1176,
	7577,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	1234,
	5936,
	   0,
	 113,
	   6,
	   0,
	   0,
	1176,
	 339,
	   0,
	   0,
	   0,
	1176,
	   0,
	7532,
	 478,
	7536,
	7539,
	 481,
	 482,
	 483,
	 484,
	  73,
	5945,
	6451,
	6454,
	6457,
	   0,
	1176,
	1176,
	   0,
	 473,
	   0,
	 475,
	 338,
	   0,
	 523,
	   0,
	   0,
	   0,
	   0,
	   0,
	1163,
	   0,
	   0,
	   0,
	 211,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	5942,
	  71,
	7129,
	7132,
	   0,
	   0,
	7136,
	 209,
	 206,
	  58,
	   0,
	  59,
	7983,
	1163,
	  50,
	8002,
	   0,
	   5,
	 154,
	 106,
	   0,
	1163,
	 558,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	6676,
	   0,
	  82,
	   0,
	7232,
	  74,
	   0,
	 431,
	1163,
	  16,
	7139,
	   0,
	   0,
	   0,
	7999,
	  67,
	7542,
	7545,
	   0,
	   0,
	   0,
	   0,
	7996,
	 183,
	 184,
	7993,
	 186,
	 187,
	   0,
	   0,
	7990,
	 149,
	8011,
	8015,
	7548,
	7986,
	  77,
	  60,
	   0,
	8019,
	8022,
	8025,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 231,
	   0,
	 332,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 363,
	   0,
	 514,
	   0,
	 706,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 131,
	 134,
	   0,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	  66,
	5966,
	  68,
	  69,
	1176,
	 361,
	1176,
	 362,
	   0,
	 113,
	 761,
	  87,
	6709,
	6714,
	6717,
	6722,
	6256,
	6253,
	   0,
	  81,
	  79,
	6268,
	6265,
	6262,
	   0,
	6259,
	8342,
	1176,
	   0,
	  80,
	1176,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	1176,
	   0,
	 971,
	 504,
	   0,
	  38,
	 218,
	   0,
	   0,
	1176,
	   0,
	   0,
	   0,
	   0,
	1176,
	 787,
	1176,
	   0,
	   0,
	   0,
	 113,
	   0,
	   0,
	   0,
	 971,
	8005,
	8008,
	   0,
	1176,
	7772,
	1176,
	1176,
	   0,
	   0,
	   0,
	 153,
	   0,
	   0,
	   0,
	 644,
	   0,
	 265,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 296,
	   0,
	   0,
	   0,
	   0,
	8339,
	   0,
	6250,
	   0,
	   0,
	 738,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 762,
	   0,
	  38,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  47,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	   0,
	   0,
	   0,
	   0,
	   0,
	 673,
	 798,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 115,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 594,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	 413,
	   0,
	 569,
	   0,
	 788,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	  72,
	 777,
	6703,
	  99,
	   0,
	   0,
	   0,
	 101,
	   0,
	8241,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	6706,
	   0,
	   0,
	   0,
	  63,
	6040,
	  72,
	  38,
	  71,
	  50,
	  65,
	 537,
	   0,
	6271,
	   0,
	   0,
	  58,
	   0,
	6188,
	   0,
	   0,
	 170,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 113,
	  63,
	  62,
	  72,
	  38,
	  71,
	  50,
	  65,
	  38,
	 559,
	  70,
	  82,
	   0,
	6170,
	6173,
	  59,
	   0,
	   0,
	  98,
	  73,
	   0,
	   0,
	   0,
	   0,
	   0,
	 100,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	5960,
	  65,
	   0,
	 561,
	  70,
	  82,
	   0,
	6028,
	  74,
	  59,
	   0,
	 514,
	 415,
	6407,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6749,
	   0,
	  64,
	 125,
	   0,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	   0,
	 106,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 105,
	 107,
	   0,
	   0,
	   0,
	   0,
	   0,
	6176,
	  67,
	6179,
	6182,
	   0,
	   0,
	 365,
	6426,
	   0,
	 132,
	   0,
	7087,
	  83,
	6430,
	  85,
	  86,
	6433,
	 773,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	  75,
	  76,
	  66,
	6031,
	6185,
	  69,
	   0,
	   0,
	   0,
	   0,
	 414,
	   0,
	   0,
	  87,
	6807,
	6034,
	  85,
	  86,
	  88,
	   0,
	   0,
	  81,
	7084,
	  78,
	  77,
	  60,
	  61,
	  75,
	7803,
	  66,
	  67,
	6037,
	  69,
	   0,
	  61,
	   0,
	   0,
	   0,
	  61,
	 116,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	  60,
	   0,
	6062,
	  76,
	 629,
	   0,
	6422,
	  62,
	  72,
	   0,
	   0,
	   0,
	   0,
	  61,
	  63,
	  62,
	  72,
	   0,
	  63,
	7523,
	  72,
	   0,
	  96,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 763,
	   0,
	   0,
	   0,
	   0,
	 681,
	  71,
	  50,
	  65,
	   0,
	   0,
	  70,
	   0,
	  38,
	6916,
	6920,
	6923,
	7526,
	  71,
	7529,
	  65,
	   0,
	  58,
	  70,
	  59,
	 360,
	  58,
	   0,
	8335,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	5972,
	   0,
	  82,
	   0,
	  64,
	  74,
	   0,
	7606,
	6928,
	  50,
	6931,
	   0,
	  64,
	6935,
	  82,
	   0,
	7486,
	7489,
	6938,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 171,
	   0,
	   0,
	 217,
	   0,
	   0,
	  63,
	6164,
	  72,
	   0,
	   0,
	   0,
	   0,
	   0,
	  63,
	  62,
	7609,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	   0,
	  73,
	   0,
	   0,
	 188,
	  22,
	  17,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  38,
	  71,
	  50,
	  65,
	   0,
	   0,
	6167,
	 571,
	7612,
	7616,
	  50,
	7619,
	   0,
	 156,
	  70,
	   0,
	   0,
	   0,
	   0,
	 385,
	 124,
	 204,
	 205,
	   0,
	   0,
	 200,
	6404,
	6025,
	  68,
	  69,
	   0,
	  97,
	 561,
	   0,
	6650,
	  67,
	6653,
	6656,
	7492,
	7756,
	7495,
	7499,
	6660,
	   0,
	  64,
	7583,
	6664,
	6667,
	6670,
	7502,
	7587,
	  75,
	  76,
	  81,
	  79,
	6673,
	  77,
	7506,
	  79,
	7509,
	7514,
	  60,
	1165,
	7517,
	  76,
	  66,
	8121,
	7520,
	7760,
	   0,
	   0,
	1163,
	   0,
	   0,
	   0,
	   0,
	 323,
	 621,
	   0,
	 212,
	 189,
	 190,
	 191,
	 192,
	6894,
	6897,
	6900,
	6903,
	6906,
	 198,
	6909,
	6912,
	   0,
	  36,
	  80,
	   0,
	7753,
	6374,
	8124,
	8128,
	  72,
	   0,
	   0,
	 129,
	1163,
	 132,
	   0,
	1163,
	   0,
	   0,
	   0,
	   0,
	  38,
	 149,
	 147,
	7763,
	 865,
	 865,
	 232,
	6155,
	  67,
	7766,
	7769,
	 150,
	   0,
	   5,
	   0,
	  66,
	8131,
	8134,
	8137,
	8141,
	  84,
	  85,
	8145,
	6419,
	   0,
	  58,
	  81,
	8148,
	6158,
	6377,
	6380,
	 214,
	6383,
	6386,
	 179,
	7590,
	7593,
	7598,
	  60,
	 113,
	7602,
	  76,
	   0,
	   0,
	   0,
	 726,
	 694,
	  38,
	 123,
	   0,
	 127,
	   0,
	  64,
	8064,
	   0,
	   0,
	   0,
	 126,
	  73,
	   0,
	   0,
	6161,
	   0,
	6746,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  61,
	   0,
	 405,
	   0,
	   0,
	 602,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  37,
	   0,
	  61,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 630,
	   0,
	   0,
	 131,
	 134,
	   0,
	   0,
	  63,
	  62,
	  72,
	6389,
	6307,
	6310,
	   0,
	 128,
	   0,
	   0,
	 485,
	   0,
	  19,
	   0,
	   0,
	  63,
	6392,
	6395,
	 206,
	8067,
	 145,
	   0,
	   0,
	   0,
	   0,
	   0,
	 909,
	   0,
	   0,
	 153,
	  38,
	  71,
	  50,
	8070,
	  67,
	8073,
	8076,
	   0,
	   0,
	8079,
	   0,
	8082,
	   0,
	   0,
	  87,
	8085,
	8088,
	8091,
	8094,
	8097,
	   0,
	6398,
	8100,
	8103,
	8106,
	8109,
	8112,
	   0,
	8115,
	8118,
	   0,
	 172,
	  80,
	   0,
	  82,
	6401,
	7457,
	7460,
	6543,
	 187,
	 230,
	   0,
	  73,
	 133,
	   0,
	   0,
	   0,
	   0,
	   0,
	5905,
	 389,
	5908,
	 125,
	 909,
	   0,
	 789,
	 126,
	  73,
	 909,
	 909,
	 909,
	6700,
	 909,
	 909,
	 909,
	6540,
	6537,
	 909,
	   0,
	   0,
	 909,
	 909,
	 909,
	   0,
	1092,
	   0,
	 909,
	  61,
	 909,
	 909,
	 909,
	   0,
	   0,
	   0,
	 280,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 493,
	 498,
	 494,
	 495,
	 496,
	 497,
	   0,
	   0,
	 764,
	6300,
	6099,
	6304,
	   0,
	   0,
	   0,
	   0,
	 132,
	   0,
	   0,
	7980,
	  67,
	  68,
	  69,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 253,
	   0,
	   0,
	   0,
	  66,
	6803,
	  68,
	5957,
	7463,
	7467,
	7470,
	7474,
	7477,
	   0,
	  75,
	7480,
	   0,
	   0,
	7483,
	   0,
	6102,
	   0,
	   0,
	  81,
	  79,
	  78,
	  77,
	8322,
	   0,
	  75,
	  76,
	   0,
	   0,
	  80,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	6089,
	6549,
	  82,
	   0,
	  64,
	  74,
	   0,
	   0,
	   0,
	 271,
	  73,
	   0,
	   0,
	   0,
	   0,
	 133,
	   0,
	   0,
	 369,
	   0,
	   0,
	   0,
	 578,
	   0,
	   0,
	 579,
	   0,
	   0,
	   0,
	   0,
	7229,
	   0,
	   0,
	   0,
	   0,
	   0,
	 774,
	   0,
	 220,
	   0,
	   0,
	7080,
	   0,
	   0,
	 312,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  97,
	 708,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 367,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	  66,
	  67,
	5954,
	  69,
	  66,
	6643,
	  68,
	6416,
	   0,
	7448,
	 779,
	 317,
	   0,
	 622,
	  64,
	   0,
	 782,
	 758,
	   0,
	  65,
	 757,
	   0,
	 817,
	 808,
	  73,
	   0,
	  64,
	 365,
	   0,
	 125,
	 134,
	   0,
	 737,
	 915,
	   0,
	1136,
	 915,
	   0,
	 887,
	 915,
	   0,
	 109,
	 170,
	   0,
	 736,
	 724,
	   0,
	  38,
	1176,
	   0,
	  63,
	1176,
	   0,
	 915,
	1176,
	   0,
	  78,
	 712,
	   0,
	 800,
	  68,
	   0,
	  69,
	  50,
	   0,
	 606,
	  50,
	   0,
	  59,
	 702,
	   0,
	  67,
	 692,
	   0,
	 714,
	  68,
	   0,
	 716,
	 682,
	   0,
	 915,
	 678,
	   0,
	  68,
	 451,
	   0,
	  50,
	  76,
	   0,
	  67,
	  38,
	   0,
	 823,
	  68,
	  71,
	   0,
	 668,
	  66,
	   0,
	  38,
	  61,
	   0,
	 745,
	 659,
	   0,
	 755,
	 317,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	 317,
	  72,
	  66,
	   0,
	 125,
	  69,
	   0,
	  71,
	  80,
	   0,
	 583,
	 638,
	   0,
	  75,
	 633,
	   0,
	  67,
	 631,
	   0,
	  58,
	  64,
	   0,
	 707,
	  67,
	   0,
	 360,
	  84,
	   0,
	  68,
	  80,
	   0,
	 607,
	  62,
	   0,
	   5,
	 625,
	   0,
	   6,
	  68,
	   0,
	  60,
	 637,
	 619,
	   0,
	   6,
	 622,
	   0,
	  67,
	  38,
	   0,
	 280,
	  65,
	   0,
	  75,
	 133,
	   0,
	 662,
	  83,
	   0,
	 407,
	  88,
	   0,
	   5,
	 358,
	   0,
	   5,
	  58,
	   0,
	 915,
	 113,
	   0,
	 824,
	 220,
	   0,
	 815,
	 106,
	   0,
	 753,
	 590,
	   0,
	  64,
	 698,
	 589,
	   0,
	 728,
	  87,
	   0,
	 697,
	  76,
	   0,
	 134,
	  62,
	   0,
	 780,
	  59,
	   0,
	 681,
	 407,
	   0,
	 792,
	  66,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	  77,
	 574,
	   0,
	  50,
	 573,
	   0,
	 729,
	  77,
	   0,
	  71,
	  63,
	   0,
	  50,
	  62,
	   0,
	  65,
	  72,
	   0,
	 315,
	  73,
	  59,
	   0,
	 636,
	  73,
	   0,
	 783,
	 759,
	  66,
	   0,
	  74,
	  62,
	   0,
	 280,
	  65,
	   0,
	 806,
	  70,
	   0,
	 280,
	  66,
	   0,
	 717,
	  78,
	   0,
	 752,
	 560,
	   0,
	 601,
	  62,
	   0,
	 570,
	  70,
	   0,
	  58,
	  64,
	   0,
	 778,
	  74,
	   0,
	 645,
	  66,
	   0,
	 365,
	  68,
	   0,
	 134,
	  69,
	   0,
	  68,
	  80,
	   0,
	 661,
	  59,
	   0,
	  38,
	 547,
	   0,
	  73,
	  82,
	   0,
	  81,
	  87,
	   0,
	  79,
	  83,
	   0,
	  78,
	  84,
	   0,
	  77,
	  85,
	   0,
	  80,
	  78,
	   0,
	  38,
	  61,
	   0,
	 514,
	 617,
	  63,
	   0,
	 744,
	  82,
	  72,
	   0,
	  58,
	  71,
	   0,
	  59,
	  65,
	   0,
	 732,
	  66,
	   0,
	 615,
	  69,
	   0,
	  38,
	  79,
	   0,
	  67,
	  61,
	   0,
	 721,
	  70,
	   0,
	 126,
	  69,
	   0,
	  70,
	  50,
	   0,
	 772,
	1176,
	   0,
	 220,
	1176,
	   0,
	  88,
	1176,
	   0,
	  75,
	 971,
	   0,
	  60,
	 971,
	   0,
	  77,
	 971,
	   0,
	  78,
	 971,
	   0,
	 660,
	  70,
	 362,
	   0,
	 915,
	   5,
	   0,
	  68,
	 526,
	   0,
	  38,
	  61,
	   0,
	  50,
	  62,
	   0,
	  82,
	  65,
	  72,
	   0,
	 572,
	  65,
	   0,
	  74,
	  70,
	   0,
	  73,
	  59,
	   0,
	 365,
	  63,
	 473,
	   0,
	  72,
	 475,
	   0,
	   5,
	 474,
	   0,
	 640,
	 472,
	   0,
	 557,
	 522,
	   0,
	  83,
	  73,
	   0,
	  64,
	  68,
	   0,
	 623,
	  69,
	   0,
	 670,
	  81,
	   0,
	  97,
	  61,
	   0,
	  64,
	  71,
	   0,
	  74,
	  50,
	   0,
	  80,
	 866,
	   0,
	  81,
	 126,
	   0,
	  79,
	 711,
	  73,
	   0,
	  78,
	 124,
	   0,
	  72,
	  66,
	   0,
	   5,
	 245,
	   0,
	 663,
	  81,
	   0,
	  71,
	  80,
	   0,
	  67,
	  61,
	   0,
	  70,
	  62,
	   0,
	  64,
	  71,
	   0,
	  74,
	  50,
	   0,
	 216,
	 202,
	   0,
	  77,
	 177,
	   0,
	  60,
	 213,
	   0,
	  75,
	 215,
	   0,
	  76,
	 178,
	   0,
	 132,
	 211,
	   0,
	  62,
	 208,
	   0,
	  72,
	 209,
	   0,
	  70,
	  16,
	   0,
	 220,
	 183,
	   0,
	  66,
	  94,
	   0,
	  73,
	 516,
	   0,
	 810,
	 280,
	   0,
	  67,
	  38,
	   0,
	  69,
	 217,
	   0,
	  88,
	 506,
	   0,
	  80,
	  63,
	 133,
	   0,
	 739,
	 693,
	 134,
	   0,
	  84,
	 132,
	   0,
	  88,
	 505,
	   0,
	 669,
	 113,
	   0,
	  72,
	 475,
	   0,
	  79,
	 489,
	   0,
	  71,
	 488,
	   0,
	  63,
	 487,
	   0,
	  62,
	 476,
	   0,
	  72,
	 470,
	   0,
	1176,
	 471,
	   0,
	  77,
	 238,
	   0,
	   6,
	  68,
	   0,
	  72,
	  81,
	   0,
	 621,
	  79,
	   0,
	 129,
	  77,
	   0,
	 723,
	  66,
	  60,
	   0,
	  68,
	  75,
	   0,
	  69,
	  50,
	  76,
	   0,
	 355,
	  71,
	   0,
	  82,
	  65,
	   0,
	  74,
	  70,
	   0,
	  73,
	  59,
	   0,
	 667,
	  66,
	   0,
	 510,
	 443,
	   0,
	 705,
	 460,
	   0,
	  66,
	 430,
	   0,
	  68,
	 451,
	   0,
	  77,
	 434,
	   0,
	  76,
	 432,
	   0,
	 492,
	 436,
	   0,
	  67,
	  38,
	   0,
	  69,
	  50,
	   0,
	  38,
	 462,
	   0,
	  58,
	 425,
	   0,
	 507,
	 911,
	   0,
	 719,
	 909,
	   0,
	 596,
	 909,
	   0,
	 186,
	 909,
	   0,
	  80,
	 133,
	   0,
	 709,
	 417,
	   0,
	  88,
	 411,
	   0,
	 133,
	 884,
	   0,
	  61,
	 884,
	   0,
	 530,
	 404,
	   0,
	 529,
	  74,
	   0,
	 563,
	  66,
	   0,
	  64,
	  68,
	   0,
	  74,
	  69,
	   0,
	  68,
	  78,
	   0,
	  69,
	  77,
	   0,
	 113,
	  61,
	   0,
	 234,
	  38,
	   0,
	  83,
	 403,
	   0,
	  86,
	 402,
	   0,
	  58,
	  64,
	   0,
	  78,
	 401,
	   0,
	 525,
	  67,
	   0,
	 790,
	  60,
	  81,
	   0,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	   6,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	 113,
	  61,
	   0,
	  70,
	 539,
	  62,
	   0,
	 356,
	  71,
	   0,
	  74,
	  70,
	  50,
	   0,
	 642,
	  67,
	   0,
	 647,
	  81,
	   0,
	 646,
	  79,
	   0,
	  67,
	  61,
	   0,
	 524,
	 911,
	  38,
	   0,
	  82,
	  66,
	   0,
	  64,
	  68,
	   0,
	  87,
	  74,
	  69,
	   0,
	  88,
	  73,
	 130,
	   0,
	  79,
	  83,
	   0,
	  78,
	  84,
	   0,
	  77,
	  85,
	   0,
	  80,
	  78,
	   0,
	 561,
	 398,
	   0,
	   6,
	 396,
	   0,
	 771,
	 394,
	   0,
	  64,
	  63,
	 473,
	 393,
	   0,
	  70,
	 278,
	   0,
	  81,
	 387,
	   0,
	 580,
	  79,
	 388,
	   0,
	 909,
	 390,
	   0,
	 600,
	 104,
	   0,
	 421,
	 384,
	   0,
	  83,
	 110,
	1176,
	  66,
	   0,
	  84,
	  67,
	   0,
	  85,
	   5,
	1176,
	  68,
	   0,
	  86,
	  69,
	   0,
	 133,
	 382,
	   0,
	  87,
	 380,
	   0,
	  67,
	 113,
	   0,
	  59,
	  66,
	   0,
	 427,
	 376,
	   0,
	  67,
	 113,
	   0,
	  60,
	 366,
	   0,
	 347,
	 133,
	   0,
	 317,
	 364,
	   0,
	 715,
	 132,
	 361,
	   0,
	  71,
	  75,
	 360,
	   0,
	  73,
	 110,
	 357,
	   0,
	  70,
	  69,
	   0,
	 580,
	  79,
	   0,
	  71,
	  75,
	   0,
	 235,
	  63,
	   0,
	 587,
	  62,
	   0,
	 448,
	  71,
	   0,
	 449,
	  50,
	   0,
	   5,
	  68,
	   0,
	 733,
	 722,
	  50,
	   0,
	 542,
	 349,
	   0,
	 685,
	 348,
	   0,
	   5,
	  58,
	 391,
	 339,
	   0,
	  67,
	  38,
	 332,
	   0,
	  83,
	 331,
	   0,
	  63,
	  78,
	   0,
	  62,
	  77,
	   0,
	  72,
	  60,
	   0,
	  79,
	  73,
	   0,
	 246,
	  66,
	   0,
	  60,
	 325,
	   0,
	  38,
	  79,
	   0,
	  71,
	  78,
	   0,
	  50,
	  77,
	   0,
	 791,
	  65,
	  60,
	   0,
	   6,
	  75,
	   0,
	  70,
	  76,
	   0,
	 106,
	  72,
	   0,
	 528,
	  65,
	   0,
	 911,
	  82,
	   0,
	   5,
	 911,
	  64,
	   0,
	 418,
	  76,
	   0,
	 113,
	  61,
	   0,
	 696,
	   6,
	  71,
	  63,
	   0,
	 695,
	 413,
	  50,
	 335,
	  62,
	   0,
	  65,
	  72,
	   0,
	 911,
	 400,
	  71,
	   0,
	  82,
	  65,
	   0,
	  74,
	  70,
	   0,
	 911,
	  73,
	  59,
	   0,
	 193,
	  81,
	   0,
	 194,
	  79,
	   0,
	 195,
	  78,
	   0,
	 196,
	  77,
	   0,
	 197,
	  60,
	   0,
	 199,
	  75,
	   0,
	 207,
	 416,
	  76,
	   0,
	  58,
	  71,
	  63,
	   0,
	  50,
	  62,
	   0,
	 799,
	  59,
	  65,
	  72,
	   0,
	 123,
	  71,
	   0,
	  73,
	 127,
	  65,
	   0,
	 125,
	  70,
	   0,
	  73,
	  59,
	   0,
	  87,
	  74,
	   0,
	  86,
	 322,
	   0,
	  61,
	  88,
	  73,
	   0,
	 317,
	  60,
	  81,
	   0,
	  64,
	  75,
	  78,
	   0,
	 125,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	 126,
	  76,
	   0,
	  38,
	  61,
	   0,
	  70,
	  50,
	   0,
	  71,
	 133,
	   0,
	  75,
	 132,
	   0,
	  75,
	 865,
	   0,
	  38,
	 865,
	   0,
	 821,
	 154,
	   0,
	  78,
	 149,
	   0,
	  77,
	 147,
	   0,
	  60,
	 151,
	   0,
	  50,
	  76,
	 320,
	   0,
	  61,
	 307,
	  73,
	   0,
	  72,
	  66,
	   0,
	 317,
	  81,
	   0,
	  64,
	  78,
	   0,
	  74,
	  77,
	   0,
	 804,
	  76,
	   0,
	 490,
	  71,
	  80,
	   0,
	 509,
	  72,
	   0,
	 408,
	  70,
	   0,
	 130,
	 317,
	   0,
	  87,
	  74,
	   0,
	  86,
	 316,
	   0,
	  88,
	  73,
	   0,
	 584,
	  66,
	   0,
	  64,
	  80,
	   0,
	  58,
	  80,
	  63,
	   0,
	  59,
	  72,
	   0,
	 128,
	  38,
	   0,
	   5,
	  71,
	   0,
	  87,
	 316,
	  50,
	   0,
	  83,
	  73,
	  65,
	   0,
	  86,
	  70,
	   0,
	  79,
	  59,
	   0,
	  61,
	 315,
	   0,
	 648,
	 613,
	 313,
	   0,
	  79,
	 311,
	   0,
	  87,
	  70,
	   0,
	 915,
	 212,
	   0,
	 915,
	 191,
	   0,
	 333,
	 192,
	   0,
	 553,
	 194,
	   0,
	 556,
	 468,
	 195,
	   0,
	 915,
	 199,
	   0,
	 231,
	 203,
	   0,
	1176,
	 213,
	   0,
	1176,
	 215,
	   0,
	 413,
	 178,
	   0,
	1176,
	 691,
	 179,
	   0,
	1176,
	 599,
	 180,
	   0,
	  50,
	  19,
	   0,
	  65,
	 628,
	 309,
	   0,
	  70,
	 208,
	   0,
	  73,
	  18,
	   0,
	 535,
	 188,
	   0,
	 503,
	  17,
	   0,
	 278,
	 308,
	   0,
	 676,
	 113,
	   0,
	  84,
	 132,
	 306,
	   0,
	 132,
	 305,
	   0,
	 546,
	  21,
	   0,
	  65,
	 304,
	   0,
	  87,
	 301,
	   0,
	 132,
	 113,
	   0,
	  60,
	 299,
	   0,
	 915,
	 295,
	   0,
	  80,
	 292,
	   0,
	  88,
	 290,
	   0,
	   6,
	 288,
	   0,
	  84,
	 431,
	 287,
	   0,
	  67,
	 286,
	   0,
	 911,
	 285,
	   0,
	 775,
	  66,
	   0,
	  58,
	  68,
	   0,
	  67,
	  38,
	   0,
	 247,
	  69,
	  50,
	   0,
	  59,
	 281,
	   0,
	  88,
	 280,
	   0,
	  74,
	 277,
	   0,
	 107,
	 220,
	   0,
	  78,
	 224,
	   0,
	  69,
	 267,
	   0,
	  97,
	 269,
	   0,
	  64,
	 264,
	   0,
	  58,
	  89,
	   0,
	  59,
	  82,
	   0,
	 327,
	  74,
	   0,
	 328,
	  73,
	   0,
	  63,
	  57,
	   0,
	  73,
	  65,
	  66,
	   0,
	  58,
	  68,
	   0,
	  70,
	  69,
	   0,
	  68,
	  63,
	   0,
	  69,
	  62,
	   0,
	 500,
	  90,
	   0,
	 932,
	  65,
	   0,
	 932,
	  70,
	   0,
	  64,
	 262,
	   0,
	 464,
	  74,
	   0,
	 493,
	  73,
	   0,
	  66,
	  81,
	  86,
	   0,
	  67,
	  79,
	  88,
	   0,
	 687,
	  60,
	  81,
	   0,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	 447,
	  38,
	  61,
	   0,
	  70,
	  50,
	   0,
	  58,
	  64,
	   0,
	 931,
	  66,
	   0,
	 131,
	  68,
	   0,
	  81,
	 931,
	 134,
	  69,
	   0,
	  68,
	  80,
	   0,
	  38,
	  61,
	   0,
	  67,
	  38,
	   0,
	  68,
	  71,
	   0,
	  73,
	  82,
	   0,
	  81,
	 258,
	   0,
	  65,
	  81,
	   0,
	  80,
	 148,
	  78,
	   0,
	 152,
	  77,
	   0,
	 667,
	 150,
	  60,
	   0,
	 767,
	  64,
	  63,
	   0,
	  74,
	  62,
	   0,
	  67,
	  38,
	   0,
	  58,
	  68,
	  71,
	   0,
	  69,
	  50,
	   0,
	  59,
	  65,
	   0,
	  58,
	  64,
	   0,
	  73,
	  66,
	   0,
	 766,
	  67,
	   0,
	  58,
	  68,
	   0,
	  72,
	  81,
	   0,
	   6,
	  78,
	   0,
	 667,
	  60,
	   0,
	 123,
	  75,
	   0,
	  64,
	  68,
	  80,
	   0,
	  64,
	  63,
	   0,
	 126,
	 540,
	  62,
	   0,
	  73,
	  72,
	   0,
	 583,
	  59,
	   0,
	 355,
	  71,
	  63,
	 255,
	   0,
	  58,
	  64,
	   0,
	  86,
	 254,
	   0,
	 727,
	 684,
	  60,
	  81,
	   0,
	  75,
	 371,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	  97,
	  61,
	   0,
	 486,
	  38,
	   0,
	  70,
	  50,
	   0,
	 184,
	  64,
	   0,
	 185,
	  74,
	   0,
	  65,
	 683,
	  81,
	   0,
	  38,
	  79,
	   0,
	  71,
	 368,
	  78,
	   0,
	  50,
	  77,
	   0,
	  65,
	  60,
	   0,
	  70,
	  76,
	   0,
	  58,
	  80,
	   0,
	  58,
	  64,
	   0,
	 126,
	  74,
	   0,
	  83,
	  66,
	   0,
	  85,
	 399,
	  68,
	   0,
	  86,
	  69,
	   0,
	  60,
	  86,
	 252,
	   0,
	  60,
	  81,
	   0,
	   6,
	 725,
	  75,
	  78,
	   0,
	  76,
	  77,
	   0,
	  80,
	  75,
	   0,
	  68,
	  80,
	   0,
	 129,
	  62,
	   0,
	 718,
	  38,
	   0,
	  70,
	  50,
	   0,
	1176,
	 467,
	 251,
	   0,
	 479,
	  64,
	   0,
	 480,
	  74,
	   0,
	  64,
	  68,
	   0,
	 383,
	  69,
	   0,
	 750,
	  79,
	   0,
	 552,
	 113,
	 198,
	  61,
	   0,
	   5,
	 915,
	  63,
	   0,
	1119,
	 477,
	 330,
	  62,
	   0,
	1234,
	  38,
	   0,
	1234,
	  50,
	   0,
	 679,
	  65,
	   0,
	1176,
	  58,
	   0,
	  61,
	  59,
	   0,
	  67,
	 250,
	   0,
	  81,
	  87,
	  74,
	   0,
	  88,
	  73,
	   0,
	 180,
	 249,
	   0,
	 740,
	  80,
	 181,
	  78,
	   0,
	 182,
	 333,
	  77,
	   0,
	   6,
	 595,
	  75,
	   0,
	  38,
	  61,
	   0,
	  82,
	  72,
	   0,
	 210,
	 128,
	  38,
	   0,
	  58,
	  71,
	   0,
	 611,
	  59,
	  21,
	 386,
	  65,
	   0,
	  61,
	  79,
	  73,
	   0,
	  72,
	  66,
	   0,
	  74,
	  62,
	 248,
	   0,
	  72,
	  60,
	   0,
	 413,
	  76,
	   0,
	  67,
	  61,
	   0,
	  80,
	  63,
	   0,
	 352,
	  65,
	   0,
	 354,
	  70,
	   0,
	 437,
	 123,
	   0,
	 439,
	 246,
	   0,
	 441,
	  64,
	   0,
	 442,
	 247,
	   0,
	 446,
	 126,
	   0,
	 456,
	  73,
	   0,
	  82,
	  72,
	  66,
	   0,
	  74,
	  69,
	   0,
	 807,
	1123,
	  73,
	 130,
	   0,
	  63,
	  84,
	   0,
	  62,
	  85,
	   0,
	  72,
	  86,
	   0,
	1123,
	  88,
	   0,
	 578,
	  79,
	   0,
	 606,
	  77,
	   0,
	 414,
	 579,
	  60,
	   0,
	  71,
	  75,
	   0,
	 463,
	  50,
	  76,
	   0,
	   5,
	  71,
	  80,
	   0,
	 216,
	  61,
	   0,
	 184,
	 237,
	  63,
	   0,
	 185,
	 236,
	  62,
	   0,
	 186,
	  72,
	   0,
	 238,
	  71,
	   0,
	  58,
	 240,
	   0,
	  72,
	 242,
	   0,
	  66,
	 243,
	   0,
	 256,
	 236,
	   0,
	  76,
	 298,
	 238,
	   0,
	 284,
	  70,
	   0,
	 201,
	1163,
	   0,
	  84,
	  67,
	1163,
	   0,
	  69,
	 154,
	   0,
	 680,
	 151,
	   0,
	  68,
	 148,
	   0,
	  69,
	 152,
	   0,
	 297,
	 133,
	   0,
	  71,
	  63,
	 227,
	   0,
	  82,
	  66,
	   0,
	  64,
	  68,
	   0,
	 318,
	  72,
	   0,
	  59,
	 106,
	   0,
	  64,
	 742,
	  68,
	 224,
	   0,
	  88,
	 370,
	 221,
	   0,
	  78,
	 220,
	   0,
	  76,
	 219,
	   0,
	 362,
	 217,
	   0,
	  69,
	  50,
	 212,
	   0,
	  65,
	 189,
	   0,
	  63,
	 191,
	   0,
	  70,
	  62,
	 303,
	 192,
	   0,
	  72,
	 193,
	   0,
	 180,
	 194,
	   0,
	  58,
	  63,
	 181,
	 195,
	   0,
	  62,
	 182,
	 196,
	   0,
	  59,
	 466,
	  72,
	 197,
	   0,
	  64,
	 199,
	   0,
	  74,
	 207,
	   0,
	  79,
	  73,
	 201,
	   0,
	  78,
	 202,
	   0,
	  77,
	 203,
	   0,
	  77,
	 177,
	   0,
	 280,
	  66,
	  60,
	 213,
	   0,
	  67,
	 214,
	   0,
	  68,
	 519,
	  75,
	 215,
	   0,
	  69,
	  76,
	 178,
	   0,
	  64,
	 365,
	  80,
	 181,
	   0,
	  74,
	 134,
	 182,
	   0,
	  78,
	 211,
	   0,
	  70,
	  19,
	   0,
	  59,
	  66,
	 209,
	   0,
	  67,
	 206,
	   0,
	 550,
	  18,
	   0,
	 534,
	 186,
	   0,
	 735,
	 188,
	   0,
	  61,
	  22,
	   0,
	  64,
	  63,
	  17,
	   0,
	  59,
	  21,
	   0,
	  50,
	  62,
	 200,
	   0,
	  65,
	  72,
	  94,
	   0,
	 577,
	   5,
	   0,
	 409,
	  58,
	   6,
	   0,
	  74,
	  69,
	 175,
	   0,
	 392,
	 113,
	   0,
	  77,
	 112,
	   0,
	 233,
	 110,
	   0,
	  74,
	 109,
	   0,
	 582,
	 173,
	   0,
	  38,
	  43,
	   0,
	 345,
	 273,
	  21,
	   0,
	 555,
	 168,
	   0,
	  79,
	 166,
	   0,
	 518,
	 165,
	   0,
	  87,
	 164,
	   0,
	  78,
	 163,
	   0,
	  85,
	 160,
	   0,
	  66,
	 157,
	   0,
	  38,
	1165,
	   0,
	   6,
	  78,
	1163,
	   0,
	  38,
	1163,
	   0,
	 185,
	1163,
	   0,
	 515,
	1163,
	   0,
	  66,
	1163,
	   0,
	  65,
	1163,
	   0,
	1176,
	 146,
	   0,
	 230,
	 145,
	   0,
	 826,
	 413,
	 147,
	   0,
	 571,
	  81,
	 151,
	   0,
	  75,
	 148,
	   0,
	  76,
	 152,
	   0,
	 819,
	 150,
	   0,
	  64,
	  78,
	   0,
	 690,
	  77,
	   0,
	 106,
	 512,
	  60,
	   0,
	 381,
	  71,
	   0,
	 533,
	  50,
	   0,
	 220,
	  38,
	 138,
	   0,
	 605,
	 139,
	   0,
	  77,
	 137,
	   0,
	  58,
	 235,
	 131,
	   0,
	  81,
	 134,
	   0,
	  75,
	 132,
	   0,
	 266,
	 125,
	   0,
	 146,
	 124,
	   0,
	  65,
	  66,
	   0,
	 231,
	  68,
	   0,
	  70,
	  69,
	   0,
	  58,
	 122,
	   0,
	  59,
	 130,
	   0,
	  38,
	  83,
	   0,
	  71,
	  84,
	   0,
	  50,
	  85,
	   0,
	  65,
	  86,
	   0,
	 909,
	  88,
	   0,
	  18,
	  81,
	   0,
	 909,
	  79,
	   0,
	  58,
	  78,
	   0,
	 909,
	  77,
	   0,
	  59,
	  60,
	   0,
	 909,
	  75,
	   0,
	 134,
	  76,
	   0,
	  67,
	  61,
	   0,
	 203,
	 365,
	  63,
	   0,
	 134,
	  62,
	   0,
	  67,
	  38,
	   0,
	  68,
	  71,
	   0,
	  87,
	  69,
	  50,
	   0,
	 612,
	  83,
	  65,
	   0,
	  86,
	  70,
	   0,
	  79,
	  59,
	   0,
	  70,
	 121,
	   0,
	  67,
	 113,
	   0,
	 703,
	  81,
	  74,
	   0,
	 452,
	  67,
	   0,
	 562,
	  75,
	   0,
	  58,
	  63,
	   0,
	 651,
	  59,
	  72,
	   0,
	  73,
	 176,
	  65,
	   0,
	  58,
	  64,
	   0,
	 665,
	  66,
	   0,
	  71,
	  63,
	   0,
	 650,
	  65,
	  72,
	   0,
	 231,
	  64,
	  71,
	   0,
	 350,
	  50,
	   0,
	 604,
	 239,
	  65,
	   0,
	  74,
	  70,
	   0,
	 280,
	  65,
	 118,
	   0,
	1176,
	  70,
	 114,
	   0,
	 915,
	 420,
	 113,
	   0,
	   5,
	 111,
	   0,
	  87,
	 109,
	   0,
	  60,
	  86,
	 109,
	   0,
	  64,
	 107,
	   0,
	 161,
	 103,
	   0,
	 911,
	 158,
	  51,
	   0,
	 911,
	  74,
	  50,
	   0,
	 155,
	  97,
	   0,
	  82,
	 179,
	  94,
	   0,
	  58,
	  64,
	   0,
	  38,
	  91,
	   0,
	 514,
	  57,
	   0,
	 652,
	  66,
	   0,
	 128,
	  67,
	   0,
	 231,
	  58,
	  68,
	   0,
	 124,
	  84,
	   0,
	 113,
	  88,
	   0,
	  63,
	  78,
	   0,
	 539,
	  62,
	  77,
	   0,
	  72,
	  60,
	   0,
	 355,
	  63,
	  75,
	   0,
	 666,
	 134,
	  62,
	  76,
	   0,
	 545,
	 356,
	  68,
	  80,
	   0,
	  50,
	  76,
	  92,
	   0,
	 378,
	  62,
	   0,
	 187,
	  90,
	   0,
	 129,
	  50,
	   0,
	  38,
	  59,
	   0,
	  79,
	  56,
	   0,
	 220,
	  54,
	   0,
	 360,
	  55,
	   0,
	  60,
	  53,
	   0,
	  79,
	  52,
	   0,
	  87,
	  50,
	   0,
	  38,
	 407,
	  39,
	   0,
	 751,
	  59,
	  35,
	   0,
	 413,
	   5,
	   0,
	  76,
	1176,
	   6,
	   0,
	 609,
	  23,
	   0,
	 760,
	  25,
	   0,
	 220,
	  26,
	   0,
	 134,
	  19,
	   0,
	 513,
	  18,
	   0,
	   6,
	  28,
	   0,
	  69,
	 300,
	  50,
	1240,
	   0,
	  58,
	   6,
	 259,
	1240,
	   0,
	  38,
	  73,
	1240,
	   0,
	  61,
	1240,
	   0,
	  82,
	1051,
	   0,
	 734,
	   7,
	   0,
	  77,
	   6,
	   0,
	  82,
	 827,
	   0,
	  79,
	   3,
	   0,
	  63,
	   4,
	   0
	  };

long act_tab2[] = {
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      162371,
      162372,
      162373,
      162374,
	   0,
	   0,
      227323,
	   0,
	   0,
	   0,
      162381,
	   0,
	   0,
      162384,
	   0,
	   0,
	   0,
      162388,
	   0,
	   0,
	   0,
      102085,
      102086,
      102087,
	   0,
       51060,
       51061,
       51062,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      185612,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       51091,
	   0,
       51093,
	   0,
      102124,
       51096,
      102126,
	   0,
       51099,
	   0,
       51101,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      116055,
	   0,
	   0,
	   0,
      116059,
	   0,
      116061,
	   0,
       83590,
	   0,
       83592,
	   0,
	   0,
      102151,
	   0,
       51124,
	   0,
	   0,
       51127,
	   0,
       88241,
	   0,
	   0,
       51132,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      116089,
	   0,
	   0,
	   0,
	   0,
	   0,
      116095,
      116096,
	   0,
	   0,
	   0,
	   0,
      116101,
	   0,
      116103,
	   0,
       83632,
      116106,
      116107,
      116108,
	   0,
      116110,
	   0,
      116112,
	   0,
      116114,
      116115,
      116116,
	   0,
	   0,
	   0,
      204261,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       97571,
	   0,
	   0,
	   0,
	   0,
	   0,
       97577,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       55833,
	   0,
	   0,
	   0,
      213563,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      102234,
	   0,
      102236,
      102237,
       51209,
       51210,
       51211,
       51212,
	   0,
	   0,
	   0,
      102245,
      102246,
      102247,
      102248,
	   0,
      102250,
	   0,
	   0,
	   0,
	   0,
      102255,
      102256,
	   0,
       51229,
	   0,
	   0,
       51232,
	   0,
	   0,
       51235,
       83709,
       83710,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       83720,
	   0,
	   0,
	   0,
	   0,
      162588,
	   0,
	   0,
       83728,
       83729,
       83730,
       83731,
       83732,
	   0,
       83734,
	   0,
      195072,
	   0,
       83738,
      195075,
	   0,
	   0,
	   0,
	   0,
       14159,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       55931,
       88405,
      181186,
	   0,
       88408,
	   0,
	   0,
	   0,
	   0,
	   0,
      176555,
	   0,
       88416,
       88417,
      181198,
      181199,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       74510,
	   0,
	   0,
	   0,
      241518,
	   0,
      209047,
	   0,
       37406,
      209050,
      260080,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       55971,
      158030,
	   0,
       88447,
	   0,
	   0,
	   0,
	   0,
       14228,
	   0,
	   0,
	   0,
	   0,
      153403,
	   0,
      171961,
      171962,
	   0,
      222993,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       88471,
      190530,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      223011,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      102410,
	   0,
      102412,
	   0,
	   0,
      102415,
      172001,
	   0,
      139530,
	   0,
	   0,
	   0,
	   0,
       56033,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      102440,
	   0,
	   0,
      102443,
	   0,
	   0,
	   0,
	   0,
      255535,
      102449,
	   0,
      102451,
	   0,
	   0,
	   0,
	   0,
	   0,
       88540,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      134940,
      134941,
      134942,
	   0,
       88554,
      153501,
	   0,
      102474,
	   0,
	   0,
      102477,
	   0,
	   0,
	   0,
      102481,
      102482,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	 433,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      134974,
	   0,
      134976,
      134977,
      218480,
	   0,
	   0,
      134981,
      134982,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      172109,
      172110,
      172111,
      172112,
	   0,
	   0,
	   0,
	   0,
	   0,
      102533,
	   0,
      172120,
	   0,
      172122,
	   0,
      172124,
	   0,
	   0,
	   0,
      172128,
	   0,
	   0,
      172131,
      172132,
	   0,
      172134,
      172135,
	   0,
	   0,
      172138,
	   0,
      153584,
      153585,
	   0,
      153587,
      102559,
	   0,
      102561,
      102562,
       28339,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      153603,
      153604,
      153605,
	   0,
	   0,
      102579,
	   0,
	   0,
      102582,
	   0,
	   0,
      102585,
      135059,
      135060,
	   0,
      135062,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      135078,
      135079,
      135080,
      135081,
      135082,
	   0,
      135084,
      135085,
	   0,
	   0,
      135088,
      111894,
      195397,
       93340,
	   0,
      195400,
       88704,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      237167,
      190778,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      232536,
      125840,
       56256,
	   0,
      172233,
	   0,
	   0,
      172236,
      172237,
	   0,
       93376,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      190811,
      190812,
	   0,
       88756,
	   0,
	   0,
	   0,
	   0,
      125873,
	   0,
	   0,
       37735,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      107327,
       79494,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      232590,
	   0,
	   0,
      190842,
      190843,
      139815,
	   0,
	   0,
      139818,
       51678,
      190849,
	   0,
      190851,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      237253,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      190874,
       84178,
      190876,
      190877,
      107376,
	   0,
	   0,
	   0,
	   0,
	   0,
      153772,
	   0,
	   0,
      255833,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      237285,
      237286,
      237287,
	   0,
	   0,
      237290,
      260486,
	   0,
	   0,
	   0,
	   0,
	   0,
       84210,
       84211,
	   0,
       51740,
       51741,
       51742,
       51743,
	   0,
	   0,
       51746,
	   0,
	   0,
       51749,
      116696,
	   0,
      158449,
	   0,
	   0,
	   0,
      237316,
      237317,
      237318,
	   0,
	   0,
      237321,
	   0,
      190933,
      237324,
	   0,
      237326,
       84240,
       84241,
       84242,
	   0,
	   0,
	   0,
       84246,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       51782,
	   0,
	   0,
      260540,
	   0,
      200235,
      200236,
	   0,
	   0,
	   0,
	   0,
      139934,
	   0,
      139936,
	   0,
      237357,
	   0,
	   0,
	   0,
       84274,
	   0,
       84276,
       84277,
	   0,
	   0,
	   0,
      190978,
	   0,
      190980,
	   0,
      190982,
	   0,
	   0,
      190985,
	   0,
      200265,
	   0,
	   0,
      200268,
	   0,
      130685,
	   0,
      130687,
	   0,
      200274,
      130690,
      200276,
	   0,
	   0,
	   0,
	   0,
	   0,
       28639,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      195653,
	   0,
	   0,
	   0,
      237408,
      200297,
	   0,
      200299,
      130715,
	   0,
	   0,
      130718,
	   0,
	   0,
      130721,
	   0,
	   0,
	   0,
       51862,
      130726,
	   0,
	   0,
	   0,
	   0,
	   0,
       42591,
	   0,
      223514,
	   0,
	   0,
      237434,
      237435,
	   0,
	   0,
	   0,
       51879,
	   0,
       51881,
	   0,
       75078,
	   0,
       51885,
	   0,
	   0,
	   0,
	   0,
       61168,
       56530,
	   0,
	   0,
	   0,
	   0,
      237456,
	   0,
	   0,
      237459,
	   0,
	   0,
	   0,
      237463,
	   0,
       84378,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       93665,
	   0,
       75111,
	   0,
       42640,
	   0,
	   0,
	   0,
	   0,
       61201,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      177186,
	   0,
      195744,
	   0,
	   0,
      200386,
      200387,
	   0,
	   0,
      195751,
      195752,
	   0,
	   0,
	   0,
	   0,
	   0,
      200397,
      200398,
	   0,
      200400,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      200407,
	   0,
	   0,
      200410,
	   0,
	   0,
      200413,
	   0,
	   0,
	   0,
      140110,
      140111,
	   0,
      130835,
      130836,
      130837,
	   0,
	   0,
	   0,
	   0,
	   0,
      130843,
       75176,
	   0,
      130846,
      130847,
      130848,
	   0,
	   0,
	   0,
	   0,
	   0,
      130854,
      130855,
      130856,
      130857,
      154053,
      130859,
      130860,
	   0,
      140140,
	   0,
      140142,
      140143,
       52003,
	   0,
	   0,
	   0,
       61285,
	   0,
       61287,
      140151,
	   0,
	   0,
      256129,
	   0,
	   0,
	   0,
	   0,
	   0,
       52019,
	   0,
	   0,
	   0,
	   0,
	   0,
      195834,
      195835,
	   0,
	   0,
      154087,
	   0,
       24197,
	   0,
      140174,
      237594,
	   0,
	   0,
       52037,
	   0,
	   0,
	   0,
      140182,
       42764,
	   0,
      195853,
	   0,
      195855,
	   0,
	   0,
	   0,
      195859,
      195860,
	   0,
	   0,
      195863,
	   0,
      260811,
      154115,
      154116,
      154117,
	   0,
	   0,
       33506,
      154121,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       52071,
       56711,
	   0,
       52074,
	   0,
       52076,
	   0,
	   0,
	   0,
	   0,
	   0,
      103111,
       75278,
       75279,
	   0,
       75281,
       75282,
	   0,
       75284,
       75285,
      154149,
	   0,
	   0,
      154152,
	   0,
	   0,
       14985,
	   0,
	   0,
	   0,
       52101,
       52102,
	   0,
	   0,
	   0,
	   0,
       52107,
	   0,
	   0,
      260865,
	   0,
	   0,
	1084,
      209840,
	   0,
	   0,
	   0,
	   0,
      140260,
      140261,
	   0,
	   0,
       79957,
	   0,
      233046,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      140278,
	   0,
      140280,
      140281,
      140282,
	   0,
      140284,
      140285,
	   0,
       79980,
      140288,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       79989,
	   0,
      200605,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      182058,
	   0,
	   0,
	   0,
	   0,
      158868,
	   0,
	   0,
      251651,
	   0,
	   0,
      154235,
      154236,
      154237,
       80014,
       19708,
	   0,
	   0,
	   0,
       52185,
       52186,
       52187,
       80022,
	   0,
	   0,
       80025,
      265586,
      163529,
	   0,
	   0,
      154254,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       52204,
	   0,
	   0,
	   0,
       75403,
       52209,
       52210,
	   0,
	   0,
       52213,
	   0,
      117161,
	5826,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       15111,
	   0,
	   0,
	   0,
      247065,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       15123,
	   0,
      214602,
	   0,
	   0,
       75435,
       75436,
	   0,
       42965,
	   0,
       42967,
       42968,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      237815,
	   0,
	   0,
	   0,
	   0,
	   0,
      219265,
	   0,
      247101,
	   0,
      247103,
	5876,
	   0,
	   0,
	   0,
       75465,
       75466,
       75467,
       75468,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       75476,
	5892,
	   0,
	   0,
	5895,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      121883,
      265693,
	   0,
	   0,
       38385,
	   0,
	   0,
	   0,
       75501,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       80151,
       80152,
      214684,
      214685,
      214686,
      214687,
	   0,
      140465,
	   0,
	   0,
       80161,
	   0,
	   0,
	   0,
       89443,
       38415,
	   0,
       38417,
	   0,
	   0,
	   0,
       38421,
	   0,
	   0,
	   0,
	   0,
	   0,
      256460,
      256461,
      256462,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      228636,
	   0,
	1327,
	   0,
	   0,
       70915,
       52360,
       52361,
	   0,
       19890,
	   0,
	   0,
	   0,
	   0,
       38451,
	   0,
	   0,
	1342,
	   0,
	   0,
	   0,
      256491,
      256492,
      256493,
	   0,
	   0,
      256496,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       84860,
       84861,
	   0,
	   0,
	   0,
	   0,
       52393,
	   0,
	   0,
       52396,
	   0,
	   0,
	   0,
       19927,
       52401,
	   0,
	   0,
	   0,
       19932,
	   0,
	   0,
	   0,
       75604,
	   0,
	   0,
       75607,
	   0,
       75609,
	   0,
      256532,
       84890,
	   0,
       84892,
       84893,
	   0,
	   0,
       84896,
	   0,
	   0,
	   0,
       52427,
       84901,
	   0,
	   0,
	   0,
       52432,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       89559,
	   0,
	   0,
       89562,
	   0,
       38535,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       84932,
	   0,
      154519,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      154527,
	   0,
	   0,
	   0,
	   0,
       38557,
	   0,
       38559,
       38560,
	   0,
	   0,
	   0,
	   0,
	   0,
       20010,
       20011,
       20012,
	   0,
	   0,
       80322,
	   0,
	   0,
	6101,
	   0,
      256609,
      256610,
      256611,
      256612,
	   0,
	   0,
	   0,
	6110,
	   0,
	   0,
	   0,
	   0,
       20032,
	   0,
       20034,
       20035,
	   0,
       52510,
	   0,
	   0,
      256629,
      256630,
      256631,
      256632,
	   0,
	   0,
      256635,
       52520,
      131384,
	   0,
	   0,
	   0,
      177778,
	   0,
	   0,
       52528,
       52529,
	   0,
       52531,
       52532,
	   0,
       52534,
       52535,
       85009,
       85010,
	   0,
       85012,
      117486,
      163877,
       57181,
       57182,
      163880,
	   0,
	   0,
       85020,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       85028,
	   0,
	   0,
	   0,
	   0,
	   0,
       85034,
       85035,
	   0,
	   0,
       85038,
	   0,
	   0,
	   0,
	   0,
      210296,
	   0,
	   0,
	   0,
      210300,
	   0,
	   0,
	   0,
	   0,
      242778,
	   0,
	   0,
	   0,
      228865,
	   0,
       80419,
	   0,
	   0,
	   0,
      177842,
	   0,
	   0,
	   0,
      177846,
	   0,
	   0,
	   0,
	   0,
      177851,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      242810,
      242811,
      242812,
	   0,
	   0,
	   0,
	1588,
	   0,
	   0,
      140761,
	   0,
	1593,
      177876,
      177877,
      261380,
	   0,
      266021,
	   0,
      177882,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      242841,
      242842,
	   0,
	6255,
	   0,
      242846,
	   0,
      140790,
	   0,
      140792,
	   0,
	   0,
	   0,
      140796,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       89780,
       52669,
	   0,
	   0,
	   0,
	   0,
	   0,
      242874,
	   0,
	   0,
	   0,
      159376,
	   0,
      140822,
      242881,
	   0,
	   0,
      140826,
      140827,
	   0,
       20215,
       20216,
       20217,
	   0,
	   0,
	   0,
       20221,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      242900,
	   0,
      122288,
	   0,
	   0,
	   0,
      177960,
	   0,
      177962,
	   0,
	   0,
	   0,
	   0,
      256830,
	   0,
      117662,
	   0,
	   0,
	   0,
      177973,
	   0,
	   0,
	   0,
       20251,
	   0,
      177979,
      177980,
	   0,
      177982,
       20257,
      177984,
	   0,
      117679,
      242933,
      177988,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      238305,
       99136,
	   0,
	   0,
	   0,
      117696,
	   0,
	   0,
	   0,
      224397,
      117701,
	   0,
      117703,
	   0,
	   0,
      242959,
      242960,
      242961,
      242962,
	   0,
	   0,
	   0,
       66684,
      140909,
	   0,
      140911,
	   0,
      117718,
	   0,
	   0,
	   0,
       57415,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      140925,
      242984,
      242985,
      140928,
      140929,
	   0,
      140931,
      140932,
	   0,
      140934,
      140935,
      252272,
	   0,
      140938,
	   0,
      205886,
	   0,
	   0,
	   0,
	   0,
       11053,
      117751,
      117752,
       20334,
	   0,
       20336,
       20337,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       20357,
	   0,
	   0,
       20360,
      140975,
	   0,
       11085,
	   0,
       11087,
      131702,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       94598,
	   0,
	   0,
	   0,
      182743,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      210588,
	   0,
	   0,
	   0,
	   0,
       11116,
	   0,
       11118,
	   0,
	   0,
       11121,
	   0,
	   0,
       11124,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      117836,
      117837,
	   0,
       43615,
	   0,
       43617,
       43618,
	   0,
       11147,
       43621,
       11149,
	   0,
	   0,
       11152,
       43626,
	   0,
	   0,
	   0,
       11157,
	   0,
	   0,
	   0,
	   0,
	   0,
      229196,
	   0,
       90028,
	   0,
      178171,
	   0,
	   0,
	6531,
       94673,
      117869,
	   0,
	   0,
      117872,
	   0,
      117874,
	   0,
	   0,
	   0,
      117878,
      117879,
	   0,
	   0,
      117882,
      117883,
      117884,
	   0,
      117886,
      117887,
      201390,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       90062,
       94702,
	   0,
	   0,
      178207,
	   0,
      122541,
      122542,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       15852,
	   0,
       15854,
	   0,
	   0,
	   0,
	6580,
	   0,
	   0,
	   0,
	   0,
	   0,
      173590,
	   0,
	   0,
	   0,
	   0,
       90093,
	   0,
	   0,
       90096,
	   0,
	   0,
	   0,
       11237,
       90101,
      122575,
	   0,
	   0,
      238553,
	   0,
	   0,
       11245,
       11246,
	   0,
       11248,
       11249,
	   0,
      257118,
	   0,
       11253,
       11254,
	   0,
	   0,
	   0,
       71565,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      122602,
       43740,
	   0,
	   0,
       43743,
	   0,
       43745,
       43746,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       43753,
	   0,
       43755,
	   0,
	   0,
	   0,
	   0,
	   0,
      104068,
       53040,
	   0,
	   0,
       53043,
	2015,
      104074,
	   0,
	   0,
	   0,
	   0,
	   0,
       53051,
	   0,
	   0,
	   0,
      238615,
      238616,
      238617,
      238618,
      150478,
	   0,
      238621,
	   0,
	   0,
      238624,
	   0,
      238626,
	   0,
	   0,
      252546,
	   0,
	   0,
	   0,
	   0,
       53074,
	   0,
       53076,
	   0,
      104107,
	   0,
	   0,
	   0,
	   0,
      122668,
      122669,
      122670,
      122671,
      122672,
	   0,
      238649,
	   0,
	   0,
	   0,
	   0,
	   0,
      229377,
	   0,
	   0,
       90210,
       90211,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       90221,
       90222,
       90223,
       90224,
	   0,
	   0,
	   0,
       90228,
	   0,
       90230,
       90231,
       90232,
      150540,
	   0,
	   0,
	   0,
	   0,
       90238,
	   0,
	   0,
	   0,
      150549,
	   0,
      150551,
	   0,
	   0,
	   0,
      118082,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      187674,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       53159,
       53160,
       53161,
       53162,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       11418,
	   0,
       53171,
       53172,
       53173,
	   0,
	   0,
	   0,
	   0,
	   0,
       53179,
	   0,
	   0,
       53182,
	   0,
	   0,
       53185,
	   0,
	   0,
	   0,
       43911,
       43912,
	   0,
	   0,
      238753,
      238754,
      238755,
      238756,
      238757,
	   0,
      238759,
      238760,
	   0,
      248040,
      238763,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       94965,
	   0,
       94967,
       94968,
	   0,
       43941,
       43942,
	   0,
	   0,
       90335,
	   0,
       90337,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       11484,
	   0,
	   0,
      248076,
	   0,
	   0,
	   0,
      150661,
      150662,
	   0,
	   0,
	   0,
	   0,
      229530,
	   0,
       95001,
       95002,
	   0,
	   0,
       43976,
       43977,
	   0,
       25423,
	   0,
      150678,
	   0,
      150680,
	   0,
      150682,
	   0,
      150684,
      150685,
	   0,
	   0,
      150688,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      127501,
	   0,
	   0,
	6890,
	   0,
	   0,
      159980,
	   0,
	   0,
      108954,
	   0,
	   0,
       16177,
	   0,
       16179,
      224935,
      224936,
      224937,
       71851,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       53303,
      141445,
      141446,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       39395,
       39396,
	   0,
	   0,
	   0,
	   0,
	   0,
       39402,
      243519,
	   0,
	   0,
      224966,
      224967,
	   0,
      136828,
	   0,
      224971,
	   0,
	   0,
      224974,
	   0,
	   0,
       95085,
	   0,
	   0,
	   0,
       44060,
       44061,
       44062,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      122938,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       44084,
	   0,
	   0,
	   0,
       53366,
       53367,
	   0,
	   0,
	   0,
	   0,
	   0,
       34817,
       53374,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       34830,
       34831,
      136890,
	   0,
	   0,
	   0,
	   0,
	   0,
      136896,
	   0,
       34840,
	   0,
       25564,
	   0,
	   0,
       53401,
	   0,
	   0,
	   0,
	   0,
       99796,
	   0,
	   0,
	   0,
	   0,
       53411,
	   0,
      201861,
      201862,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      118367,
	   0,
	   0,
      136926,
	   0,
      252903,
	   0,
      118374,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       67354,
	   0,
	   0,
	   0,
      225084,
	   0,
	   0,
	   0,
	   0,
       34890,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       34898,
	   0,
	   0,
	   0,
	   0,
	   0,
      225103,
	   0,
	   0,
	   0,
      225107,
	2436,
      225109,
      225110,
	   0,
	   0,
      225113,
	   0,
	   0,
	   0,
      201922,
      169450,
      201924,
      132340,
	   0,
	   0,
      132343,
       81315,
       81316,
	   0,
	   0,
       53485,
	   0,
	   0,
      132351,
	   0,
       81324,
	   0,
       81326,
	   0,
	   0,
       53495,
       53496,
       53497,
       53498,
       53499,
       53500,
	   0,
	   0,
       53503,
       53504,
       53505,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       34956,
	   0,
	   0,
       81349,
      169491,
       81351,
	   0,
	   0,
	   0,
      137023,
	   0,
	   0,
	   0,
	   0,
      137028,
      137029,
      137030,
      137031,
      137032,
	   0,
      137034,
      137035,
	   0,
	   0,
      137038,
	   0,
      118484,
	   0,
	   0,
      118487,
      150961,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      262310,
      262311,
	   0,
	   0,
      118505,
	   0,
	   0,
	   0,
	   0,
	   0,
      178818,
	   0,
      118513,
	   0,
	   0,
	   0,
	   0,
	   0,
      202021,
      202022,
      202023,
      202024,
      202025,
	   0,
	   0,
      202028,
	   0,
	   0,
      202031,
      202032,
      262340,
	   0,
	   0,
      262343,
	   0,
	   0,
	   0,
	   0,
	   0,
      262349,
       35039,
	   0,
	   0,
	   0,
	   0,
       81434,
       81435,
       81436,
       81437,
	   0,
	7215,
      178859,
	   0,
      132471,
      132472,
      132473,
      132474,
	   0,
	   0,
	   0,
	   0,
      132479,
      132480,
      132481,
	   0,
       81454,
	   0,
	   0,
       81457,
	   0,
	   0,
	   0,
      262382,
       11877,
       81463,
       35074,
	   0,
	   0,
	   0,
	   0,
      137137,
	   0,
	   0,
	   0,
      141780,
	   0,
	   0,
	   0,
	   0,
       35088,
       35089,
       35090,
	   0,
       35092,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      123245,
      123246,
      127886,
	   0,
	   0,
	   0,
	   0,
      123252,
	   0,
	   0,
      123255,
	   0,
	   0,
	   0,
      127898,
      127899,
	   0,
	   0,
      262433,
	   0,
      257796,
      178934,
      178935,
	   0,
      178937,
	   0,
	   0,
	   0,
	   0,
	   0,
      262445,
	   0,
	2663,
	   0,
	   0,
      118641,
      118642,
	   0,
	   0,
      151118,
	   0,
	   0,
	   0,
	   0,
      262459,
      262460,
	   0,
      262462,
	   0,
	   0,
	   0,
	   0,
	   0,
      137215,
	   0,
      137217,
	   0,
      202165,
	   0,
	   0,
	   0,
	   0,
	   0,
      262478,
	   0,
      262480,
	   0,
	   0,
	   0,
      262484,
      262485,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      123322,
	   0,
	   0,
	   0,
	   0,
      183634,
	   0,
      118690,
	   0,
	   0,
	   0,
	   0,
      239309,
	   0,
	   0,
	   0,
	   0,
	   0,
       72311,
	   0,
	   0,
       39841,
      202207,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       72323,
       72324,
	   0,
	   0,
	   0,
	   0,
	   0,
      179027,
	   0,
	   0,
	   0,
	   0,
	   0,
      118726,
      100171,
	   0,
	   0,
	   0,
	   0,
      151205,
      100177,
	   0,
	   0,
	   0,
	   0,
	   0,
	7403,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      248646,
	   0,
       30615,
       90923,
	   0,
	   0,
	   0,
	   0,
	   0,
      132680,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      137334,
	   0,
	   0,
	   0,
	   0,
       26003,
	   0,
	   0,
      267234,
	   0,
      183734,
       30648,
	   0,
	   0,
	   0,
	   0,
      248686,
	   0,
	   0,
	   0,
      165188,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      146640,
      257977,
	   0,
      257979,
       95615,
	   0,
	   0,
	   0,
      118814,
       26035,
       26036,
       26037,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      174496,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      165226,
	   0,
	   0,
      179146,
	   0,
	   0,
      146676,
	   0,
	   0,
       26065,
	   0,
	   0,
       26068,
	   0,
	   0,
       26071,
	   0,
      137409,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      109590,
	2894,
	   0,
	   0,
	   0,
	   0,
      202376,
	   0,
	   0,
       91043,
	   0,
	   0,
	   0,
       26101,
       26102,
      202385,
	   0,
	   0,
	   0,
       26107,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      109623,
	   0,
      109625,
	   0,
      207046,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	2951,
	2952,
      202430,
      202431,
	   0,
      202433,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      123577,
       53993,
	   0,
      123580,
	2967,
       91109,
	   0,
	2970,
	   0,
	   0,
	   0,
      207090,
	   0,
      207092,
      207093,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       26184,
       26185,
       26186,
       26187,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      248866,
	   0,
	   0,
	   0,
	   0,
	   0,
      137536,
	   0,
	   0,
	   0,
       26204,
	   0,
	   0,
	   0,
       86515,
       26209,
       26210,
	   0,
       35490,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      193224,
	   0,
      100446,
	   0,
       67975,
       54059,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       12320,
	   0,
	3044,
	   0,
	   0,
      179329,
	   0,
	   0,
	   0,
	   0,
	   0,
      137584,
	   0,
	   0,
	   0,
	   0,
	   0,
      170063,
	   0,
	   0,
	   0,
	   0,
	   0,
      179347,
	   0,
	   0,
      202545,
      202546,
	   0,
	   0,
	   0,
	   0,
      253580,
	   0,
	   0,
	   0,
      202555,
	   0,
	   0,
	   0,
      151530,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      207209,
      207210,
	   0,
      207212,
      170101,
	   0,
	   0,
	   0,
      146910,
	   0,
	   0,
	   0,
	   0,
	3106,
	3107,
	   0,
	   0,
	   0,
	   0,
	   0,
      133005,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       30955,
	   0,
	   0,
      146933,
	   0,
       95906,
	   0,
      179410,
	   0,
      197968,
	   0,
      267555,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      146962,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      230472,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	3176,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      230495,
	   0,
	   0,
      128440,
	   0,
	   0,
	   0,
      230502,
	   0,
	   0,
	   0,
	   0,
      198034,
      193396,
	   0,
       26394,
	   0,
	   0,
	   0,
	   0,
       26399,
	   0,
       26401,
       35680,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	3214,
	3215,
	3216,
	3217,
	   0,
	   0,
	   0,
	   0,
	   0,
      128476,
	3224,
	   0,
	   0,
       91368,
	   0,
	   0,
      207346,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       72826,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      249121,
	   0,
	   0,
       72842,
	   0,
       72844,
       72845,
      230572,
	   0,
	   0,
	   0,
	   0,
	   0,
      137798,
	   0,
	   0,
       72855,
       72856,
	   0,
      239862,
       72859,
       72860,
	   0,
	   0,
	   0,
	   0,
       72865,
	   0,
      239871,
	   0,
	   0,
	   0,
	   0,
      174930,
	   0,
	   0,
	   0,
	   0,
	   0,
       91434,
	   0,
	   0,
	   0,
	   0,
	   0,
      221332,
	   0,
	   0,
	   0,
	   0,
      239893,
      119280,
	   0,
	   0,
      119283,
	   0,
      258455,
	   0,
      137843,
	   0,
	   0,
       68261,
      119291,
      119292,
	   0,
	   0,
	   0,
	3321,
	   0,
       54352,
	   0,
	   0,
	   0,
	   0,
	   0,
       72914,
       72915,
	   0,
	   0,
       72918,
	   0,
	   0,
       72921,
       72922,
	   0,
	   0,
       72925,
	   0,
       26537,
	   0,
	   0,
       72930,
       72931,
	   0,
      119323,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      221389,
	   0,
	   0,
       40471,
	3360,
	   0,
      221395,
      221396,
	   0,
      221398,
      221399,
      221400,
      221401,
	   0,
	   0,
	   0,
       49762,
	   0,
      221407,
      221408,
	   0,
	   0,
	   0,
      221412,
	   0,
      221414,
      221415,
	   0,
	   0,
      216779,
	   0,
	   0,
	   0,
	   0,
       72975,
	   0,
       72977,
	   0,
	   0,
	   0,
	   0,
       72982,
       72983,
      253905,
	   0,
       49791,
	   0,
	   0,
	   0,
      216799,
	   0,
      151855,
	   0,
	   0,
      216804,
	   0,
	   0,
	   0,
      216808,
	   0,
	   0,
	   0,
      216812,
	   0,
      216814,
	   0,
	   0,
      133315,
      216818,
	   0,
	   0,
      216821,
      119403,
	   0,
	   0,
	   0,
      216826,
	   0,
	   0,
      119410,
	   0,
	   0,
      119413,
      119414,
      119415,
      119416,
       49832,
	   0,
	   0,
	   0,
	   0,
	   0,
      216842,
      216843,
	   0,
      119426,
	   0,
      119428,
      119429,
	   0,
      133348,
	   0,
	   0,
	   0,
	   0,
	   0,
       26657,
	   0,
	   0,
	   0,
       73051,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      249341,
	   0,
	   0,
	   0,
	   0,
	   0,
       73065,
       73066,
      249349,
	   0,
      249351,
	   0,
       26681,
       96267,
	   0,
	   0,
      216884,
       26686,
      100911,
	   0,
       26689,
      147304,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      230815,
	   0,
	   0,
      249374,
	   0,
	   0,
      249377,
	   0,
      244740,
       26708,
       73099,
	   0,
	   0,
	   0,
	   0,
	   0,
       49910,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       73113,
       73114,
	   0,
       73116,
       73117,
	   0,
	   0,
	   0,
       26731,
	   0,
	   0,
	   0,
	   0,
       49931,
       49932,
	   0,
	   0,
	   0,
	   0,
	   0,
       49938,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       40672,
	   0,
      119537,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       91710,
	   0,
      212326,
	   0,
      212328,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       40695,
       40696,
	   0,
	   0,
	   0,
	   0,
	   0,
       40702,
	   0,
      249459,
	   0,
      249461,
      249462,
      138127,
      216991,
      138129,
      216993,
	   0,
      124215,
      235552,
      249470,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      249478,
      249479,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      138150,
	   0,
      249488,
      138153,
      138154,
	   0,
	   0,
	   0,
      138158,
	   0,
	   0,
	   0,
      138162,
	   0,
      138164,
      124248,
	   0,
       54665,
       36110,
	   0,
	   0,
      138171,
	   0,
	   0,
	   0,
	   0,
      138176,
      249513,
      138178,
	   0,
	   0,
	   0,
      240240,
	   0,
	   0,
	   0,
      138186,
	   0,
	   0,
	   0,
      138190,
	   0,
      138192,
      138193,
	   0,
	   0,
	   0,
       26861,
	   0,
	   0,
	   0,
      189230,
	   0,
       54701,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       68625,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      226361,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      235646,
	   0,
       17615,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       68655,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      152165,
	   0,
	   0,
	   0,
	   0,
	   0,
      244951,
      254230,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       17651,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      166106,
	   0,
	   0,
      147553,
	   0,
	   0,
	   0,
	   0,
	   0,
      152198,
	   0,
      152200,
	   0,
      249621,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      180053,
	   0,
	   0,
	   0,
	   0,
      147585,
      147586,
      147587,
      245007,
	   0,
       13059,
	   0,
	   0,
	   0,
       13063,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      212553,
	   0,
	   0,
	   0,
	   0,
      180085,
	   0,
      180087,
      147615,
      147616,
      147617,
      147618,
      138341,
	   0,
	   0,
	   0,
	   0,
      147624,
	   0,
	   0,
	   0,
	   0,
       31654,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      231140,
      212585,
      212586,
      212587,
      180115,
      180116,
      180117,
      180118,
      129090,
      147647,
      180121,
      147649,
	   0,
	   0,
	   0,
      180126,
	   0,
	   0,
       13125,
      147657,
	   0,
	   0,
	   0,
	   0,
	   0,
       13132,
	   0,
	   0,
	   0,
	   0,
	   0,
      212615,
      212616,
	   0,
      212618,
	   0,
      180147,
      212621,
      180149,
	   0,
	   0,
      180152,
      212626,
	   0,
      129126,
      110571,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      212651,
      212652,
	   0,
	   0,
	   0,
      212656,
      212657,
	   0,
	   0,
	   0,
       96686,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       96698,
       96699,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      147735,
	   0,
	   0,
	   0,
	   0,
      124545,
	   0,
	   0,
      175577,
	   0,
	   0,
      147746,
	   0,
      147748,
      147749,
	   0,
      240531,
	   0,
      147753,
      147754,
      147755,
      147756,
      147757,
	   0,
      147759,
      147760,
      180234,
	   0,
	   0,
      180237,
	   0,
	   0,
	   0,
	   0,
      110657,
	   0,
	   0,
      180245,
	   0,
	   0,
      180248,
      180249,
      180250,
	   0,
	   0,
      180253,
	   0,
      180255,
      180256,
      180257,
      203453,
      180259,
	   0,
      212734,
      212735,
	   0,
      212737,
	   0,
      101403,
	   0,
	   0,
	   0,
       50378,
       17906,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      212753,
      212754,
      212755,
      212756,
      212757,
	   0,
	   0,
      212760,
      180288,
	   0,
	   0,
      203486,
      203487,
	   0,
	   0,
	   0,
	   0,
       82878,
      101435,
      101436,
      101437,
	   0,
       50410,
	   0,
       50412,
	   0,
       13302,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      235983,
	   0,
	   0,
	   0,
	   0,
      203515,
      203516,
      203517,
      203518,
	   0,
	   0,
      203521,
	   0,
      101465,
	   0,
	   0,
	   0,
	   0,
       50441,
	   0,
       50443,
	   0,
      101474,
       50446,
      101476,
      166423,
       50449,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      147878,
	   0,
	   0,
      203549,
	   0,
      203551,
      203552,
	   0,
	   0,
	   0,
       82942,
	   0,
	   0,
      101501,
	   0,
       50474,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       50482,
	   0,
	   0,
       31929,
	   0,
	   0,
      203575,
	   0,
	   0,
      147910,
	   0,
      147912,
	   0,
	   0,
	   0,
	   0,
	   0,
       45860,
       45861,
	   0,
	   0,
       82976,
       82977,
	   0,
	   0,
	   0,
	   0,
       82982,
	   0,
	   0,
      129375,
      129376,
      129377,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      147940,
      147941,
      147942,
      147943,
	   0,
	   0,
	   0,
      152586,
	   0,
	   0,
       45892,
	   0,
	   0,
       27339,
       45896,
	   0,
	   0,
	   0,
	   0,
       96930,
      101570,
      129405,
      129406,
	   0,
	   0,
      129409,
	   0,
	   0,
      203636,
      203637,
	   0,
      129415,
      147972,
	   0,
	   0,
      101585,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       45926,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      203659,
      203660,
      101603,
      101604,
	   0,
      101606,
	   0,
       50579,
	   0,
	   0,
       50582,
       41305,
	   0,
       50585,
       83059,
	   0,
	   0,
	   0,
	   0,
	   0,
       41314,
	   0,
	   0,
	   0,
	   0,
       83070,
      245436,
	   0,
      129463,
      129464,
      129465,
      129466,
      129467,
	   0,
	   0,
	   0,
	   0,
	   0,
      129473,
	   0,
	   0,
	   0,
	4224,
       83088,
	   0,
	   0,
	   0,
	   0,
	   0,
       22787,
	   0,
	   0,
       22790,
       41347,
       92377,
	   0,
       41350,
	   0,
	   0,
	   0,
	   0,
      226915,
       41356,
       41357,
	   0,
       41359,
       41360,
       41361,
	   0,
      148060,
	   0,
	   0,
       41366,
	   0,
      245484,
	   0,
       46009,
	   0,
	   0,
	   0,
	   0,
      148072,
      148073,
	   0,
	   0,
	   0,
       22824,
      148078,
	   0,
	   0,
	   0,
	   0,
      129527,
	   0,
	   0,
      129530,
	   0,
	   0,
	   0,
       46032,
      106340,
	   0,
       46035,
	   0,
	   0,
	   0,
      222321,
      208405,
	4290,
       22847,
	   0,
       22849,
	   0,
       22851,
	   0,
	   0,
	   0,
	   0,
       22856,
       22857,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       50703,
	   0,
      106373,
	   0,
	   0,
      171322,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	4326,
	   0,
      236278,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      180620,
	   0,
	   0,
      171345,
      171346,
	   0,
	   0,
       50735,
       50736,
       50737,
	   0,
	   0,
	   0,
	   0,
       22908,
	   0,
	   0,
      120330,
	   0,
      129610,
	   0,
	   0,
      236310,
	   0,
	   0,
      129616,
	   0,
       41477,
	   0,
	   0,
	   0,
	   0,
	   0,
      115707,
	   0,
	   0,
       41486,
       50765,
       50766,
       50767,
	   0,
       22935,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       22945,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       32240,
       22963,
	   0,
       50799,
	   0,
	   0,
	   0,
	   0,
      129667,
      171419,
	   0,
       50807,
      171422,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       97205,
	   0,
      236377,
      115764,
	   0,
      250297,
      236381,
      236382,
      115769,
      115770,
      115771,
	   0,
      115773,
      115774,
      115775,
	   0,
	   0,
      115778,
	   0,
	   0,
      115781,
      115782,
      115783,
	   0,
      115785,
	   0,
      115787,
      162178,
      115789,
      115790,
      115791,
	   0,
	   0,
	   0,
      203936,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      134367,
      134368,
      134369,
      134370,
      134371,
      134372,
	   0,
	   0,
      236433,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      231802,
	   0,
	   0,
	   0,
       50885,
       50886,
       50887,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       50895,
	   0,
	   0,
	   0,
      236459,
	   0,
      236461,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       50909,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      236478,
      236479,
      236480,
      236481,
	   0,
	   0,
      236484,
      236485,
	   0,
	   0,
      236488,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      162274,
	   0,
      162276,
      162277,
	   0,
	   0,
	   0,
       92696,
      162282,
	   0,
	   0,
	   0,
	   0,
      231872,
	   0,
	   0,
       92705,
	   0,
	   0,
	   0,
      227240,
	   0,
	   0,
      227243,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      241171,
	   0,
      176227,
	   0,
	   0,
	   0,
	   0,
	   0,
       74175,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      208715,
      213355,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
       92758,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
	   0,
      213384,
      213385,
	   0,
      213387,
      162359,
	   0,
      162361,
	   0,
	   0,
	   0,
      245652,
      236374,
	   0,
      245654,
      236376,
	   0,
      247753,
      233836,
	   0,
      242843,
      233565,
	   0,
      262119,
      257480,
      225007,
	   0,
      242876,
      224320,
	   0,
      242877,
      224321,
	   0,
      226036,
      221397,
	   0,
      239915,
      221359,
	   0,
      239911,
      221355,
	   0,
      235371,
      221454,
	   0,
      225711,
      221072,
	   0,
      249340,
      216867,
	   0,
      249310,
      216837,
	   0,
      221416,
      216777,
	   0,
      237455,
      214260,
	   0,
      255137,
      213386,
	   0,
      236462,
      213267,
	   0,
      231173,
      212617,
	   0,
      256501,
      210111,
	   0,
      249460,
      207709,
	   0,
      216489,
      207211,
	   0,
      217464,
      203547,
	   0,
      221374,
      202818,
	   0,
      262461,
      202154,
	   0,
      262342,
      202035,
	   0,
      225085,
      201890,
	   0,
      266837,
      225086,
      201891,
	   0,
      218940,
      200384,
	   0,
      237315,
      200203,
	   0,
      229396,
      196923,
	   0,
      232861,
      195749,
	   0,
      237436,
      195685,
	   0,
      237437,
      195686,
	   0,
      237349,
      200237,
      190959,
	   0,
      237352,
      190962,
	   0,
      200266,
      190988,
	   0,
      193223,
      183945,
	   0,
      190984,
      181706,
	   0,
      203635,
      180440,
	   0,
      212624,
      180151,
	   0,
      212708,
      180235,
	   0,
      221998,
      180247,
	   0,
      212736,
      180263,
	   0,
      231115,
      180086,
	   0,
      239634,
      179327,
	   0,
      239243,
      178936,
	   0,
      262482,
      183619,
      178980,
	   0,
      183668,
      179029,
	   0,
      202010,
      178815,
	   0,
      233511,
      177843,
	   0,
      212759,
      175647,
	   0,
      199955,
      172121,
	   0,
      250988,
      172125,
	   0,
      246459,
      172235,
	   0,
      241584,
      171999,
	   0,
      221394,
      170365,
	   0,
      267235,
      165177,
	   0,
      261055,
      163636,
	   0,
      232211,
      162626,
	   0,
      213301,
      208662,
      162272,
	   0,
      222677,
      162370,
	   0,
      208775,
      162385,
	   0,
      231796,
      162211,
	   0,
      245753,
      162251,
	   0,
      242840,
      159338,
	   0,
      251653,
      154234,
	   0,
      195836,
      154085,
	   0,
      195837,
      154086,
	   0,
      190981,
      153869,
	   0,
      200267,
      153877,
	   0,
      223191,
      153606,
	   0,
      171991,
      153435,
	   0,
      171992,
      153436,
	   0,
      171993,
      153437,
	   0,
      255534,
      172032,
      153476,
	   0,
      183055,
      150582,
	   0,
      248078,
      234161,
      150659,
	   0,
      238652,
      150511,
	   0,
      206211,
      150543,
	   0,
      257243,
      150546,
	   0,
      231561,
      148059,
	   0,
      217665,
      148080,
	   0,
      231615,
      148113,
	   0,
      171106,
      147911,
	   0,
      152585,
      147946,
	   0,
      180124,
      147651,
	   0,
      245071,
      147652,
	   0,
      189485,
      147734,
	   0,
      175570,
      147736,
	   0,
      175571,
      147737,
	   0,
      180236,
      147763,
	   0,
      198655,
      147626,
	   0,
      224965,
      141463,
	   0,
      242882,
      140824,
	   0,
      242978,
      140920,
	   0,
      242979,
      140921,
	   0,
      242980,
      140922,
	   0,
      242981,
      140923,
	   0,
      242988,
      140930,
	   0,
      177840,
      140728,
	   0,
      228901,
      177872,
      140760,
	   0,
      228903,
      177874,
      140762,
	   0,
      242849,
      140791,
	   0,
      242851,
      140793,
	   0,
      223761,
      140259,
	   0,
      177374,
      140262,
	   0,
      251615,
      140279,
	   0,
      200385,
      140078,
	   0,
      219009,
      140146,
	   0,
      237356,
      139937,
	   0,
      190846,
      139817,
	   0,
      240275,
      138217,
	   0,
      175252,
      138140,
	   0,
      249475,
      138139,
	   0,
      249484,
      138148,
	   0,
      249482,
      138146,
	   0,
      249481,
      138145,
	   0,
      249480,
      138144,
	   0,
      198650,
      147621,
      138343,
	   0,
      221411,
      137909,
	   0,
      153586,
      135030,
	   0,
      171990,
      134878,
	   0,
      153467,
      134911,
	   0,
      172024,
      153468,
      134912,
	   0,
      153499,
      134943,
	   0,
      153502,
      134946,
	   0,
      153507,
      134951,
	   0,
      231795,
      162210,
      134376,
	   0,
      162212,
      134378,
	   0,
      189909,
      134241,
	   0,
      185271,
      134242,
	   0,
      146914,
      132997,
	   0,
      137021,
      132382,
	   0,
      178851,
      132461,
	   0,
      178852,
      132462,
	   0,
      202063,
      132478,
	   0,
      169390,
      132278,
	   0,
      201926,
      132341,
	   0,
      201927,
      132342,
	   0,
      256638,
      131385,
	   0,
      237453,
      130756,
	   0,
      237454,
      214259,
      130757,
	   0,
      200405,
      130820,
	   0,
      140112,
      130834,
	   0,
      228259,
      130840,
	   0,
      200438,
      130853,
	   0,
      140141,
      130863,
	   0,
      190960,
      130653,
	   0,
      200271,
      130686,
	   0,
      200301,
      130716,
	   0,
      200302,
      130717,
	   0,
      203705,
      129481,
	   0,
      148081,
      129525,
	   0,
      148082,
      129526,
	   0,
      148084,
      129528,
	   0,
      148085,
      129529,
	   0,
      171352,
      129601,
	   0,
      236311,
      129614,
	   0,
      236312,
      129615,
	   0,
      236346,
      129649,
	   0,
      134302,
      129663,
	   0,
      203634,
      129410,
	   0,
      180157,
      129128,
	   0,
      258103,
      128211,
	   0,
      150660,
      127465,
	   0,
      162362,
      125250,
	   0,
      148075,
      124880,
	   0,
      212763,
      203485,
      124622,
	   0,
      226604,
      208048,
      124546,
	   0,
      147747,
      124552,
	   0,
      147750,
      124555,
	   0,
      201778,
      122915,
	   0,
      150512,
      122678,
	   0,
      195854,
      121630,
	   0,
      190841,
      121256,
	   0,
      171960,
      120931,
	   0,
      249311,
      119419,
	   0,
      249312,
      119420,
	   0,
      216840,
      119421,
	   0,
      262481,
      118672,
	   0,
      178793,
      118486,
	   0,
      262312,
      118503,
	   0,
      178811,
      118504,
	   0,
      262315,
      118506,
	   0,
      220565,
      202009,
      118507,
	   0,
      202011,
      118509,
	   0,
      202012,
      178817,
      118510,
	   0,
      136922,
      118366,
	   0,
      136924,
      118368,
	   0,
      136927,
      118371,
	   0,
      136932,
      118376,
	   0,
      201336,
      117834,
	   0,
      127155,
      117877,
	   0,
      210665,
      117885,
	   0,
      177959,
      117652,
	   0,
      177961,
      117654,
	   0,
      177981,
      117674,
	   0,
      177985,
      117678,
	   0,
      122326,
      117687,
	   0,
      140910,
      117715,
	   0,
      140912,
      117717,
	   0,
      150215,
      117742,
	   0,
      177849,
      117542,
	   0,
      125380,
      116102,
	   0,
      217835,
      115777,
	   0,
      166805,
      115776,
	   0,
      129666,
      115749,
	   0,
      202038,
      113897,
	   0,
      213302,
      111244,
	   0,
      132475,
      109280,
	   0,
      141522,
      104410,
	   0,
      201828,
      104409,
	   0,
      136572,
      104099,
	   0,
      136575,
      104102,
	   0,
      150574,
      104184,
	   0,
      150576,
      104186,
	   0,
      150577,
      104187,
	   0,
      238736,
      104205,
	   0,
      238737,
      104206,
	   0,
      141115,
      104003,
	   0,
      178289,
      104065,
	   0,
      177971,
      103747,
	   0,
      177974,
      103750,
	   0,
      134949,
      102476,
	   0,
      172130,
      102545,
	   0,
      135033,
      102560,
	   0,
      251026,
      153607,
      102578,
	   0,
      153609,
      102580,
	   0,
      153610,
      102581,
	   0,
      246393,
      153613,
      102584,
	   0,
      135061,
      102588,
	   0,
      139490,
      102378,
	   0,
      171996,
      139523,
      102411,
	   0,
      172026,
      102441,
	   0,
      172027,
      153471,
      102442,
	   0,
      185737,
      102235,
	   0,
      190394,
      102253,
	   0,
      190395,
      102254,
	   0,
      162360,
      102053,
	   0,
      134588,
      116032,
      102115,
	   0,
      147974,
      101584,
	   0,
      147976,
      101586,
	   0,
      203645,
      147977,
      101587,
	   0,
      203650,
      147982,
      101592,
	   0,
      203654,
      101596,
	   0,
      203655,
      101597,
	   0,
      203656,
      101598,
	   0,
      203663,
      101605,
	   0,
      249372,
      100924,
	   0,
      137518,
      100406,
	   0,
      238955,
       99785,
	   0,
      238651,
      150510,
      122676,
       99481,
	   0,
      102446,
       97807,
	   0,
      162378,
       97432,
	   0,
      227325,
      162379,
       97433,
	   0,
      115772,
       97216,
	   0,
      170784,
       96560,
	   0,
      115135,
       96579,
	   0,
      249471,
      235554,
      138135,
       96384,
	   0,
      249472,
       96385,
	   0,
      249473,
      244834,
      138137,
       96386,
	   0,
      249474,
       96387,
	   0,
      202622,
       95925,
	   0,
      202020,
       95323,
	   0,
      118485,
       95290,
	   0,
      224976,
       95084,
	   0,
      117870,
       94675,
	   0,
      117835,
       94640,
	   0,
      162382,
       92797,
	   0,
      120281,
       92447,
	   0,
      212649,
       92035,
	   0,
      216469,
      202552,
       91216,
	   0,
      262341,
      202034,
       90698,
	   0,
      238657,
      229379,
       90209,
	   0,
      118046,
       90212,
	   0,
      155175,
       90229,
	   0,
      150541,
       90234,
	   0,
      178201,
       90060,
	   0,
      159646,
       90061,
	   0,
      117925,
       90091,
	   0,
      117926,
       90092,
	   0,
      238009,
       89561,
	   0,
      223973,
      219334,
       89442,
	   0,
      140498,
       89469,
	   0,
      205105,
       89130,
	   0,
      223059,
      153474,
       97806,
       88528,
	   0,
      236460,
      213265,
       88012,
	   0,
      180246,
       87466,
	   0,
      177810,
       85030,
	   0,
      177811,
       85031,
	   0,
      177812,
       85032,
	   0,
      190979,
       84282,
	   0,
      130749,
       84359,
	   0,
      237457,
       84370,
	   0,
      195715,
       84379,
	   0,
      195716,
       84380,
	   0,
      195717,
       84381,
	   0,
      251386,
      195718,
       84382,
	   0,
      228193,
       84384,
	   0,
      195721,
       84385,
	   0,
      158436,
       84212,
	   0,
      135272,
       84243,
	   0,
      116097,
       83624,
	   0,
      185684,
      116099,
       83626,
	   0,
      111569,
       83735,
	   0,
      120640,
       83528,
	   0,
      208813,
      185618,
      102116,
       83560,
	   0,
      208814,
      120673,
      102117,
       88200,
       83561,
	   0,
      102118,
       83562,
	   0,
      116064,
      102147,
       83591,
	   0,
      102149,
       83593,
	   0,
      102152,
       83596,
	   0,
      116074,
      102157,
       83601,
	   0,
      129468,
       83078,
	   0,
      129469,
       83079,
	   0,
      129470,
       83080,
	   0,
      129471,
       83081,
	   0,
      129472,
       83082,
	   0,
      129474,
       83084,
	   0,
      129475,
      110919,
       83085,
	   0,
      203524,
      101466,
       82910,
	   0,
      101467,
       82911,
	   0,
      254555,
      203526,
      101468,
       82912,
	   0,
      101497,
       82941,
	   0,
      203557,
      101499,
       82943,
	   0,
      101502,
       82946,
	   0,
      101507,
       82951,
	   0,
      137020,
       81352,
	   0,
      137024,
       81356,
	   0,
      262278,
      137025,
       81357,
	   0,
      262374,
      132482,
       81453,
	   0,
      262376,
      132484,
       81455,
	   0,
      262377,
      132485,
       81456,
	   0,
      132488,
       81459,
	   0,
      262381,
       81460,
	   0,
      118365,
       81253,
	   0,
      132346,
       81317,
	   0,
      177841,
       80422,
	   0,
      256634,
       80352,
	   0,
      154259,
       80035,
	   0,
      214565,
       80034,
	   0,
      265546,
       79986,
	   0,
      154255,
       80031,
	   0,
      154256,
       80032,
	   0,
      154257,
       80033,
	   0,
      214567,
      154260,
       80036,
	   0,
      256428,
      163648,
       75507,
	   0,
       84862,
       75584,
	   0,
      256524,
       75603,
	   0,
      256526,
       75605,
	   0,
      256527,
       75606,
	   0,
      256531,
       75610,
	   0,
      122003,
       84891,
       75613,
	   0,
      126466,
       75437,
	   0,
      107944,
       75471,
	   0,
      130842,
       75174,
	   0,
      130845,
       75177,
	   0,
      130849,
       75181,
	   0,
      130850,
       75182,
	   0,
      158761,
       75259,
	   0,
      154151,
       75288,
	   0,
      195724,
       84388,
       75110,
	   0,
      195726,
       75112,
	   0,
      130808,
       75140,
	   0,
      246784,
       75141,
	   0,
      200395,
      195756,
       75142,
	   0,
      200396,
      195757,
       75143,
	   0,
      200399,
       75146,
	   0,
      200404,
       75151,
	   0,
      171928,
       74509,
	   0,
      190147,
      176230,
       74172,
	   0,
      180254,
       73557,
	   0,
      147745,
       73521,
	   0,
      221361,
       72913,
	   0,
      221364,
       72916,
	   0,
      119307,
       72917,
	   0,
      147143,
       72919,
	   0,
      147144,
      119310,
       72920,
	   0,
      221372,
       72924,
	   0,
      119322,
       72932,
	   0,
      216785,
       72976,
	   0,
      216787,
       72978,
	   0,
      170398,
       72979,
	   0,
      216789,
      207511,
       72980,
	   0,
      216790,
      170400,
       72981,
	   0,
      249342,
       73060,
	   0,
      249343,
      179758,
       73061,
	   0,
      249346,
       73064,
	   0,
      249382,
       73100,
	   0,
      137771,
       72825,
	   0,
      123856,
       72827,
	   0,
      100407,
       72573,
	   0,
      202432,
       72540,
	   0,
      137022,
      113827,
       72076,
	   0,
      141452,
       71867,
	   0,
      141455,
       71870,
	   0,
      224968,
       71881,
	   0,
      177970,
       71273,
	   0,
      224327,
       71240,
	   0,
      195857,
       70604,
	   0,
      221402,
       68315,
	   0,
      262488,
       67650,
	   0,
       90225,
       67030,
	   0,
      224618,
       66892,
	   0,
      177972,
      117665,
       66636,
	   0,
       89560,
       66365,
	   0,
      116094,
       65065,
	   0,
      242205,
       61284,
	   0,
      140149,
       61286,
	   0,
       84360,
       61165,
	   0,
      130752,
       84362,
       61167,
	   0,
      104076,
       57686,
	   0,
      177975,
       57361,
	   0,
       75502,
       56946,
	   0,
      163649,
       56952,
	   0,
       75280,
       56724,
	   0,
       83712,
       55878,
	   0,
      125190,
       55605,
	   0,
      249376,
       54538,
	   0,
      136899,
       53397,
	   0,
      136901,
       53399,
	   0,
       85875,
       53402,
	   0,
       85880,
       53407,
	   0,
      201860,
       53412,
	   0,
      201932,
       81318,
       53484,
	   0,
      132349,
       53486,
	   0,
       81321,
       53487,
	   0,
       95086,
       53335,
	   0,
       95087,
       53336,
	   0,
      122950,
       53365,
	   0,
      104397,
       53368,
	   0,
      104400,
       53371,
	   0,
      104101,
       53072,
	   0,
      118023,
       53077,
	   0,
      122667,
       53082,
	   0,
      238734,
      104203,
       53174,
	   0,
      238735,
      104204,
       53175,
	   0,
      206265,
      104207,
       53178,
	   0,
      104209,
       53180,
	   0,
      104210,
       53181,
	   0,
      104213,
       53184,
	   0,
      117924,
       90090,
       52978,
	   0,
      104071,
       53042,
	   0,
       84899,
       52426,
	   0,
      131372,
       52509,
	   0,
       80345,
       52511,
	   0,
      256628,
      131375,
       80346,
       52512,
	   0,
       85011,
       52538,
	   0,
       89440,
       52328,
	   0,
       75585,
       52390,
	   0,
       75586,
       52391,
	   0,
      154157,
       52099,
	   0,
      154253,
       52195,
	   0,
      214568,
       52203,
	   0,
      154263,
       80039,
       52205,
	   0,
       80040,
       52206,
	   0,
      219211,
       80041,
       52207,
	   0,
      237595,
      140176,
       52035,
	   0,
      140177,
       52036,
	   0,
       75260,
       52065,
	   0,
      154124,
       75261,
       52066,
	   0,
       75262,
       52067,
	   0,
      154126,
       52068,
	   0,
       84249,
       51776,
	   0,
      200307,
       51859,
	   0,
      237420,
       51860,
	   0,
      130724,
       51861,
	   0,
      195687,
       51878,
	   0,
      246718,
       51880,
	   0,
      218886,
       51882,
	   0,
      130747,
       51884,
	   0,
      130751,
       84361,
       51888,
	   0,
      139851,
       51710,
	   0,
      190881,
      139852,
       51711,
	   0,
      190882,
       51712,
	   0,
      158448,
       51751,
	   0,
      172022,
      153466,
      134910,
       51408,
	   0,
       83599,
       51126,
	   0,
      102249,
       51220,
	   0,
      222871,
      204315,
      102257,
       51228,
	   0,
      102259,
       92981,
       51230,
	   0,
      102260,
       51231,
	   0,
      102263,
       51234,
	   0,
       83711,
       51238,
	   0,
       88140,
       51028,
	   0,
      120675,
       51090,
	   0,
      102121,
       51092,
	   0,
      129664,
       50801,
	   0,
      129665,
       50802,
	   0,
      213268,
      203990,
       50903,
	   0,
      162240,
       50904,
	   0,
      162241,
       92656,
       50905,
	   0,
      162242,
       50906,
	   0,
      162243,
       50907,
	   0,
      162246,
       50910,
	   0,
      162249,
       50913,
	   0,
       82949,
       50476,
	   0,
      101506,
       50477,
	   0,
      203646,
       50559,
	   0,
      203648,
      101590,
       50561,
	   0,
      203649,
       50562,
	   0,
      203657,
      101599,
       50570,
	   0,
      101607,
       50578,
	   0,
      245418,
      222223,
      101609,
       50580,
	   0,
      101610,
       50581,
	   0,
      101613,
       50584,
	   0,
       83061,
       50588,
	   0,
      101440,
       50411,
	   0,
      217444,
       50440,
	   0,
      101471,
       50442,
	   0,
      216828,
      119409,
       49824,
	   0,
      119411,
       49826,
	   0,
      119412,
       49827,
	   0,
       96301,
       49911,
	   0,
       96302,
       49912,
	   0,
      230850,
       49929,
	   0,
      147147,
       86840,
       72923,
       49728,
	   0,
      239959,
      221403,
       49760,
	   0,
      221404,
      119346,
       86873,
       49761,
	   0,
      216794,
       49790,
	   0,
      216796,
       49792,
	   0,
      202880,
       49793,
	   0,
      216803,
       49799,
	   0,
      249278,
       49801,
	   0,
      139935,
       47155,
	   0,
      203653,
      101595,
       45927,
	   0,
      101600,
       45932,
	   0,
      129531,
       46029,
	   0,
      226951,
      148088,
      129532,
       46030,
	   0,
      129533,
       87782,
       46031,
	   0,
      189843,
      166648,
       46034,
	   0,
       82940,
       45828,
	   0,
       82974,
       45862,
	   0,
      129392,
      101558,
       45890,
	   0,
      147949,
       45891,
	   0,
      175785,
      147951,
      129395,
       96922,
       45893,
	   0,
      224903,
      150679,
       43982,
	   0,
       53337,
       44059,
	   0,
      225002,
      136861,
       44081,
	   0,
      136862,
       44082,
	   0,
      122948,
       44085,
	   0,
      104185,
       43878,
	   0,
       53188,
       43910,
	   0,
       90333,
       43943,
	   0,
       90336,
       43946,
	   0,
      117871,
       43647,
	   0,
      117873,
       43649,
	   0,
      117875,
       43651,
	   0,
      117876,
       43652,
	   0,
      117880,
       43656,
	   0,
      117881,
       43657,
	   0,
       90124,
       53012,
       43734,
	   0,
       90127,
       43737,
	   0,
      257136,
      122605,
       90132,
       43742,
	   0,
      238585,
       43747,
	   0,
      238586,
       43748,
	   0,
      238587,
       43749,
	   0,
      122613,
       43750,
	   0,
      155090,
       43754,
	   0,
      173648,
       43756,
	   0,
      159732,
      155093,
       43757,
	   0,
      104066,
       43759,
	   0,
      117984,
      104067,
       43760,
	   0,
      224684,
       53041,
       43763,
	   0,
      243030,
       43553,
	   0,
      210589,
      178116,
       43585,
	   0,
      210590,
      178117,
       43586,
	   0,
      210591,
       43587,
	   0,
      178147,
       43616,
	   0,
       75474,
       43001,
	   0,
       52362,
       43084,
	   0,
       52184,
       42906,
	   0,
       51870,
       42592,
	   0,
      237460,
       70456,
       42622,
	   0,
       61202,
       42646,
	   0,
      129480,
       41339,
	   0,
      203647,
       50560,
       41282,
	   0,
       83062,
       41311,
	   0,
      203723,
       41358,
	   0,
      148061,
       41364,
	   0,
      148062,
       41365,
	   0,
       68606,
       40772,
	   0,
      136891,
      118335,
       39472,
	   0,
       84924,
       38534,
	   0,
       84926,
       38536,
	   0,
       75499,
       38387,
	   0,
       84251,
       37861,
	   0,
      237351,
      228073,
      190961,
       37874,
	   0,
      162375,
       92790,
       37122,
	   0,
      162380,
       37127,
	   0,
      180260,
       36451,
	   0,
       91218,
       35550,
	   0,
      225087,
      201892,
       34888,
	   0,
      201893,
       34889,
	   0,
      132310,
       34891,
	   0,
      201896,
      132311,
       72004,
       34892,
	   0,
      132312,
       34893,
	   0,
       72006,
       34894,
	   0,
      201899,
       81285,
       72007,
       34895,
	   0,
       81286,
       72008,
       34896,
	   0,
      201901,
      118399,
       81287,
       34897,
	   0,
      118401,
       34899,
	   0,
      118402,
       34900,
	   0,
      225104,
      118407,
       34905,
	   0,
      225105,
       34906,
	   0,
      225106,
       34907,
	   0,
       53506,
       34950,
	   0,
      220511,
      137009,
       53507,
       34951,
	   0,
      137010,
       34952,
	   0,
      137011,
      132372,
       53509,
       34953,
	   0,
      137012,
       53510,
       34954,
	   0,
      132376,
      113820,
       53513,
       34957,
	   0,
      132377,
      113821,
       34958,
	   0,
      202030,
       35026,
	   0,
      262346,
       35035,
	   0,
      262351,
      132459,
       35040,
	   0,
      132460,
       35041,
	   0,
      146411,
       35075,
	   0,
      174261,
       35091,
	   0,
      224999,
       34800,
	   0,
      118303,
       34801,
	   0,
      225001,
      136860,
       34802,
	   0,
       53376,
       34820,
	   0,
      136892,
      118336,
       34834,
	   0,
      136893,
      118337,
       34835,
	   0,
      155173,
       34559,
	   0,
      108717,
       53049,
       34493,
	   0,
       84927,
       38537,
       33898,
	   0,
       98811,
       33865,
	   0,
      200406,
       33402,
	   0,
       42682,
       33404,
	   0,
       51777,
       33221,
	   0,
      158329,
       33076,
	   0,
      153465,
       32851,
	   0,
       88538,
       56065,
       32870,
	   0,
      146925,
       30950,
	   0,
      202029,
       30386,
	   0,
      132030,
       29972,
	   0,
       53170,
       29975,
	   0,
       52530,
       29335,
	   0,
      172123,
       28314,
	   0,
       50884,
       27689,
	   0,
       96265,
       26680,
	   0,
      244768,
       49930,
       26735,
	   0,
      212290,
       26730,
	   0,
       73115,
       26725,
	   0,
      128780,
       26722,
	   0,
       49909,
       26714,
	   0,
       96268,
       26683,
	   0,
      138187,
       26851,
	   0,
       40769,
       26852,
	   0,
      267960,
      230848,
       26732,
	   0,
      267961,
       49928,
       26733,
	   0,
       49934,
       26739,
	   0,
       49935,
       26740,
	   0,
      263330,
       26741,
	   0,
      207126,
       26205,
	   0,
      207127,
       26206,
	   0,
      193211,
      128265,
       26207,
	   0,
       95651,
       26066,
	   0,
      137403,
       26067,
	   0,
      197027,
       43940,
       25384,
	   0,
      173847,
       25399,
	   0,
      150681,
       25428,
	   0,
       75149,
       42676,
       24120,
	   0,
      200403,
       24121,
	   0,
      200409,
       24127,
	   0,
       55325,
       22852,
	   0,
       41476,
       22920,
	   0,
       50768,
       22934,
	   0,
      134272,
       22936,
	   0,
       50771,
       22937,
	   0,
       50774,
       22940,
	   0,
       50776,
       22942,
	   0,
      236340,
       22946,
	   0,
      236341,
       22947,
	   0,
      236342,
       22948,
	   0,
      236343,
       22949,
	   0,
      115730,
       22950,
	   0,
      129650,
       22953,
	   0,
      115734,
       22954,
	   0,
      236349,
       22955,
	   0,
      115736,
       22956,
	   0,
      236351,
       22957,
	   0,
      115739,
       22959,
	   0,
      134296,
       22960,
	   0,
       83060,
       22753,
	   0,
      129482,
       92370,
       22785,
	   0,
       92371,
       22786,
	   0,
       46010,
       22815,
	   0,
       46011,
       22816,
	   0,
      148070,
       46012,
       22817,
	   0,
      175905,
      148071,
       22818,
	   0,
      148074,
       22821,
	   0,
      148079,
       22826,
	   0,
       53046,
       20573,
	   0,
       43735,
       20540,
	   0,
      210451,
      177978,
       20252,
	   0,
      117754,
       20335,
	   0,
      150251,
       20359,
	   0,
      140799,
       20185,
	   0,
      191830,
      140801,
       20187,
	   0,
      140832,
       34135,
       20218,
	   0,
       52399,
       19926,
	   0,
      200930,
       20009,
	   0,
       38416,
       19860,
	   0,
      191505,
       38418,
       19862,
	   0,
      154422,
       89476,
       19891,
	   0,
       89477,
       19892,
	   0,
      172980,
       43088,
       19893,
	   0,
       38452,
       19896,
	   0,
      209786,
      154118,
       19587,
	   0,
      216800,
       49796,
       17323,
	   0,
      221406,
      114709,
       17290,
	   0,
      257184,
       15956,
	   0,
       90220,
       15996,
	   0,
      242982,
      140924,
       15671,
	   0,
      214601,
       15124,
	   0,
       28282,
       14365,
	   0,
      116098,
       27957,
       14040,
	   0,
      116100,
       83627,
       14042,
	   0,
       26982,
       13065,
	   0,
      132374,
       34955,
       11760,
	   0,
       43624,
       11151,
	   0,
      178165,
       11161,
	   0,
      247751,
       11162,
	   0,
      192155,
       11234,
	   0,
       43708,
       11235,
	   0,
      122572,
       90099,
       11236,
	   0,
       43720,
       11247,
	   0,
      173615,
       11250,
	   0,
      104035,
       11255,
	   0,
      141148,
      104036,
       11256,
	   0,
      104037,
       11257,
	   0,
       90122,
       53010,
       11259,
	   0,
      201459,
      122596,
       53011,
       11260,
	   0,
      141155,
       90126,
       43736,
       11263,
	   0,
      150542,
       90235,
       11372,
	   0,
       94588,
       11086,
	   0,
      210592,
       11115,
	   0,
       43590,
       11117,
	   0,
      247715,
       11126,
	   0,
       85029,
       10805,
	   0,
       97902,
	9761,
	   0,
      227848,
	9815,
	   0,
      236482,
	9171,
	   0,
      262479,
	7334,
	   0,
      132470,
	7217,
	   0,
      190840,
      107338,
	5280,
	   0,
      231372,
       50451,
	4061,
	   0,
      240273,
	3684,
	   0,
      249485,
      138149,
	3618,
	   0,
      174686,
	3043,
	   0,
      234996,
	3046,
	   0,
      170052,
	3048,
	   0,
      230496,
	3185,
	   0,
      128478,
	3225,
	   0,
      239568,
	2979,
	   0,
       75587,
       70948,
       52392,
	1363,
	   0,
      256499,
      237943,
       52383,
	1354,
	   0,
      256490,
       38457,
	1345,
	   0,
       84828,
	1326,
	   0,
       52424,
	1395,
	   0,
      224259,
	1587,
	   0,
      195856,
	1018,
	   0,
       51774,
	 745,
	   0,
      172129,
	 486,
	   0,
      190810,
	 611,
	   0
	  };

short def_action[] = {
    1107,
       0,
    1238,
       0,
    1108,
       0,
    1107,
    1062,
       0,
    1109,
    1239,
    1107,
       0,
    1053,
    1052,
       0,
    1248,
       0,
       0,
       0,
       0,
       0,
    1054,
    1055,
    1056,
    1057,
    1058,
       0,
    1061,
       0,
    1059,
    1060,
       0,
       0,
    1242,
    1241,
    1244,
     915,
    1073,
    1076,
    1075,
    1074,
       0,
       0,
    1018,
    1107,
    1005,
    1204,
    1204,
    1010,
    1008,
    1009,
       0,
       0,
       0,
     828,
     829,
     961,
     962,
    1172,
       0,
       0,
       0,
     909,
     910,
     911,
     912,
     913,
     914,
       0,
     946,
     947,
     948,
     949,
     950,
     951,
    1170,
     942,
    1167,
       0,
     941,
       0,
     934,
     935,
     936,
     937,
     933,
     938,
    1113,
     915,
    1111,
       0,
    1107,
       0,
       0,
    1249,
    1119,
       0,
       0,
    1079,
       0,
    1204,
       0,
       0,
       0,
    1145,
     899,
    1006,
       0,
    1205,
       0,
       0,
    1125,
       0,
       0,
    1107,
     943,
       0,
     944,
     945,
     968,
    1147,
    1149,
    1141,
     949,
     885,
       0,
     895,
     896,
     928,
       0,
       0,
     916,
       0,
       0,
     963,
     964,
     965,
     966,
    1168,
       0,
     958,
     959,
     960,
       0,
     939,
     952,
     953,
     954,
     955,
     956,
     957,
       0,
    1166,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
    1110,
    1243,
    1216,
       0,
    1063,
     845,
    1208,
       0,
    1252,
    1107,
    1255,
    1107,
    1107,
     904,
     905,
     906,
     907,
     908,
    1095,
    1096,
    1097,
    1098,
    1099,
       0,
     830,
     831,
     832,
     833,
     834,
     835,
     836,
     837,
     838,
     839,
     840,
       0,
     846,
     847,
     848,
       0,
    1220,
       0,
       0,
       0,
       0,
       0,
       0,
     900,
     901,
     902,
     903,
    1206,
       0,
       0,
       0,
       0,
       0,
    1107,
       0,
    1212,
    1173,
       0,
     969,
       0,
       0,
     884,
       0,
       0,
     967,
     922,
     923,
     924,
     925,
     926,
     917,
     918,
     919,
     920,
     921,
    1151,
     930,
       0,
     949,
    1171,
    1169,
       0,
    1164,
    1154,
    1156,
    1158,
       0,
    1157,
       0,
    1155,
       0,
    1153,
       0,
    1114,
    1112,
       0,
    1245,
       0,
       0,
    1250,
    1209,
    1214,
       0,
    1121,
       0,
       0,
       0,
       0,
       0,
    1256,
    1194,
    1176,
    1146,
     909,
     914,
       0,
       0,
       0,
       0,
       0,
    1221,
    1028,
    1117,
       0,
       0,
       0,
       0,
       0,
    1107,
       0,
    1208,
    1255,
    1007,
    1126,
    1067,
       0,
       0,
       0,
       0,
    1255,
       0,
    1107,
     970,
       0,
     927,
       0,
       0,
     864,
     865,
     866,
       0,
       0,
       0,
     940,
    1160,
    1161,
    1159,
    1162,
       0,
    1023,
    1120,
    1115,
    1251,
       0,
    1215,
    1137,
       0,
       0,
       0,
     878,
     879,
       0,
       0,
       0,
       0,
       0,
    1085,
    1086,
    1122,
    1080,
    1254,
    1253,
    1089,
    1257,
    1259,
       0,
    1094,
       0,
       0,
    1091,
       0,
    1107,
    1107,
    1184,
       0,
       0,
       0,
     898,
    1214,
    1121,
    1143,
       0,
       0,
       0,
    1029,
    1219,
       0,
    1115,
       0,
    1118,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
    1011,
       0,
    1013,
    1209,
    1015,
       0,
       0,
    1107,
    1107,
    1186,
       0,
    1186,
    1213,
    1148,
    1150,
    1142,
       0,
     929,
       0,
    1217,
       0,
       0,
       0,
       0,
       0,
    1078,
     897,
    1123,
       0,
       0,
       0,
    1082,
    1083,
    1084,
       0,
       0,
    1210,
       0,
    1174,
       0,
    1177,
     973,
     972,
    1198,
       0,
       0,
       0,
    1202,
    1198,
       0,
       0,
     974,
     975,
     976,
     977,
     978,
     979,
     980,
     981,
     982,
     983,
    1037,
    1038,
    1039,
    1107,
       0,
       0,
     909,
       0,
       0,
     984,
     985,
     986,
     987,
     988,
     989,
       0,
       0,
    1107,
       0,
       0,
       0,
       0,
    1107,
     872,
     873,
       0,
    1129,
       0,
    1129,
     871,
       0,
     850,
     851,
     852,
     853,
     854,
     855,
     856,
    1144,
       0,
    1107,
    1107,
    1068,
    1115,
       0,
       0,
     858,
     859,
     860,
     861,
     862,
    1124,
       0,
    1115,
    1024,
    1025,
    1107,
       0,
    1027,
    1064,
    1207,
    1115,
    1014,
    1088,
       0,
    1194,
       0,
    1187,
    1087,
    1019,
    1152,
    1077,
    1116,
    1022,
       0,
     891,
    1115,
       0,
    1133,
    1131,
     949,
    1081,
       0,
    1090,
    1260,
       0,
    1211,
       0,
    1196,
    1195,
    1107,
       0,
    1199,
    1236,
       0,
       0,
       0,
    1203,
    1200,
    1017,
       0,
       0,
     991,
    1232,
    1204,
       0,
       0,
       0,
       0,
    1189,
    1107,
    1185,
       0,
       0,
     994,
       0,
       0,
    1263,
    1261,
    1101,
    1100,
     849,
     863,
       0,
    1135,
     875,
     874,
    1130,
     877,
     876,
    1127,
     869,
     870,
     868,
     857,
       0,
       0,
    1222,
    1224,
       0,
       0,
     841,
       0,
       0,
       0,
    1026,
    1012,
    1107,
       0,
    1020,
    1138,
     892,
     881,
       0,
       0,
       0,
    1258,
    1016,
    1246,
    1070,
    1071,
    1197,
    1175,
    1072,
       0,
    1036,
    1004,
    1003,
       0,
       0,
       0,
       0,
    1107,
    1230,
       0,
       0,
       0,
       0,
    1228,
       0,
    1107,
    1107,
     998,
     999,
       0,
    1193,
    1107,
    1107,
     990,
    1105,
       0,
    1107,
       0,
       0,
       0,
       0,
       0,
    1066,
    1107,
    1107,
       0,
       0,
     843,
     844,
     842,
    1065,
    1186,
       0,
     883,
       0,
       0,
     882,
       0,
       0,
    1050,
    1002,
    1201,
     992,
    1106,
       0,
       0,
    1235,
    1180,
       0,
    1041,
       0,
    1107,
    1107,
    1042,
    1043,
    1044,
    1107,
    1033,
       0,
       0,
    1035,
    1194,
       0,
    1190,
       0,
    1178,
    1107,
       0,
       0,
    1262,
       0,
     886,
    1107,
    1107,
    1107,
       0,
       0,
       0,
     867,
    1194,
    1223,
    1107,
    1186,
    1204,
       0,
    1134,
    1132,
       0,
       0,
       0,
    1107,
    1237,
    1107,
    1107,
    1107,
       0,
    1107,
    1107,
    1107,
    1046,
    1045,
       0,
    1204,
       0,
       0,
       0,
    1191,
    1182,
       0,
    1180,
    1264,
       0,
       0,
       0,
     889,
     888,
       0,
       0,
       0,
    1128,
       0,
    1225,
    1030,
       0,
    1226,
       0,
    1021,
       0,
     880,
    1247,
    1069,
       0,
       0,
    1232,
       0,
    1181,
    1233,
    1047,
    1186,
    1229,
    1186,
    1186,
    1000,
       0,
    1141,
       0,
       0,
    1102,
       0,
    1103,
    1115,
    1107,
    1186,
    1032,
       0,
       0,
       0,
    1231,
       0,
       0,
       0,
       0,
    1183,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
       0,
    1204,
       0,
       0,
    1040,
    1034,
    1001,
     997,
       0,
    1107,
    1107,
       0,
       0,
     890,
    1139,
       0,
    1031,
    1227,
       0,
    1048,
     995,
     996,
    1179,
     993,
    1104,
       0,
    1141,
    1049,
    1140,
       0,
       0,
       0,
    1107,
     893,
     894
	  };

/*  The following array has 1's set for the following node kinds:
AS_CONSTRAINT 
AS_ENUM 
AS_DECLARATIONS 
AS_LABELS 
AS_AGGREGATE 
AS_TERMINATE_ALT 
AS_ABORT 
AS_ARG_ASSOC_LIST 
AS_WITH 
AS_WITH_USE_LIST 
AS_EXCEPTION 
AS_EXCEPT_DECL 
AS_GENERIC_FORMALS 
AS_LIST 
AS_USE 
*/
char islist_node[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  1,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0
    };

/*  The following array has 1's set for the following node kinds:
AS_SUBPROGRAM_STUB 
AS_PACKAGE_STUB 
AS_TASK_STUB 
AS_SUBPROGRAM 
AS_PACKAGE_BODY 
AS_TASK 
AS_SUBPROGRAM_DECL 
AS_PACKAGE_SPEC 
AS_TASK_SPEC 
AS_TASK_TYPE_SPEC 
AS_GENERIC_FUNCTION 
AS_GENERIC_PROCEDURE 
AS_GENERIC_PACKAGE 
AS_PACKAGE_INSTANCE 
AS_FUNCTION_INSTANCE 
AS_PROCEDURE_INSTANCE 
AS_USE 
AS_PRAGMA 
*/
char islater_declarative_node[] = {
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  1,
	  1,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

/*  The following array has 1's set for the following node kinds:
AS_SUBPROGRAM_STUB 
AS_PACKAGE_STUB 
AS_TASK_STUB 
AS_SUBPROGRAM 
AS_PACKAGE_BODY 
AS_TASK 
*/
char isbody_node[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

/*  The following array has 1's set for the following node kinds:
AS_STRING_LITERAL 
AS_GENERIC 
AS_MODE 
AS_OPERATOR 
AS_REAL_LITERAL 
AS_INT_LITERAL 
AS_SIMPLE_NAME 
AS_CHARACTER_LITERAL 
AS_STRING 
AS_TASK_STUB 
AS_PACKAGE_STUB 
AS_LINE_NO 
*/
char isval_node[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0
    };

/*  The following array has 1's set for the following node kinds:
AS_PRAGMA 
AS_OBJ_DECL 
AS_CONST_DECL 
AS_NUM_DECL 
AS_TYPE_DECL 
AS_SUBTYPE_DECL 
AS_SUBTYPE_INDIC 
AS_DERIVED_TYPE 
AS_OP 
AS_UN_OP 
AS_RANGE 
AS_INT_TYPE 
AS_FLOAT_TYPE 
AS_FIXED_TYPE 
AS_DIGITS 
AS_DELTA 
AS_RANGE_ATTRIBUTE 
AS_RANGE_EXPRESSION 
AS_ARRAY_TYPE 
AS_BOX 
AS_SUBTYPE 
AS_RECORD 
AS_COMPONENT_LIST 
AS_FIELD 
AS_DISCR_SPEC 
AS_VARIANT_DECL 
AS_VARIANT_CHOICES 
AS_RANGE_CHOICE 
AS_SIMPLE_CHOICE 
AS_CHOICE_UNRESOLVED 
AS_ACCESS_TYPE 
AS_INCOMPLETE_DECL 
AS_CALL_UNRESOLVED 
AS_SELECTOR 
AS_ATTRIBUTE 
AS_PARENTHESIS 
AS_NOTIN 
AS_ANY_OP 
AS_IN 
AS_NAME 
AS_QUALIFY 
AS_NEW 
AS_NEW_INIT 
AS_STATEMENTS 
AS_STATEMENT 
AS_ASSIGNMENT 
AS_IF 
AS_CONDITION 
AS_COND_STATEMENTS 
AS_CASE 
AS_CASE_STATEMENTS 
AS_LOOP 
AS_WHILE 
AS_FOR 
AS_FORREV 
AS_BLOCK 
AS_EXIT 
AS_RETURN 
AS_GOTO 
AS_SUBPROGRAM_DECL 
AS_PROCEDURE 
AS_FUNCTION 
AS_FORMAL 
AS_SUBPROGRAM 
AS_CALL 
AS_PACKAGE_SPEC 
AS_PACKAGE_BODY 
AS_PRIVATE_DECL 
AS_RENAME_PACK 
AS_RENAME_SUB 
AS_TASK_SPEC 
AS_TASK_TYPE_SPEC 
AS_TASK 
AS_DELAY 
AS_SELECTIVE_WAIT 
AS_GUARD 
AS_ACCEPT_ALT 
AS_DELAY_ALT 
AS_CONDITIONAL_ENTRY_CALL 
AS_TIMED_ENTRY_CALL 
AS_UNIT 
AS_SUBPROGRAM_STUB 
AS_SEPARATE 
AS_HANDLER 
AS_RAISE 
AS_GENERIC_FUNCTION 
AS_GENERIC_PROCEDURE 
AS_GENERIC_PACKAGE 
AS_GENERIC_OBJ 
AS_GENERIC_TYPE 
AS_GEN_PRIV_TYPE 
AS_GENERIC_SUBP 
AS_INSTANCE 
AS_PACKAGE_INSTANCE 
AS_FUNCTION_INSTANCE 
AS_PROCEDURE_INSTANCE 
AS_LENGTH_CLAUSE 
AS_ENUM_REP_CLAUSE 
AS_REC_REP_CLAUSE 
AS_COMPON_CLAUSE 
AS_ADDRESS_CLAUSE 
AS_CODE 
AS_ARG 
AS_SELECTOR 
AS_CHOICE_LIST 
AS_RENAME_OBJ 
AS_RENAME_EX 
AS_ENTRY 
AS_ENTRY_FAMILY 
AS_ACCEPT 
AS_ALL 
*/
char isast_node[] = {
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  0,
	  1,
	  0,
	  0,
	  1,
	  0,
	  0,
	  1,
	  0,
	  0,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0
    };

char *overloadable_operators[] = {
    "+",
    "-",
    "*",
    "/",
    "**",
    "&",
    "=",
    "<",
    ">",
    "<=",
    ">=",
    "/=",
    "abs",
    "or",
    "and",
    "not",
    "xor",
    "mod",
    "rem"
    };

char ispredef_pragma[] = {
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char isimpldef_pragma[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1
    };

char isimmediate_decl_pragma[] = {
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char iscontext_pragma[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char iscompilation_pragma[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char isafter_libunit_pragma[] = {
	  0,
	  1,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char istask_pragma[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

char isrepr_pragma[] = {
	  0,
	  0,
	  0,
	  0,
	  0,
	  1,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0,
	  0
    };

