PROCEDURE ReadScores (Scores : OUT ScoreArray;
                      ClassSize : OUT ClassRange) IS

-- Reads an array of exam scores (Scores)
-- for a class of up to MaxSize students.
-- Pre : None
-- Post: The data values are stored in array Scores.
--       The number of values read is stored in ClassSize.
  
  Sentinel : CONSTANT Integer := -1;  -- Sentinel value   
  TempScore : Integer;              -- Temporary storage for a score   
  TempSize : ClassRange;

BEGIN -- ReadScores

  Ada.Text_IO.Put(Item => "Enter next score after the prompt or -1 to stop.");
  Ada.Text_IO.New_Line;

  TempSize := 0;                         -- initial class size   
  -- Read each array element until done.   
  LOOP
    -- invariant:
    --   No prior value read is Sentinel and
    --   ClassSize <= MaxSize
      
    RobustInput.Get(Item => TempScore, 
                    MinVal => Sentinel,
                    MaxVal => ScoreRange'Last);

    EXIT WHEN (TempScore = Sentinel) OR (ClassSize = MaxSize);

    TempSize := TempSize + 1;
    Scores(TempSize) := TempScore;     -- Save the score   

  END LOOP;      
  -- assert:
  --   Last value read is Sentinel or
  --   TempSize is MaxSize
    
  IF TempSize = MaxSize THEN
    Ada.Text_IO.Put(Item => "Array is filled.");  
    Ada.Text_IO.New_Line;
  END IF;

  ClassSize := TempSize;

END ReadScores;
