PROCEDURE Enter_Move (Player : GameSymbol;
                     TicTacToe : IN OUT BoardArray) IS
-- Pre : Player is "X" or "O" and array TicTacToe has at least
--       one empty cell.
-- Post: The value of Player is stored in the empty cell of      
--       TicTacToe whose coordinates are read in; the rest
--       of array TicTacToe is unchanged.
  
  MoveRow    : MoveRange;    -- coordinates of selected cell   
  MoveColumn : MoveRange;

BEGIN  -- Enter_Move   

  LOOP
    Ada.Text_IO.Put(Item => "Enter your move row and then the column");
    Ada.Text_IO.New_Line;
    RobustInput.Get (MinVal => 1, MaxVal => 3, Item => MoveRow);
    RobustInput.Get (MinVal => 1, MaxVal => 3, Item => MoveColumn);
    
    IF TicTacToe(MoveRow, MoveColumn) = Empty THEN
      EXIT;
    ELSE
      Ada.Text_IO.Put(Item => "Cell is occupied - try again");  
      Ada.Text_IO.New_Line;
    END IF;
  END LOOP;
  -- assertion: A valid move is entered   

  TicTacToe(MoveRow, MoveColumn) := Player;  -- Define cell   

END Enter_Move;
