
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: pdcurses.ads "pdcurses.ads"
--        Date: 5/25/95
-- Description: Package spec for the Ada-curses binding.
--    Revision: This is part of total rewrite of the original
--              binding.  This new version should be more
--              portable and maintainable.
------------------------------------------------------------

with c;
with system;

package pdcurses is
   type bool is new c.unsigned_char;                           -- curses.h:561
   subtype chtype is c.unsigned_int;                           -- curses.h:570

--
-- Constants defined in the curses header file.  The following code was 
-- generated by cbind.  Some of these constants are used only by the C 
-- preprocessor and are limited value to Ada programs, but most of them
-- don't fall into that category.
--
   PDCURSES            : constant := 1;                        -- curses.h:136
   XOPEN               : constant := 1;                        -- curses.h:137
   SYSVCURSES          : constant := 1;                        -- curses.h:138
   BSDCURSES           : constant := 1;                        -- curses.h:139
   GO32                : constant := 1;                        -- curses.h:365
   HAVE_PROTO          : constant := 1;                        -- curses.h:368
   DOS                 : constant := 6;                        -- curses.h:371
   FALSE               : constant := 8#0000#;                  -- curses.h:540
   TRUE                : constant := 8#0001#;                  -- curses.h:543
   ERR                 : constant := 8#0000#;                  -- curses.h:549
   OK                  : constant := 1;                        -- curses.h:552
   BUTTON_RELEASED     : constant := 8#0000#;                  -- curses.h:595
   BUTTON_PRESSED      : constant := 8#0001#;                  -- curses.h:596
   BUTTON_CLICKED      : constant := 8#0002#;                  -- curses.h:597
   BUTTON_DOUBLE_CLICKED: constant := 8#0003#;                 -- curses.h:598
   BUTTON_TRIPLE_CLICKED: constant := 8#0004#;                 -- curses.h:599
   BUTTON_MOVED         : constant := 8#0005#;                 -- curses.h:600
   BUTTON_ACTION_MASK   : constant := 8#0007#;                 -- curses.h:601
   BUTTON_SHIFT         : constant := 8#0010#;                 -- curses.h:602
   BUTTON_CONTROL       : constant := 8#0020#;                 -- curses.h:603
   BUTTON_ALT           : constant := 8#0040#;                 -- curses.h:604
   BUTTON_MODIFER_MASK  : constant := 8#0070#;                 -- curses.h:605
   BUTTON1_RELEASED     : constant := 8#0001#;                 -- curses.h:620
   BUTTON1_PRESSED      : constant := 8#0002#;                 -- curses.h:621
   BUTTON1_CLICKED      : constant := 8#0004#;                 -- curses.h:622
   BUTTON1_DOUBLE_CLICKED: constant := 8#0010#;                -- curses.h:623
   BUTTON1_TRIPLE_CLICKED: constant := 8#0020#;                -- curses.h:624
   BUTTON2_RELEASED      : constant := 8#0040#;                -- curses.h:625
   BUTTON2_PRESSED       : constant := 8#0100#;                -- curses.h:626
   BUTTON2_CLICKED       : constant := 8#0200#;                -- curses.h:627
   BUTTON2_DOUBLE_CLICKED: constant := 8#0400#;                -- curses.h:628
   BUTTON2_TRIPLE_CLICKED: constant := 8#1000#;                -- curses.h:629
   BUTTON3_RELEASED      : constant := 8#2000#;                -- curses.h:630
   BUTTON3_PRESSED       : constant := 8#4000#;                -- curses.h:631
   BUTTON3_CLICKED       : constant := 8#10000#;               -- curses.h:632
   BUTTON3_DOUBLE_CLICKED: constant := 8#20000#;               -- curses.h:633
   BUTTON3_TRIPLE_CLICKED: constant := 8#40000#;               -- curses.h:634
   BUTTON_MODIFIER_SHIFT : constant := 8#100000#;              -- curses.h:635
   BUTTON_MODIFIER_CONTROL: constant := 8#200000#;             -- curses.h:636
   BUTTON_MODIFIER_ALT    : constant := 8#400000#;             -- curses.h:637
   ALL_MOUSE_EVENTS       : constant := 8#777777#;             -- curses.h:638
   REPORT_MOUSE_POSITION  : constant := 8#1000000#;            -- curses.h:639
   A_NORMAL               : constant := 16#0000#;              -- curses.h:842
   A_STANDOUT             : constant := 16#00A0_0000#;         -- curses.h:843
   A_BOLD                 : constant := 16#0080_0000#;         -- curses.h:844
   A_UNDERLINE            : constant := 16#0010_0000#;         -- curses.h:845
   A_REVERSE              : constant := 16#0020_0000#;         -- curses.h:846
   A_BLINK                : constant := 16#0040_0000#;         -- curses.h:847
   A_DIM                  : constant := 16#0002_0000#;         -- curses.h:848
   A_INVIS                : constant := 16#0008_0000#;         -- curses.h:849
   A_PROTECT              : constant := 16#0001_0000#;         -- curses.h:850
   A_ALTCHARSET           : constant := 16#0004_0000#;         -- curses.h:851
   A_ATTRIBUTES           : constant := 16#FFFF_0000#;         -- curses.h:852
   A_CHARTEXT             : constant := 16#0000_FFFF#;         -- curses.h:853
   A_COLOR                : constant := 16#FF00_0000#;         -- curses.h:854
   CHR_MSK                : constant := 16#0000_FFFF#;         -- curses.h:873
   ATR_MSK                : constant := 16#FFFF_0000#;         -- curses.h:874
   ATR_NRM                : constant := 16#0000#;              -- curses.h:875
   ACS_ULCORNER           : constant chtype := 16#00DA#;       -- curses.h:930
   ACS_LLCORNER           : constant chtype := 16#00C0#;       -- curses.h:931
   ACS_URCORNER           : constant chtype := 16#00BF#;       -- curses.h:932
   ACS_LRCORNER           : constant chtype := 16#00D9#;       -- curses.h:933
   ACS_RTEE               : constant chtype := 180;            -- curses.h:934
   ACS_LTEE               : constant chtype := 195;            -- curses.h:935
   ACS_BTEE               : constant chtype := 193;            -- curses.h:936
   ACS_TTEE               : constant chtype := 194;            -- curses.h:937
   ACS_HLINE              : constant chtype := 196;            -- curses.h:938
   ACS_VLINE              : constant chtype := 179;            -- curses.h:939
   ACS_PLUS               : constant chtype := 197;            -- curses.h:940
   ACS_S1                 : constant chtype := 45;             -- curses.h:941
   ACS_S9                 : constant chtype := 95;             -- curses.h:942
   ACS_DIAMOND            : constant chtype := 197;            -- curses.h:943
   ACS_CKBOARD            : constant chtype := 178;            -- curses.h:944
   ACS_DEGREE             : constant chtype := 248;            -- curses.h:945
   ACS_PLMINUS            : constant chtype := 241;            -- curses.h:946
   ACS_BULLET             : constant chtype := 249;            -- curses.h:947
   ACS_LARROW             : constant chtype := 60;             -- curses.h:948
   ACS_RARROW             : constant chtype := 62;             -- curses.h:949
   ACS_DARROW             : constant chtype := 118;            -- curses.h:950
   ACS_UARROW             : constant chtype := 94;             -- curses.h:951
   ACS_BOARD              : constant chtype := 35;             -- curses.h:952
   ACS_LANTERN            : constant chtype := 35;             -- curses.h:953
   ACS_BLOCK              : constant chtype := 35;             -- curses.h:954
   COLOR_BLACK            : constant := 8#0000#;               -- curses.h:982
   COLOR_BLUE             : constant := 1;                     -- curses.h:983
   COLOR_GREEN            : constant := 2;                     -- curses.h:984
   COLOR_CYAN             : constant := 3;                     -- curses.h:985
   COLOR_RED              : constant := 4;                     -- curses.h:986
   COLOR_MAGENTA          : constant := 5;                     -- curses.h:987
   COLOR_YELLOW           : constant := 6;                     -- curses.h:988
   COLOR_WHITE            : constant := 7;                     -- curses.h:989
   KEY_MIN                : constant := 16#0101#;              -- curses.h:1018
   KEY_BREAK              : constant := 16#0101#;              -- curses.h:1019
   KEY_DOWN               : constant := 16#0102#;              -- curses.h:1020
   KEY_UP                 : constant := 16#0103#;              -- curses.h:1021
   KEY_LEFT               : constant := 16#0104#;              -- curses.h:1022
   KEY_RIGHT              : constant := 16#0105#;              -- curses.h:1023
   KEY_HOME               : constant := 16#0106#;              -- curses.h:1024
   KEY_BACKSPACE          : constant := 16#0107#;              -- curses.h:1025
   KEY_F0                 : constant := 16#0108#;              -- curses.h:1026
   KEY_DL                 : constant := 16#0148#;              -- curses.h:1028
   KEY_IL                 : constant := 16#0149#;              -- curses.h:1029
   KEY_DC                 : constant := 16#014A#;              -- curses.h:1030
   KEY_IC                 : constant := 16#014B#;              -- curses.h:1031
   KEY_EIC                : constant := 16#014C#;              -- curses.h:1032
   KEY_CLEAR              : constant := 16#014D#;              -- curses.h:1033
   KEY_EOS                : constant := 16#014E#;              -- curses.h:1034
   KEY_EOL                : constant := 16#014F#;              -- curses.h:1035
   KEY_SF                 : constant := 16#0150#;              -- curses.h:1036
   KEY_SR                 : constant := 16#0151#;              -- curses.h:1037
   KEY_NPAGE              : constant := 16#0152#;              -- curses.h:1038
   KEY_PPAGE              : constant := 16#0153#;              -- curses.h:1039
   KEY_STAB               : constant := 16#0154#;              -- curses.h:1040
   KEY_CTAB               : constant := 16#0155#;              -- curses.h:1041
   KEY_CATAB              : constant := 16#0156#;              -- curses.h:1042
   KEY_ENTER              : constant := 16#0157#;              -- curses.h:1043
   KEY_SRESET             : constant := 16#0158#;              -- curses.h:1044
   KEY_RESET              : constant := 16#0159#;              -- curses.h:1045
   KEY_PRINT              : constant := 16#015A#;              -- curses.h:1046
   KEY_LL                 : constant := 16#015B#;              -- curses.h:1047
   KEY_ABORT              : constant := 16#015C#;              -- curses.h:1048
   KEY_SHELP              : constant := 16#015D#;              -- curses.h:1049
   KEY_LHELP              : constant := 16#015E#;              -- curses.h:1050
   KEY_BTAB               : constant := 16#015F#;              -- curses.h:1051
   KEY_BEG                : constant := 16#0160#;              -- curses.h:1052
   KEY_CANCEL             : constant := 16#0161#;              -- curses.h:1053
   KEY_CLOSE              : constant := 16#0162#;              -- curses.h:1054
   KEY_COMMAND            : constant := 16#0163#;              -- curses.h:1055
   KEY_COPY               : constant := 16#0164#;              -- curses.h:1056
   KEY_CREATE             : constant := 16#0165#;              -- curses.h:1057
   KEY_END                : constant := 16#0166#;              -- curses.h:1058
   KEY_EXIT               : constant := 16#0167#;              -- curses.h:1059
   KEY_FIND               : constant := 16#0168#;              -- curses.h:1060
   KEY_HELP               : constant := 16#0169#;              -- curses.h:1061
   KEY_MARK               : constant := 16#016A#;              -- curses.h:1062
   KEY_MESSAGE            : constant := 16#016B#;              -- curses.h:1063
   KEY_MOVE               : constant := 16#016C#;              -- curses.h:1064
   KEY_NEXT               : constant := 16#016D#;              -- curses.h:1065
   KEY_OPEN               : constant := 16#016E#;              -- curses.h:1066
   KEY_OPTIONS            : constant := 16#016F#;              -- curses.h:1067
   KEY_PREVIOUS           : constant := 16#0170#;              -- curses.h:1068
   KEY_REDO               : constant := 16#0171#;              -- curses.h:1069
   KEY_REFERENCE          : constant := 16#0172#;              -- curses.h:1070
   KEY_REFRESH            : constant := 16#0173#;              -- curses.h:1071
   KEY_REPLACE            : constant := 16#0174#;              -- curses.h:1072
   KEY_RESTART            : constant := 16#0175#;              -- curses.h:1073
   KEY_RESUME             : constant := 16#0176#;              -- curses.h:1074
   KEY_SAVE               : constant := 16#0177#;              -- curses.h:1075
   KEY_SBEG               : constant := 16#0178#;              -- curses.h:1076
   KEY_SCANCEL            : constant := 16#0179#;              -- curses.h:1077
   KEY_SCOMMAND           : constant := 16#017A#;              -- curses.h:1078
   KEY_SCOPY              : constant := 16#017B#;              -- curses.h:1079
   KEY_SCREATE            : constant := 16#017C#;              -- curses.h:1080
   KEY_SDC                : constant := 16#017D#;              -- curses.h:1081
   KEY_SDL                : constant := 16#017E#;              -- curses.h:1082
   KEY_SELECT             : constant := 16#017F#;              -- curses.h:1083
   KEY_SEND               : constant := 16#0180#;              -- curses.h:1084
   KEY_SEOL               : constant := 16#0181#;              -- curses.h:1085
   KEY_SEXIT              : constant := 16#0182#;              -- curses.h:1086
   KEY_SFIND              : constant := 16#0183#;              -- curses.h:1087
   KEY_SHOME              : constant := 16#0184#;              -- curses.h:1088
   KEY_SIC                : constant := 16#0185#;              -- curses.h:1089
   KEY_SLEFT              : constant := 16#0187#;              -- curses.h:1090
   KEY_SMESSAGE           : constant := 16#0188#;              -- curses.h:1091
   KEY_SMOVE              : constant := 16#0189#;              -- curses.h:1092
   KEY_SNEXT              : constant := 16#018A#;              -- curses.h:1093
   KEY_SOPTIONS           : constant := 16#018B#;              -- curses.h:1094
   KEY_SPREVIOUS          : constant := 16#018C#;              -- curses.h:1095
   KEY_SPRINT             : constant := 16#018D#;              -- curses.h:1096
   KEY_SREDO              : constant := 16#018E#;              -- curses.h:1097
   KEY_SREPLACE           : constant := 16#018F#;              -- curses.h:1098
   KEY_SRIGHT             : constant := 16#0190#;              -- curses.h:1099
   KEY_SRSUME             : constant := 16#0191#;              -- curses.h:1100
   KEY_SSAVE              : constant := 16#0192#;              -- curses.h:1101
   KEY_SSUSPEND           : constant := 16#0193#;              -- curses.h:1102
   KEY_SUNDO              : constant := 16#0194#;              -- curses.h:1103
   KEY_SUSPEND            : constant := 16#0195#;              -- curses.h:1104
   KEY_UNDO               : constant := 16#0196#;              -- curses.h:1105
   ALT_0                  : constant := 16#0197#;              -- curses.h:1109
   ALT_1                  : constant := 16#0198#;              -- curses.h:1110
   ALT_2                  : constant := 16#0199#;              -- curses.h:1111
   ALT_3                  : constant := 16#019A#;              -- curses.h:1112
   ALT_4                  : constant := 16#019B#;              -- curses.h:1113
   ALT_5                  : constant := 16#019C#;              -- curses.h:1114
   ALT_6                  : constant := 16#019D#;              -- curses.h:1115
   ALT_7                  : constant := 16#019E#;              -- curses.h:1116
   ALT_8                  : constant := 16#019F#;              -- curses.h:1117
   ALT_9                  : constant := 16#01A0#;              -- curses.h:1118
   ALT_A                  : constant := 16#01A1#;              -- curses.h:1119
   ALT_B                  : constant := 16#01A2#;              -- curses.h:1120
   ALT_C                  : constant := 16#01A3#;              -- curses.h:1121
   ALT_D                  : constant := 16#01A4#;              -- curses.h:1122
   ALT_E                  : constant := 16#01A5#;              -- curses.h:1123
   ALT_F                  : constant := 16#01A6#;              -- curses.h:1124
   ALT_G                  : constant := 16#01A7#;              -- curses.h:1125
   ALT_H                  : constant := 16#01A8#;              -- curses.h:1126
   ALT_I                  : constant := 16#01A9#;              -- curses.h:1127
   ALT_J                  : constant := 16#01AA#;              -- curses.h:1128
   ALT_K                  : constant := 16#01AB#;              -- curses.h:1129
   ALT_L                  : constant := 16#01AC#;              -- curses.h:1130
   ALT_M                  : constant := 16#01AD#;              -- curses.h:1131
   ALT_N                  : constant := 16#01AE#;              -- curses.h:1132
   ALT_O                  : constant := 16#01AF#;              -- curses.h:1133
   ALT_P                  : constant := 16#01B0#;              -- curses.h:1134
   ALT_Q                  : constant := 16#01B1#;              -- curses.h:1135
   ALT_R                  : constant := 16#01B2#;              -- curses.h:1136
   ALT_S                  : constant := 16#01B3#;              -- curses.h:1137
   ALT_T                  : constant := 16#01B4#;              -- curses.h:1138
   ALT_U                  : constant := 16#01B5#;              -- curses.h:1139
   ALT_V                  : constant := 16#01B6#;              -- curses.h:1140
   ALT_W                  : constant := 16#01B7#;              -- curses.h:1141
   ALT_X                  : constant := 16#01B8#;              -- curses.h:1142
   ALT_Y                  : constant := 16#01B9#;              -- curses.h:1143
   ALT_Z                  : constant := 16#01BA#;              -- curses.h:1144
   CTL_LEFT               : constant := 16#01BB#;              -- curses.h:1145
   CTL_RIGHT              : constant := 16#01BC#;              -- curses.h:1146
   CTL_PGUP               : constant := 16#01BD#;              -- curses.h:1147
   CTL_PGDN               : constant := 16#01BE#;              -- curses.h:1148
   CTL_HOME               : constant := 16#01BF#;              -- curses.h:1149
   CTL_END                : constant := 16#01C0#;              -- curses.h:1150
   KEY_A1                 : constant := 16#01C1#;              -- curses.h:1168
   KEY_A2                 : constant := 16#01C2#;              -- curses.h:1169
   KEY_A3                 : constant := 16#01C3#;              -- curses.h:1170
   KEY_B1                 : constant := 16#01C4#;              -- curses.h:1171
   KEY_B2                 : constant := 16#01C5#;              -- curses.h:1172
   KEY_B3                 : constant := 16#01C6#;              -- curses.h:1173
   KEY_C1                 : constant := 16#01C7#;              -- curses.h:1174
   KEY_C2                 : constant := 16#01C8#;              -- curses.h:1175
   KEY_C3                 : constant := 16#01C9#;              -- curses.h:1176
   PADSLASH               : constant := 16#01CA#;              -- curses.h:1177
   PADENTER               : constant := 16#01CB#;              -- curses.h:1178
   CTL_PADENTER           : constant := 16#01CC#;              -- curses.h:1179
   ALT_PADENTER           : constant := 16#01CD#;              -- curses.h:1180
   PADSTOP                : constant := 16#01CE#;              -- curses.h:1181
   PADSTAR                : constant := 16#01CF#;              -- curses.h:1182
   PADMINUS               : constant := 16#01D0#;              -- curses.h:1183
   PADPLUS                : constant := 16#01D1#;              -- curses.h:1184
   CTL_PADSTOP            : constant := 16#01D2#;              -- curses.h:1185
   CTL_PADCENTER          : constant := 16#01D3#;              -- curses.h:1186
   CTL_PADPLUS            : constant := 16#01D4#;              -- curses.h:1187
   CTL_PADMINUS           : constant := 16#01D5#;              -- curses.h:1188
   CTL_PADSLASH           : constant := 16#01D6#;              -- curses.h:1189
   CTL_PADSTAR            : constant := 16#01D7#;              -- curses.h:1190
   ALT_PADPLUS            : constant := 16#01D8#;              -- curses.h:1191
   ALT_PADMINUS           : constant := 16#01D9#;              -- curses.h:1192
   ALT_PADSLASH           : constant := 16#01DA#;              -- curses.h:1193
   ALT_PADSTAR            : constant := 16#01DB#;              -- curses.h:1194
   ALT_PADSTOP            : constant := 16#01DC#;              -- curses.h:1195
   CTL_INS                : constant := 16#01DD#;              -- curses.h:1196
   ALT_DEL                : constant := 16#01DE#;              -- curses.h:1197
   ALT_INS                : constant := 16#01DF#;              -- curses.h:1198
   CTL_UP                 : constant := 16#01E0#;              -- curses.h:1199
   CTL_DOWN               : constant := 16#01E1#;              -- curses.h:1200
   CTL_TAB                : constant := 16#01E2#;              -- curses.h:1201
   ALT_TAB                : constant := 16#01E3#;              -- curses.h:1202
   ALT_MINUS              : constant := 16#01E4#;              -- curses.h:1203
   ALT_EQUAL              : constant := 16#01E5#;              -- curses.h:1204
   ALT_HOME               : constant := 16#01E6#;              -- curses.h:1205
   ALT_PGUP               : constant := 16#01E7#;              -- curses.h:1206
   ALT_PGDN               : constant := 16#01E8#;              -- curses.h:1207
   ALT_END                : constant := 16#01E9#;              -- curses.h:1208
   ALT_UP                 : constant := 16#01EA#;              -- curses.h:1209
   ALT_DOWN               : constant := 16#01EB#;              -- curses.h:1210
   ALT_RIGHT              : constant := 16#01EC#;              -- curses.h:1211
   ALT_LEFT               : constant := 16#01ED#;              -- curses.h:1212
   ALT_ENTER              : constant := 16#01EE#;              -- curses.h:1213
   ALT_ESC                : constant := 16#01EF#;              -- curses.h:1214
   ALT_BQUOTE             : constant := 16#01F0#;              -- curses.h:1215
   ALT_LBRACKET           : constant := 16#01F1#;              -- curses.h:1216
   ALT_RBRACKET           : constant := 16#01F2#;              -- curses.h:1217
   ALT_SEMICOLON          : constant := 16#01F3#;              -- curses.h:1218
   ALT_FQUOTE             : constant := 16#01F4#;              -- curses.h:1219
   ALT_COMMA              : constant := 16#01F5#;              -- curses.h:1220
   ALT_STOP               : constant := 16#01F6#;              -- curses.h:1221
   ALT_FSLASH             : constant := 16#01F7#;              -- curses.h:1222
   ALT_BKSP               : constant := 16#01F8#;              -- curses.h:1223
   CTL_BKSP               : constant := 16#01F9#;              -- curses.h:1224
   PAD0                   : constant := 16#01FA#;              -- curses.h:1225
   CTL_PAD0               : constant := 16#01FB#;              -- curses.h:1226
   CTL_PAD1               : constant := 16#01FC#;              -- curses.h:1227
   CTL_PAD2               : constant := 16#01FD#;              -- curses.h:1228
   CTL_PAD3               : constant := 16#01FE#;              -- curses.h:1229
   CTL_PAD4               : constant := 16#01FF#;              -- curses.h:1230
   CTL_PAD5               : constant := 16#0200#;              -- curses.h:1231
   CTL_PAD6               : constant := 16#0201#;              -- curses.h:1232
   CTL_PAD7               : constant := 16#0202#;              -- curses.h:1233
   CTL_PAD8               : constant := 16#0203#;              -- curses.h:1234
   CTL_PAD9               : constant := 16#0204#;              -- curses.h:1235
   ALT_PAD0               : constant := 16#0205#;              -- curses.h:1236
   ALT_PAD1               : constant := 16#0206#;              -- curses.h:1237
   ALT_PAD2               : constant := 16#0207#;              -- curses.h:1238
   ALT_PAD3               : constant := 16#0208#;              -- curses.h:1239
   ALT_PAD4               : constant := 16#0209#;              -- curses.h:1240
   ALT_PAD5               : constant := 16#020A#;              -- curses.h:1241
   ALT_PAD6               : constant := 16#020B#;              -- curses.h:1242
   ALT_PAD7               : constant := 16#020C#;              -- curses.h:1243
   ALT_PAD8               : constant := 16#020D#;              -- curses.h:1244
   ALT_PAD9               : constant := 16#020E#;              -- curses.h:1245
   CTL_DEL                : constant := 16#020F#;              -- curses.h:1246
   ALT_BSLASH             : constant := 16#0210#;              -- curses.h:1247
   CTL_ENTER              : constant := 16#0211#;              -- curses.h:1248
   KEY_MOUSE              : constant := 16#0212#;              -- curses.h:1249
   KEY_MAX                : constant := 16#0212#;              -- curses.h:1250
   FAST_VIDEO             : constant := 1;                     -- curspriv.h:114
   EMALLOC                : constant := 8#0000#;               -- curspriv.h:195
   SUBWIN_C0              : constant := 16#0001#;              -- curspriv.h:201
   ENDLINE                : constant := 16#0002#;              -- curspriv.h:202
   FULLWIN                : constant := 16#0004#;              -- curspriv.h:203
   SCROLLWIN              : constant := 16#0008#;              -- curspriv.h:204
   PAD                    : constant := 16#0010#;              -- curspriv.h:205
   SUBPAD_C0              : constant := 16#0020#;              -- curspriv.h:206
   INBUFSIZ               : constant := 16#0200#;              -- curspriv.h:213
   NO_CHANGE              : constant := -1;                    -- curspriv.h:214
   BCHAR                  : constant := 16#0003#;              -- curspriv.h:220
   ECHAR                  : constant := 16#0008#;              -- curspriv.h:221
   DWCHAR                 : constant := 16#0017#;              -- curspriv.h:222
   DLCHAR                 : constant := 16#0015#;              -- curspriv.h:223
   GOCHAR                 : constant := 16#0011#;              -- curspriv.h:224
   PRINTCHAR              : constant := 16#0010#;              -- curspriv.h:225
   STOPCHAR               : constant := 16#0013#;              -- curspriv.h:226
   NUNGETCH               : constant := 20;                    -- curspriv.h:227
   NONE                   : constant := 16#0000#;              -- curspriv.h:258
   MDA                    : constant := 16#0001#;              -- curspriv.h:259
   CGA                    : constant := 16#0002#;              -- curspriv.h:260
   EGACOLOR               : constant := 16#0004#;              -- curspriv.h:261
   EGAMONO                : constant := 16#0005#;              -- curspriv.h:262
   VGACOLOR               : constant := 16#0007#;              -- curspriv.h:263
   VGAMONO                : constant := 16#0008#;              -- curspriv.h:264
   MCGACOLOR              : constant := 16#000A#;              -- curspriv.h:265
   MCGAMONO               : constant := 16#000B#;              -- curspriv.h:266
   FLEXOS                 : constant := 16#0020#;              -- curspriv.h:267
   MDS_GENIUS             : constant := 16#0030#;              -- curspriv.h:268
   UNIX_COLOR             : constant := 16#0040#;              -- curspriv.h:269
   UNIX_MONO              : constant := 16#0041#;              -- curspriv.h:270
   FONT8                  : constant := 8;                     -- curspriv.h:273
   FONT14                 : constant := 14;                    -- curspriv.h:274
   FONT15                 : constant := 15;                    -- curspriv.h:275
   FONT16                 : constant := 16#0010#;              -- curspriv.h:276
   PDC_COLORS             : constant := 8;                     -- curspriv.h:488
   PDC_COLOR_PAIRS        : constant := 16#0040#;              -- curspriv.h:489
   PDC_OFFSET             : constant := 16#0020#;              -- curspriv.h:492
   MAX_ATRTAB             : constant := 2080;                  -- curspriv.h:493

   type attr_t is new c.unsigned_int;                          -- curses.h:579
   type a_chtype_t is access all chtype;                       -- curses.h:675

   type A_WINDOW_T is private;
   type A_SCREEN_T is private;

--
-- The following functions are called via C-wrapper functions and should
-- be available to Ada programs even if they are defined/renamed via
-- #define statements in the curses header file (pseudofunctions).
--
   function addch ( ch : chtype ) return c.signed_int;

   function addstr ( s : c.charp ) return c.signed_int;

   function attrset ( a : attr_t ) return c.signed_int;

   function bkgd ( ch : chtype ) return c.signed_int;

   procedure bkgdset ( ch : chtype );

   function box (
      w : A_WINDOW_T;
      v : chtype;
      h : chtype )
      return c.signed_int;

   function border(
      ls : chtype;
      rs : chtype;
      ts : chtype;
      bs : chtype;
      tl : chtype;
      tr : chtype;
      bl : chtype;
      br : chtype)
      return c.signed_int;

   procedure cbreak;

   function clear return c.signed_int;

   function clrtobot return c.signed_int;

   function clrtoeol return c.signed_int;

   function color_pair ( n: chtype ) return chtype;

   procedure crmode;

   function delch return c.signed_int;

   function deleteln return c.signed_int;

   procedure echo;

   function echochar ( ch : chtype ) return c.signed_int;

   function erase return c.signed_int;

   procedure getbegyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int );

   function getbegx ( w : A_WINDOW_T ) return c.signed_int;

   function getbegy ( w : A_WINDOW_T ) return c.signed_int;

   function getch return c.signed_int;

   function getmaxx ( w : A_WINDOW_T ) return c.signed_int;

   function getmaxy ( w : A_WINDOW_T ) return c.signed_int;

   procedure getmaxyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int );

   function getparx ( w : A_WINDOW_T ) return c.signed_int;

   function getpary ( w : A_WINDOW_T ) return c.signed_int;

   procedure getparyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int );

   function getstr ( str : c.charp ) return c.signed_int;

   procedure getyx (
      w : in     A_WINDOW_T;
      y :    out c.signed_int;
      x :    out c.signed_int );

   procedure inch;

   function inchstr ( ch : a_chtype_t ) return c.signed_int;

   function insch ( ch : chtype ) return c.signed_int;

   function insertln return c.signed_int;

   procedure keypad  (
      w    : A_WINDOW_T;
      flag : bool );

   procedure leaveok (
      w    : A_WINDOW_T;
      flag : bool );

   function move (
      y : c.signed_int;
      x : c.signed_int )
      return c.signed_int;

   function mvaddch (
      y  : c.signed_int;
      x  : c.signed_int;
      ch : chtype )
      return c.signed_int;

   function mvaddstr (
      y : c.signed_int;
      x : c.signed_int;
      s : c.charp)
      return c.signed_int;

   function mvdelch ( 
      y : c.signed_int;
      x : c.signed_int)
      return c.signed_int;

   function mvgetch (
      y : c.signed_int;
      x : c.signed_int )
      return c.signed_int;

   function mvgetstr (
      y   : c.signed_int;
      x   : c.signed_int;
      str : c.charp )
      return c.signed_int;

   function mvinch (
      y : c.signed_int;
      x : c.signed_int)
      return c.signed_int;

   function mvinsch (
      y : c.signed_int;
      x : c.signed_int;
      ch: chtype)
      return c.signed_int;

   function mvwaddch (
      w : A_WINDOW_T;
      y : c.signed_int;
      x : c.signed_int;
      ch: chtype)
      return c.signed_int;

   function mvwaddstr (
      w   : A_WINDOW_T; 
      y   : c.signed_int;
      x   : c.signed_int;
      str : c.charp )
      return c.signed_int;

   function mvwdelch ( 
      w : A_WINDOW_T;
      y : c.signed_int;
      x: c.signed_int)
      return c.signed_int;

   function mvwgetch (
      w : A_WINDOW_T;
      y : c.signed_int;
      x : c.signed_int )
      return c.signed_int;

   function mvwgetstr (
      w   : A_WINDOW_T;
      y   : c.signed_int;
      x   : c.signed_int;
      str : c.charp )
      return c.signed_int;

   function mvwinch (
      w : A_WINDOW_T;
      y : c.signed_int;
      x : c.signed_int)
      return c.signed_int;

   function mvwinsch (
      w : A_WINDOW_T;
      y : c.signed_int;
      x : c.signed_int;
      ch: chtype)
      return c.signed_int;

   procedure nl;

   procedure nocbreak;

   procedure nocrmode;

   procedure nodelay (
      w    : A_WINDOW_T;
      flag : bool );

   procedure noecho;

   procedure nonl;

   function refresh return c.signed_int;

   function scroll ( w : A_WINDOW_T ) return c.signed_int;

   procedure scrollok (
      w    : A_WINDOW_T;
      flag : bool );

   function standend return c.signed_int;

   function standout return c.signed_int;

   function waddch (
      w  : A_WINDOW_T;
      ch : chtype)
      return c.signed_int;

   function wclear ( w : A_WINDOW_T ) return c.signed_int;

   function wechochar (
      w  : A_WINDOW_T;
      ch : chtype )
      return c.signed_int;

   function werase( w : A_WINDOW_T ) return c.signed_int;

   procedure winch(w: A_WINDOW_T);

   function winstr (
      w : A_WINDOW_T;
      s : c.charp)
      return c.signed_int;

   function wstandend ( w : A_WINDOW_T ) return c.signed_int;

   function wstandout ( w : A_WINDOW_T ) return c.signed_int;
--
-- Added to help strengthen data abstraction.
--
   function wgetattr ( w : A_WINDOW_T ) return attr_t;

--
-- The following functions are called directly.  They will not be accessible
-- to an Ada program if they have been redefined/renamed using a #define
-- statement in the curses header file (This might happen if the curses 
-- header file is updated).  They should eventually be "wrapped" like the
-- functions above.  The subprogram declarations were generated using cbind, 
-- and differ slightly in format from the previous declarations.
--

   function addchnstr(p1: a_chtype_t;
                      p2: c.signed_int)
                          return c.signed_int;                 -- curses.h:1259

   function baudrate return c.signed_int;                      -- curses.h:1260

   function beep return c.signed_int;                          -- curses.h:1261


   function breakchar return c.signed_char;                    -- curses.h:1263

   function can_change_color return c.signed_int;              -- curses.h:1264

   function clearok(p1: A_WINDOW_T;
                    p2: bool)
                        return c.signed_int;                   -- curses.h:1265

   function color_content(p1: c.signed_short;
                          p2: c.a_signed_short_t;
                          p3: c.a_signed_short_t;
                          p4: c.a_signed_short_t)
                              return c.signed_int;             -- curses.h:1266

   function copywin(p1: A_WINDOW_T;
                    p2: A_WINDOW_T;
                    p3: c.signed_int;
                    p4: c.signed_int;
                    p5: c.signed_int;
                    p6: c.signed_int;
                    p7: c.signed_int;
                    p8: c.signed_int;
                    p9: c.signed_int)
                        return c.signed_int;                   -- curses.h:1267

   function curs_set(p1: c.signed_int) return c.signed_int;    -- curses.h:1268

   function cursoff return c.signed_int;                       -- curses.h:1269

   function curson return c.signed_int;                        -- curses.h:1270

   function def_prog_mode return c.signed_int;                 -- curses.h:1271

   function def_shell_mode return c.signed_int;                -- curses.h:1272

   function delay_output(p1: c.signed_int) return c.signed_int;-- curses.h:1273

   function delwin(p1: A_WINDOW_T) return c.signed_int;        -- curses.h:1274

   function derwin(p1: A_WINDOW_T;
                   p2: c.signed_int;
                   p3: c.signed_int;
                   p4: c.signed_int;
                   p5: c.signed_int)
                       return A_WINDOW_T;                      -- curses.h:1275

   function doupdate return c.signed_int;                      -- curses.h:1276

   function dupwin(p1: A_WINDOW_T) return A_WINDOW_T;          -- curses.h:1277

   function endwin return c.signed_int;                        -- curses.h:1278

   function erasechar return c.signed_char;                    -- curses.h:1280

   function fixterm return c.signed_int;                       -- curses.h:1281

   function flash return c.signed_int;                         -- curses.h:1282

   function flushinp return c.signed_int;                      -- curses.h:1283

   function gettmode return c.signed_int;                      -- curses.h:1284


   function getsyx(p1: c.a_signed_int_t;
                   p2: c.a_signed_int_t)
                       return c.signed_int;                    -- curses.h:1285

   function halfdelay(p1: c.signed_int) return c.signed_int;   -- curses.h:1286

   function has_colors return bool;                            -- curses.h:1287

   function hline(p1: chtype;
                  p2: c.signed_int)
                      return c.signed_int;                     -- curses.h:1288

   function immedok(p1: A_WINDOW_T;
                    p2: bool)
                        return c.signed_int;                   -- curses.h:1289

   function inchnstr(p1: a_chtype_t;
                     p2: c.signed_int)
                         return c.signed_int;                  -- curses.h:1290

   function init_color(p1: c.signed_short;
                       p2: c.signed_short;
                       p3: c.signed_short;
                       p4: c.signed_short)
                           return c.signed_int;                -- curses.h:1291

   function init_pair(p1: c.signed_short;
                      p2: c.signed_short;
                      p3: c.signed_short)
                          return c.signed_int;                 -- curses.h:1292

   function initscr return A_WINDOW_T;                         -- curses.h:1293

   function intrflush(p1: A_WINDOW_T;
                      p2: bool)
                          return c.signed_int;                 -- curses.h:1294

   function is_linetouched(p1: A_WINDOW_T;
                           p2: c.signed_int)
                               return c.signed_int;            -- curses.h:1295

   function is_wintouched(p1: A_WINDOW_T) return c.signed_int; -- curses.h:1296

   function keyname(p1: c.signed_int) return c.charp;          -- curses.h:1297

   function killchar return c.signed_char;                     -- curses.h:1298

   function longname return c.charp;                           -- curses.h:1299

   function meta(p1: A_WINDOW_T;
                 p2: bool)
                     return c.signed_int;                      -- curses.h:1300

   function mvaddrawch(p1: c.signed_int;
                       p2: c.signed_int;
                       p3: chtype)
                           return c.signed_int;                -- curses.h:1301

   function mvaddrawstr(p1: c.signed_int;
                        p2: c.signed_int;
                        p3: c.charp)
                            return c.signed_int;               -- curses.h:1302

   function mvcur(p1: c.signed_int;
                  p2: c.signed_int;
                  p3: c.signed_int;
                  p4: c.signed_int)
                      return c.signed_int;                     -- curses.h:1303

   function mvderwin(p1: A_WINDOW_T;
                     p2: c.signed_int;
                     p3: c.signed_int)
                         return c.signed_int;                  -- curses.h:1304

   function mvinsrawch(p1: c.signed_int;
                       p2: c.signed_int;
                       p3: chtype)
                           return c.signed_int;                -- curses.h:1305

   function mvprintw(p1: c.signed_int;
                     p2: c.signed_int;
                     p3: c.charp)
                         return c.signed_int;                  -- curses.h:1307

   function mvscanw(p1: c.signed_int;
                    p2: c.signed_int;
                    p3: c.charp)
                        return c.signed_int;                   -- curses.h:1308

   function mvwin(p1: A_WINDOW_T;
                  p2: c.signed_int;
                  p3: c.signed_int)
                      return c.signed_int;                     -- curses.h:1310

   function mvwinsrawch(p1: A_WINDOW_T;
                        p2: c.signed_int;
                        p3: c.signed_int;
                        p4: chtype)
                            return c.signed_int;               -- curses.h:1311

   function mvwprintw(p1: A_WINDOW_T;
                      p2: c.signed_int;
                      p3: c.signed_int;
                      p4: c.charp)
                          return c.signed_int;                 -- curses.h:1313

   function mvwscanw(p1: A_WINDOW_T;
                     p2: c.signed_int;
                     p3: c.signed_int;
                     p4: c.charp)
                         return c.signed_int;                  -- curses.h:1314

   function newpad(p1: c.signed_int;
                   p2: c.signed_int)
                       return A_WINDOW_T;                      -- curses.h:1316

   function newwin(p1: c.signed_int;
                   p2: c.signed_int;
                   p3: c.signed_int;
                   p4: c.signed_int)
                       return A_WINDOW_T;                      -- curses.h:1318

   function noraw return c.signed_int;                         -- curses.h:1319

   function notimeout(p1: A_WINDOW_T;
                      p2: bool)
                          return c.signed_int;                 -- curses.h:1320

   function overlay(p1: A_WINDOW_T;
                    p2: A_WINDOW_T)
                        return c.signed_int;                   -- curses.h:1321

   function overwrite(p1: A_WINDOW_T;
                      p2: A_WINDOW_T)
                          return c.signed_int;                 -- curses.h:1322

   function pair_content(p1: c.signed_int;
                         p2: c.a_signed_short_t;
                         p3: c.a_signed_short_t)
                             return c.signed_int;              -- curses.h:1323

   function pnoutrefresh(p1: A_WINDOW_T;
                         p2: c.signed_int;
                         p3: c.signed_int;
                         p4: c.signed_int;
                         p5: c.signed_int;
                         p6: c.signed_int;
                         p7: c.signed_int)
                             return c.signed_int;              -- curses.h:1324

   function prefresh(p1: A_WINDOW_T;
                     p2: c.signed_int;
                     p3: c.signed_int;
                     p4: c.signed_int;
                     p5: c.signed_int;
                     p6: c.signed_int;
                     p7: c.signed_int)
                         return c.signed_int;                  -- curses.h:1325

   function printw(p1: c.charp) return c.signed_int;           -- curses.h:1327

   function scanw(p1: c.charp) return c.signed_int;            -- curses.h:1328

   function raw return c.signed_int;                           -- curses.h:1330

   function reset_prog_mode return c.signed_int;               -- curses.h:1332

   function reset_shell_mode return c.signed_int;              -- curses.h:1333

   function resetty return c.signed_int;                       -- curses.h:1334

   function ripoffline(p1: c.signed_int;
                       p4: c.function_pointer)
                           return c.signed_int;                -- curses.h:1335

   function saveoldterm return c.signed_int;                   -- curses.h:1336

   function savetty return c.signed_int;                       -- curses.h:1337

   function set_term(p1: A_SCREEN_T) return A_SCREEN_T;        -- curses.h:1339

   function setsyx(p1: c.signed_int;
                   p2: c.signed_int)
                       return c.signed_int;                    -- curses.h:1340

   function start_color return c.signed_int;                   -- curses.h:1341

   function slk_init(p1: c.signed_int) return c.signed_int;    -- curses.h:1342

   function slk_set(p1: c.signed_int;
                    p2: c.charp;
                    p3: c.signed_int)
                        return c.signed_int;                   -- curses.h:1343

   function slk_refresh return c.signed_int;                   -- curses.h:1344

   function slk_noutrefresh return c.signed_int;               -- curses.h:1345

   function slk_label(p1: c.signed_int) return c.charp;        -- curses.h:1346

   function slk_clear return c.signed_int;                     -- curses.h:1347

   function slk_restore return c.signed_int;                   -- curses.h:1348

   function slk_touch return c.signed_int;                     -- curses.h:1349

   function slk_attron(p1: attr_t) return c.signed_int;        -- curses.h:1350

   function slk_attrset(p1: attr_t) return c.signed_int;       -- curses.h:1351

   function slk_attroff(p1: attr_t) return c.signed_int;       -- curses.h:1352

   function subpad(p1: A_WINDOW_T;
                   p2: c.signed_int;
                   p3: c.signed_int;
                   p4: c.signed_int;
                   p5: c.signed_int)
                       return A_WINDOW_T;                      -- curses.h:1353

   function subwin(p1: A_WINDOW_T;
                   p2: c.signed_int;
                   p3: c.signed_int;
                   p4: c.signed_int;
                   p5: c.signed_int)
                       return A_WINDOW_T;                      -- curses.h:1354

   function syncok(p1: A_WINDOW_T;
                   p2: bool)
                       return c.signed_int;                    -- curses.h:1355

   function tabsize(p1: c.signed_int) return c.signed_int;     -- curses.h:1356

   function termattrs return attr_t;                           -- curses.h:1357

   function termname return c.charp;                           -- curses.h:1358

   function touchline(p1: A_WINDOW_T;
                      p2: c.signed_int;
                      p3: c.signed_int)
                          return c.signed_int;                 -- curses.h:1359

   function touchwin(p1: A_WINDOW_T) return c.signed_int;      -- curses.h:1360

   procedure traceoff;                                         -- curses.h:1362

   procedure traceon;                                          -- curses.h:1363

   function typeahead(p1: c.signed_int) return c.signed_int;   -- curses.h:1365

   function unctrl(p1: chtype) return c.charp;                 -- curses.h:1366

   function vline(p1: chtype;
                  p2: c.signed_int)
                      return c.signed_int;                     -- curses.h:1367

   function waddchnstr(p1: A_WINDOW_T;
                       p2: a_chtype_t;
                       p3: c.signed_int)
                           return c.signed_int;                -- curses.h:1368

   function waddnstr(p1: A_WINDOW_T;
                     p2: c.charp;
                     p3: c.signed_int)
                         return c.signed_int;                  -- curses.h:1369

   function waddrawstr(p1: A_WINDOW_T;
                       p2: c.charp)
                           return c.signed_int;                -- curses.h:1370

   function waddstr(p1: A_WINDOW_T;
                    p2: c.charp)
                        return c.signed_int;                   -- curses.h:1371

   function wattroff(p1: A_WINDOW_T;
                     p2: attr_t)
                         return c.signed_int;                  -- curses.h:1372

   function wattron(p1: A_WINDOW_T;
                    p2: attr_t)
                        return c.signed_int;                   -- curses.h:1373

   function wattrset(p1: A_WINDOW_T;
                     p2: attr_t)
                         return c.signed_int;                  -- curses.h:1374

   function wbkgd(p1: A_WINDOW_T;
                  p2: chtype)
                      return c.signed_int;                     -- curses.h:1375

   procedure wbkgdset(p1: A_WINDOW_T;
                      p2: chtype);                             -- curses.h:1376

   function wborder(p1: A_WINDOW_T;
                    p2: chtype;
                    p3: chtype;
                    p4: chtype;
                    p5: chtype;
                    p6: chtype;
                    p7: chtype;
                    p8: chtype;
                    p9: chtype)
                        return c.signed_int;                   -- curses.h:1377

   function wclrtobot(p1: A_WINDOW_T) return c.signed_int;     -- curses.h:1379

   function wclrtoeol(p1: A_WINDOW_T) return c.signed_int;     -- curses.h:1380

   procedure wcursyncup(p1: A_WINDOW_T);                       -- curses.h:1381

   function wdelch(p1: A_WINDOW_T) return c.signed_int;        -- curses.h:1382

   function wdeleteln(p1: A_WINDOW_T) return c.signed_int;     -- curses.h:1383


   function wgetch(p1: A_WINDOW_T) return c.signed_int;        -- curses.h:1385

   function wgetnstr(p1: A_WINDOW_T;
                     p2: c.charp;
                     p3: c.signed_int)
                         return c.signed_int;                  -- curses.h:1386

   function wgetstr(p1: A_WINDOW_T;
                    p2: c.charp)
                        return c.signed_int;                   -- curses.h:1387

   function whline(p1: A_WINDOW_T;
                   p2: chtype;
                   p3: c.signed_int)
                       return c.signed_int;                    -- curses.h:1388

   function winchnstr(p1: A_WINDOW_T;
                      p2: a_chtype_t;
                      p3: c.signed_int)
                          return c.signed_int;                 -- curses.h:1389

   function winnstr(p1: A_WINDOW_T;
                    p2: c.charp;
                    p3: c.signed_int)
                        return c.signed_int;                   -- curses.h:1390

   function winsch(p1: A_WINDOW_T;
                   p2: chtype)
                       return c.signed_int;                    -- curses.h:1391

   function winsdelln(p1: A_WINDOW_T;
                      p2: c.signed_int)
                          return c.signed_int;                 -- curses.h:1392

   function winsertln(p1: A_WINDOW_T) return c.signed_int;     -- curses.h:1393

   function winsnstr(p1: A_WINDOW_T;
                     p2: c.charp;
                     p3: c.signed_int)
                         return c.signed_int;                  -- curses.h:1394

   function wmove(p1: A_WINDOW_T;
                  p2: c.signed_int;
                  p3: c.signed_int)
                      return c.signed_int;                     -- curses.h:1395

   function wnoutrefresh(p1: A_WINDOW_T) return c.signed_int;  -- curses.h:1396

   function wordchar return c.signed_char;                     -- curses.h:1397

   function wprintw(p1: A_WINDOW_T;
                    p2: c.charp)
                        return c.signed_int;                   -- curses.h:1399

   function wscanw(p1: A_WINDOW_T;
                   p2: c.charp)
                       return c.signed_int;                    -- curses.h:1400

   function wredrawln(p1: A_WINDOW_T;
                      p2: c.signed_int;
                      p3: c.signed_int)
                          return c.signed_int;                 -- curses.h:1402

   function wrefresh(p1: A_WINDOW_T) return c.signed_int;      -- curses.h:1403

   function wscrl(p1: A_WINDOW_T;
                  p2: c.signed_int)
                      return c.signed_int;                     -- curses.h:1404

   function wsetscrreg(p1: A_WINDOW_T;
                       p2: c.signed_int;
                       p3: c.signed_int)
                           return c.signed_int;                -- curses.h:1405

   function wtabsize(p1: A_WINDOW_T;
                     p2: c.signed_int)
                         return c.signed_int;                  -- curses.h:1406

   function wtimeout(p1: A_WINDOW_T;
                     p2: c.signed_int)
                         return c.signed_int;                  -- curses.h:1407

   function wtouchln(p1: A_WINDOW_T;
                     p2: c.signed_int;
                     p3: c.signed_int;
                     p4: c.signed_int)
                         return c.signed_int;                  -- curses.h:1408

   function ungetch(p1: c.signed_int) return c.signed_int;     -- curses.h:1409

   procedure wsyncdown(p1: A_WINDOW_T);                        -- curses.h:1410

   procedure wsyncup(p1: A_WINDOW_T);                          -- curses.h:1411

   function wvline(p1: A_WINDOW_T;
                   p2: chtype;
                   p3: c.signed_int)
                       return c.signed_int;                    -- curses.h:1412

   function raw_output(p1: bool) return c.signed_int;          -- curses.h:1415

   function resize_term(p1: c.signed_int;
                        p2: c.signed_int)
                            return c.signed_int;               -- curses.h:1416

   function resize_window(p1: A_WINDOW_T;
                          p2: c.signed_int;
                          p3: c.signed_int)
                              return A_WINDOW_T;               -- curses.h:1417

   function win_print(p1: A_WINDOW_T;
                      p2: c.signed_int)
                          return c.signed_int;                 -- curses.h:1418

   function mouse_set(p1: c.unsigned_int) return c.signed_int; -- curses.h:1432

   function mouse_on(p1: c.unsigned_int) return c.signed_int;  -- curses.h:1433

   function mouse_off(p1: c.unsigned_int) return c.signed_int; -- curses.h:1434

   function request_mouse_pos return c.signed_int;             -- curses.h:1435

   function map_button(p1: c.unsigned_int) return c.signed_int;-- curses.h:1436

   procedure wmouse_position(p1: A_WINDOW_T;
                             p2: c.a_signed_int_t;
                             p3: c.a_signed_int_t);            -- curses.h:1437

   function getmouse return c.unsigned_int;                    -- curses.h:1438

   function getbmap return c.unsigned_int;                     -- curses.h:1439

   function PDC_CHADD(p1: A_WINDOW_T;
                      p2: chtype;
                      p3: bool;
                      p4: bool)
                          return c.signed_int;                 -- curses.h:1444

   function PDC_CHINS(p1: A_WINDOW_T;
                      p2: chtype;
                      p3: bool)
                          return c.signed_int;                 -- curses.h:1445

private
--
-- Keeping the curses implementation details hidden from Ada programs 
-- which really don't have to know about them.  As far as Ada is concerned,
-- these types are just bit strings that the C-functions deal with. This
-- makes the binding much more portable between curses implementations and
-- revisions.  Using system.address is particularily convenient, but any 
-- type wide enough to hold a C pointer will work. 
--
   type A_WINDOW_T is new system.address;
   type A_SCREEN_T is new system.address;

--
-- Importing C "wrapper functions" from macros.o
--
   pragma import (C, addch, "CB_addch");
   pragma import (C, addstr, "CB_addstr");
   pragma import (C, attrset, "CB_attrset");
   pragma import (C, beep, "CB_beep");
   pragma import (C, bkgd, "CB_bkgd");
   pragma import (C, bkgdset, "CB_bkgdset");
   pragma import (C, border, "CB_border");
   pragma import (C, box, "CB_box");
   pragma import (C, cbreak, "CB_cbreak");
   pragma import (C, clear, "CB_clear");
   pragma import (C, clrtobot, "CB_clrtobot");
   pragma import (C, clrtoeol, "CB_clrtoeol");
   pragma import (C, color_pair, "CB_color_pair");
   pragma import (C, crmode, "CB_crmode");
   pragma import (C, curs_set, "CB_curs_set");
   pragma import (C, delch, "CB_delch");
   pragma import (C, deleteln, "CB_deleteln");
   pragma import (C, delwin, "CB_delwin");
   pragma import (C, echo, "CB_echo");
   pragma import (C, echochar, "CB_echochar");
   pragma import (C, endwin, "CB_endwin");
   pragma import (C, erase, "CB_erase");
   pragma import (C, getbegx, "CB_getbegx");
   pragma import (C, getbegy, "CB_getbegy");
   pragma import (C, getch, "CB_getch");
   pragma import (C, getmaxx, "CB_getmaxx");
   pragma import (C, getmaxy, "CB_getmaxy");
   pragma import (C, getparx, "CB_getparx");
   pragma import (C, getpary, "CB_getpary");
   pragma import (C, getstr, "CB_getstr");
   pragma import (C, getstr, "CB_getstr");
   pragma import (C, inch, "CB_inch");
   pragma import (C, inchstr, "CB_inchstr");
   pragma import (C, initscr, "CB_initscr");
   pragma import (C, init_pair, "CB_init_pair");
   pragma import (C, insch, "CB_insch");
   pragma import (C, insertln, "CB_insertln");
   pragma import (C, keypad, "CB_keypad");
   pragma import (C, leaveok, "CB_leaveok");
   pragma import (C, move, "CB_move");
   pragma import (C, mvaddch, "CB_mvaddch");
   pragma import (C, mvaddstr, "CB_mvaddstr");
   pragma import (C, mvdelch, "CB_mvdelch");
   pragma import (C, mvgetch, "CB_mvgetch");
   pragma import (C, mvgetstr, "CB_mvgetstr");
   pragma import (C, mvinch, "CB_mvinch");
   pragma import (C, mvinsch, "CB_mvinsch");
   pragma import (C, mvprintw, "CB_mvprintw");
   pragma import (C, mvwaddch, "CB_mvwaddch");
   pragma import (C, mvwaddstr, "CB_mvwaddstr");
   pragma import (C, mvwdelch, "CB_mvwdelch");
   pragma import (C, mvwgetch, "CB_mvwgetch");
   pragma import (C, mvwgetstr, "CB_mvwgetstr");
   pragma import (C, mvwinch, "CB_mvwinch");
   pragma import (C, mvwinsch, "CB_mvwinsch");
   pragma import (C, mvwprintw, "CB_mvwprintw");
   pragma import (C, newwin, "CB_newwin");
   pragma import (C, nl, "CB_nl");
   pragma import (C, nocbreak, "CB_nocbreak");
   pragma import (C, nocrmode, "CB_nocrmode");
   pragma import (C, nodelay, "CB_nodelay");
   pragma import (C, noecho, "CB_noecho");
   pragma import (C, nonl, "CB_nonl");
   pragma import (C, refresh, "CB_refresh");
   pragma import (C, scroll, "CB_scroll");
   pragma import (C, scrollok, "CB_scrollok");
   pragma import (C, standend, "CB_standend");
   pragma import (C, standout, "CB_standout");
   pragma import (C, start_color, "CB_start_color");
   pragma import (C, subwin, "CB_subwin");
   pragma import (C, touchwin, "CB_touchwin");
   pragma import (C, waddch, "CB_waddch");
   pragma import (C, waddstr, "CB_waddstr");
   pragma import (C, wattrset, "CB_wattrset");
   pragma import (C, wbkgd, "CB_wbkgd");
   pragma import (C, wbkgdset, "CB_wbkgdset");
   pragma import (C, wclear, "CB_wclear");
   pragma import (C, wechochar, "CB_wechochar");
   pragma import (C, werase, "CB_werase");
   pragma import (C, wgetattr, "CB_wgetattr");
   pragma import (C, winch, "CB_winch");
   pragma import (C, winstr, "CB_winstr");
   pragma import (C, wmove, "CB_wmove");
   pragma import (C, wprintw, "CB_wprintw");
   pragma import (C, wrefresh, "CB_wrefresh");
   pragma import (C, wstandend, "CB_wstandend");
   pragma import (C, wstandout, "CB_wstandout");

--
-- Importing "unwrapped" functions directly from the curses library (licurso.a)
-- The following code was generated by cbind.
--
   pragma Import(C, addchnstr, "addchnstr");                  -- curses.h:1259
   pragma Import(C, baudrate, "baudrate");                    -- curses.h:1260
   pragma Import(C, border, "border");                        -- curses.h:1262
   pragma Import(C, breakchar, "breakchar");                  -- curses.h:1263
   pragma Import(C, can_change_color, "can_change_color");    -- curses.h:1264
   pragma Import(C, clearok, "clearok");                      -- curses.h:1265
   pragma Import(C, color_content, "color_content");          -- curses.h:1266
   pragma Import(C, copywin, "copywin");                      -- curses.h:1267
   pragma Import(C, cursoff, "cursoff");                      -- curses.h:1269
   pragma Import(C, curson, "curson");                        -- curses.h:1270
   pragma Import(C, def_prog_mode, "def_prog_mode");          -- curses.h:1271
   pragma Import(C, def_shell_mode, "def_shell_mode");        -- curses.h:1272
   pragma Import(C, delay_output, "delay_output");            -- curses.h:1273
   pragma Import(C, derwin, "derwin");                        -- curses.h:1275
   pragma Import(C, doupdate, "doupdate");                    -- curses.h:1276
   pragma Import(C, dupwin, "dupwin");                        -- curses.h:1277
   pragma Import(C, erasechar, "erasechar");                  -- curses.h:1280
   pragma Import(C, fixterm, "fixterm");                      -- curses.h:1281
   pragma Import(C, flash, "flash");                          -- curses.h:1282
   pragma Import(C, flushinp, "flushinp");                    -- curses.h:1283
   pragma Import(C, gettmode, "gettmode");                    -- curses.h:1284
   pragma Import(C, getsyx, "getsyx");                        -- curses.h:1285
   pragma Import(C, halfdelay, "halfdelay");                  -- curses.h:1286
   pragma Import(C, has_colors, "has_colors");                -- curses.h:1287
   pragma Import(C, hline, "hline");                          -- curses.h:1288
   pragma Import(C, immedok, "immedok");                      -- curses.h:1289
   pragma Import(C, inchnstr, "inchnstr");                    -- curses.h:1290
   pragma Import(C, init_color, "init_color");                -- curses.h:1291
   pragma Import(C, intrflush, "intrflush");                  -- curses.h:1294
   pragma Import(C, is_linetouched, "is_linetouched");        -- curses.h:1295
   pragma Import(C, is_wintouched, "is_wintouched");          -- curses.h:1296
   pragma Import(C, keyname, "keyname");                      -- curses.h:1297
   pragma Import(C, killchar, "killchar");                    -- curses.h:1298
   pragma Import(C, longname, "longname");                    -- curses.h:1299
   pragma Import(C, meta, "meta");                            -- curses.h:1300
   pragma Import(C, mvaddrawch, "mvaddrawch");                -- curses.h:1301
   pragma Import(C, mvaddrawstr, "mvaddrawstr");              -- curses.h:1302
   pragma Import(C, mvcur, "mvcur");                          -- curses.h:1303
   pragma Import(C, mvderwin, "mvderwin");                    -- curses.h:1304
   pragma Import(C, mvinsrawch, "mvinsrawch");                -- curses.h:1305
   pragma Import(C, mvscanw, "mvscanw");                      -- curses.h:1308
   pragma Import(C, mvwin, "mvwin");                          -- curses.h:1310
   pragma Import(C, mvwinsrawch, "mvwinsrawch");              -- curses.h:1311
   pragma Import(C, mvwscanw, "mvwscanw");                    -- curses.h:1314
   pragma Import(C, newpad, "newpad");                        -- curses.h:1316
   pragma Import(C, noraw, "noraw");                          -- curses.h:1319
   pragma Import(C, notimeout, "notimeout");                  -- curses.h:1320
   pragma Import(C, overlay, "overlay");                      -- curses.h:1321
   pragma Import(C, overwrite, "overwrite");                  -- curses.h:1322
   pragma Import(C, pair_content, "pair_content");            -- curses.h:1323
   pragma Import(C, pnoutrefresh, "pnoutrefresh");            -- curses.h:1324
   pragma Import(C, prefresh, "prefresh");                    -- curses.h:1325
   pragma Import(C, printw, "printw");                        -- curses.h:1327
   pragma Import(C, scanw, "scanw");                          -- curses.h:1328
   pragma Import(C, raw, "raw");                              -- curses.h:1330
   pragma Import(C, reset_prog_mode, "reset_prog_mode");      -- curses.h:1332
   pragma Import(C, reset_shell_mode, "reset_shell_mode");    -- curses.h:1333
   pragma Import(C, resetty, "resetty");                      -- curses.h:1334
   pragma Import(C, ripoffline, "ripoffline");                -- curses.h:1335
   pragma Import(C, saveoldterm, "saveoldterm");              -- curses.h:1336
   pragma Import(C, savetty, "savetty");                      -- curses.h:1337
   pragma Import(C, set_term, "set_term");                    -- curses.h:1339
   pragma Import(C, setsyx, "setsyx");                        -- curses.h:1340
   pragma Import(C, slk_init, "slk_init");                    -- curses.h:1342
   pragma Import(C, slk_set, "slk_set");                      -- curses.h:1343
   pragma Import(C, slk_refresh, "slk_refresh");              -- curses.h:1344
   pragma Import(C, slk_noutrefresh, "slk_noutrefresh");      -- curses.h:1345
   pragma Import(C, slk_label, "slk_label");                  -- curses.h:1346
   pragma Import(C, slk_clear, "slk_clear");                  -- curses.h:1347
   pragma Import(C, slk_restore, "slk_restore");              -- curses.h:1348
   pragma Import(C, slk_touch, "slk_touch");                  -- curses.h:1349
   pragma Import(C, slk_attron, "slk_attron");                -- curses.h:1350
   pragma Import(C, slk_attrset, "slk_attrset");              -- curses.h:1351
   pragma Import(C, slk_attroff, "slk_attroff");              -- curses.h:1352
   pragma Import(C, subpad, "subpad");                        -- curses.h:1353
   pragma Import(C, syncok, "syncok");                        -- curses.h:1355
   pragma Import(C, tabsize, "tabsize");                      -- curses.h:1356
   pragma Import(C, termattrs, "termattrs");                  -- curses.h:1357
   pragma Import(C, termname, "termname");                    -- curses.h:1358
   pragma Import(C, touchline, "touchline");                  -- curses.h:1359
   pragma Import(C, traceoff, "traceoff");                    -- curses.h:1362
   pragma Import(C, traceon, "traceon");                      -- curses.h:1363
   pragma Import(C, typeahead, "typeahead");                  -- curses.h:1365
   pragma Import(C, unctrl, "unctrl");                        -- curses.h:1366
   pragma Import(C, vline, "vline");                          -- curses.h:1367
   pragma Import(C, waddchnstr, "waddchnstr");                -- curses.h:1368
   pragma Import(C, waddnstr, "waddnstr");                    -- curses.h:1369
   pragma Import(C, waddrawstr, "waddrawstr");                -- curses.h:1370
   pragma Import(C, wattroff, "wattroff");                    -- curses.h:1372
   pragma Import(C, wattron, "wattron");                      -- curses.h:1373
   pragma Import(C, wborder, "wborder");                      -- curses.h:1377
   pragma Import(C, wclrtobot, "wclrtobot");                  -- curses.h:1379
   pragma Import(C, wclrtoeol, "wclrtoeol");                  -- curses.h:1380
   pragma Import(C, wcursyncup, "wcursyncup");                -- curses.h:1381
   pragma Import(C, wdelch, "wdelch");                        -- curses.h:1382
   pragma Import(C, wdeleteln, "wdeleteln");                  -- curses.h:1383
   pragma Import(C, wgetch, "wgetch");                        -- curses.h:1385
   pragma Import(C, wgetnstr, "wgetnstr");                    -- curses.h:1386
   pragma Import(C, wgetstr, "wgetstr");                      -- curses.h:1387
   pragma Import(C, whline, "whline");                        -- curses.h:1388
   pragma Import(C, winchnstr, "winchnstr");                  -- curses.h:1389
   pragma Import(C, winnstr, "winnstr");                      -- curses.h:1390
   pragma Import(C, winsch, "winsch");                        -- curses.h:1391
   pragma Import(C, winsdelln, "winsdelln");                  -- curses.h:1392
   pragma Import(C, winsertln, "winsertln");                  -- curses.h:1393
   pragma Import(C, winsnstr, "winsnstr");                    -- curses.h:1394
   pragma Import(C, wnoutrefresh, "wnoutrefresh");            -- curses.h:1396
   pragma Import(C, wordchar, "wordchar");                    -- curses.h:1397
   pragma Import(C, wscanw, "wscanw");                        -- curses.h:1400
   pragma Import(C, wredrawln, "wredrawln");                  -- curses.h:1402
   pragma Import(C, wscrl, "wscrl");                          -- curses.h:1404
   pragma Import(C, wsetscrreg, "wsetscrreg");                -- curses.h:1405
   pragma Import(C, wtabsize, "wtabsize");                    -- curses.h:1406
   pragma Import(C, wtimeout, "wtimeout");                    -- curses.h:1407
   pragma Import(C, wtouchln, "wtouchln");                    -- curses.h:1408
   pragma Import(C, ungetch, "ungetch");                      -- curses.h:1409
   pragma Import(C, wsyncdown, "wsyncdown");                  -- curses.h:1410
   pragma Import(C, wsyncup, "wsyncup");                      -- curses.h:1411
   pragma Import(C, wvline, "wvline");                        -- curses.h:1412
   pragma Import(C, raw_output, "raw_output");                -- curses.h:1415
   pragma Import(C, resize_term, "resize_term");              -- curses.h:1416
   pragma Import(C, resize_window, "resize_window");          -- curses.h:1417
   pragma Import(C, win_print, "win_print");                  -- curses.h:1418
   pragma Import(C, mouse_set, "mouse_set");                  -- curses.h:1432
   pragma Import(C, mouse_on, "mouse_on");                    -- curses.h:1433
   pragma Import(C, mouse_off, "mouse_off");                  -- curses.h:1434
   pragma Import(C, request_mouse_pos, "request_mouse_pos");  -- curses.h:1435
   pragma Import(C, map_button, "map_button");                -- curses.h:1436
   pragma Import(C, wmouse_position, "wmouse_position");      -- curses.h:1437
   pragma Import(C, getmouse, "getmouse");                    -- curses.h:1438
   pragma Import(C, getbmap, "getbmap");                      -- curses.h:1439
   pragma Import(C, PDC_CHADD, "PDC_chadd");                  -- curses.h:1444
   pragma Import(C, PDC_CHINS, "PDC_chins");                  -- curses.h:1445
end pdcurses;
