-----------------------------------------------------------------------
--
--  File:        letters.ads
--  Description: HANGMAN guessed character handling
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
package Letters is

   type Letter_Set is private;

   Default_Letter_Set : constant Letter_Set;

   procedure Show (Set : in Letter_Set);
   procedure Set_Used (Set : in out Letter_Set; C : Character);
   function Is_Valid (Set : in Letter_Set; C : Character) return Boolean;

private

   type Letter is
      record
         Value : Character;
         Used  : Boolean;
      end record;

   type Letter_Set is array (1 .. 26) of Letter;

   Default_Letter_Set : constant Letter_Set := (
     ('A', False), ('B', False), ('C', False), ('D', False), ('E', False),
     ('F', False), ('G', False), ('H', False), ('I', False), ('J', False),
     ('K', False), ('L', False), ('M', False), ('N', False), ('O', False),
     ('P', False), ('Q', False), ('R', False), ('S', False), ('T', False),
     ('U', False), ('V', False), ('W', False), ('X', False), ('Y', False),
     ('Z', False)
   );

end letters;
