/* Secure Drive V1.0 */
/* Code common to CRYPTDSK and LOGIN */

#include "secdrv.h"

struct tsrdata far *cryptdata;

void invgets(char *input)
{
unsigned i=0;
char c;
while(i<(MAXPASS-1)) {
    c=getch();
    if(c=='\x0d')
	{
	printf("\n");
	*input='\0';
	return;
	}
    else if(c=='\b')
	{
	if(i>0)
	    {
	    i--;
	    input--;
	    printf("\b \b");
	    }
	}
    else
	{
	printf("*");
	*input++=c;
	i++;
	}
    }
}

void readsec(unsigned drive,unsigned head,unsigned track,
	     unsigned sector,unsigned nsects,void *buffer)
{
unsigned i;
char c;
for(;;) {
    for(i=0;i<3;i++) 
	if(!biosdisk(2,drive,head,track,sector,nsects,buffer)) return;
    printf("\nRead error: drive %02x, head %u, track %u\n",
	    drive,head,track);
    printf("Abort, Retry, Ignore? ");
    c=toupper(getch()); printf("%c\n",c);
    if(c=='I') return;
    if(c=='A') exit(1);
    }    
}

void writesec(unsigned drive,unsigned head,unsigned track,
	      unsigned sector,unsigned nsects,void *buffer)
{
unsigned i;
char c;
for(;;) {
    for(i=0;i<3;i++) 
	if(!biosdisk(3,drive,head,track,sector,nsects,buffer)) return;
    printf("\nWrite error: drive %02x, head %u, track %u\n",
	    drive,head,track);
    printf("Abort, Retry, Ignore? ");
    c=toupper(getch()); printf("%c\n",c);
    if(c=='I') return;
    if(c=='A') exit(1);
    }    
}

int getyn(void)
{
char c;
for(;;)
    {
    c=getch();
    if(c=='y'||c=='Y') { printf("Yes\n\n"); return(TRUE); }
    if(c=='n'||c=='N') { printf("No\n\n"); return(FALSE); }
    }
}

void getkey(unsigned char *key,unsigned char *check,int confirm)
{
char pass1[MAXPASS];
char pass2[MAXPASS];
unsigned char temp[16];
MD5_CTX md5buf;
unsigned k;

if(confirm) printf("\
You need a passphrase to encrypt this disk. Your passphrase should be\n\
fairly long, and should not appear verbatim in any literature or text.\n\
Passphrases are case sensitive - this can be a security feature or it\n\
can be a hazard. If you lose or forget your passphrase, there is no way\n\
to recover the encrypted data!\n");
enterpass:
if(confirm) printf("\nEnter passphrase: ");
invgets(pass1);
if(confirm) {
   int good=TRUE;
   int upper=FALSE;
   int lower=FALSE;
   int other=FALSE;
   unsigned i,j;
   char c;
   printf("\n");
   i=strlen(pass1);
   if(i<8) {
       printf("Your passphrase is only %i characters long.\n",i);
       good=FALSE; }
   for(j=0;j<i;j++) {
       c=pass1[j];
       if(isupper(c)) upper=TRUE;
       else if (islower(c)) lower=TRUE;
       else if (!isspace(c)) other=TRUE; }
   if(upper&&!lower&&!other) {
       printf("Your passphrase is monocase (uppercase only).\n");                   
       good=FALSE; }
   if(lower&&!upper&&!other) {
       printf("Your passphrase is monocase (lowercase only).\n");
       good=FALSE; }
   if(i>15) good=TRUE;
   if(!good) printf("\nThis passphrase may not be secure.\
 If you want to use it, retype it to\nconfirm. If not, press return to\
 try again.\n\n");
   printf("Re-enter passphrase: ");
   invgets(pass2);
   printf("\n");
   if(strcmp(pass1,pass2)) {
       printf("Passphrases do not match. Try again.\n");
       goto enterpass; }
   } 
MD5Init(&md5buf);
MD5Update(&md5buf,pass1,strlen(pass1));
MD5Final(key,&md5buf);

MD5Init(&md5buf);
MD5Update(&md5buf,key,16);
MD5Final(temp,&md5buf);
memcpy(check,temp,4);

for(k=0;k<MAXPASS;k++) {
  pass1[k]='\0';
  pass2[k]='\0'; }
}

struct tsrdata far *gettsradr(void)
{
unsigned seg;
unsigned ofs;
struct tsrdata far *ptr;
struct REGPACK rgs;

rgs.r_ax=0x0800;
rgs.r_dx=0x00f0;
intr(0x13,&rgs);
if(rgs.r_ax!=0x0edcb) 
    return( (struct tsrdata far *) NULL);
ptr=(long) rgs.r_dx+(long) 0x10000*rgs.r_cx;
return(ptr);
}

void readptbl(unsigned drive,unsigned head,unsigned track,
	      unsigned char letter,unsigned *ptdrive,
	      unsigned *pthead,unsigned *pttrack)
{
unsigned i,pt,ph,pc;
unsigned char buf[512];
unsigned char *bufp;
if(biosdisk(2,drive+0x80,head,track,1,1,buf)) return;
for(i=0;i<4;i++) {
    bufp=buf+0x1be+(i*16);
    pt=bufp[4];
    ph=bufp[1];
    pc=bufp[3]+(bufp[2]>>6)*256;
    if((pt==1)||(pt==4)||(pt==6))
	if(letter=='C') {
	    *ptdrive=drive;
	    *pthead=ph;
	    *pttrack=pc;
	    return; }
	else(letter--);
    else if(pt==5) readptbl(drive,ph,pc,letter,
			    ptdrive,pthead,pttrack); }
if((drive==0)&&(*ptdrive==255)) readptbl(1,0,0,letter,
					 ptdrive,pthead,pttrack);
}

/*      Compute IDEA encryption subkeys Z */
void en_key_idea(word16 *userkey, word16 *Z)
{
	unsigned i,j;
	word16 *Y=Z;
	/*
	 * shifts
	 */
	for (j=0; j<8; j++)
		Z[j] = *userkey++;

	for (i=0; j<KEYLEN; j++)
	{       i++;
		Z[i+7] = Z[i & 7] << 9 | Z[i+1 & 7] >> 7;
		Z += i & 8;
		i &= 7;
	}
	for(i=0;i<52;i++)
		Y[i]^=0x0dae;
}        /* en_key_idea */

void calcdiskparams(unsigned char *buf,unsigned *maxtrack,
		    unsigned *maxhead,unsigned *maxsector,
		    unsigned *secsize,unsigned serial[2])
{
unsigned long i,l0,l1,l2,l3;
*maxsector=buf[0x18]+256*buf[0x19];
*maxhead=buf[0x1a]+256*buf[0x1b];
*secsize=buf[0x0b]+256*buf[0x0c];
serial[0]=buf[0x27]+256*buf[0x28];
serial[1]=buf[0x29]+256*buf[0x2a];
l0=(unsigned char)buf[0x20];
l1=(unsigned char)buf[0x21];
l2=(unsigned char)buf[0x22];
l3=(unsigned char)buf[0x23];
i=l0+256*(l1+256*(l2+256*(l3)));
if(i==0) i=(unsigned)buf[0x13]+256*buf[0x14];
*maxtrack=i / *maxsector / *maxhead;
if((i%(*maxsector * *maxhead))==0) (*maxtrack)--;
}
