/* Secure Drive LOGIN V1.0 */
/* Logs into encrypted disks */

#include "secdrv.h"

main(int argc,char *argv[])
{
unsigned drive,firstcyl,firsthead,maxtrack;
unsigned maxhead,maxsector,secsize,i;
unsigned safemode=FALSE;
unsigned char buf[512],key[16],check[4];
word16 expkey[52];
unsigned serial[2];

if(argc==1) {
    printf("\n\
Secure Drive Login Version 1.0\n\
This program sets parameters and loads passphrases for encrypted\
 drives.\n\n\
LOGIN /F                         to enter floppy disk passphrase\n\
\n\
LOGIN /C                         to erase keys and disable encryption\n\
\n\
LOGIN drive letter               to activate an encrypted hard drive\n\
LOGIN D:    (example)\n\
LOGIN D: /S                      to prevent accidental access to an\n\
				 encrypted drive without logging in\n\
\n\
LOGIN drive cylinder head        to manually enter parameters for\n\
				 a hard drive partition\n\
LOGIN drive cylinder head /S     to prevent accidental access\n\
LOGIN 0 100 1 (example)\n\
      drives are numbered from zero\n\n");
    exit(1); }

if(!(cryptdata=gettsradr())) {
    printf("\nError: Secure Drive TSR not loaded.\n");
    exit(1); }

if((*argv[1]=='/')&&(toupper(*(argv[1]+1))=='C')) {
   cryptdata->hd.active=0;
   for(i=0;i<104;i++) {
       cryptdata->fkey[i]=0xaa;
       cryptdata->hkey[i]=0xbb; }
   for(i=0;i<4;i++)
       cryptdata->fkeychk[i]=0x0ff;
   printf("\nAll keys erased. System secured.\n");
   exit(0); }

else if((*argv[1]=='/')&&(toupper(*(argv[1]+1))=='F')) {
   printf("\nEnter floppy disk passphrase: ");
   getkey(key,check,FALSE);
   en_key_idea((word16 *) key,expkey);
   memcpy(cryptdata->fkey,expkey,104);
   memcpy(cryptdata->fkeychk,check,4);
   cryptdata->fda.firstcyl=0;
   cryptdata->fdb.firstcyl=0;
   printf("\nFloppy disk encryption enabled.\n");
   exit(0); }

else if(isalpha(*argv[1])) {
   char drvltr=toupper(*argv[1]);
   drive=255;
   readptbl(0,0,0,drvltr,&drive,&firsthead,&firstcyl);
   if(drive==255) {
       printf("\nDrive not found.\n");
       exit(1); }
   if((*argv[2]=='/')&&(toupper(*(argv[2]+1))=='S'))
       safemode=TRUE;
   printf("\nDrive %c is physical hard drive %u, head %u,\
 cylinder %u\n",drvltr,drive,firsthead,firstcyl); }

else {
    i=sscanf(argv[1],"%u",&drive);
    i=i&&sscanf(argv[2],"%u",&firstcyl);
    i=i&&sscanf(argv[3],"%u",&firsthead);
    if((*argv[4]=='/')&&(toupper(*(argv[4]+1))=='S'))
	safemode=TRUE;
    if(!i) {
	printf("\nIncorrect drive, track, or head input.\n\
Run without a command line for help.\n");
	exit(1); }
    }

drive+=0x80;

readsec(drive,firsthead,firstcyl,1,1,buf);

if((buf[510]!=0x55)||(buf[511]!=0xaa)) {
    printf("\nThis is not a boot sector.\n");
    exit(1); }

calcdiskparams(buf,&maxtrack,&maxhead,&maxsector,
	       &secsize,serial);

printf("\nThis disk has: %i tracks, %i sectors, %i heads, sector \
size %i bytes\n",maxtrack+1,maxsector,maxhead,secsize);

if(memcmp("CRYP",buf+3,4)) {
    printf("\nThis disk is not encrypted.\n");
    exit(1); }

if(!safemode) {
    printf("\nEnter hard disk passphrase: ");
    getkey(key,check,FALSE);

    if(memcmp(check,buf+7,4)) {
	printf("\nWrong passphrase.\n");
	exit(1); }

    en_key_idea((word16 *)key,expkey);

    memcpy(cryptdata->hkey,expkey,104); }

cryptdata->hdnum=drive;
cryptdata->hd.firstcyl=firstcyl;
cryptdata->hd.firsthd=firsthead;
cryptdata->hd.firstsec=1;
cryptdata->hd.lastcyl=firstcyl+maxtrack;
cryptdata->hd.maxsec=maxsector;
cryptdata->hd.maxhd=maxhead;
cryptdata->hd.secsize=secsize;
cryptdata->hdnum=drive;
if(!safemode) {
    cryptdata->hd.serial[0]=serial[0];
    cryptdata->hd.serial[1]=serial[1];
    cryptdata->hd.active=1;
    printf("\nHard disk encryption enabled.\n"); }
else printf("\nHard disk set to safe mode.\n");

for(i=0;i<16;i++) key[i]='\0';
for(i=0;i<52;i++) expkey[i]=0;

exit(0);
}
