#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <exec/ports.h>
#include <exec/memory.h>
#include <exec/types.h>
#include <exec/interrupts.h>
#include <devices/input.h>
#include <intuition/intuition.h>
#include <proto/all.h>
#include <clib/exec_protos.h>
#include <clib/alib_protos.h>
#include <clib/intuition_protos.h>

#include "headers/global.h"
#include "headers/deamon.h"
#include "headers/talkto_proto.h"
/*#include "headers/login.h"*/
#include "headers/error_proto.h"



static const char __Version[]=LOGINVERST;

extern void 	ButtonSwap(void);
void		INITKillButtons(void);
void		KillButtons(void);
void		FINALRestoreButtons(void);
void		RestoreButtons(void);

struct IOStdReq		*inputReqBlk;
struct MsgPort		*inputPort;
struct Interrupt	*inputHandler;
UBYTE			device;

void KillButtons() 
{
	inputHandler->is_Code = ButtonSwap;
	inputHandler->is_Data=NULL;
	inputHandler->is_Node.ln_Pri=100;
	inputHandler->is_Node.ln_Name=LOGINVERST;
	inputReqBlk->io_Data=(APTR)inputHandler;
	inputReqBlk->io_Command=IND_ADDHANDLER;
	DoIO((struct IORequest *)inputReqBlk);
	
}

void INITKillButtons() 
{
	if (inputPort = CreatePort(NULL,NULL)) {
		if (inputHandler=AllocMem(sizeof(struct Interrupt),MEMF_PUBLIC+MEMF_CLEAR)){
			if (inputReqBlk=(struct IOStdReq *)CreateExtIO(inputPort,sizeof(struct IOStdReq))) {
				if (!(device = OpenDevice("input.device",NULL,(struct IORequest *)inputReqBlk,NULL))) {
					inputHandler->is_Code = ButtonSwap;
					inputHandler->is_Data=NULL;
					inputHandler->is_Node.ln_Pri=100;
					inputHandler->is_Node.ln_Name=LOGINVERST;
					inputReqBlk->io_Data=(APTR)inputHandler;
					inputReqBlk->io_Command=IND_ADDHANDLER;
					DoIO((struct IORequest *)inputReqBlk);
				}
				else {
					Error("Could not open input.device");
					DeleteExtIO((struct IORequest *)inputReqBlk);
					exit(10);
				}
			}
			else {
				Error("Could not create IORequest");
				FreeMem(inputHandler,sizeof(struct Interrupt));
				exit(10);
			}
		}
		else {
			Error("could not allocate interrupt struct Memory");
			DeletePort(inputPort);	
			exit(10);
		}
		
	}
	else {
		Error("could not create message port");
		exit (10);
	}
}

void RestoreButtons()
{
	inputReqBlk->io_Data=(APTR)inputHandler;
	inputReqBlk->io_Command=IND_REMHANDLER;
	DoIO((struct IORequest *)inputReqBlk);
}

void FINALRestoreButtons()
{
	inputReqBlk->io_Data=(APTR)inputHandler;
	inputReqBlk->io_Command=IND_REMHANDLER;
	DoIO((struct IORequest *)inputReqBlk);
	DeleteExtIO((struct IORequest*)inputReqBlk);
	FreeMem(inputHandler,sizeof(struct Interrupt));
	DeletePort(inputPort);
}
