**
**	$VER: libhdr.i 1.1 (13.01.1994)
**
**	library header include file
**
**	 Copyright 1994 by Norbert Pschel
**	All Rights Reserved
**
**	Include & assemble with asm -iINCLUDE:
**

	IFND	LIBHDR_I
LIBHDR_I	SET	1

* includes

	IFND EXEC_TYPES_I
	INCLUDE 'exec/types.i'
	ENDC
	IFND EXEC_LIBRARIES_I
	INCLUDE 'exec/libraries.i'
	ENDC
	IFND EXEC_RESIDENT_I
	INCLUDE 'exec/resident.i'
	ENDC
	IFND EXEC_INITIALIZERS_I
	INCLUDE	'exec/initializers.i'
	ENDC

* CALLSYS macro

CALLSYS	MACRO
	move.l	A6,-(SP)
	move.l	_SysBase,A6
	jsr	_LVO\1(A6)
	move.l	(SP)+,A6
	ENDM

* _LVOs

_LVORemove      	EQU	-252
_LVOFreeMem     	EQU	-210

* library code & romtag

	SECTION	TEXT,CODE

StartCode:
	moveq	#-1,D0
	rts

RomTag:
	dc.w	RTC_MATCHWORD
	dc.l	RomTag
	dc.l	EndCode
	dc.b	RTF_AUTOINIT
	dc.b	VER
	dc.b	NT_LIBRARY
	dc.b	PRI
	dc.l	_LibName
	dc.l	_LibID
	dc.l	InitTab

	IFND	BASE_SIZE
BASE_SIZE	EQU	LIB_SIZE
	ENDC

InitTab:
	dc.l	BASE_SIZE
	dc.l	_FuncTable
	dc.l	_DataTable
	dc.l	_aLibInit

_DataTable:
	INITBYTE	LN_TYPE,NT_LIBRARY
	INITLONG	LN_NAME,_LibName
	INITBYTE	LIB_FLAGS,LIBF_SUMUSED!LIBF_CHANGED
	INITWORD	LIB_VERSION,VER
	INITWORD	LIB_REVISION,REV
	INITLONG	LIB_IDSTRING,_LibID
	dc.l		0

_aLibInit:
	move.l	A0,_SegList
	move.l	A6,_SysBase
	move.l	D0,_LibBase	; set global variables
	rts

	IFD	GLOBAL
	XREF	_LIBGlobalAlloc
	XREF	_LIBGlobalFree	; this must not break a Forbid() !!!
	ENDC

	IFD	LOCAL
	XREF	_LIBLocalAlloc
	XREF	_LIBLocalFree
	ENDC

_aLibOpen:
	IFD	GLOBAL
	tst.l	_InitFlag
	bne.s	1$
	move.l	A6,D0
	jsr	_LIBGlobalAlloc
	tst.l	D0
	beq.s	2$
	move.l	D0,_InitFlag
1$:
	ENDC

	IFD	LOCAL
	move.l	A6,D0
	jsr	_LIBLocalAlloc
	tst.l	D0
	beq.s	2$
	ENDC

	move.l	A6,D0
	addq.w	#1,LIB_OPENCNT(A6)
	bclr	#LIBB_DELEXP,LIB_FLAGS(A6)

2$:	rts

_aLibClose:
	IFND	LOCAL
	moveq.l	#0,D0
	ENDC

	subq.w	#1,LIB_OPENCNT(A6)

	IFD	LOCAL
	move.l	A6,D0
	jsr	_LIBLocalFree
	tst.l	D0
	bne.s	1$
	addq.w	#1,LIB_OPENCNT(A6)
	bra.s	2$
1$:	moveq.l	#0,D0
	tst.w	LIB_OPENCNT(A6)
	ENDC

	bne.s	2$
	btst	#LIBB_DELEXP,LIB_FLAGS(A6)
	beq.s	2$
	bsr	_aLibExpunge

2$:	rts

_aLibExpunge:
	tst.w	LIB_OPENCNT(A6)
	beq.s	1$

	bset	#LIBB_DELEXP,LIB_FLAGS(A6)
	moveq.l	#0,D0
	bra.s	3$

1$:
	IFD	GLOBAL
	tst.l	_InitFlag
	beq.s	2$
	move.l	A6,D0
	jsr	_LIBGlobalFree	; this must not break the Forbid() !
	tst.l	D0
	bne.s	2$
	bset	#LIBB_DELEXP,LIB_FLAGS(A6)
	bra.s	3$
2$:
	ENDC

	move.l	A6,A1
	CALLSYS	Remove

	moveq.l	#0,D0
	move.l	A6,A1
	move.w	LIB_NEGSIZE(A6),D0
	sub.l	D0,A1
	add.w	LIB_POSSIZE(A6),D0
	CALLSYS	FreeMem

	move.l	_SegList,D0

3$:	rts

_aLibExtFunc:
	moveq.l	#0,D0
	rts

	IFD	REXX

	XREF	_LIBRexxQuery

_aLibRexxQuery:
	link	A5,#-4
	lea	-4(A5),A1
	jsr	_LIBRexxQuery
	move.l	-4(A5),A0
	unlk	A5
	rts

	ENDC	

EndCode:

	SECTION	__MERGED,DATA

* LIBRARY macro for generating the function table

LIBRARY	MACRO

VER	EQU	\2
REV	EQU	\3
PRI	EQU	\4

	XDEF	_\5
	XDEF	_SysBase

_\5:
_LibBase:
	dc.l	0
_SysBase:
	dc.l	0
_SegList:
	dc.l	0
	IFD	GLOBAL
_InitFlag:
	dc.l	0
	ENDC

	dc.b	'$VER: '
_LibID:
	dc.b	\1,' \2.\3 (',\6,')',13,10,0
_LibName:
	dc.b	\1,0
	dc.w	0

_FuncTable:
	dc.l	_aLibOpen
	dc.l	_aLibClose
	dc.l	_aLibExpunge
	dc.l	_aLibExtFunc

	IFD	REXX
	dc.l	_aLibRexxQuery
	ENDC

	ENDM

FUNCDEF	MACRO
	XREF	_LIB\1
	dc.l	_LIB\1
	ENDM

ENDLIB	MACRO
	dc.l	-1
	ENDM

	ENDC	; LIBHDR_I
