(*

	Frank J. Beckamnn  (26.10.1993)

	HomeDir - get the homedirectory of a user


	Usage:  HomeDir USERID,UID/K/N

		Only USERID or UID may be specified.
		If no argument is given HomeDir uses the UID of logged user.

*)

MODULE HomeDir;

FROM SYSTEM IMPORT
 ADDRESS, ADR;

FROM Arts IMPORT
 returnVal;
FROM String IMPORT
 Copy;
FROM Terminal IMPORT
 WriteString, WriteLn, Flush;

FROM DosD IMPORT
 RDArgsPtr;
FROM DosL IMPORT
 ReadArgs;

FROM MultiUserD IMPORT
 UserInfoPtr, keyTypeUid, keyTypeUserID, useridsize;
FROM MultiUserL IMPORT
 AllocUserInfo, GetTaskOwner, GetUserInfo, FreeUserInfo;


CONST
 version=ADDRESS{ADR("$VER: HomeDir 39.4 (26.10.1993)\n")};


TYPE
 User=RECORD
  CASE :INTEGER OF
  | 1: user: LONGCARD;
  | 2: uid: CARDINAL; gid: CARDINAL;
  END;
 END;

 MyArg=RECORD
  CASE :INTEGER OF
  | 1: num: LONGCARD;
  | 2: str: ARRAY [0..useridsize-1] OF CHAR;
  END;
 END;


PROCEDURE NoUser();
 BEGIN
  WriteString("Error: No user!");
  WriteLn();
  returnVal:=10;
 END NoUser;


PROCEDURE ExtractUid(u: LONGCARD): CARDINAL;
 VAR
  user: User;
 BEGIN
  user.user:=u;
  RETURN user.uid;
 END ExtractUid;


VAR
 info: UserInfoPtr;
 args: RDArgsPtr;
 argarray: ARRAY [0..1] OF POINTER TO MyArg;
 keyType: LONGINT;
 error: BOOLEAN;


BEGIN
 argarray[0]:=NIL; argarray[1]:=NIL;
 args:=ReadArgs(ADR("USERID,UID/K/N"),ADR(argarray),NIL);
 IF args # NIL THEN
  IF (argarray[0] = NIL) OR (argarray[1] = NIL) THEN
   info:=AllocUserInfo();
   IF info # NIL THEN
    error:=FALSE;
    IF (argarray[0] = NIL) AND (argarray[1] = NIL) THEN
     keyType:=keyTypeUid;
     info^.uid:=ExtractUid(GetTaskOwner(NIL));
     IF info^.uid = 0 THEN error:=TRUE END;
    ELSIF argarray[0] = NIL THEN
     keyType:=keyTypeUid;
     info^.uid:=CARDINAL(argarray[1]^.num);
    ELSE
     keyType:=keyTypeUserID;
     Copy(info^.userID, argarray[0]^.str);
    END;
    IF NOT error THEN
     IF GetUserInfo(info, keyType) THEN
      WriteString(info^.homeDir); Flush(); (* Sometimes Flush() is needed ?! *)
      WriteLn();
     ELSE
      NoUser();
     END;
    ELSE
     NoUser();
    END;
    FreeUserInfo(info);
   ELSE
    WriteString("Error: No memory for UserInfo!");
    WriteLn();
    returnVal:=20;
   END;
  ELSE
   WriteString("Error: Please only one argument!");
   WriteLn();
   returnVal:=10;
  END;
 ELSE
  WriteString("Error in arguments");
  WriteLn();
  returnVal:=10;
 END;
END HomeDir.
