The EXE file included with this MS-DOS distribution of btoa will run
properly under this operating system. There is no need to mess with the
C sources unless you really want to. For those so inclined, here is how
I ported btoa to MS-DOS.

Porting btoa to MS-DOS proved to be fairly easy. The problem that I encountered
is that MS-DOS handles binary files and text files slightly differently.
Most operating systems don't have this problem, since they use a single
character to mark the end of a text line. The initial input file to btoa
is assumed to be a binary file. So is the final output when the encoded
file is decoded. Every other file that btoa uses is a text file. The
problem, then, is to make sure that the right file is thrown into
binary mode at the right time, depending on the process requested --
encoding or decoding.

Luckily, this is no great problem. In fact, it can be solved by adding
only 3 lines to the btoa.c source file. None of the other files require
alteration. For those with the Unix-type "patch" utility, I have
provided atob.dif for you, which will autopatch btoa.c for you.

If you need to do the port manually, here's how to go about it:

[ ] Start a text editor and load btoa.c
[ ] Add the following line to the very top of the file:
	#include <fcntl.h>
[ ] fcntl.h contains the definition for O_BINARY

[ ] locate the following if-block in function main():
  if (!error)
  {
    if (diagnosis)
      error = producerepair(infile);
    else if (repair)
      error = performrepair(infile);
    else if (a_to_b)
      error = atob(infile);
    else
      error = btoa(infile, infilename);
  }

[ ] The above block calls the major function that btoa is to do (encode,
    decode, or do 1 of 2 repair functions. After you have located it,
    change it so that it reads as follows:
  if (!error)
  {
    if (diagnosis)
      error = producerepair(infile);
    else if (repair)
      error = performrepair(infile);
    else if (a_to_b)
    {
      setmode(fileno(outfile), O_BINARY);
      error = atob(infile);
    }
    else
    {
      setmode(fileno(infile), O_BINARY);
      error = btoa(infile, infilename);
    }
 }

[ ] You are now done with the repairs.
[ ] Compile btoa.c , atob.c , and repair.c , then link all 3 obj files
    together to form btoa.exe .

--
Duane A. Paulson_
dap@kandy.com  | | _____    The Kandy Shack BBS, est. 1982
dap@netcom.com | |/ / __|  Garden Grove, CA +1 714 636-2667
      --       |   <\__ \   Public Access Usenet/Internet!
Santa Ana, CA  |_|\_\___/ Co-sysop/Programmer. Stop by/Say hi!
