/****************************************************************************
*
* VERSION
*	$VER: parse.c 1.71 (18.12.93)
*
* DESCRIPTION
*	Icon args parser...
*
* AUTHOR
*	Rune Johnsrud
*
* COPYRIGHT
*	(c) 1993 Amiga Freelancers
*
*****************************************************************************/

#define INTUI_V36_NAMES_ONLY

#include <exec/types.h>
#include <exec/memory.h>
#include <dos/dos.h>
#include <workbench/workbench.h>
#include <workbench/startup.h>
#include <utility/date.h>

#include <clib/alib_stdio_protos.h>

#include <proto/dos.h>
#include <proto/icon.h>
#include <proto/exec.h>

#include <stdlib.h>
#include <string.h>

#include "global.h"

/************************************************************************/

extern struct GlobalData *gd;
extern struct ClockInfo *ci;

/************************************************************************/

static BOOL ReplaceTool(UBYTE **ttarr, UBYTE *ts, UBYTE *rps);

/************************************************************************/


WORD ParseIconArgs(struct WBStartup *wbs)
{
	struct DiskObject *dobj;
	UBYTE **tarray;
	UBYTE *s;
	WORD errcode = NOERROR;

	if (!wbs) return GEN_ERR_NOICONARGS;

	CurrentDir(wbs->sm_ArgList->wa_Lock);

	if (dobj = GetDiskObject(wbs->sm_ArgList->wa_Name))
	{
		tarray = (char **) dobj->do_ToolTypes;

		if (s = FindToolType(tarray, "PUBSCREEN"))
			strncpy(ci->PubScreenName, s, MAXPUBSCREENNAME);
		else
			strcpy(ci->PubScreenName, "Workbench");

		if (s = FindToolType(tarray, "CLOCKTYPE"))
		{
			if (MatchToolValue(s, "ANALOG"))
				ci->ClockType = CT_ANALOG;
			else
				ci->ClockType = CT_DIGITAL;
		}

		if (s = FindToolType(tarray, "TOPPOS"))
			ci->Top = atoi(s);

		if (s = FindToolType(tarray, "LEFTPOS"))
			ci->Left = atoi(s);

		if (s = FindToolType(tarray, "WIDTH"))
			ci->Width = atoi(s);

		if (ci->Width <= MIN_ACLOCK_WIDTH) ci->Width = MIN_ACLOCK_WIDTH;

		if (s = FindToolType(tarray, "HEIGHT"))
			ci->Height = atoi(s);

		if (ci->Height <= MIN_ACLOCK_HEIGHT) ci->Height = MIN_ACLOCK_HEIGHT;

		if (s = FindToolType(tarray, "FONTNAME"))
			strncpy(ci->FontName, s, 254);
		else
			strcpy(ci->FontName, "topaz.font");

		if (s = FindToolType(tarray, "FONTSIZE"))
			ci->FontSize = atoi(s);

		if (ci->FontSize > 127) ci->FontSize = 127;
		if (ci->FontSize <   1) ci->FontSize =   1;

		gd->TextAttr.ta_Name  = ci->FontName;
		gd->TextAttr.ta_YSize = ci->FontSize;
		gd->TextAttr.ta_Style = FS_NORMAL;
		gd->TextAttr.ta_Flags = 0;

		if (s = FindToolType(tarray, "BACKDROP"))
			strncpy(ci->BDRPic, s, 254);
		else
			ci->BDRPic = NULL;

/*** Global Flags ********************************************************/

		if (s = FindToolType(tarray, "GLOBALFLAGS"))
		{
//			if (MatchToolValue(s, "SHOWTIME")) ci->ShowTime = TRUE;	/* Not yet implemented */

			if (MatchToolValue(s, "SHOWDATE"))
				ci->ShowDate = TRUE;
			else
				ci->ShowDate = FALSE;

			if (MatchToolValue(s, "SHOWSEC")) ci->ShowSec = TRUE;

			if (MatchToolValue(s, "EDGEBEVEL"))
				ci->WinBevel = TRUE;
			else
				ci->WinBevel = FALSE;

			if (MatchToolValue(s, "BACKDROPWIN")) ci->BDClock = TRUE;

			if (MatchToolValue(s, "LOCKPOS")) ci->LockPos = TRUE;
		}

/*** Analog Flags ********************************************************/

		if (s = FindToolType(tarray, "ANALOGFLAGS"))
		{
			if (MatchToolValue(s, "PLACECLOCK"))	ci->PlaceClock = TRUE;
			if (MatchToolValue(s, "SHOWDIAL"))		ci->ShowDial   = TRUE;
			if (MatchToolValue(s, "AUTOSIZE"))		ci->AutoSize   = TRUE;
		}

/*** Digital Flags *******************************************************/

//		if (s = FindToolType(tarray, "DIGITALFLAGS"))
//		{
//			/* We need some FLAGS!!! */
//		}

/*************************************************************************/

//		if (s = FindToolType(tarray, "BEVELDEPTH"))		/* Not yet Implemented */
//			ci->BevelDepth = atoi(s);

		if (s = FindToolType(tarray, "TEXTPEN"))
			ci->TextPen = atoi(s);

		if (s = FindToolType(tarray, "BGPEN"))
			ci->BGPen = atoi(s);

		if (s = FindToolType(tarray, "SHINEPEN"))
			ci->ShinePen = atoi(s);

		if (s = FindToolType(tarray, "SHADOWPEN"))
			ci->ShadowPen = atoi(s);

		if (s = FindToolType(tarray, "DATESEPARATOR"))
		{
			if (strlen(s) > 0)
				strncpy(ci->DateSep, s, 1);
		}

		if (s = FindToolType(tarray, "TIMESEPARATOR"))
		{
			if (strlen(s) > 0)
				strncpy(ci->TimeSep, s, 1);
		}

		if (s = FindToolType(tarray, "DATEFORMAT"))
			ci->DateFormat = atoi(s);

		if (ci->DateFormat > NUM_OF_DATEFORMATS) ci->DateFormat = NUM_OF_DATEFORMATS;

		if (s = FindToolType(tarray, "DATESPACING"))
			ci->DateSpc = atoi(s);

		if (ci->DateSpc < 0) ci->DateSpc = 0;

		if (s = FindToolType(tarray, "EDGESPACING"))
			ci->EdgeSpace = atoi(s);

		if (ci->EdgeSpace < 1) ci->EdgeSpace = 1;

		if (s = FindToolType(tarray, "MINSMALLPEN"))
			ci->apn.MinSmallPen = atoi(s);

		if (s = FindToolType(tarray, "MINLARGEPEN"))
			ci->apn.MinLargePen = atoi(s);

		if (s = FindToolType(tarray, "SECPEN"))
			ci->apn.SecPen = atoi(s);

		if (s = FindToolType(tarray, "MINPEN"))
			ci->apn.MinPen = atoi(s);

		if (s = FindToolType(tarray, "HOURPEN"))
			ci->apn.HourPen = atoi(s);

		if (s = FindToolType(tarray, "MINXSCALE"))
			ci->ap.MIXScale = atoi(s);

		if (ci->ap.MIXScale < 1) ci->ap.MIXScale = 1;

		if (s = FindToolType(tarray, "MINYSCALE"))
			ci->ap.MIYScale = atoi(s);

		if (ci->ap.MIYScale < 1) ci->ap.MIYScale = 1;

		if (s = FindToolType(tarray, "CLOCKLEFT"))
			ci->ap.ClockLeft = atoi(s);

		if (ci->ap.ClockLeft < 1) ci->ap.ClockLeft = 1;

		if (s = FindToolType(tarray, "CLOCKTOP"))
			ci->ap.ClockTop = atoi(s);

		if (ci->ap.ClockTop < 1) ci->ap.ClockTop = 1;

		if (s = FindToolType(tarray, "CLOCKHEIGHT"))
			ci->ap.ClockHeight = atoi(s);

		if (ci->ap.ClockHeight <= MIN_ACLOCK_HEIGHT) ci->ap.ClockHeight = MIN_ACLOCK_HEIGHT;

		if (s = FindToolType(tarray, "CLOCKWIDTH"))
			ci->ap.ClockWidth = atoi(s);

		if (ci->ap.ClockWidth <= MIN_ACLOCK_WIDTH) ci->ap.ClockWidth = MIN_ACLOCK_WIDTH;

		if (s = FindToolType(tarray, "DIALPEN"))
			ci->apn.DialPen = atoi(s);

		if (s = FindToolType(tarray, "DIALOUTLINEPEN"))
			ci->apn.DialOPen = atoi(s);

		FreeDiskObject(dobj);
	}
	else errcode = GEN_ERR_READICON;

	return errcode;	
}


static BOOL ReplaceTool(UBYTE **ttarr, UBYTE *ts, UBYTE *rps)
{
	WORD a = 0;

	while (ttarr[a])
	{
		if (strnicmp(ttarr[a], ts, strlen(ts)) == 0)
		{
			ttarr[a] = rps;
			return FALSE;
		}
		a++;
	}
	return TRUE;
}


WORD SaveCurrSettings(struct WBStartup *wbs)
{
	struct DiskObject *dobj;
	static UBYTE buff[7][512];
	UBYTE **oldtooltypes, **tarray;
	WORD errcode = NOERROR;

	if (!wbs) return GEN_ERR_NOICONARGS;

	CurrentDir(wbs->sm_ArgList->wa_Lock);

	if (dobj = GetDiskObject(wbs->sm_ArgList->wa_Name))
	{
		tarray = (char **) dobj->do_ToolTypes;

		sprintf(buff[0], "TOPPOS=%ld", gd->ClockWindow->TopEdge);
		ReplaceTool(tarray, "TOPPOS", (UBYTE *) &buff[0]);

		sprintf(buff[1], "LEFTPOS=%ld", gd->ClockWindow->LeftEdge);
		ReplaceTool(tarray, "LEFTPOS", (UBYTE *) &buff[1]);

		if (ci->AutoSize)
		{
			sprintf(buff[2], "WIDTH=%ld", ci->Width);
			ReplaceTool(tarray, "WIDTH", (UBYTE *) &buff[2]);

			sprintf(buff[3], "HEIGHT=%ld", ci->Height);
			ReplaceTool(tarray, "HEIGHT", (UBYTE *) &buff[3]);
		}

		if (ci->ClockType == CT_DIGITAL)
		{
			sprintf(buff[4], "FONTNAME=%s", gd->TextAttr.ta_Name);
			ReplaceTool(tarray, "FONTNAME", (UBYTE *) &buff[4]);

			sprintf(buff[5], "FONTSIZE=%ld", gd->TextAttr.ta_YSize);
			ReplaceTool(tarray, "FONTSIZE", (UBYTE *) &buff[5]);
		}

		if (ci->ClockType == CT_ANALOG)
		{
			sprintf(buff[6], "BACKDROP=%s", ci->BDRPic);
			ReplaceTool(tarray, "BACKDROP", (UBYTE *) &buff[6]);
		}

		oldtooltypes = dobj->do_ToolTypes;
		dobj->do_ToolTypes = tarray;

		if (!PutDiskObject(wbs->sm_ArgList->wa_Name, dobj))
			errcode = GEN_ERR_WRITEICON;

		dobj->do_ToolTypes = oldtooltypes;
		FreeDiskObject(dobj);
	}
	else errcode = GEN_ERR_READICON;

	return errcode;
}


/* End Of File */
