


     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



     NAME
          ppmforge - fractal forgeries of clouds, planets, and starry
          skies

     SYNOPSIS
          ppmforge [-clouds] [-night] [-dimension dimen] [-hour hour]
                   [-inclination|-tilt angle] [-mesh size] [-power
                   factor] [-glaciers level] [-ice level] [-saturation
                   sat] [-seed seed] [-stars fraction] [-xsize|-width
                   width] [-ysize|-height height]

     DESCRIPTION
          ppmforge generates three  kinds  of  ``random  fractal  for-
          geries,'' the term coined by Richard F. Voss of the IBM Tho-
          mas J. Watson Research Center for seemingly  realistic  pic-
          tures  of natural objects generated by simple algorithms em-
          bodying randomness and fractal self-similarity.   The  tech-
          niques  used  by  ppmforge  are  essentially  those given by
          Voss[1], particularly the technique  of  spectral  synthesis
          explained in more detail by Dietmar Saupe[2].

          The program generates two varieties of pictures: planets and
          clouds, which are just different renderings of data generat-
          ed in an identical manner, illustrating  the  unity  of  the
          fractal  structure of these very different objects.  A third
          type of picture, a starry sky, is synthesised directly  from
          pseudorandom numbers.

          The generation of planets or clouds begins with the prepara-
          tion  of  an  array  of random data in the frequency domain.
          The size of this array, the ``mesh size,'' can be  set  with
          the -mesh option; the larger the mesh the more realistic the
          pictures but the calculation time and memory requirement in-
          creases  as the square of the mesh size.  The fractal dimen-
          sion, which you can  specify  with  the  -dimension  option,
          determines the roughness of the terrain on the planet or the
          scale of detail in the clouds.  As the fractal dimension  is
          increased, more high frequency components are added into the
          random mesh.

          Once the mesh  is  generated,  an  inverse  two  dimensional
          Fourier  transform  is performed upon it.  This converts the
          original random frequency domain data  into  spatial  ampli-
          tudes.   We  scale  the real components that result from the
          Fourier transform into numbers from 0 to 1  associated  with
          each  point on the mesh.  You can further modify this number
          by applying a ``power law scale'' to it with the -power  op-
          tion.    Unity  scale leaves the numbers unmodified; a power
          scale of 0.5 takes the square root of  the  numbers  in  the
          mesh,  while  a power scale of 3 replaces the numbers in the
          mesh with their cubes.  Power law scaling is best envisioned
          by  thinking  of  the  data as representing the elevation of



     Page 1                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



          terrain; powers less than 1 yield landscapes  with  vertical
          scarps  that  look  like  glacially-carved  valleys;  powers
          greater than one make  fairy-castle  spires  (which  require
          large mesh sizes and high resolution for best results).

          After these calculations, we have a array of  the  specified
          size containing numbers that range from 0 to 1.  The pixmaps
          are generated as follows:

          Clouds    A colour map is created that ranges from pure blue
                    to white by increasing admixture (desaturation) of
                    blue  with  white.   Numbers  less  than  0.5  are
                    coloured  blue,  numbers  between  0.5 and 1.0 are
                    coloured with corresponding levels of white,  with
                    1.0 being pure white.

          Planet    The mesh is projected onto a sphere.  Values  less
                    than  0.5  are treated as water and values between
                    0.5 and 1.0 as land.  The water areas are coloured
                    based  upon the water depth, and land based on its
                    elevation.  The random  depth  data  are  used  to
                    create  clouds over the oceans.  An atmosphere ap-
                    proximately like the  Earth's  is  simulated;  its
                    light  absorption  is  calculated to create a blue
                    cast around the limb of the  planet.   A  function
                    that  rises from 0 to 1 based on latitude is modu-
                    lated by the local elevation to generate polar ice
                    caps--high   altitude   terrain  carries  glaciers
                    farther from the pole.  Based on the  position  of
                    the  star  with  respect  to the observer, the ap-
                    parent colour of each pixel of the planet is  cal-
                    culated by ray-tracing from the star to the planet
                    to the observer and applying a lighting model that
                    sums  ambient  light  and  diffuse reflection (for
                    most planets ambient light is zero, as their  pri-
                    mary  star  is  the  only source of illumination).
                    Additional random data are used to generate  stars
                    around the planet.

          Night     A sequence of pseudorandom numbers is used to gen-
                    erate stars with a user specified density.

          Cloud pictures always contain 256 or fewer colours  and  may
          be  displayed  on most colour mapped devices without further
          processing.  Planet pictures often contain tens of thousands
          of  colours  which  must  be  compressed  with  ppmquant  or
          ppmdither before encoding in a colour mapped format.  If the
          display  resolution is high enough, ppmdither generally pro-
          duces better looking  planets.   ppmquant  tends  to  create
          discrete colour bands, particularly in the oceans, which are
          unrealistic and distracting.  The number of colours in star-
          ry  sky pictures generated with the -night option depends on



     Page 2                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



          the value specified for -saturation.  Small values limit the
          colour  temperature distribution of the stars and reduce the
          number of colours in the image.  If the -saturation  is  set
          to  0,  none of the stars will be coloured and the resulting
          image will never contain more than 256 colours.   Night  sky
          pictures  with  many  different star colours often look best
          when colour compressed by pnmdepth rather than  ppmquant  or
          ppmdither.   Try  newmaxval  settings  of 63, 31, or 15 with
          pnmdepth to reduce the number of colours in the  picture  to
          256 or fewer.

     OPTIONS
          -clouds   Generate clouds.  A pixmap of  fractal  clouds  is
                    generated.   Selecting clouds sets the default for
                    fractal dimension to 2.15 and power  scale  factor
                    to 0.75.

          -dimension dimen
                    Sets the fractal dimension to the specified dimen,
                    which  may  be  any floating point value between 0
                    and 3.   Higher  fractal  dimensions  create  more
                    ``chaotic''  images,  which require higher resolu-
                    tion output and a larger FFT  mesh  size  to  look
                    good.   If  no dimension is specified, 2.4 is used
                    when generating planets and 2.15 for clouds.

          -glaciers level
                    The floating point level setting controls the  ex-
                    tent  to which terrain elevation causes ice to ap-
                    pear at lower latitudes.   The  default  value  of
                    0.75  makes the polar caps extend toward the equa-
                    tor across high terrain and forms glaciers in  the
                    highest  mountains,  as  on  Earth.  Higher values
                    make ice sheets that cover more and  more  of  the
                    land  surface,  simulating planets in the midst of
                    an ice age.   Lower  values  tend  to  be  boring,
                    resulting in unrealistic geometrically-precise ice
                    cap boundaries.

          -hour hour
                    When generating a planet,  hour  is  used  as  the
                    ``hour  angle  at  the central meridian.''  If you
                    specify -hour 12, for example, the planet will  be
                    fully  illuminated,  corresponding to high noon at
                    the longitude at the centre of  the  screen.   You
                    can specify any floating point value between 0 and
                    24 for hour, but values which place  most  of  the
                    planet in darkness (0 to 4 and 20 to 24) result in
                    crescents which, while pretty, don't give you many
                    illuminated  pixels  for  the  amount of computing
                    that's required.  If no -hour option is specified,
                    a random hour angle is chosen, biased so that only



     Page 3                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



                    25% of the images generated will be crescents.

          -ice level
                    Sets the extent of the polar ice caps to the given
                    floating  point  level.   The default level of 0.4
                    produces ice caps similar to those of  the  Earth.
                    Smaller  values  reduce  the  amount of ice, while
                    larger -ice settings  create  more  prominent  ice
                    caps.   Sufficiently  large values, such as 100 or
                    more, in conjunction with  small  settings  for  -
                    glaciers (try 0.1) create ``ice balls'' like Euro-
                    pa.

          -inclination|-tilt angle
                    The inclination angle of the planet with regard to
                    its primary star is set to angle, which can be any
                    floating point value from -90 to 90.  The inclina-
                    tion angle can be thought of as specifying, in de-
                    grees, the ``season'' the planet is presently  ex-
                    periencing  or,  more  precisely,  the latitude at
                    which the star transits the zenith at local  noon.
                    If  0,  the  planet  is  at  equinox;  the star is
                    directly overhead at the equator.  Positive values
                    represent summer in the northern hemisphere, nega-
                    tive values summer  in  the  southern  hemisphere.
                    The  Earth's  inclination  angle,  for example, is
                    about  23.5  at  the  June  solstice,  0  at   the
                    equinoxes in March and September, and -23.5 at the
                    December solstice.  If  no  inclination  angle  is
                    specified,  a  random value between -21.6 and 21.6
                    degrees is chosen.

          -mesh size
                    A mesh of size by size will be used for  the  fast
                    Fourier  transform  (FFT).   Note  that memory re-
                    quirements and computation speed increase  as  the
                    square  of  size; if you double the mesh size, the
                    program will use four times  the  memory  and  run
                    four  times as long.  The default mesh is 256x256,
                    which produces reasonably  good  looking  pictures
                    while  using half a megabyte for the 256x256 array
                    of single precision complex  numbers  required  by
                    the  FFT.  On machines with limited memory capaci-
                    ty, you may have to reduce the mesh size to  avoid
                    running out of RAM.  Increasing the mesh size pro-
                    duces better looking pictures; the difference  be-
                    comes particularly noticeable when generating high
                    resolution images with relatively high fractal di-
                    mensions (between 2.2 and 3).

          -night    A starry sky is generated.  The stars are  created
                    by the same algorithm used for the stars that sur-



     Page 4                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



                    round planet pictures, but the output consists ex-
                    clusively of stars.

          -power factor
                    Sets the ``power factor'' used to scale elevations
                    synthesised  from  the FFT to factor, which can be
                    any floating point number greater than  zero.   If
                    no factor is specified a default of 1.2 is used if
                    a planet is being generated, or 0.75 if clouds are
                    selected by the -clouds option.  The result of the
                    FFT image  synthesis  is  an  array  of  elevation
                    values  between 0 and 1.  A non-unity power factor
                    exponentiates each  of  these  elevations  to  the
                    specified power.  For example, a power factor of 2
                    squares each value, while a power  factor  of  0.5
                    replaces  each  with  its square root.  (Note that
                    exponentiating  values  between  0  and  1  yields
                    values that remain within that range.)  Power fac-
                    tors less than 1 emphasise  large-scale  elevation
                    changes at the expense of small variations.  Power
                    factors greater than 1 increase the  roughness  of
                    the terrain and, like high fractal dimensions, may
                    require a  larger  FFT  mesh  size  and/or  higher
                    screen resolution to look good.

          -saturation sat
                    Controls the degree of colour  saturation  of  the
                    stars that surround planet pictures and fill star-
                    ry skies created with the -night option.  The  de-
                    fault  value  of  125 creates stars which resemble
                    the sky as seen by the human eye from Earth's sur-
                    face.   Stars are dim; only the brightest activate
                    the cones in the human retina, causing  colour  to
                    be  perceived.   Higher  values of sat approximate
                    the appearance of stars from  Earth  orbit,  where
                    better  dark  adaptation,  absence of skyglow, and
                    the concentration of light from a given star  onto
                    a smaller area of the retina thanks to the lack of
                    atmospheric turbulence enhances the perception  of
                    colour.   Values greater than 250 create ``science
                    fiction'' skies that, while pretty, don't occur in
                    this universe.

                    Thanks to the inverse  square  law  combined  with
                    Nature's  love of mediocrity, there are many, many
                    dim stars for every bright one.   This  population
                    relationship  is accurately reflected in the skies
                    created by ppmforge.  Dim,  low  mass  stars  live
                    much longer than bright massive stars, consequent-
                    ly there are many reddish stars for every blue gi-
                    ant.   This relationship is preserved by ppmforge.
                    You can reverse the proportion, simulating the sky



     Page 5                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



                    as  seen  in  a  starburst galaxy, by specifying a
                    negative sat value.

          -seed num Sets the seed for the random number  generator  to
                    the  integer  num.   The  seed used to create each
                    picture is displayed on  standard  output  (unless
                    suppressed with the -quiet option).  Pictures gen-
                    erated with the same seed will be  identical.   If
                    no  -seed is specified, a random seed derived from
                    the date and time will be chosen.   Specifying  an
                    explicit  seed  allows  you to re-render a picture
                    you particularly like at a  higher  resolution  or
                    with different viewing parameters.

          -stars fraction
                    Specifies the percentage of pixels, in tenths of a
                    percent,  which  will appear as stars, either sur-
                    rounding a planet or filling the entire  frame  if
                    -night is specified.  The default fraction is 100.

          -xsize|-width width
                    Sets the width of the  generated  image  to  width
                    pixels.   The default width is 256 pixels.  Images
                    must be at least as wide as they are  high;  if  a
                    width  less  than the height is specified, it will
                    be increased to equal the  height.   If  you  must
                    have  a long skinny pixmap, make a square one with
                    ppmforge, then use pnmcut to extract a portion  of
                    the shape and size you require.

          -ysize|-height height
                    Sets the height of the generated image  to  height
                    pixels.  The default height is 256 pixels.  If the
                    height specified exceeds the width, the width will
                    be increased to equal the height.

          All flags can be abbreviated to their shortest  unique  pre-
          fix.

     BUGS
          The algorithms require the output pixmap to be at  least  as
          wide  as  it  is high, and the width to be an even number of
          pixels.  These constraints are enforced  by  increasing  the
          size of the requested pixmap if necessary.

          You may have to reduce the FFT mesh size on machines with 16
          bit integers and segmented pointer architectures.

     SEE ALSO
          pnmcut(1), pnmdepth(1), ppmdither(1), ppmquant(1), ppm(5)

          [1]  Voss, Richard  F.,  ``Random  Fractal  Forgeries,''  in



     Page 6                                          (printed 12/9/93)






     ppmforge(1)          AMIGA (25 October 1991)          ppmforge(1)



               Earnshaw  et.  al., Fundamental Algorithms for Computer
               Graphics, Berlin:  Springer-Verlag, 1985.

          [2]  Peitgen, H.-O., and Saupe,  D.  eds.,  The  Science  Of
               Fractal Images, New York: Springer Verlag, 1988.

     AUTHOR
               John Walker
               Autodesk SA
               Avenue des Champs-Montants 14b
               CH-2074 MARIN
               Suisse/Schweiz/Svizzera/Svizra/Switzerland
               Usenet:  kelvin@Autodesk.com
               Fax:     038/33 88 15
               Voice:   038/33 76 33

          Permission  to  use,  copy,  modify,  and  distribute   this
          software  and  its documentation for any purpose and without
          fee is hereby granted, without any  conditions  or  restric-
          tions.   This software is provided ``as is'' without express
          or implied warranty.

          PLUGWARE! If you like this kind of stuff, you may also enjoy
          ``James Gleick's Chaos--The Software'' for MS-DOS, available
          for $59.95 from your local software store or  directly  from
          Autodesk,  Inc.,  Attn:  Science Series, 2320 Marinship Way,
          Sausalito, CA 94965, USA.  Telephone:  (800) 688-2344  toll-
          free  or,  outside  the  U.S. (415) 332-2344 Ext 4886.  Fax:
          (415) 289-4718.  ``Chaos--The  Software''  includes  a  more
          comprehensive   fractal   forgery  generator  which  creates
          three-dimensional landscapes as well as clouds and  planets,
          plus five more modules which explore other aspects of Chaos.
          The user guide of more than 200 pages includes an  introduc-
          tion by James Gleick and detailed explanations by Rudy Ruck-
          er of the mathematics and algorithms used by each program.




















     Page 7                                          (printed 12/9/93)



