


     libpbm(3)                     AMIGA                     libpbm(3)



     NAME
          libpbm - functions to support portable bitmap programs

     SYNOPSIS
          #include <pbm.h>
          cc ... libpbm.a


     DESCRIPTION - PACKAGE-WIDE ROUTINES
        KEYWORD MATCHING
          int pm_keymatch( char* str, char* keyword, int minchars )

          Does a case-insensitive match of str against keyword.  str
          can be a leading sunstring of keyword, but at least minchars
          must be present.

        LOG BASE TWO
          int pm_maxvaltobits( int maxval )
          int pm_bitstomaxval( int bits )

          Convert between a maxval and the minimum number of bits
          required to hold it.

        MESSAGES AND ERRORS
          void pm_message( char* fmt, ... )

          printf() style routine to write an informational message.

          void pm_error( char* fmt, ... )

          printf() style routine to write an error message and abort.

          void pm_usage( char* usage )

          Write a usage message.  The string should indicate what
          arguments are to be provided to the program.

        GENERIC FILE MANAGEMENT
          FILE* pm_openr( char* name )

          Open the given file for reading, with appropriate error
          checking.  A filename of "-" is taken as equivalent to
          stdin.

          FILE* pm_openw( char* name )

          Open the given file for writing, with appropriate error
          checking.

          void pm_close( FILE* fp )

          Close the file descriptor, with appropriate error checking.



     Page 1                                          (printed 12/9/93)






     libpbm(3)                     AMIGA                     libpbm(3)



        ENDIAN I/O
          int pm_readbigshort( FILE* in, short* sP )
          int pm_writebigshort( FILE* out, short s )
          int pm_readbiglong( FILE* in, long* lP )
          int pm_writebiglong( FILE* out, long l )
          int pm_readlittleshort( FILE* in, short* sP )
          int pm_writelittleshort( FILE* out, short s )
          int pm_readlittlelong( FILE* in, long* lP )
          int pm_writelittlelong( FILE* out, long l )

          Routines to read and write short and long ints in either
          big- or little-endian byte order.

     DESCRIPTION - PBM-SPECIFIC ROUTINES
        TYPES AND CONSTANTS
          typedef ... bit;
          #define PBM_WHITE ...
          #define PBM_BLACK ...

          each bit should contain only the values of PBM_WHITE or
          PBM_BLACK.

          #define PBM_FORMAT ...
          #define RPBM_FORMAT ...
          #define PBM_TYPE PBM_FORMAT
          #define PBM_FORMAT_TYPE(f) ...

          For distinguishing different file formats and types.

        INITIALIZATION
          void pbm_init( int* argcP, char* argv[] )

          All PBM programs must call this routine.

        MEMORY MANAGEMENT
          bit** pbm_allocarray( int cols, int rows )

          Allocate an array of bits.

          bit* pbm_allocrow( int cols )

          Allocate a row of the given number of bits.

          void pbm_freearray( bit** bits, int rows )

          Free the array allocated with pbm_allocarray() containing
          the given number of rows.

          void pbm_freerow( bit* bitrow )

          Free a row of bits.




     Page 2                                          (printed 12/9/93)






     libpbm(3)                     AMIGA                     libpbm(3)



        READING FILES
          void pbm_readpbminit( FILE* fp, int* colsP, int* rowsP, int* formatP )

          Read the header from a PBM file, filling in the rows, cols
          and format variables.

          void pbm_readpbmrow( FILE* fp, bit* bitrow, int cols, int format )

          Read a row of bits into the bitrow array.  Format and cols
          were filled in by pbm_readpbminit().

          bit** pbm_readpbm( FILE* fp, int* colsP, int* rowsP )

          Read an entire bitmap file into memory, returning the
          allocated array and filling in the rows and cols variables.
          This function combines pbm_readpbminit(), pbm_allocarray()
          and pbm_readpbmrow().

          char* pm_read_unknown_size( FILE* fp, long* nread )

          Read an entire file or input stream of unknown size to a
          buffer.  Allocate memory more memory as needed. The calling
          routine has to free the allocated buffer with free().
          pm_read_unknown_size() returns a pointer to the allocated
          buffer. The nread argument returns the number of bytes read.

        WRITING FILES
          void pbm_writepbminit( FILE* fp, int cols, int rows, int forceplain )

          Write the header for a portable bitmap file.  The forceplain
          flag forces a plain-format file to be written, as opposed to
          a raw-format one.

          void pbm_writepbmrow( FILE* fp, bit* bitrow, int cols, int forceplain )

          Write a row from a portable bitmap.

          void pbm_writepbm( FILE* fp, bit** bits, int cols, int rows, int forceplain )

          Write the header and all data for a portable bitmap.  This
          function combines pbm_writepbminit() and pbm_writepbmrow().

     SEE ALSO
          libpgm(3), libppm(3), libpnm(3)

     AUTHOR
          Copyright (C) 1989, 1991 by Tony Hansen and Jef Poskanzer.








     Page 3                                          (printed 12/9/93)



