/* ppmchange.c - change a given color to another
**
** Copyright (C) 1991 by Wilson H. Bent, Jr.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include "ppm.h"


int
main( argc, argv )
    int argc;
    char* argv[];
    {
    FILE* ifp;
    int argn, format, row;
    register int col;
    int rows, cols;
    pixel* prow;
    pixel color0, color1;
    pixval maxval;
    char* usage = "<oldcolor> <newcolor> [ppmfile]";

    ppm_init( &argc, argv );

    argn = 1;

    if ( argn == argc )
	pm_usage( usage );
    color0 = ppm_parsecolor( argv[argn], PPM_MAXMAXVAL );
    ++argn;
    color1 = ppm_parsecolor( argv[argn], PPM_MAXMAXVAL );
    ++argn;

    if ( argn != argc )
	{
	ifp = pm_openr( argv[argn] );
	++argn;
	}
    else
	ifp = stdin;

    if ( argn != argc )
	pm_usage( usage );

    ppm_readppminit( ifp, &cols, &rows, &maxval, &format );
    ppm_writeppminit( stdout, cols, rows, maxval, 0 );
    prow = ppm_allocrow( cols );

    /* Scan for the desired color */
    for ( row = 0; row < rows; ++row )
	{
	ppm_readppmrow( ifp, prow, cols, maxval, format );
	for ( col = 0; col < cols; ++col )
	    if ( PPM_EQUAL( prow[col], color0 ) )
		PPM_ASSIGN( prow[col],
			PPM_GETR( color1 ),
			PPM_GETG( color1 ),
			PPM_GETB( color1 ) );
	ppm_writeppmrow( stdout, prow, cols, maxval, 0 );
	}

    pm_close( ifp );

    exit( 0 );
    }
