/*
** AREXX $VER:MFEdit.rexx1.0 (13.9.1993)
**
** This ARexx script is called from VirMF (or IniMF) in case of an
** error or if the 'e' command is used, and it's given the current file
** and line number as arguments.  We will successively call CygnusEd (CED)
** or Micro(GNU)Emacs (MG) to load the file and the logfile.
** Other editors welcome!
**
** INPUTS:
**    1: filename to edit (please no spaces in filename)
**    2: line where error occured
**
** BUGS:
**    Does not handle names relative to the local root correctly (like ":foo/bar")
**
**    See each editor relative bugs below.
**
** FILES:
**    Rexx:NameStruc
**    LIBS:rexxsupport.library
**
** AUTHORS:
**    Jrg Hhle, since March 91 (TeXEdit.rexx)
**    Georg Hemann, previous version (TeXEdit.rexx)
**    Andreas Scherer (MFEdit.rexx)
*/

If ~Show('Libraries','rexxsupport.library') Then
  If ~AddLib('rexxsupport.library',0,-30,0) Then Do
    Say "Konnte 'rexxsupport.library' nicht ffnen!"
    Exit 20
  End

Parse Arg FILENAME NUMBER .

/*
** If the MetaFont 'e' command was used to call the editor,
** don't ask if files should be loaded.
*/
If "EDIT" ~= Upper(MyGetEnv("MFREXX")) Then
  ASKLOAD = 0
Else
  ASKLOAD = 1

Parse Value NameStruc(FILENAME) With IVOL IDIRS IBASE .

/*
** The idea in the following statements is to get an absolute path
** for <filename>. The result will be stored in <errnfile>. For example,
** "CD MF:bar" "virmf foo" should give <filename>=foo, and
** <errnfile>=MF:bar/foo. This is necessary because the editor doesn't
** know where file foo is located, but will be able to load file
** MF:bar/foo.
*/

/*
** We have a hard time finding the right directories.
*/
MFDIR = Pragma('d')

/*
** Amiga OS dirnames should end with either `:' or `/'.
** Thus you need just append the filename.
*/
If Right(MFDIR,1) ~= ':' & Right(MFDIR,1) ~= '/' Then
  MFDIR = MFDIR||'/'

If 0 = IVOL Then
  ERRNFILE = MFDIR||SubStr(FILENAME,1+IVOL)
/*
** The logfile is in the current dir.
*/
Else
  ERRNFILE = FILENAME

LOGFILE = MFDIR||SubStr(FILENAME,1+IVOL+IDIRS,IBASE)||".log"
Drop MFDIR

/*
** 0 = ibase would mean that the call was incorrect, for example when
** MFREXXEDIT says "MFEdit.rexx" and not "MFEdit.rexx %s %d"
*/
If 0 = IBASE | ~Exists(ERRNFILE) Then Do
  Say "MFEdit.rexx: Konnte fehlerhafte Datei nicht finden."
  Exit 10
End; Else If ~Exists(LOGFILE) Then Do
  Say "MFEdit.rexx: Konnte Logfile nicht finden."
  LOGFILE = ""

/*
** But we continue.
*/
End

Drop IVOL IDIRS IBASE

/*
** Here starts each editor's specific part.
*/

/*
** Cygnus Ed Professional Version 2.12
*/
If Show('Port','rexx_ced') Then Do
  Address 'rexx_ced'

  Options Results

  CEDtoFront

/*
** Testen, ob die Files nicht schon geladen sind. (hes)
*/

/*
** The following should not be commented out, as this macro is called
** asynchronously, and it would be very bad for the user to have it's
** input mixed with the newly loaded files. Popping up a requester
** ensures that the user does not type in something and waits for the
** files to be loaded. This is the method I use for synchronization. (JCH)
*/
  If ASKLOAD Then Do
    Okay2 "MetaFont fand einen Fehler in der Datei"'0A'X"'"ERRNFILE"'. Datei laden?"
    If 1 ~= RESULT Then
      Exit 0
  End

/*
** TODO: We should really delete old logfiles automatically, without letting
**       CED open a requester to ask if an old modified file may be
**       overwritten or not.
*/

  If "" ~= LOGFILE Then Do
    'jump to file "'LOGFILE'"'
/*
** Always assume the logfile currently loaded is old,
** because MetaFont generated a new one.
*/
    If 0 ~= RESULT Then Do
      Quit
      Open new
    End

    Open '"'LOGFILE'"'

/*
** Now it's non-editable.
*/
    Editable file
    Beg of file

/*
** If we don't have the line number: search the number in the logfile. (hes)
*/
    If 0 ~= NUMBER Then
      'Search for...' "l."||NUMBER
    Else Do
/*
** ^M bringt nichts, und dann Steuercodes hier ...
*/
      'Search for...' "l."
      'Right'

/*
** Take the current line from CED.
*/
      'Status 55'
      Parse Var RESULT "l."NUMBER .
    End
/*
** Changed from Search "! " (hes)
*/
  End; Else
    Okay1 "Konnte kein richtiges Logfile finden!"

/*
** The following line should really read "jump to file errnfile" and not
** filename, because I have done extra work to get the right directory. But
** this information is only in errnfile, which contains an absolute pathname,
** and not in filename, which is the parameter supplied by virmf or inimf,
** usually a relative pathname. CED's current directory is not necessarily
** virmf's one. It also seems that CED is not smart enough as to make the
** difference between foo:tgmoae/myfile and bar:tgmoab/myfile. If I say
** jump to file foo:tgmoae/myfile it may as well jump to bar:tgmoab/myfile,
** whichever window comes first.
*/
  'jump to file "'ERRNFILE'"'
  If 0 = RESULT Then Do
    Open new
    Open '"'errnfile'"'
  End

/*
** TODO: another editor may have modified the disk file, or the user
** the currently loaded file, while virmf compiled an old version. How
** can I get rid of that stupid filerequester in that case? I said "open
** errnfile", so why does CED pop up a filerequester (and may put the
** user in the wrong directory too)?
*/

  If 0 ~= NUMBER Then
    JumpTo NUMBER

  Beg of line

  Exit 0
End
/*
** End of CED part.
*/

/*
** Micro(Gnu)Emacs (MG), to be found on AmigaLibDisk352.
*/
If Show('Port','mg') Then Do
  Address 'mg'

  Options Results

/*
** The following waits until MG is deiconified.
*/
  'amiga-window-to-top'

/*
** We need to prevent the user from continuing to type and thus
** modifying the newly created buffers. I choose the rexx-lock/unlock
** method to synchronise with the user because MG3b4 has some cursor
** position/display bugs: the cursor may erroneously appear in some
** buffer and overwrite it (on the screen only), and not appear in the
** bottom line where it belongs.
*/

  If ASKLOAD Then Do
/*
** This is dangerous if this script aborts.
*/
    'rexx-lock'

    Address Value RESULT

    'rexx-request "MetaFont fand einen Fehler. Datei laden? "'
    RETC = RC
    RETS = RESULT

    'rexx-unlock'
 
    Address Value RESULT

    If 1 < RETC | Left(Upper(RETS),1) = 'N' Then Do
      'rexx-display ""'
      Exit 0
    End

    Drop RETC RETS
  End

  'find-file "'ERRNFILE'"'
/*
** MG doesn't seem to set the RC value on a find-file.
*/
  'rexx-buffer' BUF

/*
** buf.1 is the buffer name, buf.3 the number of lines.
*/
  If NUMBER < BUF.3 Then Do
    'delete-other-windows'

    If "" ~= LOGFILE Then Do
      'split-window-vertically'

/*
** Now get rid of old logfiles. Here I make sure that I get rid of
** every suspicious logfile, because multiple pathes may lead to the same
** file, as for example SYS:mf/sample.log & MF:sample.log.
*/
      'rexx-buffer-list' BUFFERS

      Parse Value NameStruc(LOGFILE) With IVOL IDIRS IBASE

      LOGNAME = Upper(SubStr(LOGFILE,1+IVOL+IDIRS))

      Do I=1 To BUFFERS.0
        If 0 < Index(Upper(BUFFERS.I.FILE),LOGNAME) Then Do
          'switch-to-buffer "'BUFFERS.I.NAME'"'
          'not-modified'
          'kill-buffer "'BUFFERS.I.NAME'"'
        End
      End

      'find-file "'LOGFILE'"'
/*
** MG doesn't seem to set the RC value.
*/
      'beginning-of-buffer'

      If 0 ~= NUMBER Then
        're-search-forward "^l."NUMBER'
      Else Do
/*
** Try to use normal search?
*/
        're-search-forward "^l."' /* ^ means begin of line */

/*
** If search successfull get current line contents.
*/
        If 0 = RC Then Do
          'rexx-line'
          Parse Var RESULT "l."NUMBER .
        End
      End

      'other-window'
      'rexx-display "Now what''s that error?"'
    End; Else
      'rexx-display "Konnte kein richtiges Logfile finden!"'

    If 0 ~= NUMBER Then
      'goto-line 'NUMBER
  End; Else Do
    'not-modified'
    'kill-buffer "'BUF.NAME'"'
    'rexx-display "Konnte fehlerhafte Datei nicht finden!"'
    Exit 5
  End

  Exit 0
End
/*
** End of MG part.
*/

/*
** Write macros for your favorite editor here.
*/

Say "MFEdit.rexx: Kein untersttzter Editor aktiv."
Exit 10

/*
** When will ARexx supply GetEnv/SetEnv?
*/
MyGetEnv: Procedure
Parse Arg NAME

If Open(TEMPFILE,"ENV:"||NAME,'r') Then Do
  GIVES = Readln(TEMPFILE)
  Call Close TEMPFILE
End; Else GIVES = ""

Return GIVES
