/*
** AREXX MakeBatch 1.03
**
** Send new features and bug reports to 
**
** Martin Bokaemper
** Reuthstr. 12
** 91099 Poxdorf
** Germany
**
** Email:  mnbokaem@cip.e-technik.uni-erlangen.de 
**         Zerberus: mab@ame.ZER 
**
** Ulrich Wisser
** Heerstr. 125
** 53111 Bonn
**
** HISTORY:
**    0.80: My 'works-fine-for-me' version slightly modified by
**          Georg Hessmann 13.04.91
**          + set script bit of the batchfile 
**
**    0.81: + take new Parameters 'drivertype' and 'pkfilename' 
**          Georg Hessmann 17.04.91
**
**    0.82: + History 
**          + some small changes 
**          Martin Bokaemper 17.04.91
**
**    0.83: + improved batchfile creation
**          + More messages for the user
**          J\"org H\"ohle 25.04.91
**
**    0.84: + add new parameter 'pkdir' (new since driver version V1.10)
**          + add the dummy variable
**          Georg Hessmann 09.06.91
**
**    0.85
**    0.86: + bumped revision number because of MakeTeXFont
**          + changed script file extension to .sh
**          J\"org H\"ohle 06.08.91
**
**    0.90: + bumped revision number because of MakeTeXFont
**          Georg Hessmann 28.08.91
**
**    1.0:  + add fontcaching for DVIPS-driver
**          ! DVIPS doesn't supply correct pkdir, please adapt
**          ! "DVIPSPKDIR" to your needs
**          + MakeTeXFont added
**          Ulrich Wisser 25.08.92
**
**    1.01: + DVIPS fontcaching enhanced to infinity resolutions per disk.
**          ! This was done while I set up my Redis distribution.  All
**          ! fonts for one driver fit on one disk, which means 37 dirs
**          ! for ShowDVI.
**          Ulrich Wisser 5.10.92
**
**    1.02: + DVIPS fontcaching enhanced.  pk-subdirectories now created.
**          Ulrich Wisser 9.12.92
**
**    1.03: + bumped revision number because of partial integration
**          Andreas Scherer 30.10.93
*/
          
BATCHNAME    = "MF:MakeTeXFont.sh"
FONTFILENAME = "TeX:config/fontvols"
DVIPSPKDIR   = "TeX:pk/Laser/"
MAKETEXFONT  = "MF:rexx/MakeTeXFont"

If ~Show('Libraries','rexxsupport.library') Then Do
  If ~AddLib('rexxsupport.library',0,-30) Then Do
    Say "No RexxSupport ... no Metafont"
    Exit 10
  End
End

Address COMMAND

If ~Exists(BATCHNAME) Then Do
  If ~Open(BATCHFILE,BATCHNAME,'W') Then Do
    Say "MakeBatch: Could not create "BATCHNAME" !"
    Exit 10
  End; Else Do
    Call Writeln(BATCHFILE,";# Batchfile for font generation")
    If Close(BATCHFILE) Then Do
      'Protect 'BATCHNAME' Add s'
      Say "MakeBatch: Batchfile "BATCHNAME" created."
    End; Else Do
      Say "MakeBatch: Error during creation of "BATCHNAME" !"
      Exit 10
    End
  End
End

Parse Arg PARAMETERS
Parse Value PARAMETERS With FNTNAME DPI HBASEDPI VBASEDPI DRIVERTYPE PKFILENAME PKDIR .

/*
** Only ShowDVI and DVIPrint of version >= 1.08 supply arguments
** <drivertype> (show/print) and <pkfilename> (for example "120/cmr10.pk")
**
** Only ShowDVI and DVIPrint of version >= 1.10 supply the argument <pkdir>
**
** DVIPS 5.47 supplies <drivertype> <pkfilename> and <pkdir>, but <pkdir>
** is NOT correct!  It is always "TeX:pk/" instead of the directory given
** in "config.ps".
*/

/*
** Insert fontcaching for DVIPS.
*/
If DRIVERTYPE="dvips" Then Do
  If Open('fontfile', fontfilename, 'read') Then Do
    Do  Until EOF('fontfile')
      LINE = readln('fontfile')
      If Pos(';', line) > 0 Then
        LINE = Left(LINE, Pos(';', LINE)-1)
      Parse Var LINE DISK'='ddd'd.'LINE
      If DDD=HBASEDPI Then Do
        Do Until LINE = ''
          Parse Var LINE DIR'.'LINE
          If DIR=DPI Then Do
            If Exists(DISK':'PKFILENAME) Then Do
              FULLNAME=DVIPSPKDIR||PKFILENAME
              DIRNAME=Left(FULLNAME, LastPos('/', FULLNAME)-1)
              If ~Exists(DIRNAME) Then Do
                Say 'makedir 'DIRNAME
                MakeDir DIRNAME
              End
              Say 'copy 'DISK':'PKFILENAME' 'FULLNAME
              Copy DISK':'PKFILENAME' 'DVIPSPKDIR||PKFILENAME' QUIET NOREQ'
              If ~Close('fontfile') Then
                Say "Can't close "fontfilename"-file!"
              Exit
            End /* If Exists */
          End /* If DIR=DPI */
        End /* Do Until LINE */
      End /* If DDD */
    End /* Do Until EOF */
    If ~Close('fontfile') Then
      Say "Can't close "fontfilename"-file!"
  End /* If Open */
  Else Say "Couldn't find file "fontfilename
End /* If DRIVERTYPE */

/*
** Say "MakeBatch: Font named = "FNTNAME" with dpi = "DPI" and base x = "HBASEDPI"  y = "VBASEDPI
** If DRIVERTYPE ~= "" Then
**   Say " for driver = "DRIVERTYPE", pkname = "PKFILENAME
*/

MESSAGE = 'rx 'MAKETEXFONT PARAMETERS

'Search >NIL: 'BATCHNAME' "'MESSAGE'"'
/*
** Better: Search for FNTNAME, DPI, HBASEDPI and VBASEDPI only?
*/

If RC ~=0 Then Do
  If ~Open(BATCHFILE,BATCHNAME,'Append') Then Do
    Say "MakeBatch: Can't open "BATCHNAME" to add new entry"
    Exit 10
  End

  DUMMY = Writeln(BATCHFILE,MESSAGE)

  If Close(BATCHFILE) Then
    Say "MakeBatch: New entry added for "FNTNAME DPI" dpi"
  Else Do
    Say "MakeBatch: Error while adding new entry!"
    Exit 10
  End
End; Else 
  Say "MakeBatch: Entry already exists!"

Exit 0
