// SR_DIB.H
//  Header file for SR_DIB.DLL
//

/* Macros to display/remove hourglass cursor for lengthy operations */
#define StartWait() hcurSave = SetCursor(LoadCursor(NULL,IDC_WAIT))
#define EndWait()   SetCursor(hcurSave)

/* Header signatutes for various resources */
#define BFT_ICON   0x4349   /* 'IC' */
#define BFT_BITMAP 0x4d42   /* 'BM' */
#define BFT_CURSOR 0x5450   /* 'PT' */

/* macro to determine if resource is a DIB */
#define ISDIB(bft) ((bft) == BFT_BITMAP)

/* Macro to determine to round off the given value to the closest byte */
#define WIDTHBYTES(i)   ((i+31)/32*4)

#define PALVERSION      0x300
#define MAXPALETTE  256   /* max. # supported palette entries */


HANDLE WINAPI _loadds OpenDIB (LPSTR szFile);
BOOL WINAPI _loadds WriteDIB (LPSTR szFile, HANDLE hdib);
BOOL WINAPI _loadds DibInfo (HANDLE hbi, LPBITMAPINFOHEADER lpbi);
HPALETTE WINAPI _loadds CreateBIPalette (LPBITMAPINFOHEADER lpbi);
HPALETTE WINAPI _loadds CreateDibPalette (HANDLE hbi);
HANDLE WINAPI _loadds ReadDibBitmapInfo (int fh);
WORD WINAPI _loadds PaletteSize (VOID FAR * pv);
WORD WINAPI _loadds DibNumColors (VOID FAR * pv);
HANDLE WINAPI _loadds DibFromBitmap (HBITMAP hbm, DWORD biStyle, WORD biBits, HPALETTE hpal);
HBITMAP WINAPI _loadds BitmapFromDib (HANDLE hdib, HPALETTE hpal);
BOOL WINAPI _loadds DrawBitmap (HDC hdc, int x, int y, HBITMAP hbm, DWORD rop);
BOOL WINAPI _loadds DibBlt (HDC hdc, int x0, int y0, int dx, int dy, HANDLE hdib, int x1, int y1, LONG rop);
BOOL WINAPI _loadds StretchDibBlt (HDC hdc, int x, int y, int dx, int dy, HANDLE hdib, int x0, int y0, int dx0, int dy0, LONG rop);
DWORD WINAPI _loadds GetDibInfoHeaderSize (DWORD);
WORD WINAPI _loadds GetDibWidth (HANDLE);
WORD WINAPI _loadds GetDibHeight (HANDLE);
BYTE huge * WINAPI _loadds GetDibBitsAddr (DWORD);
BOOL WINAPI _loadds DisplayDIB (HDC, HANDLE);
BOOL WINAPI _loadds FreeDIB (HANDLE);
BOOL WINAPI _loadds FancyProc (HWND hDlg, UINT Message, UINT wParam, LONG lParam);
BOOL WINAPI _loadds StageFancyIntro (HINSTANCE hInstance, WORD, WORD);



