(*(***********************************************************************

:Program.    GadgetClass.mod
:Contents.   Oberon-like interface to BOOPSI's gadgetclasses
:Author.     hartmut Goebel [hG]
:Address.    Aufseplatz 5, D-90459 Nrnberg
:Address.    UseNet: hartmut@oberon.nbg.sub.org
:Address.    Z-Netz: hartmut@asn.zer   Fido: 2:246/81.1
:Copyright.  Copyright  1993 by hartmut Goebel
:Language.   Oberon-2
:Translator. Amiga Oberon 3.0
:Imports.    Boopsi.mod - Albert Weinert with some changes bg [hG]
:Version.    $VER: GadgetClass.mod 36.0 (5.9.93) Copyright  1993 by hartmut Goebel

(****i* GadgetClass/--history-- ***************************************
*
*********************************************************************)*)*)

MODULE GadgetClass;

(****** GadgetClass/--background-- ************************************
*
*  This is an Oberon-like interface to the BOOPSI class 'gadgetclass'
*  and it's subclasses.
*
*************
* $StackChk- $NilChk- $RangeChk- $CaseChk- $OvflChk-
* $ReturnChk- $ClearVars- $TypeChk-
*)

IMPORT
  RootClass,
  bps:=Classface,
  I := Intuition,
  e := Exec;

CONST
  versionString = "$VER: GadgetClass 36.0 (5.9.93) Copyright  1993 by hartmut Goebel";

TYPE
  Gadget = UNTRACED POINTER TO GadgetClass;
  GadgetClass * = RECORD (RootClass.RootClass)
    gadget -: I.GadgetDummyPtr;
  END;

PROCEDURE (VAR g: GadgetClass) New * (VAR msg: I.OpSet): e.APTR;
BEGIN
  g.gadget := g.New^(msg);
  RETURN g.gadget;
END New;

PROCEDURE (VAR g: GadgetClass) HitTest * (VAR msg: I.HitTest): e.APTR;
BEGIN
  msg.msg.methodID := I.gmHitTest;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END HitTest;

PROCEDURE (VAR g: GadgetClass) GoActive * (VAR msg: I.Input): e.APTR;
BEGIN
  msg.msg.methodID := I.gmGoActive;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END GoActive;

PROCEDURE (VAR g: GadgetClass) GoInactive * (VAR msg: I.GoInactive): e.APTR;
BEGIN
  msg.msg.methodID := I.gmGoInactive;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END GoInactive;

PROCEDURE (VAR g: GadgetClass) Render * (VAR msg: I.Render): e.APTR;
BEGIN
  msg.msg.methodID := I.gmRender;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END Render;

PROCEDURE (VAR g: GadgetClass) HandleInput * (VAR msg: I.Input): e.APTR;
BEGIN
  msg.msg.methodID := I.gmHandleInput;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END HandleInput;

PROCEDURE (VAR g: GadgetClass) HelpTest * (VAR msg: I.HitTest): e.APTR;
BEGIN
  msg.msg.methodID := I.gmHelpTest;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END HelpTest;

PROCEDURE (VAR g: GadgetClass) Layout * (VAR msg: I.Layout): e.APTR;
BEGIN
  msg.msg.methodID := I.gmLayout;
  RETURN bps.DoSuperMethodA(g.class,g.object,msg);
END Layout;


PROCEDURE Dispatch * (cl: I.IClassPtr; obj: I.ObjectPtr; msg: I.MsgPtr): e.APTR;
VAR
  g: Gadget;
BEGIN
  IF msg.methodID # I.new THEN
    g := RootClass.BoopsiToObj(cl,obj)(Gadget);
  END;
  CASE msg.methodID OF
  | I.gmHitTest:
      RETURN g.HitTest(msg^(I.HitTest));
  | I.gmRender:
      RETURN g.Render(msg^(I.Render));
  | I.gmGoActive:
      RETURN g.GoActive(msg^(I.Input));
  | I.gmHandleInput:
      RETURN g.HandleInput(msg^(I.Input));
  | I.gmGoInactive:
      RETURN g.GoInactive(msg^(I.GoInactive));
  | I.gmHelpTest:
      RETURN g.HelpTest(msg^(I.HitTest));
  | I.gmLayout:
      RETURN g.Layout(msg^(I.Layout));
  ELSE
    RETURN RootClass.Dispatch(cl,obj,msg);
  END;
END Dispatch;

END GadgetClass.
