
#include <stdio.h>
#include <string.h>


#include "mpatch.h"



class MyPatch : public MPatch
	{
	public:
	 void Show_start();
	 void Show();
	 void Show_end();
	};


void MyPatch::Show_start()
{
 puts("\nStart appling patch. Please Wait...");
}

void MyPatch::Show()
{
 static short i=0;
 printf("%3d",i++);
}

void MyPatch::Show_end()
{
 puts("\nOk. Finished!");
}





int main(int argc, char *argv[])
{
 MyPatch patch;

 puts("SAMPLE - A simply *.MDF applier");
 puts("(C) 1993/94 Maurizio Giunti");

 char diffile[256];
 char oldfile[256];
 char newfile[256];

 if((argc<2)||(argc>4))
	{
	 puts("Usage: SAMPLE <mdf> [<old>] [<new>]");
	 return 0;
	}

 *diffile=NULL;
 *oldfile=NULL;
 *newfile=NULL;

 for(short i=1;i<argc;i++)
	{
	 if(*diffile==NULL) strcpy(diffile,argv[i]);
	 else if(*oldfile==NULL) strcpy(oldfile,argv[i]);
	 else strcpy(newfile,argv[i]);
	}

 patch.SetRate(3);
 if(patch.MDFPatch(diffile,oldfile,newfile)!=0)
	{
	 puts(patch.LastError());
	}
 else puts("<Done!>");
 return 0;
}




