/******************************************************************************

                                 Toolbar 1.24

                                   DEMODLL.C

               Example of user defined utility button in Toolbar
                 (It simply creates a random pattern of lines)

                       (C) Juan M. Aguirregabiria (1993)

                            First version  7-17-93

                            Last revision  8-23-93

******************************************************************************/

#include "demodll.h"

/* -----------------------------[ Parameters ]------------------------------ */
                                                
#define LPENTRY ((EntryType FAR*)lpParams)              /* Notational */
#define NUMLINES ((LENPARAM-32)/sizeof(LineType))       /* Lines stored */

/* --------------------------------[ Types ]-------------------------------- */

typedef struct {                /* Data for each line */
  int  x1, y1, x2, y2;          /* Start and end coordinates */
  BOOL fDrawn;                  /* Must be erased? */
} LineType;

typedef struct {                /* Data for each instance */
  char     szLines[15];         /* Number of lines per tick (ASCII) */
  char     cNull;               /* Separator: the following is not stored  */
  unsigned nLines;              /* Number of lines in binary format */
  unsigned nInc;                /* Maximum step in each case */
  int      nLast;               /* Last line */
  LineType Line[NUMLINES];      /* Displayed lines */
} EntryType;

/* --------------------------[ Global variables ]--------------------------- */

InitDLLType InitData = {                /* Data for InitToolbarDLL */
                        TRUE,           /* Want hdc for TIMER */
                        TickToolbarDLL, /* TIMER callback */
                        DrawToolbarDLL  /* PAINT callback */
                       };

HINSTANCE hInst;                        /* Instance */

unsigned nLines, nInc;                  /* Auxiliary variables */

RECT rect;

/* ------------------------------[ Utilities ]------------------------------ */

void GetHwndBox(HWND hwnd)                              /* This is necessary */
{                                                       /* to get the RECT   */
  int x;                                                /* bounding the icon */

  GetClientRect(hwnd,&rect);                            /* Full window */
  x = (GetSystemMetrics(SM_CXICON)-rect.right)/2;       /* Correct border */
  InflateRect(&rect,x,x);
  rect.bottom = rect.top+GetSystemMetrics(SM_CYICON);   /* Correct titles */
}

/* --------------------------[ Dialog procedure ]--------------------------- */

#pragma argsused
BOOL CALLBACK LinesProc(HWND hDlg,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
  switch (wMsg) {

    case WM_INITDIALOG:                 /* Set number variables */
      SetDlgItemInt(hDlg,IDD_LINES,nLines,FALSE);
      SetDlgItemInt(hDlg,IDD_INC  ,nInc  ,FALSE);
      return TRUE;

    case WM_COMMAND:                    /* Dialog box control message */
      switch (wParam) {

        case IDOK:                      /* Click on OK button */
          nLines = GetDlgItemInt(hDlg,IDD_LINES,NULL,FALSE);
          nInc   = GetDlgItemInt(hDlg,IDD_INC  ,NULL,FALSE);
          EndDialog(hDlg,TRUE);
          return TRUE;

        case IDCANCEL:                  /* Click on Cancel button */
          EndDialog(hDlg,FALSE);
          return TRUE;

      }
    break;

    case WM_SYSCOMMAND:                 /* From dialog box system menu */
      switch (wParam) {
        case SC_CLOSE:                  /* ALT+F4 or "Close"  */
          EndDialog(hDlg,FALSE);
          return FALSE;
      }
    break;
  }
  return FALSE;
}

/* ----------------------------[ Line drawing ]----------------------------- */

void DrawLine(HDC hdc,LineType FAR*lpLine)
{
  MoveTo(hdc,lpLine->x1,lpLine->y1);
  LineTo(hdc,lpLine->x2,lpLine->y2);
}

/* ------------------------[ Starting the library ]------------------------- */

#pragma argsused
InitDLLType FAR * CALLBACK InitToolbarDLL(HINSTANCE hInstance,LPSTR lpParams)
{
  sscanf(LPENTRY->szLines,"%u:%u",&nLines,&nInc);       /* Binary->ASCII */
  LPENTRY->nLines = (nLines) ? nLines : 10;             /* Default 10 */
  LPENTRY->nInc   = (nInc  ) ? nInc   :  3;             /* Default  3 */
  return &InitData;                                     /* Information */
}

/* -------------------------[ Exiting the library ]------------------------- */

#pragma argsused
void CALLBACK FreeToolbarDLL(HINSTANCE hInstance,LPSTR lpParams)
{                                                       
}                                                       /* Do nothing */

/* ---------------------[ When the button is invoked ]---------------------- */

#pragma argsused
void CALLBACK RunToolbarDLL(HWND hwnd,LPSTR lpParams,LPSTR lpFiles)
{
  if (lpFiles)                                  /* If dropped files */
    MessageBox(hwnd,lpFiles,ERR,MB_ICONHAND | MB_OK);
  else {                                        /* If Enter or double click */
    nLines = LPENTRY->nLines;                   /* Get new number of lines */
    nInc   = LPENTRY->nInc  ;                   /* and new step */
    if (DialogBox(hInst,MAKEINTRESOURCE(DLG_LINES),hwnd,LinesProc))
      LPENTRY->nLines = nLines;                 /* only if OK is pressed */
      LPENTRY->nInc   = nInc  ;
      wsprintf(LPENTRY->szLines,"%u:%u",nLines,nInc);   /* Binary->ASCII */
  }
}

/* ----------------------[ Processing TIMER messages ]---------------------- */

int GetIncrement(unsigned nInc)
{
  return random(2*nInc+1)-nInc;                 /* -nInc ... nInc */
}

#pragma argsused
void CALLBACK TickToolbarDLL(HWND hwnd,HDC hdc,LPSTR lpParams)
{
  WORD n, i;
  int  x1, y1, x2, y2, c;

  GetHwndBox(hwnd);                             /* Get window bounds */
  SelectPen(hdc,GetStockPen(WHITE_PEN));        /* Blanck lines */
  SetROP2(hdc,R2_XORPEN);                       /* XOR mode is simpler */
  i = LPENTRY->nLast;                           /* Get last line */
  x1 = max(rect.left  ,LPENTRY->Line[i].x1);
  y1 = max(rect.top   ,LPENTRY->Line[i].y1);
  x2 = min(rect.right ,LPENTRY->Line[i].x2);
  y2 = min(rect.bottom,LPENTRY->Line[i].y2);
  for (n = LPENTRY->nLines; n; n--) {
    i = (i+1) % NUMLINES;                       /* Next line slot */
    if (LPENTRY->Line[i].fDrawn)                /* Erase old line */
      DrawLine(hdc,LPENTRY->Line+i);
    LPENTRY->Line[i].fDrawn = TRUE;             /* Get new line */
    c = GetIncrement(LPENTRY->nInc);
    LPENTRY->Line[i].x1 =
    x1 = (x1+c < rect.left  ) ? x1-c : (x1+c > rect.right ) ? x1-c : x1+c ;
    c = GetIncrement(LPENTRY->nInc);
    LPENTRY->Line[i].y1 =
    y1 = (y1+c < rect.top   ) ? y1-c : (y1+c > rect.bottom) ? y1-c : y1+c ;
    c = GetIncrement(LPENTRY->nInc);
    LPENTRY->Line[i].x2 =
    x2 = (x2+c < rect.left  ) ? x2-c : (x2+c > rect.right ) ? x2-c : x2+c ;
    c = GetIncrement(LPENTRY->nInc);
    LPENTRY->Line[i].y2 =
    y2 = (y2+c < rect.top   ) ? y2-c : (y2+c > rect.bottom) ? y2-c : y2+c ;
    DrawLine(hdc,LPENTRY->Line+i);
  }
  LPENTRY->nLast = i;                           /* Save last line */
}

/* ----------------------[ Processing PAINT messages ]---------------------- */

#pragma argsused                               
void CALLBACK DrawToolbarDLL(HWND hwnd,HDC hdc,LPSTR lpParams)
{
  int n;

  GetHwndBox(hwnd);                             /* Erase the window */
  FillRect(hdc,&rect,GetStockBrush(BLACK_BRUSH));
  for (n = 0; n < NUMLINES; n++)                /* and previous lines */
    LPENTRY->Line[n].fDrawn = FALSE;
}

/* -------------------------------[ LibMain ]------------------------------- */

#pragma argsused
int CALLBACK LibMain(HINSTANCE hInstance,WORD wDataSeg,WORD wHeapSize,
                       LPSTR lpszCmdLine)
{
  if (wHeapSize > 0) UnlockData(0);
  hInst = hInstance;                            /* Save information */
  randomize();                                  /* Init random numbers */
  return 1;
}
