
(*
  NAME   The_Prn.Pas  Copyright 1992-94, Rob W. Smetana All Rights Reserved.
  ====   Pascal support file for The Printer (a printer code database).

  PURPOSE
  =======

  An INCLUDE file providing the "field structure" of both Printer.Dat (large
  database) and Printer.Cfg (small configuration file saved by Printer.Exe).


  RECORD LAYOUT
  =============

  "Records" (for each printer) are 1024 bytes in length.  In the main
  database, there's 1 record for each printer (but see next paragraph).
  The "Printer.Cfg" file saved by Printer.Exe or Edit.Exe contains TWO
  1024 byte records.  The first contains labels, the 2nd contains
  printer codes.

  In The Printer's database, a printer may have 2 or more records if it
  can emulate 2 or more other printers.  In other words, each emulation
  is treated as a separate printer. The field "EmMode" tells you which
  printer is being emulated.

  ALL fields are STRINGS and all are 14 bytes long EXCEPT the first two:
    - Reserved is 1 byte   (reserved for our development)
    - Printer Manufacturer is 15 bytes


  PLACEHOLDERS:  ASCII character 251 ()
  ============

  Some printer codes require "variables."  For example, to specify, say
  3/48 inch line spacing (instead of the normal 6 lines per inch), you
  send a code like Chr$(27);"L03" (for a Toshiba printer).  In this case
  both "0" and "3" are variables.
   - The database would store this code as:  L
   - Escape is stored as ASCII character 27.
   - ASCII 251 () is simply a "placeholder" which YOU must replace
     with appropriate characters.

  You MUST replace the placeholder -- the printer code is meaningless
  otherwise.


  TWO TYPES
  =========

  Below are 2 TYPES you may use to read printer records.

   * These TYPES can be used to read either the large database itself
     (Printer.Dat) or the small config. file (Printer.Cfg) saved by
     Printer.Exe when you select a printer.

   * The first TYPE (PrnHeader) reads the 1st 44 bytes of records.
     Here you'll find the printer's Manufacturer, Model and Emulation mode.

   * The 2nd TYPE (ThePrn) will read/hold actual printer codes.


  NOTE:  By separating these, if you don't care about the header, you're
         not forced to keep it around.  Read it (with any 44-byte variable),
         throw it away, then read just the printer codes.
*)


TYPE
   PrnHeader = Record

{ '=========== Start with a header (Printer manufacturer, model and emulation). }

           Reserved :Byte;             { Reserved (for development) }

       Manufacturer :Array[1..15] of Char; { eg., Epson, Panasonic, Star, etc. }


{ =========== All remaining fields are 14 bytes. }

              Model ,                  { Specific printer model (eg., LQ-510) }

             EmMode :Array[1..14] of Char; { If not blank, this describes the }
                                           { printer being emulated. }

                                       { 44 bytes through here !!! }
End;

TYPE
   ThePrn = Record
{========== 70, 14-byte printer codes follow.

            The last few are blank, "expansion" fields for our
            use (if we add codes), or by you or your user.

            NOTE:  We may expand into these -- starting with the
            first.  If you're concerned that later we might collide
            with you, start your codes at the end, then move forward.
}

         Initialize ,                 { Reset to power-on mode (many printers }
                                      { have no reset -- a shame). }

{ ...pitch/character sets/master attributes }

          Pitch10ON ,                 { Turn on 10 characters-per-inch (CPI; Pica) }
          Pitch12ON ,                 { Turn on 12 CPI (eg., Elite) }
        CondensedON ,                 { Turn on Condensed mode (15-17 CPI) }
       CondensedOFF ,                 { Turn Condensed mode off }
ProportionalSpacing ,                 { Turn on Proportional Spacing }
       FixedSpacing ,                 { Turn on Fixed Spacing }

      SelectCharSet ,                 { Select Character Set (USA, French, etc.) }
   SelectMasterFont ,                 { Select Master Font (Roman, Prestige, etc.) }
   SelectPrintStyle ,                 { Select Elite, Condensed, etc. }
          DraftMode ,                 { Turn Draft Mode on (high speed) }
  NearLetterQuality ,                 { Turn on Near-Letter Quality mode }

{ ... Line spacing }

      LinesPerInch6 ,                 { Turn on 6 lines-per-inch (LPI) }
      LinesPerInch8 ,                 {   "  "  8    "   "   " }
     LinesPerInch12 ,                 {   "  "  12   "   "   " }

  VariableLineSpace ,                 { Change line spacing (LPI) -- fine increments }
    AltVariableLine ,                 { Alternate way to change line spacing }

{ ... Attributes/Emphasis/SuperScript/Etc }

     DoubleStrikeON ,                 { Turn on Double-Strike mode }
    DoubleStrikeOFF ,                 {   "  off  "       "     " }

       DoubleWideON ,                 { Turn Double-Wide on }
      DoubleWideOFF ,                 {   "    "     "   off }

     DoubleHeightON ,                 { Turn Double-High on }
    DoubleHeightOFF ,                 {   "    "     "   off }

       EmphasizedON ,                 { Turn Emphasized mode on }
      EmphasizedOFF ,                 {   "       "      "   off }

             BoldOn ,                 { Turn Bold mode on }
            BoldOff ,                 {   "   "     "   off }

        UnderlineON ,                 { Turn Underline mode on }
       UnderlineOff ,                 {   "       "     "   off }

           ItalicON ,                 { Turn Italic mode on }
          ItalicOff ,                 {   "     "     "   off }

      SuperScriptON ,                 { Superscript on }
     SuperScriptOFF ,                 {     "       off }

        SubScriptON ,                 { Subscript on }
       SubScriptOFF ,                 {     "     off }

{ ... Other }

  SkipPerforationON ,                 { Skip perforation zone }
 SkipPerforationOFF ,                 { Turn off Skip perf. }

UnidirectionalPrint ,                 { Unidirectional print on (for accuracy) }
 BidirectionalPrint ,                 { Bidirectional print on (for speed) }

         PushCursor ,                 { (LaserJet) Push (save) cursor position }
          PopCursor ,                 {      "     Pop (restore)  "       " }

   PageLengthInches ,                 { Set page length in INCHES }
    PageLengthLines ,                 { Set page length in LINES }

        SetTabStops ,                 { Set Tab Stops }

       SetTopMargin ,                 { Set Top Margin }
    SetBottomMargin ,                 {  "  Bottom " }
      SetLeftMargin ,                 {  "  Left   " }
     SetRightMargin ,                 {  "  Right  " }


{ ... The next 4 codes let you move to vertical or horizontal locations,   }
{     either in absolute terms (ie., a specific row/column) or relative to }
{     where you are (ie., move 5 dots down). }

AbsVerticalLocation ,                 { Move vertically to a specific Row (or dot) }
RelVerticalLocation ,                 { Move "y" rows/dots from where we are now }

   AbsHorizLocation ,                 { Move horizontally to a column (or dot) }
   RelHorizLocation ,                 { Move "x" columns/dots from where we are }

     InterCharSpace ,                 { Expand/shrink the spacing between }
                                      { letters (some newer printers only) }


{ ... Expansion fields to give us, you or your users options to add codes. }

         User1 ,
         User2 ,
         User3 ,
         User4 ,
         User5 ,
         User6 ,
         User7 ,
         User8 ,
         User9 ,
        User10 ,
        User11 ,
        User12 ,
        User13 ,
        User14 ,
        User15 ,
        User16 ,
        User17 : Array[1..14] of Char; { This rounds out the     }
                                       { structure to 1024 bytes.}
End;

