#ifndef _OPTDLL_H_
#define _OPTDLL_H_

#define WND_FRONT_ALWAYS        1      /* Always pop up windows */
#define WND_FRONT_SHIFT         2      /* only with shift       */
#define WND_FRONT_NEVER         3      /* no, never             */

#define TOOLS_MENU_NOTHING      0
#define TOOLS_MENU_UPPER_LEFT   1      /* These are the menus   */
#define TOOLS_MENU_UPPER_RIGHT  2
#define TOOLS_MENU_LOWER_LEFT   4
#define TOOLS_MENU_LOWER_RIGHT  8
#define TOOLS_MENU_SHIELD       16
#define TOOLS_MENU_TOOLS        32

#ifdef __cplusplus
 extern "C" {
#endif

/* The following functions are the FeelX-"API"-functions. Do not  */
/* use the uncommented functions. They are for internal use only! */


 int           init();
 void          setHab(HAB h);
 void _System  setX(BOOL);             /* TRUE: activate windows with mouse */
                                       /* FALSE: normal OS/2 behaviour      */
 void _System  toggleX();              /* Toggle FeelX status               */
 void _System  setWindowFront(int);    /* int: WND_FRONTxxx                 */
 void _System  setStaticWinlist(BOOL); /* FALSE: WinList switches FeelX off */
                                       /* TRUE: default                     */
 void _System  setTools(BOOL);         /* TRUE: corner tools menu enabled   */
 void _System  setHidetimeout(int);    /* Hide mouse pointer after .. sec.  */
 void _System  disableHidetimeout();   /* do not Hide pointer               */
 void _System  setMark(BOOL);          /* TRUE: FeelX VIO-marking is on     */
 void _System  setFolder(BOOL);        /* FALSE: Do not move Folders to the */
                                       /*        front, when the user clicks*/
                                       /* TRUE: default                     */
 void          setPID(PID);
 void          setXClient(HWND);
 void _System  setPriority(BOOL);      /* TRUE: FeelX runs with High priority */
                                       /* FALSE: default                    */
 HAB           queryHab();
 int _System   queryX();               /* return FeelX status               */
 int _System   queryWindowFront();     /* returns WND_FRONT_xxx             */
 BOOL _System  queryTools();           /* corner tools on?                  */
 BOOL _System  queryTimeoutStatus();   /* TRUE: hide pointer                */
 ULONG _System queryHidetimeout();     /* return timeout in sec.            */
 BOOL _System  queryMark();            /* TRUE: FeelX marking on            */
 BOOL _System  queryFolder();          /* TRUE: Move folder to the front    */
 PID _System   queryPID();             /* Process id of FeelX               */
 HWND _System  queryXClient();         /* Post messages to this "adress"    */
 BOOL _System  queryStaticWinlist();   /* static Window list?               */
 BOOL _System  queryPriority();        /* TRUE: high priority               */
 void _System  addToXMenu(char *);     /* add string to menu                */
 void _System  delFromXMenu(char *);   /* delete                            */
 void _System  clearXMenu(int);        /* delete the whole menu             */
                                       /* cf. online docs for more information */

 BOOL _System  loadSettings();         /* load from os2.ini                 */
 void _System  saveSettings();         /* save to os2.ini                   */

 BOOL          queryFront(HWND);
 BOOL  _System addFront(HWND);         /* HWND: always top window           */
 void _System  deleteFront(HWND);      /* HWND: no longer top window        */
 HWND          behindFront(HWND);
 HWND          behindBottom(HWND);
 int          *queryActFront();

 BOOL _System  queryWPSAutoload();     /* not used                          */
 void _System  setWPSAutoload(BOOL t); /* not used                          */

#ifdef __cplusplus
}
#endif

#ifndef NO_IMPORT
 #pragma import (init, "", "FXOPTDLL", 0)
 #pragma import (queryParms, "", "FXOPTDLL", 0)
 #pragma import (setHab, "", "FXOPTDLL", 0)
 #pragma import (setX, "", "FXOPTDLL", 0)
 #pragma import (toggleX, "", "FXOPTDLL", 0)
 #pragma import (setWindowFront, "", "FXOPTDLL", 0)
 #pragma import (setStaticWinlist, "", "FXOPTDLL", 0)
 #pragma import (setTools, "", "FXOPTDLL", 0)
 #pragma import (setHidetimeout, "", "FXOPTDLL", 0)
 #pragma import (disableHidetimeout, "", "FXOPTDLL", 0)
 #pragma import (setMark, "", "FXOPTDLL", 0)
 #pragma import (setFolder, "", "FXOPTDLL", 0)
 #pragma import (setPID, "", "FXOPTDLL", 0)
 #pragma import (setXClient, "", "FXOPTDLL", 0)
 #pragma import (setPriority, "", "FXOPTDLL", 0)
 #pragma import (queryHab, "", "FXOPTDLL", 0)
 #pragma import (queryWindowFront, "", "FXOPTDLL", 0)
 #pragma import (queryX, "", "FXOPTDLL", 0)
 #pragma import (queryTools, "", "FXOPTDLL", 0)
 #pragma import (queryTimeoutStatus, "", "FXOPTDLL", 0)
 #pragma import (queryMark, "", "FXOPTDLL", 0)
 #pragma import (queryHidetimeout, "", "FXOPTDLL", 0)
 #pragma import (queryFolder, "", "FXOPTDLL", 0)
 #pragma import (queryPID, "", "FXOPTDLL", 0)
 #pragma import (queryXClient, "", "FXOPTDLL", 0)
 #pragma import (queryStaticWinlist, "", "FXOPTDLL", 0)
 #pragma import (queryPriority, "", "FXOPTDLL", 0)
 #pragma import (addToXMenu, "", "FXOPTDLL", 0)
 #pragma import (delFromXMenu, "", "FXOPTDLL", 0)
 #pragma import (clearXMenu, "", "FXOPTDLL", 0)
 #pragma import (loadSettings, "", "FXOPTDLL", 0)
 #pragma import (saveSettings, "", "FXOPTDLL", 0)
 #pragma import (queryFront, "", "FXOPTDLL", 0)
 #pragma import (addFront, "", "FXOPTDLL", 0)
 #pragma import (deleteFront, "", "FXOPTDLL", 0)
 #pragma import (behindFront, "", "FXOPTDLL", 0)
 #pragma import (behindBottom, "", "FXOPTDLL", 0)
 #pragma import (queryActFront, "", "FXOPTDLL", 0)
 #pragma import (queryWPSAutoload, "", "FXOPTDLL", 0)
 #pragma import (setWPSAutoload, "", "FXOPTDLL", 0)
#endif

#endif
